/* PROGRAM:	gshhs.c
 * AUTHOR:	Paul Wessel (wessel@soest.hawaii.edu)
 * DATE:	JAN. 28, 1996
 * PURPOSE:	To extract ASCII data from binary shoreline data
 *		as described in the 1996 Wessel & Smith JGR Data Analysis Note.
 */

#include <stdio.h>
#include <math.h>
#include "gshhs.h"

main (argc, argv)
int	argc;
char **argv;
{
	double w, e, s, n, area, lon, lat;
	char source;
	FILE	*fp;
	int	k, max = 270000000;
	struct	POINT p;
	struct GSHHS h;
	int ib, ileft, itot, breakup=1000;
	
        long int npoints, nstrokes, nsmore;
	long int nlots;
	
        
	if (argc != 2) {
		fprintf (stderr, "usage:  gshhs gshhs_[f|h|i|l|c].b > ascii.dat\n");
		exit(-1);
	}
	
	if ((fp = fopen (argv[1], "r")) == NULL ) {
		fprintf (stderr, "gshhs:  Could not find file %s.\n", argv[1]);
		exit(-1);
	}
	npoints=nstrokes=nsmore=0;
	
	while (fread((char *)&h, sizeof (struct GSHHS), 1, fp) == 1) {

		w = h.west  * 1.0e-6;
		e = h.east  * 1.0e-6;
		s = h.south * 1.0e-6;
		n = h.north * 1.0e-6;
		source = (h.source == 1) ? 'W' : 'C';
		area = 0.1 * h.area;

		
                nstrokes++;
		npoints+=h.n;
		if(h.n>breakup)
		  { 
		    ib = h.n/breakup;
		    ileft = h.n - ib*breakup;
                    if(ileft>0) itot = ib+1;
		    else  itot = ib;
		    nsmore+= itot;
		    
		    fprintf (stderr,"P %6d%8d%2d%2c%13.3lf%10.5lf%10.5lf%10.5lf%10.5lf\n", h.id, h.n, h.level, source, area, w, e, s, n);
		    fprintf (stderr,"ib=%d ileft=%d itot=%d h.n=%d\n", ib, ileft, itot, h.n);
		    
		    nlots++;
		  }
		else nsmore++;
		
		
		for (k = 0; k < h.n; k++) {

			if (fread ((char *)&p, sizeof(struct POINT), 1, fp) != 1) {
				fprintf (stderr, "gshhs:  Error reading file.\n");
				exit(-1);
			}

			lon = (h.greenwich && p.x > max) ? p.x * 1.0e-6 - 360.0 : p.x * 1.0e-6;
			lat = p.y * 1.0e-6;
			
		}
		max = 180000000;	/* Only Eurasiafrica needs 270 */
	}
		
	fclose(fp);
	fprintf(stderr,"%d %d   (nstrokes, npoints) nlots = %d \n", nstrokes, npoints, nlots);
	fprintf(stderr,"gshhs2lees %s %d %d >  newlees.BIN  \n", argv[1], nstrokes, npoints);
	fprintf(stderr,"gshhs2lees %s %d %d >  newlees.BIN  \n", argv[1], nsmore, npoints);


	exit (0);
}
