/* PROGRAM:	gshhs.c
 * AUTHOR:	Paul Wessel (wessel@soest.hawaii.edu)
 * DATE:	JAN. 28, 1996
 * PURPOSE:	To extract ASCII data from binary shoreline data
 *		as described in the 1996 Wessel & Smith JGR Data Analysis Note.
 */

#include <stdio.h>
#include <math.h>
#include "gshhs.h"
#include "/data/g3/lees/Map/LEES-MAP/mapstroke.h"

#ifndef MAX
#define MAX(A, B) ((A) > (B) ? (A) : (B))
#endif
 
#ifndef  MIN
#define MIN(A, B) ((A) < (B) ? (A) : (B))
#endif



main (argc, argv)
int	argc;
char **argv;
{
	double w, e, s, n, area, lon, lat;
	char source;
	FILE	*fp;
	int	k, max = 270000000;
	struct	POINT p;
	struct GSHHS h;
        MAPSTROKE my;
	
	int ib, ileft, itot, klot, breakup=1000;
	
        long int npoints, nstrokes, nsmore;
	long int nlots;


FILE  *fb, *fopen();
float *phis, *lams;


	if (argc < 3) {
		fprintf (stderr, "usage:  gshhs gshhs_[f|h|i|l|c].b nstrokes npoints > ascii.dat\n");
		exit(-1);
	}
	
	if ((fp = fopen (argv[1], "r")) == NULL ) {
		fprintf (stderr, "gshhs:  Could not find file %s.\n", argv[1]);
		exit(-1);
	}

	nstrokes = atoi(argv[2]);
	npoints = atoi(argv[3]);
		
     fwrite(&nstrokes,sizeof(int) , 1  ,  stdout);
     fwrite(&npoints, sizeof(int) , 1 ,  stdout);


	while (fread((char *)&h, sizeof (struct GSHHS), 1, fp) == 1)
	  {

		w = h.west  * 1.0e-6;
		e = h.east  * 1.0e-6;
		s = h.south * 1.0e-6;
		n = h.north * 1.0e-6;
		source = (h.source == 1) ? 'W' : 'C';
		area = 0.1 * h.area;

		/* printf ("P %6d%8d%2d%2c%13.3lf%10.5lf%10.5lf%10.5lf%10.5lf\n", h.id, h.n, h.level, source, area, w, e, s, n); */


		if(h.n>breakup)
		  {
	    	    ib = h.n/breakup;
		    ileft = h.n - ib*breakup;

                    if(ileft>0)
		      itot = ib+1;
		    else 
		      itot = ib;

                    for(klot=0; klot<ib; klot++)
		      {
			
			sprintf(my.name,"%6d_%d", h.id, klot);
			my.num = breakup;
			my.style = 2;
			my.col = 1; 
			my.code='a';
			my.latmin=s;
			my.latmax=n;
			my.lonmin=w;
			my.lonmax=e;
			my.index1=0;
			
			
			phis = (float *) calloc(breakup, sizeof(float));
			lams = (float *) calloc(breakup, sizeof(float));
			
			for (k = 0; k < breakup; k++) 
			  {
			    
			    if (fread ((char *)&p, sizeof(struct POINT), 1, fp) != 1) 
			      {
				fprintf (stderr, "gshhs:  Error reading file.\n");
				exit(-1);
			      }
			    
			    lon = (h.greenwich && p.x > max) ? p.x * 1.0e-6 - 360.0 : p.x * 1.0e-6;
			    lat = p.y * 1.0e-6;
			    phis[k] = lat ;
			    lams[k] = lon ;
			    
			    /* printf ("%10.5lf%10.5lf\n", lon, lat); */
			  }
			my.latmin = my.latmax = phis[0];
			my.lonmin = my.lonmax = lams[0];
			for (k = 0; k < breakup; k++) 
			  {
			    my.latmin=MIN(my.latmin, phis[k]);
			    my.latmax=MAX(my.latmax, phis[k]);
			    my.lonmin=MIN(my.lonmin, lams[k]);
			    my.lonmax=MAX(my.lonmax, lams[k]);
			  }
		    
                     
			max = 180000000;	/* Only Eurasiafrica needs 270 */
			fwrite(&my, 1, sizeof(MAPSTROKE), stdout);
			fwrite(phis, my.num  , sizeof(float),  stdout);
			fwrite(lams, my.num  , sizeof(float),  stdout);
			cfree(phis);
			cfree(lams);




		    
		      }

		    
		    if(ileft>0)
		      {
			sprintf(my.name,"%6d_%d", h.id, klot);
			my.num = ileft;
			my.style = 2;
			my.col = 1; 
			my.code='a';
			my.latmin=s;
			my.latmax=n;
			my.lonmin=w;
			my.lonmax=e;
			my.index1=0;


			phis = (float *) calloc(ileft, sizeof(float));
			lams = (float *) calloc(ileft, sizeof(float));

			for (k = 0; k < ileft; k++) 
			  {

			    if (fread ((char *)&p, sizeof(struct POINT), 1, fp) != 1) 
			      {
				fprintf (stderr, "gshhs:  Error reading file.\n");
				exit(-1);
			      }

			    lon = (h.greenwich && p.x > max) ? p.x * 1.0e-6 - 360.0 : p.x * 1.0e-6;
			    lat = p.y * 1.0e-6;
			    phis[k] = lat ;
			    lams[k] = lon ;
                      
			    /* printf ("%10.5lf%10.5lf\n", lon, lat); */
			  }
			my.latmin = my.latmax = phis[0];
			my.lonmin = my.lonmax = lams[0];
			for (k = 0; k < ileft; k++) 
			  {
			    my.latmin=MIN(my.latmin, phis[k]);
			    my.latmax=MAX(my.latmax, phis[k]);
			    my.lonmin=MIN(my.lonmin, lams[k]);
			    my.lonmax=MAX(my.lonmax, lams[k]);
			  }
		    
                     
			max = 180000000;	/* Only Eurasiafrica needs 270 */
			fwrite(&my, 1, sizeof(MAPSTROKE), stdout);
			fwrite(phis, my.num  , sizeof(float),  stdout);
			fwrite(lams, my.num  , sizeof(float),  stdout);
			cfree(phis);
			cfree(lams);
			
			  }
		    
	    
		      }
		else
		  {
	    
		    sprintf(my.name,"%6d", h.id);
		    my.num = h.n;
		    my.style = 2;
		    my.col = 1; 
		    my.code='a';
		    my.latmin=s;
		    my.latmax=n;
		    my.lonmin=w;
		    my.lonmax=e;
		    my.index1=0;
		    
		    
		    phis = (float *) calloc(h.n, sizeof(float));
		    lams = (float *) calloc(h.n, sizeof(float));
		    
		    fwrite(&my, 1, sizeof(MAPSTROKE), stdout);
		    for (k = 0; k < h.n; k++) {
		      
		      if (fread ((char *)&p, sizeof(struct POINT), 1, fp) != 1) {
			fprintf (stderr, "gshhs:  Error reading file.\n");
			exit(-1);
		      }
		      
		      lon = (h.greenwich && p.x > max) ? p.x * 1.0e-6 - 360.0 : p.x * 1.0e-6;
		      lat = p.y * 1.0e-6;
		      phis[k] = lat ;
		      lams[k] = lon ;
		      /* printf ("%10.5lf%10.5lf\n", lon, lat); */
		    }
		    max = 180000000;	/* Only Eurasiafrica needs 270 */
		    
		    fwrite(phis, my.num  , sizeof(float),  stdout);
		    fwrite(lams, my.num  , sizeof(float),  stdout);
		    cfree(phis);
		    cfree(lams);
		  }
		
	  }
	

	fclose(fp);
	
	exit (0);
}



