#include <stdio.h>
#include <math.h>
#include "std.h"

#define MAX_NUM_PLOTS  10
#define FOC_TRACE   1000
#define FAULT_TRACE   200
#define MAX_TICS  200
#define  NUM_FOCS 1000

typedef fxyz point;
typedef xy pix;
typedef fxyxy FSeg;
typedef xyxy PSeg;


#include <focproto.h>

/* One record in a ".ac" (Acards) files */
typedef struct {
	char type;
	char id[11];	/* Date/Time it happened */
	float sec;		/* Second it happened */
        float phi[3], lam[3];
         int lat1, lat2, lon1,lon2; 
	float depth;
	float mag;
	int nump;
	int nums;
	int gap;
	int delta;
	float rms;
	float err;
	char q1, q2;
	char modid[3];
    char NS, EW, JU;
} ac_rec;



typedef  struct {
        
        float strk1,dip1,strk2,dip2;
        float  urot, udip,vrot, vdip;
        float prot,pdip,trot,tdip;

    } Mech;

typedef  struct {
    ac_rec ac;
     Mech  fm;
    fxy  traj1[FOC_TRACE];
    fxy  traj2[FOC_TRACE];
     fxy fault[FAULT_TRACE];
     fxy aux[FAULT_TRACE];
     int numft1, numft2;
    int num1,num2, ipol;
    point loc;
    int type;
    float explode_angle;
    float explode_dist;

    float explode_x;
    float explode_y;


   } foc_rec;

BOOLEAN readac( FILE *f, ac_rec *a);
BOOLEAN readmc( FILE *f, Mech *a);


BOOLEAN readfoc( FILE *f, foc_rec *a)
{
      int i;
char ch;



readac( f, &a->ac);
readmc( f, &a->fm);


	if (  feof(f) ) return FALSE;
	
        return TRUE;
  
}

void Upper_Sphere(foc_rec *foc)
{

               foc->fm.strk1 = 180 + foc->fm.strk1;
               foc->fm.strk2 = 180 + foc->fm.strk2;
               foc->fm.urot = 180 + foc->fm.urot;
               foc->fm.vrot = 180 + foc->fm.vrot;
               foc->fm.prot = 180 + foc->fm.prot;
               foc->fm.trot = 180 + foc->fm.trot;

             if(foc->fm.strk2>360) foc->fm.strk2 = foc->fm.strk2-360;
             if(foc->fm.strk1>360) foc->fm.strk1 = foc->fm.strk1-360;
             if(foc->fm.urot>360) foc->fm.urot = foc->fm.urot-360;
             if(foc->fm.vrot>360) foc->fm.vrot = foc->fm.vrot-360;
             if(foc->fm.prot>360) foc->fm.prot = foc->fm.prot-360;
             if(foc->fm.trot>360) foc->fm.trot = foc->fm.trot-360;
              
             if(foc->fm.strk1<0) foc->fm.strk1 = 360 + foc->fm.strk1;
             if(foc->fm.strk2<0) foc->fm.strk2 = 360 + foc->fm.strk2;
             if(foc->fm.prot<0) foc->fm.prot = 360 + foc->fm.prot;
             if(foc->fm.trot<0) foc->fm.trot = 360 + foc->fm.trot;
            if(foc->fm.urot<0) foc->fm.urot = 360 + foc->fm.urot;
            if(foc->fm.vrot<0) foc->fm.vrot = 360 + foc->fm.vrot;
}

void Lower_Sphere(foc_rec *foc)
{

               foc->fm.strk1 = -180 + foc->fm.strk1;
               foc->fm.strk2 = -180 + foc->fm.strk2;
               foc->fm.urot = -180 +  foc->fm.urot;
               foc->fm.vrot = -180 + foc->fm.vrot;
               foc->fm.prot = -180 + foc->fm.prot;
               foc->fm.trot = -180 + foc->fm.trot;

             if(foc->fm.strk2>360) foc->fm.strk2 = foc->fm.strk2-360;
             if(foc->fm.strk1>360) foc->fm.strk1 = foc->fm.strk1-360;
             if(foc->fm.urot>360) foc->fm.urot = foc->fm.urot-360;
             if(foc->fm.vrot>360) foc->fm.vrot = foc->fm.vrot-360;
             if(foc->fm.prot>360) foc->fm.prot = foc->fm.prot-360;
             if(foc->fm.trot>360) foc->fm.trot = foc->fm.trot-360;
              
             if(foc->fm.strk1<0) foc->fm.strk1 = 360 + foc->fm.strk1;
             if(foc->fm.strk2<0) foc->fm.strk2 = 360 + foc->fm.strk2;
             if(foc->fm.prot<0) foc->fm.prot = 360 + foc->fm.prot;
             if(foc->fm.trot<0) foc->fm.trot = 360 + foc->fm.trot;
            if(foc->fm.urot<0) foc->fm.urot = 360 + foc->fm.urot;
            if(foc->fm.vrot<0) foc->fm.vrot = 360 + foc->fm.vrot;
}


void create_Acard(ac_rec *ac , char *acrd);
void create_Mcard(Mech *mc , char *mcrd);
main(int *argc, char **argv)
{

FILE  *fopen(), *inf;
 int i;
char acard[76];
char mcard[76];

foc_rec foc;


char foc_file[60];



 strcpy(foc_file, argv[1]);

	if(( inf = fopen( foc_file ,"r")) == NULL) {
		printf("Can't open Focal Mechanisms: %s  Try again\n",foc_file);
		 
		 return;
	 }
							 
	  
	i = 0;

  	
	while( readfoc( inf, &foc) )
           {


Lower_Sphere(&foc);

             create_Acard( &foc.ac, acard);
             create_Mcard( &foc.fm, mcard);
fprintf(stdout,"%s",acard);
fprintf(stdout,"%s",mcard);

         }

}
