#include <stdio.h>
#include <math.h>
#include <string.h>
#define            DEG2RAD   0.017453293
#define            RAD2DEG  57.295778667

#include <std.h>
void            jlcgc(float phio, float lamo, float *phi, float *lam, float ex, float why);

float  mag_vec(double v[3])
{
	return sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
}

float  nize(double v[3])
{
	double           d;
	d = mag_vec(v);
	v[0] /= d;
	v[1] /= d;
	v[2] /= d;
	return d;
}
void transpose(double mat[3][3])
{       int i,j;
   double tem[3][3];
  for(i=0; i<3; i++)
  {for(j=0; j<3; j++) tem[i][j] = mat[i][j];}

  for(i=0; i<3; i++)
  {for(j=0; j<3; j++) mat[i][j] = tem[j][i];}

}

/*******************************************/
void  mat3mult(double mat[3][3], double vec[3], double out[3])
{
	int             i, j;
	double          sum;
	for (i = 0; i < 3; i++) {
		sum = 0;
		for (j = 0; j < 3; j++)
			sum += mat[i][j] * vec[j];
		out[i] = sum;
	}
}



void new_arrow(float x1[3], float x2[3], float ar[5][3])
{
  double mat1[3][3];
  double vec[3],vec1[3],tem1[3], vec2[3], tem[3];
  double d, radius2;
  double ang2;
   double D;
    ang2 = DEG2RAD*30;
  

  ar[0][0] = x1[0];
  ar[0][1] = x1[1];
  ar[0][2] = x1[2];

  ar[1][0] = x2[0];
  ar[1][1] = x2[1];
  ar[1][2] = x2[2];

  ar[4][0] = x2[0];
  ar[4][1] = x2[1];
  ar[4][2] = x2[2];

  vec[0] = x2[0]-x1[0];
  vec[1] = x2[1]-x1[1];
  vec[2] = x2[2]-x1[2];


/*fprintf(stderr,"NAvec0: %f %f %f\n",vec[0],vec[1],vec[2]);*/
  D = nize(vec);
/*fprintf(stderr,"d length: %f \n",d);
fprintf(stderr,"NAvec1: %f %f %f\n",vec[0],vec[1],vec[2]);*/
radius2 = .1*D;

  d = sqrt(vec[0]*vec[0] + vec[1]*vec[1]);



if(d==0){
     
  	mat1[0][0] = 0;
	mat1[0][1] = 0;
	mat1[0][2] = 1;
	mat1[1][0] = 0;
	mat1[1][1] = 1;
	mat1[1][2] = 0;
	mat1[2][0] = -1;
	mat1[2][1] = 0;
	mat1[2][2] = 0;
    }
   else
  {
 	mat1[0][0] = vec[0]/D;
	mat1[0][1] = vec[1]/D;
	mat1[0][2] = vec[2]/D;
	mat1[1][0] = -vec[1]/d;
	mat1[1][1] = vec[0]/d;
	mat1[1][2] = 0;
	mat1[2][0] = -vec[0]*vec[2]/(D*d);
	mat1[2][1] = -vec[1]*vec[2]/(D*d);
	mat1[2][2] = d/D;
}
/* find inverse  of matrix, turns out inverse is just transpose of mat1 (?) */
/* draw an arrow pointing along the x axis */
  vec1[0] = x2[0]-x1[0];
  vec1[1] = x2[1]-x1[1];
  vec1[2] = x2[2]-x1[2];

/*fprintf(stderr,"NAvec1: %f %f %f\n",vec1[0],vec1[1],vec1[2]);*/

 mat3mult(mat1, vec1, vec);

/*fprintf(stderr,"NAvec : %f %f %f (should be 1 0 0 )\n",vec[0],vec[1],vec[2]);*/


transpose(mat1);

/***********************/
  tem1[0] = D - radius2;
  tem1[1] = radius2*sin(ang2);
  tem1[2] = 0;

 mat3mult(mat1, tem1, vec1);

  ar[2][0] = vec1[0]+x1[0];
  ar[2][1] = vec1[1]+x1[1];
  ar[2][2] = vec1[2]+x1[2];

/***********************/

  tem1[0] = D - radius2;
  tem1[1] = -radius2*sin(ang2);
  tem1[2] = 0;

 mat3mult(mat1, tem1, vec1);

  ar[3][0] = vec1[0]+x1[0];
  ar[3][1] = vec1[1]+x1[1];
  ar[3][2] = vec1[2]+x1[2];






}


void ZEE_arrow(float x1[3], float x2[3], float ar[5][3])
{
  double mat1[3][3];
  double vec[3],vec1[3],tem1[3], vec2[3], tem[3];
  double d, radius2;
  double ang2;
   double D;
    ang2 = DEG2RAD*30;
  

  ar[0][0] = x1[0];
  ar[0][1] = x1[1];
  ar[0][2] = x1[2];

  ar[1][0] = x2[0];
  ar[1][1] = x2[1];
  ar[1][2] = x2[2];

  ar[4][0] = x2[0];
  ar[4][1] = x2[1];
  ar[4][2] = x2[2];

  vec[0] = x2[0]-x1[0];
  vec[1] = x2[1]-x1[1];
  vec[2] = x2[2]-x1[2];


/*fprintf(stderr,"NAvec0: %f %f %f\n",vec[0],vec[1],vec[2]);*/
  D = nize(vec);
/*fprintf(stderr,"d length: %f \n",d);
fprintf(stderr,"NAvec1: %f %f %f\n",vec[0],vec[1],vec[2]);*/
radius2 = .1*D;

  d = sqrt(vec[0]*vec[0] + vec[1]*vec[1]);



if(d==0){
     
  	mat1[0][0] = 0;
	mat1[0][1] = 0;
	mat1[0][2] = 1;
	mat1[1][0] = 0;
	mat1[1][1] = 1;
	mat1[1][2] = 0;
	mat1[2][0] = -1;
	mat1[2][1] = 0;
	mat1[2][2] = 0;
    }
   else
  {
 	mat1[0][0] = vec[0]/D;
	mat1[0][1] = vec[1]/D;
	mat1[0][2] = vec[2]/D;
	mat1[1][0] = -vec[1]/d;
	mat1[1][1] = vec[0]/d;
	mat1[1][2] = 0;
	mat1[2][0] = -vec[0]*vec[2]/(D*d);
	mat1[2][1] = -vec[1]*vec[2]/(D*d);
	mat1[2][2] = d/D;
}
/* find inverse  of matrix, turns out inverse is just transpose of mat1 (?) */
/* draw an arrow pointing along the x axis */
  vec1[0] = x2[0]-x1[0];
  vec1[1] = x2[1]-x1[1];
  vec1[2] = x2[2]-x1[2];

/*fprintf(stderr,"NAvec1: %f %f %f\n",vec1[0],vec1[1],vec1[2]);*/

 mat3mult(mat1, vec1, vec);

/*fprintf(stderr,"NAvec : %f %f %f (should be 1 0 0 )\n",vec[0],vec[1],vec[2]);*/


transpose(mat1);

/***********************/
  tem1[0] = D - radius2;
  tem1[2] = radius2*sin(ang2);
  tem1[1] = 0;

 mat3mult(mat1, tem1, vec1);

  ar[2][0] = vec1[0]+x1[0];
  ar[2][1] = vec1[1]+x1[1];
  ar[2][2] = vec1[2]+x1[2];

/***********************/

  tem1[0] = D - radius2;
  tem1[2] = -radius2*sin(ang2);
  tem1[1] = 0;

 mat3mult(mat1, tem1, vec1);

  ar[3][0] = vec1[0]+x1[0];
  ar[3][1] = vec1[1]+x1[1];
  ar[3][2] = vec1[2]+x1[2];






}


void BIG_arrow(float x1[3], float x2[3], float ar[8][3])
{
  double mat1[3][3];
  double vec[3],vec1[3],tem1[3], vec2[3], tem[3];
  double d, radius2;
  double ang2;
   double D;
    ang2 = DEG2RAD*30;
  

  ar[0][0] = x1[0];
  ar[0][1] = x1[1];
  ar[0][2] = x1[2];

  ar[1][0] = x2[0];
  ar[1][1] = x2[1];
  ar[1][2] = x2[2];

  ar[4][0] = x2[0];
  ar[4][1] = x2[1];
  ar[4][2] = x2[2];

  ar[7][0] = x2[0];
  ar[7][1] = x2[1];
  ar[7][2] = x2[2];


  vec[0] = x2[0]-x1[0];
  vec[1] = x2[1]-x1[1];
  vec[2] = x2[2]-x1[2];


/*fprintf(stderr,"NAvec0: %f %f %f\n",vec[0],vec[1],vec[2]);*/
  D = nize(vec);
/*fprintf(stderr,"d length: %f \n",d);
fprintf(stderr,"NAvec1: %f %f %f\n",vec[0],vec[1],vec[2]);*/
radius2 = .1*D;

  d = sqrt(vec[0]*vec[0] + vec[1]*vec[1]);



if(d==0){
     
  	mat1[0][0] = 0;
	mat1[0][1] = 0;
	mat1[0][2] = 1;
	mat1[1][0] = 0;
	mat1[1][1] = 1;
	mat1[1][2] = 0;
	mat1[2][0] = -1;
	mat1[2][1] = 0;
	mat1[2][2] = 0;
    }
   else
  {
 	mat1[0][0] = vec[0]/D;
	mat1[0][1] = vec[1]/D;
	mat1[0][2] = vec[2]/D;
	mat1[1][0] = -vec[1]/d;
	mat1[1][1] = vec[0]/d;
	mat1[1][2] = 0;
	mat1[2][0] = -vec[0]*vec[2]/(D*d);
	mat1[2][1] = -vec[1]*vec[2]/(D*d);
	mat1[2][2] = d/D;
}
/* find inverse  of matrix, turns out inverse is just transpose of mat1 (?) */
/* draw an arrow pointing along the x axis */
  vec1[0] = x2[0]-x1[0];
  vec1[1] = x2[1]-x1[1];
  vec1[2] = x2[2]-x1[2];

/*fprintf(stderr,"NAvec1: %f %f %f\n",vec1[0],vec1[1],vec1[2]);*/

 mat3mult(mat1, vec1, vec);

/*fprintf(stderr,"NAvec : %f %f %f (should be 1 0 0 )\n",vec[0],vec[1],vec[2]);*/


transpose(mat1);

/***********************/
  tem1[0] = D - radius2;
  tem1[1] = radius2*sin(ang2);
  tem1[2] = 0;

 mat3mult(mat1, tem1, vec1);

  ar[2][0] = vec1[0]+x1[0];
  ar[2][1] = vec1[1]+x1[1];
  ar[2][2] = vec1[2]+x1[2];

/***********************/

  tem1[0] = D - radius2;
  tem1[1] = -radius2*sin(ang2);
  tem1[2] = 0;

 mat3mult(mat1, tem1, vec1);

  ar[3][0] = vec1[0]+x1[0];
  ar[3][1] = vec1[1]+x1[1];
  ar[3][2] = vec1[2]+x1[2];



/***********************/
  tem1[0] = D - radius2;
  tem1[1] = 0;
  tem1[2] = radius2*sin(ang2);

 mat3mult(mat1, tem1, vec1);

  ar[5][0] = vec1[0]+x1[0];
  ar[5][1] = vec1[1]+x1[1];
  ar[5][2] = vec1[2]+x1[2];

/***********************/

  tem1[0] = D - radius2;
  tem1[1] = 0;
  tem1[2] = -radius2*sin(ang2);

 mat3mult(mat1, tem1, vec1);

  ar[6][0] = vec1[0]+x1[0];
  ar[6][1] = vec1[1]+x1[1];
  ar[6][2] = vec1[2]+x1[2];







}






void  ParrowA(FILE * inf, float phio, float lamo, float z1, float ang1, float ang2, int col, float size, float radius2)
{
	float           phi, lam;
	float           sin30 = 0.5;
	float           cos30 = 0.866025;
	float           sina, cosa;
	float           x, y, z;
	float           sinang2, cosang2, cosang1, sinang1;
	float           x2, y2, z2;
	float           sin1, cos1;

	cosang1 = cos(ang1);
	sinang1 = sin(ang1);

	cosang2 = cos(ang2);
	sinang2 = sin(ang2);

	z2 = z1 - size * sinang2;
	x2 = size * cosang2 * cosang1;
	y2 = size * cosang2 * sinang1;

	/*
	 * fprintf(stderr, "ParrowA: phi =%f lam = %f x2=%f y2=%f z2=%f
	 * \n",phio, lamo, x2, y2, z2); fprintf(stderr, "ParrowA: size=%f
	 * radius2=%f\n",size, radius2);
	 */



	fprintf(inf, "paxis 5 0 %d\n", col);
	/* jlcgc(phio, lamo, &phi, &lam, y1, x1); */

	fprintf(inf, "%f %f %f\n", phio, -lamo, z1);

	jlcgc(phio, lamo, &phi, &lam, y2, x2);

	fprintf(inf, "%f %f %f\n", phi, -lam, z2);



	sin1 = sin(ang2);
	cos1 = -cos(ang2);

	sina = sin1 * cos30 + cos1 * sin30;
	cosa = cos1 * cos30 - sin1 * sin30;

	z = z2 + radius2 * sina;
	x = x2 + radius2 * cosa * cosang1;
	y = y2 + radius2 * cosa * sinang1;

	jlcgc(phio, lamo, &phi, &lam, y, x);

	fprintf(inf, "%f %f %f\n", phi, -lam, z);


	sina = sin1 * cos30 - cos1 * sin30;
	cosa = cos1 * cos30 + sin1 * sin30;

	z = z2 + radius2 * sina;
	x = x2 + radius2 * cosa * cosang1;
	y = y2 + radius2 * cosa * sinang1;

	jlcgc(phio, lamo, &phi, &lam, y, x);

	fprintf(inf, "%f %f %f\n", phi, -lam, z);


	jlcgc(phio, lamo, &phi, &lam, y2, x2);

	fprintf(inf, "%f %f %f\n", phi, -lam, z2);

}
