      subroutine jtpplot (da1, dd1, sa1, strk1,dip1,strk2,
     &                  dip2,slip2,prot,pdip,trot,tdip,ipol) 
c                     
      integer		iunit
      real              da1                             ! dip angle of principle plane                                              
      real              dd1                             ! dip direction of principle plane                                          
      real              pi                              ! pi                                                                        
      real              rad                             ! pi/180                                                                    
      real              sa1                             ! rake of principle plane                                                   
c                     
      real              ain1                            ! angle of incidence of p/t axis                                            
      real              ain2                            ! angle of incidence of t/p axis                                            
      real              az1                             ! azimuth of p/t axis                                                       
      real              az2                             ! azimuth of t/p axis                                                       
      real              da2                             ! dip angle of auxilliary plane                                             
      real              dd2                             ! dip direction of auxilliary plane                                         
      real              sa2                             ! strike of auxilliary plane                                                
      double precision  phi1                            ! fault plane strike of principal plane                                     
      double precision  phi2                            ! strike of auxilliary plane in radians                                     
      character*1	sym1				! 1st pressure axis id
      character*1	sym2				! 2nd pressure axis id
c                     
c                     
c find auxilliary plane 
        real     strk1,dip1,strk2,dip2,prot,pdip,trot,tdip,slip2                                                                                                        
c      

  	  pi = 3.141592654
           degrad = 0.017453293
           raddeg = 57.295778667
            rad =   0.017453293             
      call auxpln (dd1, da1, sa1, dd2, da2, sa2)                                                                                    
      phi1 = dd1 - 90.0d0                                                                                                           
      if (phi1 .lt. 0.0d0) phi1 = phi1 + 360.0d0                                                                                    
      phi2 = dd2 - 90.0d0                                                                                                           
      if (phi2 .lt. 0.0d0) phi2 = phi2 + 360.0d0                                                                                    
c      write(iunit,*) 'strike1    dip1   slip1 strike2    dip2   slip2'
c      write(iunit,'(6(f7.2,1x))') phi1, da1, sa1, phi2, da2, sa2
        strk1 = phi1
        dip1 = da1
        slip1 = sa1
        strk2 = phi2
        dip2 = da2
        slip2 = sa2
         
        
c                     
c find p and t axes   
c                     
      call tandp (ain1, ain2, az1, az2, da1, da2, dd1, dd2, pi, rad) 

                                                               
c      write(iunit, *) 'pressure axis, azimuth, plunge'
      if (sa1 .lt. 0.) then                                                                                                         
        sym1 = 'p'    
        sym2 = 't'
          ipol = 1     
         else  
           ipol = 0 
        sym1 = 't'    
        sym2 = 'p'    
      end if          
	if (ain1.ge.90.0) then
		ain1=ain1-90.0
		az1=az1+180.0
	else
		ain1=90.0-ain1
	endif
	if (ain2.ge.90.0) then
		ain2=ain2-90.0
		az2=az2+180.0
	else
		ain2=90.0-ain2
	endif
	if (az1.lt.0.0) az1=az1+360.0
	if (az2.lt.0.0) az2=az2+360.0



c      write(iunit, 101) sym1, az1, ain1
101    format(8x,a1,6x,f7.2,2x,f7.2)
c      write(iunit, 101) sym2, az2, ain2
c   

	if (sym1.eq.'p')then
        
             prot = az1
             pdip = ain1
             trot = az2
             tdip = ain2

c      write(0,*) prot,pdip,trot,tdip,' ',sym1
         else
             trot = az1
             tdip = ain1
             prot = az2
             pdip = ain2
c      write(0,*) prot,pdip,trot,tdip,' ',sym1
         endif
c      write(0,*) prot,pdip,trot,tdip,' ',sym1
           return
           end
