#include <stdio.h>
#include <math.h>
#include <string.h>

#include "..Progs/Ref/primitive.h"
#include "..Progs/Ref/pickfile.h"

#define            DEG2RAD   0.017453293
#define            RAD2DEG  57.295778667
#define            PI        3.141592654
#define            PIO2     1.570796327
#define            SQRT2	1.414213562

void TP_2_XYZ(float trend, float dip, float *x);


#include <focproto.h>

typedef  struct {
    ac_rec ac;
     Mech  fm;

   } foc_rec;

BOOLEAN readac( FILE *f, ac_rec *a);
BOOLEAN readmc( FILE *f, Mech *a);

void jgclc(float phio,float lamo,float phi,float lam, float *x, float *y);
void jlcgc(float phio,float lamo,float *phi,float *lam, float ex, float why);

void ParrowA(FILE * inf, float phio, float lamo, float z1, float theta, float delta, int col, float size, float radius2);

void create_Acard(ac_rec *ac , char *acrd);
void create_Mcard(Mech *mc , char *mcrd);

void new_arrow(float x1[3], float x2[3], float ar[5][3]);
void BIG_arrow(float x1[3], float x2[3], float ar[8][3]);
void ZEE_arrow(float x1[3], float x2[3], float ar[5][3]);

BOOLEAN readfoc( FILE *f, foc_rec *a)
{
char acard[76];

readac( f, &a->ac);
readmc( f, &a->fm);
	if (  feof(f) ) return FALSE;
        return TRUE; 
}


void main(int argc, char **argv)
{

FILE  *fopen(), *inf;
 int i, j, col, kind;
char acard[76];
char mcard[76];
float size, theta, delta, radius2;
float phio, lamo, phi, lam;
float x1,y1,z1,x2,y2,z2;
float vec[3];
foc_rec foc;
float v1[3],v2[3],ar[5][3], Bar[8][3];

char foc_file[60];

if(argc<2){ fprintf(stderr,"USAGE: parrow A&M_file size kind> output\n"); return; }

size = atof(argv[2]);
kind = atoi(argv[3]);

 strcpy(foc_file, argv[1]);
fprintf(stderr,"%s %f\n",foc_file, size);

	if(( inf = fopen( foc_file ,"r")) == NULL) {
		printf("Can't open Focal Mechanisms: %s  Try again\n",foc_file);
		 
		 return;
	 }
							 
	  
	i = 0;
        col = 2;
  	
	while( readfoc( inf, &foc) )
           {
#if 0
     create_Acard( &foc.ac, acard);
      fprintf(stderr,"%s",acard);

     create_Mcard( &foc.fm, mcard);
      fprintf(stderr,"%s",mcard);
#endif


   /* first convert to km  */

       
      phio = (float)foc.ac.lat1+foc.ac.lat2/6000.0;
      lamo = (float)foc.ac.lon1+foc.ac.lon2/6000.0;

       theta = DEG2RAD * foc.fm.prot;
       delta = DEG2RAD * (90-foc.fm.pdip);

     v1[0] = 0;
     v1[1] = 0;
     v1[2] = foc.ac.depth;


  
     v2[0] = size*sin(delta)*sin(theta);
     v2[1] = size*sin(delta)*cos(theta);
     v2[2] = v1[2]+size*cos(delta);



	/*fprintf(stderr, "theta=%f delta=%f v1=[%f %f %f] v2=[%f %f %f]\n", foc.fm.prot,
foc.fm.pdip, v1[0],v1[1],v1[2],v2[0],v2[1],v2[2]);*/
switch (kind) {
case 0:
	fprintf(stdout, "paxis 5 0 %d\n", col);
	new_arrow(v1, v2, ar);
	for (j = 0; j < 5; j++) {
		jlcgc(phio, lamo, &phi, &lam, ar[j][1], ar[j][0]);
		fprintf(stdout, "%f %f %f\n", phi, -lam, ar[j][2]);

	}
	break;

case 1:
	fprintf(stdout, "paxis 5 0 %d\n", col);
	ZEE_arrow(v1, v2, ar);
	for (j = 0; j < 5; j++) {
		jlcgc(phio, lamo, &phi, &lam, ar[j][1], ar[j][0]);
		fprintf(stdout, "%f %f %f\n", phi, -lam, ar[j][2]);

	}
	break;

case 2:

	fprintf(stdout, "paxis 8 0 %d\n", col);
	BIG_arrow(v1, v2, Bar);
	for (j = 0; j < 8; j++) {
		jlcgc(phio, lamo, &phi, &lam, Bar[j][1], Bar[j][0]);
		fprintf(stdout, "%f %f %f\n", phi, -lam, Bar[j][2]);
	}
	break;


}



         }

}
