                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
      subroutine auxpln (dd1, da1, sa1, dd2, da2, sa2)                                                                              
c                                                                                                                                   
c    calculate the auxilliary plane of a double couple fault plane solution, given the principle plane.                             
c                                                                                                                                   
c    written by paul reasenberg, june, 1984, from class notes by dave boore, (both at the u.s.g.s., menlo park.)                    
c    angle variables phi, del and lam are as defined in aki and richards, (1980), p.114.                                            
c                                                                                                                                   
      real              da1                             ! dip angle in degrees                                                      
      real              dd1                             ! dip directions in degrees                                                 
      real              sa1                             ! slip angle in degrees                                                     
      real              da2                             ! dip angle of auxilliary plane                                             
      real              dd2                             ! dip direction of auxilliary plane                                         
      real              sa2                             ! slip angle of auxillary plane                                             
c                                                                                                                                   
                                                                                                                                    
      double precision  bot                             ! scratch variable                                                          
      double precision  del1                            ! dip angle of principal plane in radians                                   
      logical           first                           ! test: true if first time into routine                                     
      double precision  phi1                            ! fault plane strike of principal plane                                     
      double precision  phi2                            ! strike of auxilliary plane in radians                                     
      double precision  rad                             ! conversion factor from degrees to radian                                  
      double precision  sgn                             ! saves principal plane slip angle for assigning proper sign to auxilliary  
      double precision  top                             ! scratch variable                                                          
      double precision  xlam1                           ! slip angle of principal plane in radians                                  
      double precision  xlam2                           ! slip angle of auxilliary plane                                            
c                                                                                                                                   
      data first /.true./                                                                                                           
      save first, rad                                                                                                               
c                                                                                                                                   
      if (first) then                                                                                                               
        first = .false.                                                                                                             
        rad = datan(1.0d0)/45.0d0                                                                                                   
      end if                                                                                                                        
c                                                                                                                                   
      phi1 = dd1 - 90.0d0                                                                                                           
      if (phi1 .lt. 0.0d0) phi1 = phi1 + 360.0d0                                                                                    
      phi1 = phi1*rad                                                                                                               
      del1 = da1*rad                                                                                                                
      sgn = sa1                                                                                                                     
      xlam1 = sa1*rad                                                                                                               
c                                                                                                                                   
      top = dcos(xlam1)*dsin(phi1) - dcos(del1)*dsin(xlam1)*dcos(phi1)                                                              
      bot = dcos(xlam1)*dcos(phi1) + dcos(del1)*dsin(xlam1)*dsin(phi1)                                                              
      dd2 = datan2(top, bot)/rad                                                                                                    
      phi2 = (dd2 - 90.0d0)*rad                                                                                                     
      if (sa1 .lt. 0.0d0) dd2 = dd2 - 180.0d0                                                                                       
      if (dd2 .lt. 0.0d0) dd2 = dd2 + 360.0d0                                                                                       
      if (dd2. gt. 360.0d0) dd2 = dd2 - 360.0d0                                                                                     
c                                                                                                                                   
      da2 = dacos(dsin(dabs(xlam1))*dsin(del1))/rad                                                                                 
      xlam2 = -dcos(phi2)*dsin(del1)*dsin(phi1) +                                                                                   
     & dsin(phi2)*dsin(del1)*dcos(phi1)                                                                                             
c                                                                                                                                   
c machine accuracy problem                                                                                                          
c                                                                                                                                   
      if (dabs(xlam2) .gt. 1.0d0) then                                                                                              
        xlam2 = dsign(1.0d0, xlam2)                                                                                                 
      end if                                                                                                                        
      xlam2 = dsign(dacos(xlam2), sgn)                                                                                              
      sa2 = xlam2/rad                                                                                                               
c                                                                                                                                   
      return                                                                                                                        
      end                                                                                                                           
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
      subroutine tpplot (da1, dd1, pi, rad, sa1, iunit) 
c                                                                                                                                   
      integer		iunit
      real              da1                             ! dip angle of principle plane                                              
      real              dd1                             ! dip direction of principle plane                                          
      real              pi                              ! pi                                                                        
      real              rad                             ! pi/180                                                                    
      real              sa1                             ! rake of principle plane                                                   
c                                                                                                                                   
      real              ain1                            ! angle of incidence of p/t axis                                            
      real              ain2                            ! angle of incidence of t/p axis                                            
      real              az1                             ! azimuth of p/t axis                                                       
      real              az2                             ! azimuth of t/p axis                                                       
      real              da2                             ! dip angle of auxilliary plane                                             
      real              dd2                             ! dip direction of auxilliary plane                                         
      real              sa2                             ! strike of auxilliary plane                                                
      double precision  phi1                            ! fault plane strike of principal plane                                     
      double precision  phi2                            ! strike of auxilliary plane in radians                                     
      character*1	sym1				! 1st pressure axis id
      character*1	sym2				! 2nd pressure axis id
c                                                                                                                                   
c                                                                                                                                   
c find auxilliary plane                                                                                                             
c                                                                                                                                   
      call auxpln (dd1, da1, sa1, dd2, da2, sa2)                                                                                    
      phi1 = dd1 - 90.0d0                                                                                                           
      if (phi1 .lt. 0.0d0) phi1 = phi1 + 360.0d0                                                                                    
      phi2 = dd2 - 90.0d0                                                                                                           
      if (phi2 .lt. 0.0d0) phi2 = phi2 + 360.0d0                                                                                    
      write(iunit,*) 'strike1    dip1   slip1 strike2    dip2   slip2'
      write(iunit,'(6(f7.2,1x))') phi1, da1, sa1, phi2, da2, sa2
c                                                                                                                                   
c find p and t axes                                                                                                                 
c                                                                                                                                   
      call tandp (ain1, ain2, az1, az2, da1, da2, dd1, dd2, pi, rad)                                                                
      write(iunit, *) 'pressure axis, azimuth, plunge'
      if (sa1 .lt. 0.) then                                                                                                         
        sym1 = 'p'                                                                                                                  
        sym2 = 't'                                                                                                                  
      else                                                                                                                          
        sym1 = 't'                                                                                                                  
        sym2 = 'p'                                                                                                                  
      end if                                                                                                                        
	if (ain1.ge.90.0) then
		ain1=ain1-90.0
		az1=az1+180.0
	else
		ain1=90.0-ain1
	endif
	if (ain2.ge.90.0) then
		ain2=ain2-90.0
		az2=az2+180.0
	else
		ain2=90.0-ain2
	endif
	if (az1.lt.0.0) az1=az1+360.0
	if (az2.lt.0.0) az2=az2+360.0
      write(iunit, 101) sym1, az1, ain1
101    format(8x,a1,6x,f7.2,2x,f7.2)
      write(iunit, 101) sym2, az2, ain2
c                                                                                                                                   
      return                                                                                                                        
      end                                                                                                                           
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
      subroutine tandp(ain1, ain2, az1, az2, da1, da2, dd1, dd2, pi,rad)                                                            
c                                                                                                                                   
c     given two planes compute az and angle of incidence of p & t axes                                                              
c                                                                                                                                   
      real              ain1                            ! angle of incidence of p/t axis                                            
      real              ain2                            ! angle of incidence of t/p axis                                            
      real              az1                             ! azimuth of p/t axis                                                       
      real              az2                             ! azimuth of t/p axis                                                       
      real              da1                             ! dip angle of priniciple plane                                             
      real              da2                             ! dip angle of auxilliary plane                                             
      real              dd1                             ! dip direction of principle plane                                          
      real              dd2                             ! dip direction of auxilliary plane                                         
      real              pi                              ! pi                                                                        
      real              rad                             ! pi/180                                                                    
c                                                                                                                                   
      real              alat1                           ! dip angle in radians of principle plane measured from vertical            
      real              alat2                           ! dip angle in radians of auxilliary plane measured from vertical           
      real              alon1                           ! dd1 in radians                                                            
      real              alon2                           ! dd2 in radians                                                            
      real              azimth                          ! azimuth in radians of pole ??                                             
      real              az0                             ! azimuth from pole of auxilliary plane to pole of principle ??             
      real              bazm                            ! not used                                                                  
      real              delta                           ! not used                                                                  
      real              plunge                          ! plunge in radians of pole ??                                              
      real              shift                           ! azimuthal shift from pole of plane to p to t axis (= 45 degrees)??        
      real              xpos                            ! not used                                                                  
      real              ypos                            ! not used                                                                  
c                                                                                                                                   
      parameter (shift = 0.7853981)                                                                                                 
c                                                                                                                                   
      alat1 = (90. - da1)*rad                                                                                                       
      alon1 = dd1*rad                                                                                                               
      alat2 = (90. - da2)*rad                                                                                                       
      alon2 = dd2*rad                                                                                                               
      call refpt (alat2, alon2)                                                                                                     
      call delaz (alat1, alon1, delta, az0, bazm, xpos, ypos)                                                                       
      call back (shift, az0, plunge, azimth)                                                                                        
      if (abs(azimth) .gt. pi) azimth = azimth - sign(2.0*pi, azimth)                                                               
      az1 = azimth/rad                                                                                                              
      ain1 = plunge/rad + 90.                                                                                                       
      az0 = az0 + pi                                                                                                                
      call back (shift, az0, plunge, azimth)                                                                                        
      if (abs(azimth) .gt. pi) azimth = azimth - sign(2.0*pi, azimth)                                                               
      az2 = azimth/rad                                                                                                              
      ain2 = plunge/rad + 90.                                                                                                       
c                                                                                                                                   
      return                                                                                                                        
      end                                                                                                                           
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
      subroutine geocen                                                                                                             
c                                                                                                                                   
c      geocen - calculate geocentric postitions, distances, and azimuths (bruce julian, usgs menlo park, ca)                        
c                                                                                                                                   
c      the geocentric distance delta and azimuth az0 from point (lat0, lon0) to point (lat1, lon1) are calculted from               
c            cos(delta) = cos(lat0')*cos(lat1')*cos(lon1 - lon0) + sin(lat0')*sin(lat1')                                            
c            sin(delta) = sqrt(a*a + b*b)                                                                                           
c            tan(az0) = a/b                                                                                                         
c                                                                                                                                   
c      where                                                                                                                        
c            a = cos(lat1')*sin(lon1-lon0)                                                                                          
c            b = cos(latn0')*sin(lat1') - sin(lat0')*cos(lat1')*cos(lon1 - lon0)                                                    
c            lat0', lat1' = geocentric latitudes of points                                                                          
c            lon0, lon1 = longitudes of points                                                                                      
c                                                                                                                                   
c      the geocentric latitude lat' is gotten from the geographic latitude lat by tan(lat') = (1 - alpha)*(1 - alpha)*tan(lat),     
c      where alpha is the flattening of the ellipsoid.  see function ggtogc for conversion.                                         
c      the back azimuth is calculated by the same formulas with (lat0', lon0) and (lat1', lon1) interchanged.                       
c      azimuth is measured clockwise from north thru east.                                                                          
c                                                                                                                                   
      real              r, theta                        ! radius, azimuth in polar coordinates                                      
      real              az0                             ! azimuth from reference point to secondary point in radians                
      real              az1                             ! azimuth from secondary point to reference point in radians                
      real              cdelt                           ! sine of delta to secondary point                                          
      real              cdlon                           ! cosine of difference of secondary point, reference longitude              
      real              colat                           ! average colatitude of station                                             
      real              ct0                             ! sine of reference point latitude                                          
      real              ct1                             ! sine of secondary point latitude                                          
      real              cz0                             ! cosine of azimuth to secondary point                                      
      real              delta                           ! geocentric distance in degrees                                            
      real              dlon                            ! azimuth in polar coordinates to secondary point ?                         
      real              erad                            ! equatorial radius (chovitz, 1981, eos, 62, 65-67)                         
      real              flat                            ! earth flattening constant (chovitz, 1981, eos, 62, 65-67)                 
      integer           lambda                          ! dummy variable                                                            
      real              lat                             ! latitude in radians                                                       
      real              lon                             ! longitude in radians                                                      
      real              olat                            ! origin latitude in radians                                                
      real              olon                            ! origin longitude in radians                                               
      real              phi0                            ! reference secondary point longitude                                       
      real              pi                              ! 3.14159...                                                                
      real              radius                          ! earth radius at colat                                                     
      real              sdelt                           ! cosine of delta to secondary point                                        
      real              sdlon                           ! sine of difference of secondary point, reference longitude                
      real              st0                             ! cosine of reference point latitude                                        
      real              st1                             ! cosine of secondary point latitude                                        
      real              twopi                           ! 2*pi
      
c                                                                                                                                   
c      save st0, ct0, phi0, olat
      save st0, ct0, phi0
      parameter (pi = 3.1415926535897, twopi = 2.*pi)                                                                               
      parameter (flat = 1./298.257, erad = 6378.137)                                                                                
      parameter (lambda = flat*(2. - flat)/(1. - flat)**2)                                                                          
c                                                                                                                                   
c refpt - store the geocentric coordinates of the refeernce point                                                                   
c                                                                                                                                   
      entry refpt(olat, olon)                                                                                                       
c                                                                                                                                   
      st0 = cos(olat)                                                                                                               
      ct0 = sin(olat)                                                                                                               
      phi0 = olon                                                                                                                   
      return                                                                                                                        
c                                                                                                                                   
c delaz - calculate the geocentric distance, azimuths                                                                               
c                                                                                                                                   
      entry delaz(lat, lon, delta, az0, az1, x, y)                                                                                  
c                                                                                                                                   
      ct1 = sin(lat)                                                                                                                
      st1 = cos(lat)                                                                                                                
      if ((ct1 - ct0) .eq. 0. .and. (lon - phi0) .eq. 0.) then                                                                      
        delta = 0.                                                                                                                  
        az0 = 0.                                                                                                                    
        az1 = 0.                                                                                                                    
      else                                                                                                                          
        sdlon = sin(lon - phi0)                                                                                                     
        cdlon = cos(lon - phi0)                                                                                                     
        cdelt = st0*st1*cdlon + ct0*ct1                                                                                             
        call cvrtop (st0*ct1 - st1*ct0*cdlon, st1*sdlon, sdelt, az0)                                                                
        delta = atan2(sdelt, cdelt)                                                                                                 
        call cvrtop (st1*ct0 - st0*ct1*cdlon, -sdlon*st0, sdelt, az1)                                                               
        if (az0 .lt. 0.0) az0 = az0 + twopi                                                                                         
        if (az1 .lt. 0.0) az1 = az1 + twopi                                                                                         
      end if                                                                                                                        
      colat = pi/2. - (lat + olat)/2.                                                                                               
      radius = erad/sqrt(1.0 + lambda*cos(colat)**2)                                                                                
      y = radius*delta*cos(az0)                                                                                                     
      x = radius*delta*sin(az0)                                                                                                     
      return                                                                                                                        
c                                                                                                                                   
c back - calculate geocentric coordinates of secondary point from delta, az                                                         
c                                                                                                                                   
      entry back (delta, az0, lat, lon)                                                                                             
c                                                                                                                                   
      sdelt = sin(delta)                                                                                                            
      cdelt = cos(delta)                                                                                                            
      cz0 = cos(az0)                                                                                                                
      ct1 = st0*sdelt*cz0 + ct0*cdelt                                                                                               
      call cvrtop (st0*cdelt - ct0*sdelt*cz0, sdelt*sin(az0), st1, dlon)                                                            
      lat = atan2(ct1, st1)                                                                                                         
      lon = phi0 + dlon                                                                                                             
      if (abs(lon) .gt. pi) lon = lon - sign(twopi, lon)                                                                            
c                                                                                                                                   
      return                                                                                                                        
      end                                                                                                                           
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
      subroutine cvrtop(x, y, r, theta)                                                                                             
c                                                                                                                                   
c cvrtop - convert from rectangular to polar coordinates (bruce julian, usgs menlo park, ca)                                        
c                                                                                                                                   
      real              x,y                             ! x,y rectangular coordinates                                               
      real              r, theta                        ! radius, azimuth in polar coordinates                                      
c                                                                                                                                   
      r = sqrt(x*x + y*y)                                                                                                           
      theta = atan2(y, x)                                                                                                           
      return                                                                                                                        
      end                                                                                                                           
c                                                                                                                                   
c                                                                                                                                   
c                                                                                                                                   
        subroutine upstr (str, len)                                                                                                 
c                                                                                                                                   
c       upstr converts the character string str to upper case.                                                                      
c       len is the number of characters to convert, not to exceed the                                                               
c       actual length of str.                                                                                                       
c                                                                                                                                   
c       author: fred klein (u.s.g.s)                                                                                                
c                                                                                                                                   
        character str*(*)                                                                                                           
        do 2 i = 1, len                                                                                                             
          j = ichar(str(i:i))                                                                                                       
          if (j .gt. 96 .and. j .lt. 123) str(i:i) =  char(j - 32)                                                                  
2       continue                                                                                                                    
        return                                                                                                                      
        end                                                                                                                         
