#include <math.h>

/* ************ FUNCTION DELTA ************ */
double delta_(double *rlat1, double *rlong1, double *rlat2, double *rlong2)
{
    /* System generated locals */
    double ret_val;

    /* Local variables */
    static double del;

/* ...given lat,long coords (radians) of points 1 and 2 routine */
/* ...returns geocentric angular distance (radians) between */
/* ...points 1 and 2. For best results be sure geocentric latitudes */
/* ...are fed to this routine. */
    del = cos(*rlat1) * cos(*rlat2) * cos(*rlong1 - *rlong2);
    del += sin(*rlat1) * sin(*rlat2);
/* ...Account for roundoff */
    if (del > 1.) {
	del = (float)1.;
    }
    if (del < -1.) {
	del = (float)-1.;
    }
    ret_val = acos(del);
    return ret_val;
} /* delta_ */

double azim_(double *delt, double *rla1,double * rla2, double *rlo1, double *rlo2)
{
    /* System generated locals */
    double ret_val;

    /* Local variables */
    static int nchek, nquad;
    static double sdelt, phi;

/* ...Given angular distance delt between points 1 and 2 and lat and */
/* ...long of points 1 and 2 azimuth from point 1 to 2 is returned. */
/* ...All angles (rla1, rla2, rlo1, rlo2, and azim) are in radians. */
/* ...Note:Azim is 0 to 2*PI clockwise from north. East longitude */
/* ...is + and west long. is -. */
/* ...Check special case......................... */
    sdelt = sin(*delt);
    if (sdelt < 1e-7) {
	ret_val = (float)0.;
	return ret_val;
    }
/* ............................................... */
    if (*rlo1 < 0.) {
	*rlo1 += 6.2831853071795862;
    }
    if (*rlo2 < 0.) {
	*rlo2 += 6.2831853071795862;
    }
    nquad = 0;
    phi = *rlo2 - *rlo1;
    nchek = (int) (phi / 3.141592653589793238 + (float)3.);
    switch ((int)nchek) {
	case 1:  goto L10;
	case 2:  goto L20;
	case 3:  goto L30;
	case 4:  goto L40;
    }
L10:
    phi += 6.2831853071795862;
    nquad = 1;
    goto L50;
L20:
    phi = -phi;
    goto L50;
L30:
    nquad = 1;
    goto L50;
L40:
    phi = 6.2831853071795862 - phi;
L50:
    ret_val = -cos(*rla2) * cos(phi) * sin(*rla1);
    ret_val += cos(*rla1) * sin(*rla2);
    ret_val /= sdelt;
/* ...Account for roundoff */
    if (ret_val > 1.) {
	ret_val = (float)1.;
    }
    if (ret_val < -1.) {
	ret_val = (float)-1.;
    }
    ret_val = acos(ret_val);
    if (nquad == 1) {
	return ret_val;
    }
    ret_val = 6.2831853071795862 - ret_val;
    return ret_val;
} /* azim_ */

