#include <stdio.h>
#include <math.h>


/* Table of constant values */

#ifndef ABS
#define ABS(a) ((a) < (0) ? -(a) : (a))
#endif

double delta_(double *rlat1, double *rlong1, double *rlat2, double *rlong2);
double azim_(double *delt, double *rla1,double * rla2, double *rlo1, double *rlo2);



static float c_b4 = (float)0.;
static float c_b5 = (float)45.;
static float c_b6 = (float)135.;

/* ********************** SITE **************************************** */
int siteJ(float *xla1, float *xlo1, float *xla2, float *xlo2, float *del, float *az)
{
    /* Initialized data */

    static float geocen = (float).9932315;
    static float dtr = (float).01745329251;
    static float pi = (float)3.14159265;

    /* System generated locals */
    float r__1;

    /* Local variables */
    static float pang, temp, pxla1, pxla2, rxla1, rxlo1, c1, c2, d5, s1, cd;

/* ...calculates geographic coords of point 2 on earth given coords of */
/* ...point 1 and delta and az (all in degs) */
/* ...of point 2 rel. to point 1. del is assumed to be geocentric. */
/* ...Routine adjusts for ellipticity. */
/* ... */
/* ...Site is a variation of point.f that always does computations */
/* ...for point1 each time routine is called. */
/* ... */
/* ...Note that west longitude is considered negative in this routine. */
/* ... */
/* ...calculate some point 1 parameters.................................. 
*/

/*    DO NOT USE ELLIPTICITY */
    geocen = (float)1.;

    if (*xla1 >= (float)90.) {
	pxla1 = (float)0.;
    } else if (*xla1 <= (float)-90.) {
	pxla1 = pi;
    } else {
	r__1 = *xla1 * dtr;
	rxla1 = atan(geocen * (sin(r__1) / cos(r__1)));
	pxla1 = pi / (float)2. - rxla1;
    }
/* ...convert long of point 1 to 0-360 deg */
    rxlo1 = dtr * *xlo1;
    if (rxlo1 < (float)0.) {
	rxlo1 += pi * (float)2.;
    }
    c1 = cos(pxla1);
    s1 = sin(pxla1);
/* ...................................................................... 
*/
/* ...compute latitude of point 2 */
    d5 = *del * dtr;
    cd = cos(d5);
    c2 = c1 * cd + s1 * sin(d5) * cos(*az * dtr);
    if (c2 > (float)1.) {
	c2 = (float)1.;
    }
    if (c2 < (float)-1.) {
	c2 = (float)-1.;
    }
    pxla2 = acos(c2);
    *xla2 = pi / (float)2. - pxla2;
/* ...convert to geographic coords */
    *xla2 = atan((float)1. / geocen * (sin(*xla2) / cos(*xla2)));
    *xla2 /= dtr;
/* ...compute long diff. betw. 1 and 2. */
    temp = (cd - c1 * c2) / (s1 * sin(pxla2));
    if (temp > (float)1.) {
	temp = (float)1.;
    }
    if (temp < (float)-1.) {
	temp = (float)-1.;
    }
    pang = acos(temp);
    if (*az - (float)180. > (float)0.) {
	*xlo2 = (rxlo1 - pang) / dtr;
    } else {
	*xlo2 = (rxlo1 + pang) / dtr;
    }
    if (*xlo2 > (float)180.) {
	*xlo2 += (float)-360.;
    }
    return 0;
} /* siteJ */



int mconv2J(float *strk, float *dip, float *rake, float *rlatf, float *rlonf, float *rlatg, float *rlong, 
	float *rlatu, float *rlonu, float *rlatv, float *rlonv, float *rlatp, float *rlonp, float *rlatt, float *rlont)
{
    static double delt;
    static float rlona, qlons, qlonu;
    static double az;
    static int lu1, lu2, lu3;
    static float azz;
    static double rla1, rla2, rlo1, rlo2;

/* input: strk, dip and rake : in degrees */
/* input: rlatf, rlonf, rlatu, rlonu : degrees */
/* output:  rlatg, rlong, rlatv, rlonv, rlatp, rlonp, rlatt, rlonp */

/* For a GENERAL CASE - (not pure strike-slip, dip-slip, normal */
/* or thrust) */
/* this program converts from a fault plane representation */
/* given as strike dip and rake to the UW format of */
/* azimuth and plunge of strike and auxilary planes, and */
/* azimuth and plunge of the poles of the planes, and */
/* azimuth and plunge of the P nd T axes */

/*  RAKE PASSED INTO THIS ROUTINE IS THE ABSOLUTE VALUE OF THE RAKE */
/*  if the REAL rake is negative, the P and T axes emerging from this */
/* routine will be reversed relative to desired P and T axes */

/* According to Aki & Richards, Quantitative Seismology, Theory and */
/* Methods, Vol 1. p 106, */


    lu2 = 6;
    lu3 = 8;
    lu1 = 5;
/* find V  - V is pole of auxilliary plane G */
/* 	use absolute value of rake,  because sign only reflects */
/*       quadrant polarity, per Aki&Richards, V. 1 p. 106 */
/*  Determine azimuth from strike to F */
/*       change to radians */
    rla1 = (float)0.;
    rlo1 = *strk * (float)6.2831853 / (float)360.;
    rla2 = *rlatf * (float)6.2831853 / (float)360.;
    rlo2 = *rlonf * (float)6.2831853 / (float)360.;

    /* fprintf(stderr,"T1: %f %f %f %f %f %f %f\n", *strk, *dip, *rake, 
              *rlatf, *rlonf, *rlatu, *rlonu); */
    

/*       determine delta */
    delt = delta_(&rla1, &rlo1, &rla2, &rlo2);
/* determine azimuth (in radians) */
    az = azim_(&delt, &rla1, &rla2, &rlo1, &rlo2);
/* convert to degrees */
    azz = az * (float)360. / (float)6.2831853;
/*  V - step out 'rake' degrees from strike */
    qlons = *strk;
    if (*strk > (float)180.) {
	qlons = *strk - (float)360.;
    }

    *rlatv = (float)0.;
    *rlonv = (float)0.;
    siteJ(&c_b4, &qlons, rlatv, rlonv, rake, &azz);
    if (*rlonv < (float)0.) {
	*rlonv += 360;
    }
/* lon=az, lat=plunge */
    if (*rlatv < (float)0.) {
	*rlatv += (float)90.;
	*rlonv += (float)180.;
	if (*rlonv >= (float)360.) {
	    *rlonv += (float)-360.;
	}
    }
    if (*rlatv > (float)90.) {
	*rlatv += (float)-90.;
	*rlonv += (float)180.;
	if (*rlonv >= (float)360.) {
	    *rlonv += (float)-360.;
	}
    }

/* find G  -  V is the pole of G */
    *rlong = *rlonv + (float)180.;
    *rlatg = 90 - *rlatv;
    if (*rlong >= (float)360.) {
	*rlong += (float)-360.;
    }
/* find P and T */
/*  Determine azimuth from U to V */
/*       change to radians */
    rla1 = *rlatu * (float)6.2831853 / (float)360.;
    rlo1 = *rlonu * (float)6.2831853 / (float)360.;
    rla2 = *rlatv * (float)6.2831853 / (float)360.;
    rlo2 = *rlonv * (float)6.2831853 / (float)360.;
/*       determine delta */
    delt = delta_(&rla1, &rlo1, &rla2, &rlo2);
/* determine azimuth (in radians) */
    az = azim_(&delt, &rla1, &rla2, &rlo1, &rlo2);
/* convert to degrees */
    azz = az * (float)360. / (float)6.2831853;
/*  P - step out 45 degrees from U towards V */
    qlonu = *rlonu;
    if (rlona > (float)180.) {
	qlonu = rlona - (float)360.;
    }


    *rlatp = (float)0.;
    *rlonp = (float)0.;
    siteJ(rlatu, &qlonu, rlatp, rlonp, &c_b5, &azz);
    if (*rlonp < (float)0.) {
	*rlonp += 360;
    }
/* lon=az, lat=plunge */
    if (*rlatp < (float)0.) {
	*rlatp += (float)90.;
	*rlonp += (float)180.;
	if (*rlonp >= (float)360.) {
	    *rlonp += (float)-360.;
	}
    }
    if (*rlatp > (float)90.) {
	*rlatp += (float)-90.;
	*rlonp += (float)180.;
	if (*rlonp >= (float)360.) {
	    *rlonp += (float)-360.;
	}
    }
/*  T - step out 135 degrees from U towards V */
    *rlatt = (float)0.;
    *rlont = (float)0.;
    siteJ(rlatu, &qlonu, rlatt, rlont, &c_b6, &azz);
    if (*rlont < (float)0.) {
	*rlont += 360;
    }
/* lon=az, lat=plunge */
    if (*rlatt < (float)0.) {
	*rlatt *= (float)-1.;
	*rlont += (float)180.;
	if (*rlont >= (float)360.) {
	    *rlont += (float)-360.;
	}
    }
    if (*rlatt > (float)90.) {
	*rlatt += (float)-90.;
	*rlont += (float)180.;
	if (*rlont >= (float)360.) {
	    *rlont += (float)-360.;
	}
    }





    return 0;
} 


/*** FUNC DEF ***/ int mconvJ(float *jfaz, float *jdip, float *jrake, float *rlatf, float *rlonf, float *rlatg, float *rlong, 
	float *rlatu, float *rlonu, float *rlatv, float *rlonv, float *rlatp, float *rlonp, float *rlatt, float *rlont)
{
    /* System generated locals */
    float r__1;

    /* Local variables */
    static float rake, rtmp, strk, adip1, adip2, arake;
    static int iorig;
    static float arake1, arake2;
    static float rlongf, dip, tol;

/* input: jfaz, jdip and jrake : in degrees */
/* output: rlatf, rlonf, rlatu, rlonu, rlatg, rlong, rlatv, rlonv, */
/*        rlatp, rlonp, rlatt, rlonp: in degrees */

/* rlonf  and rlatf are azimuth and plunge of point "F" as defined */
/* for the "M" card in "pickfile" and "focal" UW documentation. */
/* likewise G,U,V,P and T */

/* this routine converts from a fault plane representation */
/* given as strike, dip, and rake to the UW format of */
/* azimuth and plunge of fault(F), and auxilary(G) planes, and */
/* azimuth and plunge of the poles of the planes (U and V), and */
/* azimuth and plunge of the P and T axes */
/* ...CORRECTION. IT APPEARS TO ME THAT INPUT VARIABLE jfaz IS THE */
/* ...AZIMUTH OF THE DIP VECTOR OF THE PLANE, NOT ITS STRIKE. */
/* ...THEREFORE, input variables jfaz, jdip, jrake are the */
/* ...   dip direction, dip, and rake of the "fault plane" -tony Q. 12/91 
*/


/* According to Aki & Richards, Quantitative Seismology, Theory and */
/* Methods, Vol 1. p 106, */


    tol = (float).001;
/* Float the input arguments */

    *rlonf = (float) (*jfaz);
    *rlatf = (float) (*jdip);
    rake = (float) (*jrake);
/*  flag to indicate whether P and T axes should be switched */
    iorig = 0;
    if (rake < (float)0.) {
	rake += (float)180.;
	iorig = 1;
    }

/* have  F  az and plunge - define strk */
    strk = *rlonf + (float)90.;
    if (strk >= (float)360.) {
	strk += (float)-360.;
    }

/* find U  - U is pole of fault plane F */
    *rlonu = *rlonf + (float)180.;
    *rlatu = (float)90. - *rlatf;
    if (*rlonu >= (float)360.) {
	*rlonu += (float)-360.;
    }

/*  IS THIS A GENERAL CASE? ie: dip not equal to 90 or 45 degrees */
/* *********************** */
    arake = ABS(rake);

#if 0
    adip1 = (r__1 = *rlatf - (float)90., ABS(r__1));
    adip2 = (r__1 = *rlatf - (float)45., ABS(r__1));
    arake1 = (r__1 = arake - (float)90., ABS(r__1));
    arake2 = (r__1 = arake - (float)180., ABS(r__1));
#endif

    adip1 = ABS( (*rlatf - (float)90.) );
    adip2 = ABS( (*rlatf - (float)45.) );
    arake1 = ABS( (arake - (float)90. ));
    arake2 = ABS( (arake - (float)180.));


/* fprintf(stderr, "rlatf=%f arake=%f r1=%f tol=%f\n", *rlatf, arake, r__1,tol); */
/* fprintf(stderr,"adip1=%f adip2=%f arake1=%f arake2=%f\n",adip1, adip2, arake1, arake2); */

/* *********************** */
/* *********************** */
/* 	
*/
if( (adip1 > tol) || ((adip1<tol)&&(arake1>tol)) ) {

   /* fprintf(stderr,"T1: %f %f %f %f %f %f %f\n", strk, dip, arake, *rlatf, *rlonf, *rlatu, *rlonu); */
    


	mconv2J(&strk, &dip, &arake, rlatf, rlonf, rlatg, rlong, rlatu, rlonu,
		 rlatv, rlonv, rlatp, rlonp, rlatt, rlont);

/*    fprintf(stderr,"O1: rlatg=%f rlong=%f rlatv=%f rlonv=%f rlatp=%f rlonp=%f rlatt=%f rlont=%f\n",   */
/* 	   *rlatg, *rlong, *rlatv, *rlonv , */
/* 	   *rlatp, *rlonp, *rlatt, *rlont ); */
 

    } else {
/*  OR A SPECIAL CASE? */
/* *********************** */
/*        STRIKE SLIP FAULT */
/*fprintf(stderr,"SPECIAL CASE:\n");*/

	if (adip1 < tol && (arake < tol || arake2 < tol)) {
/*fprintf(stderr,"STRIKE SLIP FAULT:\n");*/

	    *rlong = rlongf + (float)90.;
	    *rlatg = (float)90.;
	    *rlonv = *rlatg;
	    *rlatv = (float)0.;
	    if (arake < tol) {
		*rlonp = *rlonf + (float)45.;
		if (*rlonp >= (float)360.) {
		    *rlonp += (float)-360.;
		}
		*rlatp = (float)0.;
		*rlont = *rlonf - (float)45.;
		if (*rlont < (float)0.) {
		    *rlont += (float)360.;
		}
		*rlatt = (float)0.;
	    } else {
		*rlonp = *rlonf + (float)135.;
		if (*rlonp >= (float)360.) {
		    *rlonp += (float)-360.;
		}
		*rlatp = (float)0.;
		*rlont = *rlonf + (float)225.;
		if (*rlont >= (float)360.) {
		    *rlont += (float)-360.;
		}
		*rlatt = (float)0.;
	    }
	}

/*      DIP SLIP FAULT */
	if (adip1 < tol && arake1 < tol) {
/*fprintf(stderr,"DIP SLIP FAULT:\n");*/

	    *rlong = *rlonf;
	    *rlatg = (float)0.;
	    *rlonv = *rlonf;
	    *rlatv = (float)90.;
	    *rlonp = *rlonf;
	    *rlatp = (float)45.;
	    *rlont = *rlonf + (float)180.;
	    if (*rlont >= (float)360.) {
		*rlont += (float)-360.;
	    }
	    *rlatt = (float)45.;
	}
    }

    if (iorig == 0) {
/* switch P and T axes */
	rtmp = *rlatt;
	*rlatt = *rlatp;
	*rlatp = rtmp;
	rtmp = *rlont;
	*rlont = *rlonp;
	*rlonp = rtmp;
    }
    return 0;
} 


