#ifndef STD_H
#define STD_H

typedef char BOOLEAN;
#define FALSE 0
#ifndef TRUE
#define TRUE (!FALSE)
#endif
#ifndef NULL
#define NULL ((void *)0)
#endif
#define NONULL ((void *)1)

#ifndef NIL
#define NIL '\0'
#endif

/* A point in plots->space */
typedef struct {float x, y, z;} fxyz;
typedef struct {float deg, min, sec;} angle;

typedef struct {int x, y, z; } xyz;
typedef struct {short x, y, z; } sxyz;

#define XYZ_PTR(A) &((A).x), &((A).y), &((A).z)

typedef struct {
	float x1, y1, x2, y2;
} fxyxy;

typedef struct {int x1, y1, x2, y2; } xyxy;

typedef struct {
	float x, y;
} fxy;

typedef struct {
	int x, y;
} xy;

typedef int ivec3[3];

typedef struct {int x, y, w, h;} xywh;
typedef struct {int w, h;} wh;

#define XY_PTR(A) &((A).x), &((A).y)
#define XYXY_PTR(A) &((A).x1), &((A).y1), &((A).x2), &((A).y2)

/* Macro for length of a constant string */
#define STRLEN(s) (sizeof(s) - 1)

#define XY(a) (a).x, (a).y
#define VEC2(a) (a)[0], (a)[1]
#define VEC2_PTR(a) &(a)[0], &(a)[1]
#define XY1(a) (a).x1, (a).y1
#define XYZ(a) (a).x, (a).y, (a).z
#define VEC3(a) (a)[0], (a)[1], (a)[2]
#define VEC3_PTR(a) &(a)[0], &(a)[1], &(a)[2]
#define XYXY(a) (a).x1, (a).y1, (a).x2, (a).y2
#define XYWH(a) (a).x, (a).y, (a).w, (a).h
#define WH(a) (a).w, (a).h

#ifndef MIN
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#endif

#define IBETWEEN(x, small, large) ((x) >= (small) && (x) <= (large))
#define BETWEEN(x, small, large) ((x) > (small) && (x) < (large))

#define dprintf printf		/* To tell debugging output */

/* Stuff to make fread() and fwrite() easier */
#define arr_len(arr)			((int) (sizeof(arr) / sizeof((arr)[0])))
#define write_item(f, i)		(fwrite(i, sizeof(*(i)), 1, f) == 1)
#define write_array(f, a, n)	(fwrite(a, sizeof((a)[0]), n, f) == (n))
#define write_full_array(f, a)	write_array(f, a, arr_len(a))
#define read_item(f, i)			(fread(i, sizeof(*(i)), 1, f) == 1)
#define read_array(f, a, n)		(fread(a, sizeof((a)[0]), n, f) == (n))
#define read_full_array(f, a)	read_array(f, a, arr_len(a))

#define new_var(p) ((p) = (typeof(p))malloc(sizeof(typeof(*p))))
#define new_array(p, size) ((p) = (typeof(p))malloc(sizeof(typeof(*p)) * size))

#endif
