/*  current types
 X- Known explosion, P- Probable explo-
          sion, F- Felt event, T- Teleseisms, H- Hand picked
          (previous 'types' take precedence), L- Low frequency
          volcanic, C- Centralia explosion, R- regional earthquake
*/

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"
#include "pickfile.h"

/* --- function prototypes --- */

void gstrc(char *string1, int begin, int num, char *i);
void gstrf(char *string1, int begin, int num, float *i);
void gstri(char *string1, int begin, int num, int *i);
int getline(FILE *input,char s[],int lim);

/* --- functions --- */

/* given a pointer to a string  read in a UW acard  */

bool_t readac_str(char *str, ac_rec *a)
  {
  int i, m;

  i = strlen(str);
  if(i < 90)
    {
    for(m = i - 1; m < 78; m++) str[m] = '0';
    strcat(str, "\0");
    }

  gstrc(str, 1, 1, a->type);
  gstrc(str, 2, 12, a->id);
  gstrf(str, 12+2, 6, &a->sec);
  gstri(str, 19+2, 2, &a->lat1);
  gstrc(str, 21+2, 1, a->NS);
  gstri(str, 22+2, 4, &a->lat2);
  gstri(str, 27+2, 3, &a->lon1);
  gstrc(str, 30+2, 1, a->EW);
  gstri(str, 31+2, 4, &a->lon2);
  gstrf(str, 35+2, 6, &a->depth);
  gstrc(str, 41+2, 1, a->Fix);
  gstrf(str, 42+2, 4, &a->mag);
  gstri(str, 46+2, 3, &a->nump);
  gstrc(str, 49+2, 1, a->JU);
  gstri(str, 50+2, 3, &a->nums);
  gstri(str, 54+2, 3, &a->gap);
  gstri(str, 57+2, 3, &a->delta);
  gstrf(str, 60+2, 5, &a->rms);
  gstrf(str, 65+2, 5, &a->err);
  gstrc(str, 70+2, 1, a->q1);
  gstrc(str, 71+2, 1, a->q2);
  gstrc(str, 73+2, 2, a->modid);

  a->phi = a->lat1 + a->lat2 / 6000.0;
  a->lam = a->lon1 + a->lon2 / 6000.0;

  if( !strcmp(a->NS,"S") )
    {
      a->phi=(-a->phi);
    }

  if( !strcmp(a->EW,"W") )
    {
      a->lam=(-a->lam);
    }



  

  return(TRUE);
  }


bool_t readacE_str(char *str, ac_rec *a)
  {
/* read in a UW format acard which has extensions:
    a unique file id is attached to the end of the 
   acard  
*/
  int i, m;

  i = strlen(str);
  if(i < 92)
    {
    for(m = i - 1; m < 92; m++) str[m] = '0';
    strcat(str, "\0");
    }

  gstrc(str, 1, 1, a->type);
  gstrc(str, 2, 12, a->id);
  gstrf(str, 12+2, 6, &a->sec);
  gstri(str, 19+2, 2, &a->lat1);
  gstrc(str, 21+2, 1, a->NS);
  gstri(str, 22+2, 4, &a->lat2);
  gstri(str, 27+2, 3, &a->lon1);
  gstrc(str, 30+2, 1, a->EW);
  gstri(str, 31+2, 4, &a->lon2);
  gstrf(str, 35+2, 6, &a->depth);
  gstrc(str, 41+2, 1, a->Fix);
  gstrf(str, 42+2, 4, &a->mag);
  gstri(str, 46+2, 3, &a->nump);
  gstrc(str, 49+2, 1, a->JU);
  gstri(str, 50+2, 3, &a->nums);
  gstri(str, 54+2, 3, &a->gap);
  gstri(str, 57+2, 3, &a->delta);
  gstrf(str, 60+2, 5, &a->rms);
  gstrf(str, 65+2, 5, &a->err);
  gstrc(str, 70+2, 1, a->q1);
  gstrc(str, 71+2, 1, a->q2);
  gstrc(str, 73+2, 2, a->modid);
  gstrc(str, 78+2, 13, a->unique_id);

  /* fprintf(stderr,"unique_id = %s\n", a->unique_id); */
  
  a->phi = a->lat1 + a->lat2 / 6000.0;
  a->lam = a->lon1 + a->lon2 / 6000.0;

  return(TRUE);
  }



/* given file pointer read in a card at a time  */

bool_t readac(FILE *f, ac_rec *a)
  {
  int i;
  char str[120];
  bool_t b;

  if(feof(f)) return(FALSE);

  i = getline(f, str, 120);
  if(i == 0) return(FALSE);

  b = readac_str(str, a);
  return(b);
  }

void create_Acard(ac_rec *ac, char *acrd)
  {
  int m;

  sprintf(acrd, "A%1s%12s%6.2f %2d%1s%4d %3d%1s%4d%6.2f%1s%4.1f%3d%1s%3d"
	  " %3d%3d %4.2f %4.1f%1s%1s %2s\n", ac->type, ac->id, ac->sec,
	  ac->lat1, ac->NS, ac->lat2, ac->lon1, ac->EW, ac->lon2, ac->depth,
	  ac->Fix, ac->mag, ac->nump, ac->JU, ac->nums, ac->gap, ac->delta,
	  ac->rms, ac->err, ac->q1, ac->q2, ac->modid);

  for(m = 22; m < 25; m++) if(acrd[m] == ' ') acrd[m] = '0';
  for(m = 31; m < 34; m++) if(acrd[m] == ' ') acrd[m] = '0';
  for(m = 50; m < 53; m++) if(acrd[m] == ' ') acrd[m] = '0';
  }

void init_Acard(ac_rec *ac)
  {

  strcpy(ac->type," "); 
  strcpy(ac->id, "00000000000");
  /* ac->id = "0000000000";
     sscanf("000000000000", "%12s" , ac->id); */
  ac->sec = 0;
  ac->lat1 = 0;
  strcpy(ac->NS, "N");
  ac->lat2 = 0;
  ac->lon1 = 0;
  strcpy(ac->EW, "W");
  ac->lon2 = 0;
  ac->depth = 0;
  strcpy(ac->Fix, " ");
  ac->mag = 0;
  ac->nump = 0;
  strcpy(ac->JU, "/");
  ac->nums = 0;
  ac->gap = 0;
  ac->delta = 0;
  ac->rms = 0;
  ac->err = 0;
  strcpy(ac->q1, "0");
  strcpy(ac->q2, "0");
  strcpy(ac->modid, "00");
  ac->phi = ac->lat1 + ac->lat2 / 6000.0;
  ac->lam = ac->lon1 + ac->lon2 / 6000.0;
  }

bool_t readMcard(char *str, Mech *a)
  {

  /* printf("%s", str); */

  gstrf(str, 4, 3, &a->strk1);
  gstrf(str, 8, 2, &a->dip1);
  gstrf(str, 13, 3, &a->strk2);
  gstrf(str, 17, 2, &a->dip2);
  gstrf(str, 22, 3, &a->urot);
  gstrf(str, 26, 2, &a->udip);
  gstrf(str, 31, 3, &a->vrot);
  gstrf(str, 35, 2, &a->vdip);
  gstrf(str, 40, 3, &a->prot);
  gstrf(str, 44, 2, &a->pdip);
  gstrf(str, 49, 3, &a->trot);
  gstrf(str, 53, 2, &a->tdip);     

  /*
     00000000001111111111222222222233333333334444444444555555555566666
     01234567890123456789012345678901234567890123456789012345678901234
     M F 330 85 G 231 30 U 150  5 V 411 59 P 355 33 T 481 42
     */

  return(TRUE);
  }

/* given file pointer read in a card at a time  */

bool_t readmc(FILE *f, Mech *a)
  {
  int i;
  char str[120];
  bool_t b;

  i = getline(f, str, 120);
  if(i == 0) return(FALSE);

  b = readMcard(str, a);
  return(b);
  }

void create_Mcard(Mech *mc, char *mcrd)
  {

  sprintf(mcrd, "M F %3.0f%3.0f G %3.0f%3.0f U %3.0f%3.0f V %3.0f%3.0f P"
	  " %3.0f%3.0f T %3.0f%3.0f\n", mc->strk1, mc->dip1, mc->strk2,
	  mc->dip2, mc->urot, mc->udip, mc->vrot, mc->vdip, mc->prot,
	  mc->pdip, mc->trot, mc->tdip);
  }

/***************************************************************/

/* given a pointer to a string  read in a UW acard  */

bool_t read_hinv_str(char *str, ac_rec *a)
  {
  int idum, i, m;

  i = strlen(str);
  if(i < 76)
    {
    for(m = i - 1; m < 76; m++) str[m] = '0';
    strcat(str, "\0");
    }

/*
        write(hbuf,1030)yy,mo,dd,hh,mi,isec,
     &	iphi1,iphi2,ilam1,ilam2,
     &     idep, imag,nump, igap,idelta,irms,ismaz1,ismaz2,
     &     ismmag1, iintaz1,iintaz2,iintmag ,idurmag,
     &     hrmk,ilargerr,
     &     nums, ihozerr,iverterr,numpols


1030    format(5i2,i4,i2,1x,i4,i3,1x,i4,
     &   i5,i2,i3,i3,i3,i4,i3,i2,i4,i3,i2,
     &      i4,i2,a3,i4,t79,i2,i4,i4,i2)


          |   |  |   |   |   |    | |  |  |  |   
8510 3 612487119 4696155 3573 152937 67 96 11  1035463  54254 5  3541KEA  30F 19  35  4963
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7....|....8....|....9
0   4    9    4    9    4    9    4    9    4    9    4    9    4    9    4    9    4     9
iiiiiiiiiissssll llllooo oooodddddaabbbcccdddeeeefffgghhhhiiijjkkkkllmmmnnnn  aabbbbccccdd
ident     sec l1  l2  lon    dep mag np gp dl rms z1 z2   
*/

  /* fprintf(stderr,"%s", str); */

  strcpy(a->type , " ");
  strcpy(a->q1 , "A");
  strcpy(a->q2 , "A");
  strcpy(a->NS, "N");
  strcpy(a->EW, "W");
  strcpy(a->JU, "/");
  strcpy(a->Fix, " ");

  for(m = 0; m < 10; m++) if(str[m] == ' ')str[m]='0';
  gstrc(str, 0, 10, a->id);
  gstri(str, 10, 4, &idum);
  a->sec = idum / 100.0;
  gstri(str, 14, 2, &a->lat1);
  gstri(str, 17, 4, &a->lat2);
  gstri(str, 21, 3, &a->lon1);
  gstri(str, 25, 4, &a->lon2);
  gstri(str, 29, 5, &idum);
  a->depth = idum / 100.0;
  gstri(str, 34, 2, &idum);
  a->mag = idum / 10.0;
  gstri(str, 36, 3, &a->nump);
  gstri(str, 39, 3, &a->gap);
  gstri(str, 42, 3, &a->delta);
  gstri(str, 45, 4, &idum);
  a->rms = idum / 100.0;
  gstrc(str, 69, 2, a->modid);
  gstri(str, 78, 2, &a->nums);
  gstri(str, 80, 4, &idum);
  a->err = idum / 100.0;
  a->phi = a->lat1 + a->lat2 / 6000.0;
  a->lam = a->lon1 + a->lon2 / 6000.0;

  return(TRUE);
  }

/* given a pointer to a string  read in a UW acard  */

bool_t read_citcat_str(char *str, ac_rec *a)
  {
  int i, m, yy, mo, dd, hh, mi;
  float fdum;

  i = strlen(str);
  if(i < 77)
    { 
    for(m = i - 1; m < 79; m++) str[m] = '0';
    strcat(str, "\0");
    }

/*
 2001	format(2x,i2,t6,i2,t9,i2,t13,i2,t16,
     &  i2,t19,f5.2,t26,i2,t29,f5.2,t34,i4,
     &	  t39,f5.2,t45,a1,t47,f3.1,t55,f5.2,t60,i3,t67,f4.2,t72
     &     , i7)

         nread = nread +1
	read(5,2001,end=800,err=920)yy,mo,dd,hh,mi,sec,
     &       lat,la2,lon,lo2,q1,mag,dep,numsob,rms,iid
1977  1  1  19 21  0.60  33  0.95-116 17.02 D 0.0      7.85  0    0.00       0
1977  1  1  20 22 52.44  34  3.32-116 31.53 C 0.0      5.63  0    0.00       0
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7....|....8....|....9
0   4    9    4    9    4    9    4    9    4    9    4    9    4    9    4    9    4     9
yyyy mm dd  hh mm ss.ss  ll ll.ll-ooo oo.oo d a.a      f.ff  g    e.ee       h
                                              mag      dep   n    rms       iid

*/

  /* fprintf(stderr,"%s", str); */
  strcpy(a->type , " ");
  strcpy(a->q1 , "A");
  strcpy(a->q2 , "A");
  strcpy(a->NS, "N");
  strcpy(a->EW, "E");
  strcpy(a->JU, "/");
  strcpy(a->modid, "CT");

  a->gap = 0;
  a->delta = 0;
  a->err = 0;

  for(m = 2; m < 12; m++) if(str[m] == ' ')str[m] = '0';
  gstrc(str, 0, 10, a->id);
  gstri(str, 2, 2, &yy);
  gstri(str, 5, 2, &mo);
  gstri(str, 8, 2, &dd);
  gstri(str, 12, 2, &hh);
  gstri(str, 15, 2, &mi);

  sprintf(a->id, "%2d%2d%2d%2d%2d", yy, mo, dd, hh, mi);

  for(m = 0; m < 10; m++) if(a->id[m] == ' ') a->id[m] = '0';

  gstrf(str, 18, 5, &a->sec);
  gstri(str, 24, 3, &a->lat1);

  if(a->lat1<0)
    {
    a->lat1 *= -1;
    strcpy(a->NS, "S");
    }

  gstrf(str, 28, 5, &fdum);
  a->lat2 = fdum * 100;
  gstri(str, 33, 4, &a->lon1);

  if(a->lon1 < 0)
    {
    a->lon1 *= -1;
    strcpy(a->EW, "W");
    }

  gstrf(str, 38, 5, &fdum);
  a->lon2 = fdum * 100;
  gstrc(str, 44, 1, a->q1);
  strcpy(a->q2 , a->q1);
  gstrf(str, 45, 4, &a->mag);
  gstri(str, 59, 3, &a->nump);
  gstrf(str, 52, 7, &a->depth);
  gstrf(str, 66, 4, &a->rms);

  a->phi = a->lat1 + a->lat2 / 6000.0;
  a->lam = a->lon1 + a->lon2 / 6000.0;

  return(TRUE);
  }

bool_t read_hypo71_str(char *str, ac_rec *a)
  {
  int i, m, yy, mo, dd, hh, mi;
  float fdum;

/*******************************************************************************
yymmdd hhmm ss.ss ll ll.ll ooo oo.oo zzz.zz  mmag  nn gap     rmss            q
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
921128  051 53.85 36 02.87 117 46.39  14.93   0.0  13 169      0.42           DU                    
921128  056 20.71 36 02.40 117 47.57  10.72   0.0   8 127      0.12           BU                    
921128  145 46.02 35 59.46 117 42.16  13.93   0.0  14 290      0.21           CU                    
921128  148 38.18 35 57.69 117 38.99   0.97   0.0   5 343      0.10           CU                    
921128  212  0.34 36 00.70 117 46.44   1.98   0.0  13 131      0.05           AU                    
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$

**************************************************************************/

  i = strlen(str);
  if(i < 77)
    {
    for(m = i - 1; m < 79; m++) str[m] = '0';
    strcat(str, "\0");
    }

  /* given a pointer to a string  read in a hypo71 acard  */

  /* fprintf(stderr, "%s", str); */
  strcpy(a->type , " ");
  strcpy(a->q1 , "A");
  strcpy(a->q2 , "A");
  strcpy(a->NS, "N");
  strcpy(a->EW, "W");
  strcpy(a->JU, "/");
  strcpy(a->modid, "CT");
  strcpy(a->Fix, " ");

  a->gap = 0;
  a->delta = 0;
  a->err = 0;

  for(m = 0; m < 11; m++) if(str[m] == ' ') str[m] = '0';

  gstri(str, 0, 2, &yy);
  gstri(str, 2, 2, &mo);
  gstri(str, 4, 2, &dd);
  gstri(str, 7, 2, &hh);
  gstri(str, 9, 2, &mi);

  sprintf(a->id, "%2d%2d%2d%2d%2d", yy, mo, dd, hh, mi);

  for(m = 0; m < 10; m++) if(a->id[m] == ' ') a->id[m] = '0';

  gstrf(str, 12, 5, &a->sec);
  gstri(str, 17, 3, &a->lat1);

  if(a->lat1 < 0)
    {
    a->lat1 *= -1;
    strcpy(a->NS, "S");
    }

  gstrf(str, 21, 5, &fdum);
  a->lat2 = fdum * 100;
  gstri(str, 26, 4, &a->lon1);

  if(a->lon1 < 0)
    {
    a->lon1 *= -1;
    strcpy(a->EW, "E");
    }

  gstrf(str, 31, 5, &fdum);
  a->lon2 = fdum * 100;
  gstrc(str, 78, 1, a->q1);
  strcpy(a->q2, a->q1);
  gstrf(str, 45, 4, &a->mag);
  gstri(str, 51, 2, &a->nump);
  gstrf(str, 37, 6, &a->depth);
  gstrf(str, 63, 4, &a->rms);
  a->phi = a->lat1 + a->lat2 / 6000.0;
  a->lam = a->lon1 + a->lon2 / 6000.0;

  return(TRUE);
  }

bool_t read_hcard_str(char *str, ac_rec *a)
  {
  int yy, mo, dd, hh, mi;
  float sec, lat, lon, dep, mag;
  char typ[2];

/*******************************************************************************
L   year moddhhmm SEC LAT  LON  DEPTH   MAG           
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$

**************************************************************************/

  /* given a pointer to a string  read in a UW acard  */

  sscanf(str, "%1s %d %d %d %d %d %f %f %f %f %f", typ, &yy, &mo, &dd, &hh,
	 &mi,  &sec, &lat, &lon, &dep, &mag);

  /* given a pointer to a string  read in an hcard */

  /* fprintf(stderr,"%s", str); */

  strcpy(a->type, " ");
  strcpy(a->q1, "U");
  strcpy(a->q2, "U");
  strcpy(a->Fix, " ");

  strcpy(a->JU, "/");
  strcpy(a->modid, "LC");

  a->gap = 0;
  a->delta = 0;
  a->err = 0;
  a->rms = 0;
  a->nump = 0;
  a->nums = 0;

  	/*   Y2K FIX  */
  /*  yy -= 1900;
      if(yy < 0 || yy > 100) yy = 0; */
  

  sprintf(a->id, "%04d%02d%02d%02d%02d", yy, mo, dd, hh, mi);

  a->sec = sec;

  if(lat < 0)
    {
    a->phi = -lat;
    strcpy(a->NS, "S");
    }
  else
    {
    a->phi = lat;
    strcpy(a->NS, "N");
    }

  a->lat1 = (int)a->phi;
  a->lat2 = (a->phi - a->lat1) * 6000;

  if(lon < 0)
    {
    a->lam = -lon;
    strcpy(a->EW, "W");
    }
  else
    {
    a->lam = lon;
    strcpy(a->EW, "E");
    }

  a->lon1  = (int)a->lam;
  a->lon2 = (a->lam - a->lon1) * 6000;

  a->mag = mag;
  a->depth = dep;
  return(TRUE);
  }
