
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

void usleep(unsigned int useconds);

    


/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jml.h"
#include "jutil.h"
#include "user2pix.h"

/* --- macros --- */

#define NUM_SEL 50

/* --- global variables and function prototypes --- */

extern int screenx, screeny;

void csorta(float *bufin, int *ibufdx, float *bufout, int n);
void create_Acard(ac_rec *ac , char *acrd);
void tojul(int year, int month, int day, int *jul);
void send_repaint(Widget wij, int x, int y, int w, int h);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
void draw_Xmark(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void get_tim_str(char *jtim);
void Print_Header(FILE *inf, char fname[]);
Boolean readac(FILE *f, ac_rec *a);

extern void setup_pat_ps(FILE *inf);

/* --- functions --- */
double  DEG2RAD= 3.14159265358979323846/180.0;
    double  RAD2DEG = 180.0/3.14159265358979323846;

void focal_ternary(Widget wij, mpic * mplot);
void PS_focal_ternary(Widget wij, mpic * mplot);
 


/**********************************************/

int intarg(float x, float y, JGRAPH gr)
  {

  return(((x > gr.user_xmin) && (x < gr.user_xmax) && (y > gr.user_ymin)
	  && (y < gr.user_ymax)) ? 1 : 0);
  }  






float get_dismax_special(char *source_file, mpic *m, float meanX, float meanY)
  {
  float fx, fy;
  FILE *inf;
  float phi, lam, dismax, dis;
  ac_rec accard;

  if((inf = fopen(source_file, "r")) == NULL)
    {
    printf("Can't open special source %s ....try again\n", source_file);
    return(0.0);
    }

  dismax = 0.0;
  while(readac(inf, &accard))
    {
    phi = accard.lat1 + accard.lat2 / 6000.0;
    lam = accard.lon1 +  accard.lon2 / 6000.0;
    if(accard.EW[0] == 'W') lam *= -1;
    if(accard.NS[0] == 'S') phi *= -1;

    geo2xy(m, phi, lam, &fx, &fy);
    if(intarg(fx, fy, m->gr))
      {
      dis = sqrt((meanX - fx) * (meanX - fx) + (meanY - fy) * (meanY - fy));
      dismax = max2(dis, dismax);
      }
    }
  fclose(inf);
  return(dismax);
  }

void dump_explode_special(char *source_file, mpic *m, float meanX,
			  float meanY, float dismax)
  {
  float fx, fy, ang, dis, phi, lam;
  FILE *inf;
  ac_rec accard;

  if((inf = fopen(source_file, "r")) == NULL)
    {
    printf("Can't open special source %s ....try again\n", source_file);
    return;
    }

  dismax = 0.0;
  while(readac(inf, &accard))
    {
    phi = accard.lat1 + accard.lat2 / 6000.0;
    lam = accard.lon1 + accard.lon2 / 600.0;

    if(accard.EW[0] == 'W') lam *= -1;
    if(accard.NS[0] == 'S') phi *= -1;

    geo2xy(m, phi, lam, &fx, &fy);
    if(intarg(fx,fy,m->gr))
      {
      dis = sqrt((meanX - fx) * (meanX - fx) + (meanY - fy) * (meanY - fy));
      ang = 57.29578 * atan2((fy - meanY), (fx - meanX));
      if(ang < 0.0) ang += 360.0;
      fprintf(stderr, "%f \t%f \t%.2f \t%.2f \t(%s) \t explod \n", fx, fy,
	      dis + dismax, ang, accard.id);
      }
    }
  fclose(inf);
  }

/*************************************************************/

void focal_Proj(Widget wij, mpic * mplot)
  {
  Display *disp;
  Window wind;
  GC ggc;
  JGRAPH ngr;
  int ix, iy, hsize, circle = 23040, k, i, j, kount, kx, ky, psize = 4,
    ntype = 7, itype[7] = {18, 23, 22, 21, 19, 20, 2}, ktype[7],
    col_fillbox = 18, col_perim = 1, col_fillsphere = 25,
    col_perimsphere = 22, col_lines = 24, col_pax = 9, col_tax = 27,
    xstamp_pos, ystamp_pos, xstamp_width, ystamp_width;
  float tminx, tmaxx, tminy, tmaxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, px, py, phi, lam, ax, ay;
  float bot=10000.0, top=-100000.0;
  double xi, tq, focrad = 0.5, minx = 0.0, maxx = 1.0, miny = 0.0, maxy = 1.0;
  char *ctype[7] = { "strikeslip", "rev-oblSS", "obl-rev", "reverse",
		     "norm-oblSS", "obl-norm", "normal"};
  Position        x, y;
  Dimension       width, height;

  /* XtVaGetValues(wij, XtNdata, &mplot, NULL); */

  wind = XtWindow(mplot->wij);
  disp = XtDisplay(mplot->wij);
  ggc = mplot->ggc;

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

 if( mplot->foc_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }

  xstamp_pos = 4;
  ystamp_pos = (((float)height * 3.0) / 4.0);
  xstamp_width = ystamp_width = (height - ystamp_pos) - 10;
  ystamp_pos -= 50;

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_fillbox)]);
  XFillRectangle(disp, wind, ggc, xstamp_pos - 1, ystamp_pos - 1,
		 xstamp_width + 2, ystamp_width + 2);
  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_perim)]);
  XDrawRectangle(disp, wind, ggc, xstamp_pos - 1, ystamp_pos - 1,
		 xstamp_width + 2, ystamp_width + 2);

  window(&ngr, minx, maxx, miny, maxy);
  viewport(&ngr, xstamp_pos, xstamp_pos + xstamp_width,
	   ystamp_pos + ystamp_width, ystamp_pos);

  hsize = ystamp_width;

  ix = user_to_pix_x(&ngr, (double)0.0);
  iy = user_to_pix_y(&ngr, (double)0.0);

  /* fprintf(stderr,"circle: ix=%d  iy=%d\n", ix, iy); */

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_fillsphere)]);
  XFillArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_perimsphere)]);
  XDrawArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_lines)]);

  XDrawLine(disp, wind, ggc,
	    user_to_pix_x(&ngr, (double)0.0),
	    user_to_pix_y(&ngr, (double)0.5),
	    user_to_pix_x(&ngr, (double)1.0),
	    user_to_pix_y(&ngr, (double)0.5));

  XDrawLine(disp, wind, ggc,
	    user_to_pix_x(&ngr, (double)0.5),
	    user_to_pix_y(&ngr, (double)0.0),
	    user_to_pix_x(&ngr, (double)0.5),
	    user_to_pix_y(&ngr, (double)1.0));

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    }
  else
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }

  bottom_left_x = (float)tminx;
  bottom_left_y = (float)tminy;
  top_right_x = (float)tmaxx;
  top_right_y = (float)tmaxy;

  for(j = 0; j < ntype; j++) ktype[j] = 0;
  k = 0;

  for (kount = 0; kount < mplot->num_focm_files; kount++)
    {
    for(i = 0; i < mplot->focm[kount].numpoints; i++)
      {

 if(!mplot->focm[kount].focs[i].on_off)continue;

      if( !(mplot->foc_in_layer == 0 || 
	    (mplot->foc_in_layer == 1 && mplot->focm[kount].focs[i].loc.z < bot  
	     && mplot->focm[kount].focs[i].loc.z >= top)) ) continue; 

      phi = mplot->focm[kount].focs[i].loc.x;
      lam = mplot->focm[kount].focs[i].loc.y;
      geo2xy(mplot, phi, lam, &px, &py);

      if((px >= bottom_left_x) && (px <= top_right_x) && (py >= bottom_left_y)
	 && (py <= top_right_y))
	{
	k++;
	xi = 1.570796327 - 0.0174532 * mplot->focm[kount].focs[i].fm.pdip;
	tq = 1.414213562 * sin(xi / 2.0);
	ax = (0.5 + focrad * tq * sin(0.0174532
				      * mplot->focm[kount].focs[i].fm.prot));
	ay = (0.5 + focrad * tq * cos(0.0174532
				      * mplot->focm[kount].focs[i].fm.prot));
	ay = 1 - ay;

	kx = user_to_pix_x(&ngr, (double)ax);
	ky = user_to_pix_y(&ngr, (double)ay);

	XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_pax)]);
	draw_Xmark(disp, wind, ggc, kx, ky, psize);

	xi = 1.570796327 - 0.0174532 * mplot->focm[kount].focs[i].fm.tdip;
	tq = 1.414213562 * sin(xi / 2.0);
	ax = (0.5 + focrad * tq * sin(0.0174532
				      * mplot->focm[kount].focs[i].fm.trot));
	ay = (0.5 + focrad * tq * cos(0.0174532
				      * mplot->focm[kount].focs[i].fm.trot));
	ay = 1 - ay;

	kx = user_to_pix_x(&ngr, (double)ax);
	ky = user_to_pix_y(&ngr, (double)ay);

	XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_tax)]);
	draw_Xmark(disp, wind, ggc, kx, ky, psize);

	for(j = 0; j < ntype; j++)
	  if(itype[j] == mplot->focm[kount].focs[i].type) ktype[j]++;
	}
      }
    }

  XSetFont(disp, ggc, mplot->fonts[0]);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_pax)]);
  draw_just_text(disp, wind, ggc, user_to_pix_x(&ngr, (double)0.01),
		 user_to_pix_y(&ngr, (double) 0.98), "P-axis", HJ_LEFT,
		 VJ_BASELINE);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_tax)]);
  draw_just_text(disp, wind, ggc, user_to_pix_x(&ngr, (double)0.01),
		 user_to_pix_y(&ngr, (double)0.1), "T-axis", HJ_LEFT,
		 VJ_BASELINE);

  XFlush(disp);

  fprintf(stdout, "\n\n-------------------------------------\n");
  fprintf(stdout, "Lower Left(x,y)= %f %f km\n", bottom_left_x, bottom_left_y);
  fprintf(stdout, "Upper Right(x,y)= %f %f km\n", top_right_x, top_right_y);

  xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);

  
  fprintf(stdout, "Lower Left(lat,lon)= %f %f deg\n",phi, lam);
  xy2geo(mplot, &phi, &lam, top_right_x, top_right_y);

  lam *= -1;
  fprintf(stdout, "Upper Right(lat,lon)= %f %f deg\n", phi, lam);
  fprintf(stdout, "\n");
  fprintf(stdout, "k=%d Focal P-T axes\n", k);
  fprintf(stdout, "Summary of Focal Mechanisms:\n");

  for(j = 0; j < ntype; j++)
    fprintf(stderr, "%-5d %s\n", ktype[j], ctype[j]);

  /* send_repaint(mplot->wij, 0, 0, width, height); */
  }

/*************************************************************/

void PS_focal_Project(Widget wij, mpic * mplot)
  {
  float tminx, tmaxx, tminy, tmaxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, px, py, phi, lam, ax, ay;
  int k, i, j, kount, ntype = 7, itype[7] = {18, 23, 22, 21, 19, 20, 2},
    ktype[7];
  double xi, tq;
float bot=10000, top=-10000;
  char *ctype[7] = {"strikeslip", "rev-oblSS", "obl-rev", "reverse",
		    "norm-oblSS", "obl-norm", "normal"},
    *psdir, psfile[200], jtim[25];
  FILE *inf;

  /* XtVaGetValues(wij, XtNdata, &mplot, NULL); */

  if((inf = fopen("focsum.ps", "w")) == NULL)
    {
    printf("Can't open focsum.ps file...continuing\n");
    return;
    }
  if( mplot->foc_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }

  fprintf(inf, "%%!PS\n");
  if((psdir = getenv("PSHEAD")) == NULL)
    {
    fprintf(stderr, "%%%%  Can't find header file. \n");
    fprintf(stderr, "%%%%  Please set env varible: PSHEAD \n");
    fprintf(inf, "%%%%  Please set env varible: PSHEAD \n");
    fprintf(inf, "%%%%  ( need to include the header file here )\n");
    }
  else
    {
    sprintf(psfile, "%s/head.big", psdir);
    Print_Header(inf,  psfile);
    }

  get_tim_str(jtim);
  fprintf(inf,"%%  Postscript file Created: %s ", jtim);
  fprintf(inf, " %%--------------------------------------------- \n");
  fprintf(inf, " 4 inch 5 inch translate %% center of the plot\n\n");
  fprintf(inf, "/bx { 2 inch mul } def \n");
  fprintf(inf, "/bz { 2 inch mul } def \n");
  fprintf(inf, "/siz { .1 inch } def \n");
  fprintf(inf, " \n          %% \n");
  fprintf(inf, "/setcol1  { setrgbcolor } def \n");
  fprintf(inf, " \n          %% this is the lighter-background color setting"
	  "\n");
  fprintf(inf, "/setcol2  { setrgbcolor } def \n");
  fprintf(inf, "\n   /BW { /setcol1  { pop pop pop 0 setgray } def "
	  "\n /setcol2  { pop pop pop 1 setgray } def \n } def\n");
  fprintf(inf, "           %% for Black and White figures uncomment the"
	  " following line:\n\n");

  if(mplot->BW_flag == 1)
    {
    fprintf(inf, "           BW\n\n"); 
    setup_pat_ps(inf);
    }
  else fprintf(inf, "           %%BW\n\n");

  fprintf(inf, "%%----------------COLOR Stuff  ------------\n\n");
  fprintf(inf, "  /setcolP { 1.000000 0.980392 0.803922 setcol1 }"
	  " def     %%  P-axis\n");
  fprintf(inf, "  /setcolT { 0.498039 1.000000 0.831373 setcol1 }"
	  " def     %%  T-axis\n\n");
  fprintf(inf, "  /external_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /map_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /internal_back_color { 0.560784 0.737255 0.560784 setcol2 }"
	  " def\n");
  fprintf(inf, "  /fill_color { 0.411765 0.411765 0.411765  setcol2 } def\n");
  fprintf(inf, "  /perim_color { 0.529412 0.807843 1.000000  setcol1 } def\n");
  fprintf(inf, "  /lines_color { 0.321569 0.545098 0.545098  setcol1 } def\n");
  fprintf(inf, "  internal_back_color \n");
  fprintf(inf, "  -1 bx -.1 inch add -1 bz -.1 inch  add 1 bx .1  inch add"
	  " 1 bz .1  inch add bord fill \n");
  fprintf(inf, "  map_color \n");
  fprintf(inf, "  -1 bx -.1 inch add -1 bz -.1 inch  add 1 bx .1  inch add"
	  " 1 bz .1  inch add bord stroke \n");
  fprintf(inf, "  fill_color \n");
  fprintf(inf, "  0 0 1 bx 0 360 arc fill \n");
  fprintf(inf, "  perim_color \n");
  fprintf(inf, "  0 0 1 bx 0 360 arc  stroke \n");
  fprintf(inf, "  lines_color \n");
  fprintf(inf, "  0 -1 bz   moveto 0 1 bz lineto stroke \n");
  fprintf(inf, "   -1 bx 0 moveto 1 bx 0 lineto stroke \n");

  /* set up selection box   */

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    } 
  else
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }

  bottom_left_x = (float)tminx;
  bottom_left_y = (float)tminy;
  top_right_x = (float)tmaxx;
  top_right_y = (float)tmaxy;

  for(j = 0; j < ntype; j++) ktype[j] = 0;

  k = 0;
  for(kount = 0; kount < mplot->num_focm_files; kount++)
    {
    for(i = 0; i < mplot->focm[kount].numpoints; i++)
      {

 if(!mplot->focm[kount].focs[i].on_off)continue;

      if( !(mplot->foc_in_layer == 0 || 
	    (mplot->foc_in_layer == 1 && mplot->focm[kount].focs[i].loc.z < bot  
	     && mplot->focm[kount].focs[i].loc.z >= top)) ) continue; 


      phi = mplot->focm[kount].focs[i].loc.x;
      lam = mplot->focm[kount].focs[i].loc.y;

      geo2xy(mplot, phi, lam, &px, &py);

      if((px >= bottom_left_x) && (px <= top_right_x) && (py >= bottom_left_y)
	 && (py <= top_right_y))
	{
	k++;
	xi = 1.570796327 - 0.0174532 * mplot->focm[kount].focs[i].fm.pdip;
	tq = 1.414213562 * sin(xi / 2.0);
	ax =  tq * sin(0.0174532 * mplot->focm[kount].focs[i].fm.prot);
	ay =  tq * cos(0.0174532 * mplot->focm[kount].focs[i].fm.prot);
			
	fprintf(inf, "  setcolP  %f bx %f bz siz xmark\n", ax, ay);

	xi = 1.570796327 - 0.0174532 * mplot->focm[kount].focs[i].fm.tdip;
	tq = 1.414213562 * sin(xi / 2.0);
	ax = tq * sin(0.0174532 * mplot->focm[kount].focs[i].fm.trot);
	ay =  tq * cos(0.0174532 * mplot->focm[kount].focs[i].fm.trot);

	fprintf(inf, "  setcolT  %f bx %f bz siz xplus\n", ax, ay);

	for(j = 0; j < ntype; j++)
	  if(itype[j] == mplot->focm[kount].focs[i].type) ktype[j]++;
	}
      }
    }

  fprintf(inf, "\n");
  fprintf(inf, "  setcolP  -.9 bx -.9 bz siz xmark  -.9 bx -.9 bz moveto"
	  " .1 inch siz -.5 mul rmoveto (P-Axis) show\n");
  fprintf(inf, " setcolT  -.9 bx .9 bz siz xplus -.9 bx .9 bz moveto"
	  " .1 inch siz -.5 mul rmoveto (T-Axis) show\n");
  fprintf(inf, "\n\n");
  fprintf(inf, "0 setgray\n");
  fprintf(inf, "/info_table  { \n");
  fprintf(inf, "0 0 moveto (k=%d Focal P-T axes) show\n", k);
  fprintf(inf, "0 -.2 inch  moveto (Summary of Focal Mechanisms:) show\n");
  fprintf(inf, "/pin { -15 mul -20 add } def\n");

  for(j = 0; j < ntype; j++)
    fprintf(inf, "0 %d pin moveto (%-5d %s) show\n",j+1,  ktype[j], ctype[j]);

  fprintf(inf, " } def \n");
  fprintf(inf, "\n\n %% to NOT plot the text summary, comment out next line"
	  " \n");
  fprintf(inf, " gsave -1 bx -1 bz translate 0 -.4 inch translate info_table"
	  "  grestore  \n\n");
  fprintf(inf, "  showpage \n");

  fclose(inf);

  fprintf(stderr, "\n\n Done: to see plot submit file focsum.ps to printer\n"
	  "     (or ghostview), e.g.: lpr focsum.ps");

  /* send_repaint(mplot->wij, 0, 0, width, height); */
  }

/*************************************************************/

/*************************************************************/
void PS_focal_summary(Widget wij, mpic * mplot, char *call_data)
  {
    PS_focal_Project( wij, mplot);
    PS_focal_ternary( wij,  mplot);
    
  }

/*************************************************************/
void Key_s_lees(Widget wij, XKeyEvent *ev, String *params,
		Cardinal *num_params)
  {
  mpic *m;
  float fx, fy, meanX, meanY, dismax, phi, lam;
  int ix, iy, i, hsize, circle = 23040;
  FILE *inf;
  ac_rec          accard;
  Display *disp;	
  Window wind;	
  GC ggc;	

  XtVaGetValues(wij, XtNdata, &m, NULL);

  wind = XtWindow(wij);
  disp = XtDisplay(wij);
  ggc = m->ggc;

  hsize = 4 * m->SourceSize;

  fprintf(stderr, "Reading from input source file = %s\n", m->src_dump_file);
  if((inf = fopen(m->src_dump_file, "r")) == NULL)
    {
    printf("Can't open special source %s ....try again\n", m->src_dump_file);
    return;
    }

  meanX = meanY = i = 0;

  while(readac(inf, &accard))
    {
    phi = accard.lat1 + accard.lat2 / 6000.0;
    lam = accard.lon1 + accard.lon2 / 6000.0;
    if(accard.EW[0] == 'W') lam *= -1;
    if(accard.NS[0] == 'S') phi *= -1;

    geo2xy(m, phi, lam, &fx, &fy);
    if(intarg(fx,fy,m->gr))
      {
      i++;
      meanX = meanX + fx;
      meanY = meanY + fy;
      }
        
    ix = user_to_pix_x(&m->gr, (double) fx) - (hsize / 2);
    iy = user_to_pix_y(&m->gr, (double) fy) - (hsize / 2);

    if(strlen(accard.id) == 10)
      XSetForeground(disp, ggc, m->colors[XmapAppColor(13)]);
    else
      XSetForeground(disp, ggc, m->colors[XmapAppColor(19)]);
    XFillArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

    XSetForeground(disp, ggc, m->colors[XmapAppColor(21)]);
    XDrawArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

    XSetFont(disp, ggc, m->fonts[0]);
    XSetForeground(disp, ggc, m->colors[XmapAppColor(1)]);
    if(m->sta_name_flag)
      draw_just_text(disp, wind, ggc, ix, iy, accard.id, HJ_LEFT, VJ_BASELINE);

    XFlush(disp);
    }
  fclose(inf);

  if(m->sta_name_flag)
    {
    meanX = meanX / (float)i;
    meanY = meanY / (float)i;

    dismax = get_dismax_special(m->src_dump_file, m, meanX, meanY);
    dump_explode_special(m->src_dump_file, m, meanX, meanY, dismax);
    }
  }

/*************************************************/

typedef struct
  {
  char dat[15];
  } stamp;
/*************************************************/



/*************************************************/

void Key_A_lees(Widget wij, XKeyEvent *ev, String *params,
		Cardinal *num_params)
  {
  mpic *mplot;
  float *tims, dt, wa, secs_to_wait, *siz;
  int total_num, i, k, j, n, hsize, circle = 23040, *indtim, *pixx, *pixy,
    inine, num, yy, freq_print = 100, iy, im, id, ih, mm, dd,
    xstamp_pos = 200, ystamp_pos = 40, xstamp_width = 200, ystamp_width = 20,
    ystamp_text = 60;
 /* stamp date_stamp[10000];*/
  stamp *date_stamp;
  
  Display *disp;	
  Window wind;	
  GC ggc;	
    unsigned int  iwait;



  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  wind = XtWindow(wij);
  disp = XtDisplay(wij);
  ggc = mplot->ggc;

  mplot->src_flag = 0;
  mplot->more_src_flag =0;

  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

  XSetFont(disp, ggc, mplot->fonts[2]);
  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(0)]);
  XFillRectangle(disp, wind, ggc, xstamp_pos, ystamp_pos, xstamp_width,
		 ystamp_width);
  XFlush(disp);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(2)]);
  draw_just_text(disp, wind, ggc, xstamp_pos, ystamp_text, "Please Wait...",
		 HJ_LEFT, VJ_BASELINE);
  XFlush(disp);

  total_num = 0;
  for(j = 0; j < mplot->max_more_src; j++ )
    total_num += mplot->sources[j].numpoints;

  fprintf(stderr,"Total num= %d\n", total_num);

  indtim = alloc_ivec(0, total_num);    
  pixx = alloc_ivec(0, total_num);
  pixy = alloc_ivec(0, total_num);
  tims = alloc_fvec(0, total_num);
  siz = alloc_fvec(0, total_num);

  /* date_stamp = (stamp *)malloc(sizeof(stamp)); */
  date_stamp =XmapNewArray(stamp, total_num);
  
  yy = 1980;
  iy = 1;
  tojul(yy, iy, iy, &inine);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(3)]);
  hsize = mplot->SourceSize / 2;
  /* create_busy_cursor();*/

  k = 0;
  n = 0;
  printf(" number of files: %d\n", mplot->max_more_src); 

  for(j = 0; j < mplot->max_more_src; j++) 
    {
    for(i = 0; i< mplot->sources[j].numpoints; i++)
      {
      /* busy_cursor(wind);*/
      sscanf(mplot->sources[j].acard[i].id, "%2d%2d%2d%2d%2d", &iy, &im, &id,
	     &ih, &mm);
      yy = 1900 + iy;
      tojul(yy, im, id, &dd);
      dd -= inine;
      /* printf("%d %d %d %d %d %d %d\n",iy,im,id,ih,mm,dd,yy);*/
      dt = (dd + (float)ih / 24.0 + (float)mm / (24.0 * 60.0)
	    + mplot->sources[j].acard[i].sec / (24.0 * 60.0 * 60.0));
      /* siz[k] = mplot->SourceSize+1.5*mplot->sources[j].acard[i].mag; */
      wa = exp(mplot->sources[j].acard[i].mag);
      siz[k] = mplot->SourceSize + 0.08 * wa;
      if(siz[k] > 50.0) siz[k] = 37.5 + 0.25 * siz[k];
      /* printf("%d %f %f\n",k,siz[k],mplot->sources[j].acard[i].mag); */

      pixx[k] = (user_to_pix_x(&mplot->gr, (double)mplot->sources[j].loc[i].x)
		 - siz[k] / 2);
      pixy[k] = (user_to_pix_y(&mplot->gr, (double)mplot->sources[j].loc[i].y)
		 - siz[k] / 2);
      sprintf(date_stamp[k].dat, "%2d %2d %2d %2d %2d", iy, im, id, ih, mm);
      tims[k] = dt;
      k++;
      }
    }

  num = k;
  freq_print = 100;
  if(num < 100) freq_print = 1;

  printf("Please wait......\n .......there are %d events to sort\n", num);

  csorta(tims, indtim, tims, num);
  dt = tims[num - 1] - tims[0];
  wa = mplot->time_plot_wait / dt;

  for(i = 0; i < num - 1; i++)
    {
    hsize = siz[indtim[i]];

    /* printf("%d %d \n",pixx[indtim[i]], pixy[indtim[i]]); */

    XSetForeground(disp, ggc, mplot->colors[XmapAppColor(21)]);
    XFillArc(disp,wind, ggc, pixx[indtim[i]], pixy[indtim[i]], hsize, hsize,
	     0, circle);

    XSetForeground(disp, ggc, mplot->colors[XmapAppColor(14)]);
    XDrawArc(disp,wind, ggc, pixx[indtim[i]], pixy[indtim[i]], hsize, hsize,
	     0, circle);

    XFlush(disp);

    if((i % freq_print) == 0)
      {
      /* printf("%d  %s\n",i, date_stamp[indtim[i]].dat); */

      XSetForeground(disp, ggc, mplot->colors[XmapAppColor(0)]);
      XFillRectangle(disp, wind, ggc, xstamp_pos, ystamp_pos, xstamp_width,
		     ystamp_width);
      XFlush(disp);

      XSetForeground(disp, ggc, mplot->colors[XmapAppColor(2)]);
      draw_just_text(disp, wind, ggc, xstamp_pos, ystamp_text,
		     date_stamp[indtim[i]].dat, HJ_LEFT, VJ_BASELINE);
      XFlush(disp);
      }

    secs_to_wait = (tims[i + 1] - tims[i]) * wa;
    /* printf("%f seconds to wait\n",secs_to_wait); */

     iwait = 1000000 * secs_to_wait; usleep(iwait); 

    /*  sleep(secs_to_wait); */
    }

#if 1	

  hsize = siz[indtim[num - 1]];
  /* printf("%d %d \n",pixx[indtim[num]-1], pixy[indtim[num]-1]); */

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(1)]);
  XFillArc(disp, wind, ggc, pixx[indtim[num - 1]], pixy[indtim[num - 1]],
	   hsize, hsize, 0, circle);
  XFlush(disp);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(21)]);
  XFillArc(disp, wind, ggc, pixx[indtim[num - 1]], pixy[indtim[num-1]],
	   hsize, hsize, 0, circle);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(14)]);
  XDrawArc(disp, wind, ggc, pixx[indtim[num - 1]], pixy[indtim[num - 1]],
	   hsize, hsize, 0, circle);
  XFlush(disp);

#endif

  mplot->src_flag = mplot->more_src_flag = 1;

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(0)]);
  XFillRectangle(disp, wind, ggc, xstamp_pos, ystamp_pos, xstamp_width,
		 ystamp_width);
  XFlush(disp);
  printf("DONE: %d \n", num);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(2)]);
  draw_just_text(disp, wind, ggc, xstamp_pos, ystamp_text, "Done!      ",
		 HJ_LEFT, VJ_BASELINE);
  XFlush(disp);

  free_ivec(indtim, 0, total_num);
  free_ivec(pixx, 0, total_num);
  free_ivec(pixy, 0, total_num);
  free_fvec(tims, 0, total_num); 
  free_fvec(siz, 0, total_num); 
  XmapFree(date_stamp);

  /* free(date_stamp); */
  }

/***************************   END TIME PLOT ***********************/
/***************************   NEW TIME PLOT ***********************/

void Key_A_lees1(Widget wij, XKeyEvent *ev, String *params,
		 Cardinal *num_params)
  {
  mpic *mplot;
  float *tims, dt, *siz, wa, secs_to_wait;
  int i, k, j, n, total_num, hsize, circle = 23040, *indtim, *onoff, *place,
    *pixx, *pixy, inine, num, num2, yy, freq_print = 100, iy, im, id,
    ih, mm, dd, xstamp_pos = 200, ystamp_pos = 40, xstamp_width = 200,
    ystamp_width = 20, ystamp_text = 60;
  stamp *date_stamp;

  Display *disp;	
  Window wind;	
  GC ggc;	

  unsigned int iwait;
  

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  wind = XtWindow(wij);
  disp = XtDisplay(wij);
  ggc = mplot->ggc;

  mplot->src_flag =  mplot->more_src_flag = 0;
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

  XSetFont(disp, ggc, mplot->fonts[2]);
  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(0)]);
  XFillRectangle(disp, wind, ggc, xstamp_pos,ystamp_pos, xstamp_width,
		 ystamp_width);
  XFlush(disp);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(2)]);
  draw_just_text(disp, wind, ggc, xstamp_pos, ystamp_text, "Please Wait...",
		 HJ_LEFT, VJ_BASELINE);
  XFlush(disp);

  total_num = 0;
  for(j = 0; j < mplot->max_more_src; j++)
    total_num += mplot->sources[j].numpoints;

  fprintf(stderr,"Total num= %d\n", total_num);

  indtim = alloc_ivec(0, 2 * total_num);
  onoff = alloc_ivec(0, 2 * total_num);
  place = alloc_ivec(0, 2 * total_num);
  pixx = alloc_ivec(0, total_num);
  pixy = alloc_ivec(0, total_num);
  tims = alloc_fvec(0, 2 * total_num);
  siz = alloc_fvec(0, total_num);

  /* date_stamp=(stamp *)malloc(sizeof(stamp)); */
  date_stamp =XmapNewArray(stamp, total_num);
  yy = 1980;
  iy = 1;
  tojul(yy, iy, iy, &inine);

  XSetForeground(disp, ggc, mplot->colors[ XmapAppColor(3) ] );
  hsize = mplot->SourceSize / 2;
  k = n = 0;
  printf(" number of files: %d\n", mplot->max_more_src);

  for(j = 0; j < mplot->max_more_src; j++)
     {
     for(i = 0; i < mplot->sources[j].numpoints; i++)
       {
       sscanf(mplot->sources[j].acard[i].id, "%2d%2d%2d%2d%2d", &iy, &im, &id,
	      &ih, &mm);
       yy = 1900 + iy;
       tojul(yy, im, id, &dd);
       dd -= inine;
       /* printf("%d %d %d %d %d %d %d\n",iy,im,id,ih,mm,dd,yy); */
       dt = (dd + ((float)ih / 24.0 + (float)mm / (24.0 * 60.0)
		   + mplot->sources[j].acard[i].sec / (24.0 * 60.0 * 60.0)));

       /* siz[k] = mplot->SourceSize+1.5*mplot->sources[j].acard[i].mag; */

       wa = exp(mplot->sources[j].acard[i].mag);
       siz[k] = mplot->SourceSize+ 0.08 * wa;
       if(siz[k] > 50.0) siz[k] = 37.5 + 0.25 * siz[k];

       pixx[k] = (user_to_pix_x(&mplot->gr, (double)mplot->sources[j].loc[i].x)
		  - siz[k] / 2);
       pixy[k] = (user_to_pix_y(&mplot->gr, (double)mplot->sources[j].loc[i].y)
		   - siz[k] / 2);
       sprintf(date_stamp[k].dat, "%2d %2d %2d %2d %2d", iy, im, id, ih, mm);

       tims[n] = dt;
       place[n] = k;
       onoff[n] = 1;
       n++;

       /****     TURN OFF TIME    *******/

       tims[n] = dt + 0.14 * wa;
       place[n] = k;
       onoff[n] = 0;
       n++;
       k++;
       }
     }

  num = k;
  num2 = n;
  freq_print = 100;
  if(num < 100) freq_print = 1;
  printf("Please wait......\n .......there are %d events to sort\n", num);
  csorta(tims, indtim, tims, num2);
  dt = tims[num2 - 1] - tims[0];
  wa = mplot->time_plot_wait / dt;

  /*  plot first event  */

  for(i = 0; i< num2 - 1; i++)
    {
    hsize = siz[place[indtim[i]]];

    /* printf("%d %d \n",pixx[place[indtim[i]]], pixy[place[indtim[i]]]); */
    if(onoff[indtim[i]] == 1)
      {
      XSetForeground(disp, ggc,	mplot->colors[XmapAppColor(21)]);
      XFillArc(disp, wind, ggc, pixx[place[indtim[i]]],	pixy[place[indtim[i]]],
	       hsize, hsize, 0, circle);

      XSetForeground(disp, ggc,	mplot->colors[XmapAppColor(14)]);
      XDrawArc(disp, wind, ggc,	pixx[place[indtim[i]]],	pixy[place[indtim[i]]],
	       hsize, hsize, 0, circle);

      XFlush(disp);
      }
    else
      {
      XSetForeground(disp, ggc,	mplot->colors[XmapAppColor(17)]);
      XFillArc(disp, wind, ggc,	pixx[place[indtim[i]]],	pixy[place[indtim[i]]],
	       hsize, hsize, 0, circle);
      }

    if((i % freq_print) == 0)
      {
      /* printf("%d  %s\n",i, date_stamp[place[indtim[i]]].dat); */

      XSetForeground(disp, ggc, mplot->colors[XmapAppColor(0)]);
      XFillRectangle(disp, wind, ggc, xstamp_pos, ystamp_pos, xstamp_width,
		     ystamp_width);
      XFlush(disp);

      XSetForeground(disp, ggc, mplot->colors[XmapAppColor(2)]);
      draw_just_text(disp, wind, ggc, xstamp_pos, ystamp_text,
		     date_stamp[place[indtim[i]]].dat, HJ_LEFT, VJ_BASELINE);
      XFlush(disp);
      }

    secs_to_wait = (tims[i + 1] - tims[i]) * wa;

    /* printf("%f seconds to wait\n",secs_to_wait); */

     iwait = 1000000 * secs_to_wait; usleep(iwait); 

     /*  sleep(secs_to_wait); */
    }

  mplot->src_flag = mplot->more_src_flag = 1;

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(0)]);
  XFillRectangle(disp, wind, ggc, xstamp_pos, ystamp_pos, xstamp_width,
		 ystamp_width);
  XFlush(disp);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(2)]);
  draw_just_text(disp, wind, ggc, xstamp_pos, ystamp_text, "Done!      ",
		 HJ_LEFT, VJ_BASELINE);
  XFlush(disp);

  printf("DONE: %d \n", num);
  free_ivec(indtim, 0, 2 * total_num);
  free_ivec(onoff, 0, 2 * total_num);
  free_ivec(place, 0, 2 * total_num);
  free_ivec(pixx, 0, total_num);
  free_ivec(pixy, 0, total_num);
  free_fvec(tims, 0, 2 * total_num); 
  free_fvec(siz, 0, total_num);
  XmapFree(date_stamp);

  }

/*************************************************/

void Hypos_2_File(mpic *mplot, char *source_file, int append)
  {
  int i, j, k = 0;
  float minx, maxx, miny, maxy;
  char acrd[76];
  FILE *inf;
   float bot=10000.0, top=-10000.0;

  switch(append)
    {
    case 0:
      fprintf(stderr,"Saving Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "w")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;

    case 1:
      fprintf(stderr,"Appending Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "a")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;

    default:
      fprintf(stderr,"Saving Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "w")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;
    }

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    maxx =pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    maxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    }
  else
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    maxy =pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }
  if( mplot->src_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }
   
  k = 0;
  for(j = 0; j <= mplot->max_more_src - 1; j++)
     {
     printf("\n-------------From Source File %s ---------------\n",
	    mplot->sources[j].file_name);
     for(i = 0; i < mplot->sources[j].numpoints; i++)
	{
	if((mplot->sources[j].loc[i].x >= minx)
	   && (mplot->sources[j].loc[i].x <= maxx)
	   && (mplot->sources[j].loc[i].y >=  miny)
	   && (mplot->sources[j].loc[i].y <= maxy))


	   {
	   if(mplot->sources[j].onoff[i] == 1)
	      {
       
	      if( mplot->src_in_layer == 0 || 
		 (mplot->src_in_layer == 1 && 
		  mplot->sources[j].loc[i].z < bot  && 
		  mplot->sources[j].loc[i].z >= top) )  
		 {
		 create_Acard(&mplot->sources[j].acard[i], acrd);
		 fprintf(inf, "%s", acrd);
		 k++; 
		 }

	      }
	   }
      

	} 
     }

  fprintf(stdout,"\n\n Number of points saved= %d\n", k);
  fclose(inf);
  }

void Extended_2_File(mpic *mplot, char *source_file, int append)
  {
  int i, j, k = 0;
  float minx, maxx, miny, maxy;
 /* char acrd[76];*/
  FILE *inf;
 float bot=10000.0, top=-10000.0;

  if(strcmp(mplot->hypo_format_str, "UWE"))
       {
       fprintf(stderr,"Sources have no extensions.....(returning)\n");
       return;
       }

  switch(append)
    {
    case 0:
      fprintf(stderr,"Saving Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "w")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;

    case 1:
      fprintf(stderr,"Appending Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "a")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;

    default:
      fprintf(stderr,"Saving Sources to file:%s\n", source_file);
      if((inf = fopen(source_file, "w")) == NULL)
	{
	printf("Can't open special source %s ....try again\n", source_file);
	return;
	}
      break;
    }

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    maxx =pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    maxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    }
  else
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    maxy =pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }
 if( mplot->src_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }
   
  k = 0;
  for(j = 0; j <= mplot->max_more_src - 1; j++)
     {
     printf("\n-------------From Source File %s ---------------\n",
	    mplot->sources[j].file_name);
     for(i = 0; i < mplot->sources[j].numpoints; i++)
	{
	if((mplot->sources[j].loc[i].x >= minx)
	   && (mplot->sources[j].loc[i].x <= maxx)
	   && (mplot->sources[j].loc[i].y >=  miny)
	   && (mplot->sources[j].loc[i].y <= maxy))
	   {
	   if(mplot->sources[j].onoff[i] == 1)
	      {
       
	      if( mplot->src_in_layer == 0 || 
		 (mplot->src_in_layer == 1 && 
		  mplot->sources[j].loc[i].z < bot  && 
		  mplot->sources[j].loc[i].z >= top) )  
		 {
		 /* create_Acard(&mplot->sources[j].acard[i], acrd); */
		 if(strcmp(mplot->sources[j].acard[i].unique_id,""))
		    {
		    fprintf(inf, "%s\n",mplot->sources[j].acard[i].unique_id     );
		    }
	   
		 k++; 
		 }
	      }
	   }
      
	} 
     }

  fprintf(stdout,"\n\n Number of points saved= %d\n", k);
  fclose(inf);
  }

/*************************************************/

void SAVE_Src(Widget wij, mpic *mplot, char *call_data)
  {
  int append = 0;

  Hypos_2_File(mplot, mplot->src_dump_file, append);
  }


void Extend_Src(Widget wij, mpic *mplot, char *call_data)
  {
  int append = 0;

  Extended_2_File(mplot, mplot->src_dump_file, append);
  }



void APPEND_Src(Widget wij, mpic *mplot, char *call_data)
  {
  int append = 1;

  Hypos_2_File(mplot, mplot->src_dump_file, append);
  }

void Run_DB(Widget wij, mpic *mplot, char *call_data)
  {
    system("UW_LIST_DB.prl");
    
  }

/*************************************************/

void Spe_Src(Widget wij, mpic *m, char *call_data)
  {
  /* this routine does not work - I don't know why
     but I cannot draw from a menu operation   */

  float fx, fy, phi, lam;
  int ix, iy, hsize;
  FILE *inf;
  ac_rec accard;
  Display *disp;	
  Window wind;	
  GC ggc;	

  /* XtVaGetValues(wij, XtNdata, &m, NULL); */

  wind = XtWindow(wij);
  disp = XtDisplay(wij);
  ggc = m->ggc;
  hsize = 3 * m->SourceSize;

  if((inf = fopen(m->src_dump_file, "r")) == NULL)
    {
    printf("Can't open special source %s ....try again\n", m->src_dump_file);
    return;
    }
  while(readac(inf, &accard))
    {
    phi = accard.lat1+accard.lat2 / 6000.0;
    lam = accard.lon1+accard.lon2 / 6000.0;
    if(accard.EW[0] == 'W') lam *= -1;
    if(accard.NS[0] == 'S') phi *= -1;
    fprintf(stderr, "%f %f\n", phi,  lam);

    geo2xy(m, phi, lam, &fx, &fy);

    fprintf(stderr, "fx fy = %f %f \n", fx, fy);
    ix = user_to_pix_x(&m->gr, (double)fx) - (hsize / 2);
    iy = user_to_pix_y(&m->gr, (double)fy) - (hsize / 2);
    fprintf(stderr, "ix iy = %d %d \n", ix, iy);

    XSetForeground(disp, ggc, m->colors[XmapAppColor(21)]);
    fprintf(stderr, "color set 1\n");
    XFillRectangle(disp, wind, ggc, ix, hsize, iy, hsize);

#if 0
    XFillArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);
    fprintf(stderr, "done arc 1\n");

    XSetForeground(disp, ggc, m->colors[XmapAppColor(14)]);
    fprintf(stderr, "color set 2\n");
    XDrawArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);
    fprintf(stderr, "done arc 2\n");
#endif

    XFlush(disp);
    fprintf(stderr, "Flushed \n");
    }
  }

int Get_Stuff1(mpic *m);

void Key_F1_map(Widget wij, XKeyEvent *ev, String *params,
		Cardinal *num_params)
  {
  mpic *mplot;
  unsigned short x, y, w, h;
  float bx1, by1, phi, lam;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  if(mplot->project_type <= 1)
    {
    mplot->origin.minx = 0.0;
    mplot->origin.maxx = mplot->origin.nxblk*mplot->origin.dx;
    mplot->origin.miny = 0.0;
    mplot->origin.maxy = mplot->origin.nyblk*mplot->origin.dy;
    }
  else
    {
    mplot->origin.minx = 0.0;
    mplot->origin.miny = 0.0;
    phi = mplot->origin.phimin;  
    lam = mplot->origin.lammax;  

    geo2xy(mplot, phi, lam, &bx1, &by1);
    mplot->origin.maxx = bx1;
    phi = mplot->origin.phimax;  
    lam = mplot->origin.lammin;  
    geo2xy(mplot, phi, lam, &bx1, &by1);
    mplot->origin.maxy = by1;
    }

  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

void focal_summary(mpic * mplot)
  {

    
    focal_Proj(mplot->wij,  mplot);
    focal_ternary(mplot->wij,  mplot);
      
    
  }
