.TH xm_color l "5 March 1995"
.SH NAME
xm_color - Color format for the xmap8 program 
.SH SYNOPSIS
\fBxm_color\fP - Input File Format
.SH DESCRIPTION
.sp
Default colors are set for xmap8 at run time.  These include
60 map colors plus 2 image palettes of 40 colors each.
The image palettes include a rainbow-like spectrum and a
red-black-blue spectrum useful for tomographic results.

.sp
.SH FORMAT
.sp
.nf
The color map is divided into 3 parts:  The first 27 colors
are used by the program in various drawing routines.
The assignements of these colors to specific objects are
defined below as an option.  Otherwise these objects take on
default colors.  Color numbers 28-60 are free colors,
useful for making complicated geological maps.
You may use the first 28 colors for making maps also.
The 2 image palettes are for plotting contours and images.
They can be modified inthe same way that map colors are modified.
You can modify the colors by installing two optional files:

setenv XMA_PALETTE /full_path/file_name

this modifies the 60 color palette so you can choose any 
colors (paint) from the X color library.
I may add an R-G-B option here, but I have not worked
that out yet.

setenv XMA_COLORS /full_path/file_name

is a file that has a mapping of the colors in the palette to the
objects that get colors.  This is the part that is not completely
tested yet since I had to go back to all the (20K lines of) code and
un-hardwire all the color asignations.  If something does not color as
you expect, better get in touch with me and I'll fix it.


So now, if you don't like the green stations that I always draw, you
simply make a file that includes this line:


sta_col 2

(to get red stations with the default palette).  The names of these are
somewhat cryptic, to shorten the typing. I will make a more extensive
documentation later.


Alternatively, you can change the green paintbrush
to a red one by change the default palette (7=green),

7	"red"

This file is read in a program start up.

"Dump Colors"  prints out the current color scheme and palette.

So now you can view fancy earthquakes in any color you want  and you
can change the background etc.....

Any changed color is also changed in the postscript color output.
However, the default colors do not match exactly between screen and
postscript rendering.  This is because my experience with screen
versus paper output has instructed me to fiddle with the colors
for better paper reproduction.  If you don't like the default translation,
modify the color for a specific paintbrush (number) and 
you wil get a direct translation of the screen color inot postscript.


-----------------------
Default Palette:

0	"black"
1	"white"
2	"red"			
3	"light blue"		
4	"mediumpurple"		
5	"azure"		
6	"darkorange"		
7	"green"		
8	"plum"			
9	"LemonChiffon1"	
10	"SeaGreen1"		
11	"DeepSkyBlue1"		
12	"turquoise1"		
13	"DeepPink"		
14	"gold"			
15	"lightcyan"		
16	"OldLace"		
17	"DarkSlateGray"	
18	"DarkSeaGreen"		
19	"GreenYellow"		
20	"orange"		
21	"RoyalBlue"		
22	"SkyBlue1"		
23	"cyan1"		
24	"DarkSlateGray4"	
25	"dimgray"	
26	"beige"		
27	"aquamarine1"

28    "LightPink"
29    "yellow1"
30    "SkyBlue"
31    "LightSeaGreen"
32    "MistyRose2"
33    "tan4"
34    "LightCyan2"
35    "PeachPuff1"
36    "lavender"
37    "magenta3"
38    "pink"
39    "green"
40    "PaleGreen3"
41    "SteelBlue2"
42    "moccasin"
43    "DeepPink"
44    "AntiqueWhite"
45    "cornsilk2"
46    "khaki"
47    "bisque3"
48    "PaleGreen"
49    "IndianRed"
50    "LightSalmon"
51    "thistle1"
52    "LightSkyBlue1"
53    "MediumAquamarine"
54    "yellow2"
55    "MintCream"
56    "sienna4"
57    "salmon"
58    "LemonChiffon"
59    "SeaGreen1"

------------------------
Default Color Scheme:

special_src_col 13
special_sta_col 19
special_perim_col 21
special_name_col 1
back_label_col 0
name_label_col 2
date_col 3
fill_arc_col 21
draw_arc_col 14
fancy_src_col 21
fancy_perim_col 14
magscale_col 1
special_station_col 19
exploding_line_col 1
back_foc_col 1
ptax_col 0
faultplane_col 0
strikeslip_col 18
rev_oblSS_col 23
oblq_norm_col 20
obl_rev_col  22
reverse_col  21
norm_oblSS_col 19
normal_col  2
xsec_color 1
box_xsec_col 18
zoom_box_col 22
spline_col 22
spline_points_col 1
sta_col 7
bord_col 2
back_fill_col 24
stuff_col 3
map_col 3
src_col 14
title_col 6
picsource_col 5
text_col 3
background_col 0
foreground_col 1





.br
.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points 
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees
Yale University, Dept. Geology and Geophysics
P.O. Box 208109, New Haven, CT, 06520-8109
Voice: (203) 432-6947    FAX (203) 432-3134
email:  lees@lamb.geology.yale.edu
 WWW:    http://love.geology.yale.edu/~lees


see article by J. M. Lees:
Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.

.br
