.TH xm_ellipse l "1 Oct 1995"
.SH NAME
xm_ellipse - Ellipse format for the xmap8 program 
.SH SYNOPSIS
\fBxm_ellipse\fP - Input File Format
.SH DESCRIPTION
.sp
Ellipses are stored in a simple ascii format in free format.
You can load ellipses by using the -E <filename> option or by
reading them in with the menu option "Get Ellipses".
Toggling the "Plot Ellipses" button will turn the plotting on or off.

.br
.sp
.SH FORMAT
.sp
The format for ellipses comes in 2 "styles".
.sp
The first simple style involves only 3 parameters: DX, DY, and DZ
and will provide a simple plot of an ellipse oriented along the
N-S, E-W, Z axes.  
.sp
The second format provides
the 6 elements of the covariance matrix describing the ellipsoid.  
In this case ellipsoids are plotted such the viewer sees the outline of
the full ellipsoid projected onto the viewers plane. 
.sp
.nf
------------------------
Format 1:
name LAT LON DEPTH DX DY DZ
.sp
------------------------
Format 2:
name LAT LON DEPTH XX XY XZ YY YZ ZZ

so that DX = sqrt(XX), DY = sqrt(YY), DZ = sqrt(ZZ)

.br
.sp
.SH UW FORMAT
Since UW pickfiles have the E card separate from the
A-card, or hypocenter card, all you have to do is run a simple 
script to combine the two into an xmap8 ellipse card.  I
have provided a simple Perl script to do this.
.nf
PERL SCRIPT:
#!/usr/local/bin/perl 

# program reads a pickfile in UW format,
#   extracts information from the A-card and E-card
#   returns an xmap8 ellipse card
#                   J. M. LEES Sun Oct  1 01:18:42 EDT 1995

while(<>){

   $kind = substr($_,0,1);

    if($kind eq "A") { 

         #print "got an A card: $_ \n" ;

#A 8005190129 30.25 46N1276 122W1108 19.44  2.6 26/000 051 04 0.35 00.7CA C1
#c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$

          $type = substr($_, 1, 1 );
          $id= substr($_, 2, 10);
          $sec = substr($_, 12, 6);
          $lat1 = substr($_ ,19, 2);
          $NS = substr($_, 21, 1);
          $lat2 = substr($_, 22, 4);
          $lon1 = substr($_, 27, 3);
          $EW = substr($_, 30, 1);
          $lon2 = substr($_, 31, 4);
          $depth = substr($_, 35, 6);
          $mag = substr($_, 43, 3);
          $nump = substr($_, 46, 3);
          $JU = substr($_, 49, 1);
          $nums = substr($_, 50, 3);
          $gap = substr($_, 54, 3);
          $delta = substr($_, 57, 3);
          $rms = substr($_, 60, 5);
          $err = substr($_, 65, 5);
          $q1 = substr($_, 70, 1);
          $q2 = substr($_, 71, 1);
          $modid = substr($_, 73, 2);

 
         $latdd = $lat1 + $lat2/6000.0;
         $londd = $lon1 + $lon2/6000.0;

if($EW eq "W") { $londd = -$londd; }
if($NS eq "S") { $latdd = -$latdd; }

     }

    if($kind eq "E") { 
          $dx = substr($_, 46, 4 );
          $dy= substr($_, 51, 4);
          $dz = substr($_, 56, 4);

#E LQ 0.152 0.061 0.159 0.145 2266.93   9      1.69 2.11 3.48 0.21 0.00 0.00
#Vel,RMS,MeanRMS,SDabout0,SDaboutMean,SSWRES,NDFR,FIXXYZT,SDx,SDy,
#      SDz,SDt,Mag,StErrMag,MeanUncert
#FORMAT('E',1x,A2,4(1x,f5.3),1x,F7.2,1x,I3,1x,4A1,4(1x,F4.2),3(1x,F4.2)
#                                               dx    dy   dz   dt
#E VV RR.RR M.MMM S.SSS S.SSS WWWW.WW NNN XYZT D.DD D.DD D.DD D.DD M.MM S.SS U.UU
#0c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$

# OUTPUT ELLIPSE CARD: 

printf("%s  %f   %f  %f   %f %f %f\n",$id, $latdd, $londd,  $depth, $dx, $dy, $dz );
   }  
   }

.br

.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
 WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.

.br

