.TH xm_hypo l "5 March 1995"
.SH NAME
xm_hypo - Hypocenter format for the xmap8 program 
.SH SYNOPSIS
\fBxm_hypo\fP - Input File Format
.SH DESCRIPTION
.sp
The default format for hypocenters in xmap8 is UW pickfile format for hypocenters and focal mechanisms.
.sp
New: Now you can import hypoinverse and CalTech Catalogue
hypocenters into xmap8.  See below.
.sp
Importation of fpfit output is still not available.

.br
.sp
.SH FORMAT
.sp
.nf
Can have Several Source Files input. Use: -S file1 -S file2.....
(S = Source)

The hypocenter format is determined by env variable: XMA_HYPO_FORMAT
which can be set to any of:  { UW , uw ,  hypoinverse , cit , CIT }
Or it can be changed on the fly on the command line by including
the suffix on the -S option, e.g.
-Suw files  -Scit file ...etc.

There is now a new format which is an augmented UW file
card that include the unique name of the file
added on the end, separated by a colon (:).
This allows you to access a database of digital waveforms
(or other information) which is accessed via the unique identification. 



e.g.
setenv XMA_HYPO_FORMAT hypoinverse

the default is UW format, described below.
cit = CalTech Catalog format
hypoinverse = (one variant of) hypoinverse format
----------------------------------------

Hypocenters are normally screened spatially to limit
the number stored in memory.  Normally, hypocenters
located outside of the window surrounding the target
are excluded.  To force inclusion of all hypocenters
into memory use the command line option

-force_source  

This will force all hypocenters to be included (no spatial selection).
This is important to use when applying the "connect" option on the Source menu.
This option requires that the source files being connected
have 1-1 correspondence.


---------UW FORMAT-----------------------

    ident      sec   lat    long    depth mag np  ns gap delt err rms qq mod
A 9005051858 24.25 36N0127 117W5001  2.50  0.0 05/005 266 01 0.05 00.2AD F1     
A 9005061311  7.80 36N0275 117W5144  2.02  0.2 06/005 304 05 0.03 00.3AD F1     
A 9005061308 47.18 36N0005 117W4801  2.07  0.0 05/005 200 00 0.05 00.2AD F1     
A 9005061309  5.68 36N0131 117W5024  2.08  0.0 06/006 273 02 0.03 00.1AD F1     

See Details below.
Lat and Long are in the format ddNmmmm   where mmmm is minutes*100

N can be either N or S
W can be either W or E

#################################
FOCAL-MECHANISM file is also in UW format:

Can have Several focal Mechanism Files input. Use: -F file1 -F file2.....

It is organized as pairs of A and M cards.  
The A cards are the same as those described above. 
 An example of an A & M-card pair is:

A 9204230225 29.57 33N5728 116W1868 12.23  3.3 82/000  63  7 0.18  0.2BA CN
M F 345 45 G 255 90 U 165 45 V 435  0 P 219 29 T 470 30

M:      strk1 dip1  strk2 dip2 pol1 dip1 pol2 dip2 p-axis pdip taxis t-dip

These pairs of cards must stay together and there may 
be many concatenated in one file.
The first pair of strk-dip represent, by convention, 
the focal plane and the second the auxiliary plane.  
These can be switched by running a utility called switchfoc, 
or they can be switched in xmap8.  See accelerator keys.
----------------------------------------------------------
Details of A-card -  UW FORMAT


     A    The header line begins with a 'A' in the first col and
          contains all of the date-time information for the
          event, as well as location, magnitude and some quality
          information.  The approved "types" which can appear in
          column 2 are: X- Known explosion, P- Probable explo-
          sion, F- Felt event, T- Teleseisms, H- Hand picked
          (previous 'types' take precedence), L- Low frequency
          volcanic, C- Centralia explosion, R- regional earthquake.

	  Quality factors (UW) :

		 Q1     
	       C    =>     rms <0.5   err <5.0
	       B    =>     rms < 0.3  err < 2.5 errz<5
	       A    =>     rms <0.15  err< 1.0 errz < 2

                 Q2
               C    =>     gap < 180  dmin < 50
	       B    =>     gap < 135   dmin < max(2*depth,5)
	       A    =>     gap <  90   dmin < max(depth,5)


Type,Year,Month,Day,Hour,Min,Sec,Lat,NS,Latmin*100,Longitude,EW,Lonmin*100
Depth,Fix,Magnitude,Numpobs,Numsobs,Gap,Mindelta,RMS,ERR,Q1,Q2,Velmodel
FORMAT('A',A1,5I2,F6.2,I3,A1,I4,I4,A1,I4,
F6.2,A1,F4.1,I3,'/',I3,I4,I3,F5.2,f5.1,2A1,1x,A2)
ATYYMMDDHHMM SS.SS LLNMMMM LLLWMMMM DD.DD* M.M NN/NNN GGG DD R.RR EE.EQQ VV


     M    Mechanism line which summarizes the focal mechanism for
          this event.  Up to 6 fix format packets in pairs for
          nodal planes (F,G), slip vectors (U,V), and major
          stress axes (P,T).  
          In format below AAA is the DOWN DIP AZIMUTH strike
          of a plane measured clockwise from north eastward.  
          PP
          is the dip measured from the horizontal downward.  
          For example a plane with a strike of N55E
          and dipping 30 to the SSE is AAA=145 PP=30.

Plane#1,Plane#2,Slip#1,Slip#2,P-axis,T-axis,Comment
FORMAT('M',6(1x,A1,1x,I3,1x,I2),'C',A)
M F AAA PP G AAA PP U AAA PP V AAA PP P AAA PP T AAA PP C comment
-----------------------------------------------------------------------
hypoinverse example:
8005190858461646 1165122 1231  95219 17 62  2  29  0 0 190  0 0 19019JJJ  40  17  40  40 0


cit catalog example:
1977  1  1  20 22 52.44  34  3.32-116 31.53 C 0.0      5.63  0    0.00       0



.br
.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
 WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:
Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.

.br

