.TH xm_map l "5 March 1995"
.SH NAME
xm_map - Map format for the xmap8 program 
.SH SYNOPSIS
\fBxm_map\fP - Input File Format
.SH DESCRIPTION
.sp
Maps in xmap8 come in 3 formats:
default (dumb map)
gmt_style (dumb map)
lees_format   (smart format)
A "smart format" map is one that has various attributes
that allow the user to control plotting or processing.
lees_format maps include information about whether they are point, 
line or fill objects, color for plotting and an ascii code for determining the
kind of object (river, thrust fault or highway?).
The program works best when using lees_format maps and they recommended.
If you use lees-format maps you can have numerous entries on
the command line.
.br
.sp
.SH FORMAT
.sp
.nf
Default map Format is
an ASCII file with alist of strokes:

Lat1 Lon1 Lat2 Lon2  
(which represents a stroke in lat-lon)

-------------------------------------------------------------
GEOLOGICAL MAP FORMAT

Identification number_of_points  Style  Color kind minlat maxlat minlon maxlon

	Identification = 8 character id  the first 4 chars are used for
			the geological formation name
	
	number_of_points = number of lat-lon pairs associated with this id

	Style = style of object:
			1 = point  (then number_of_points must be 1)
			2 = line
			3 = filled object (geological unit)

	Color = use this number from 1-20 for different color formations
				color(0) = black
                                color(1) = white
                                color(others) = various colors
	Kind

 -----------------------------------------------------
GMT style:
each stroke is a list of lat-lons.
separated by the ">" character"
> first stroke
lon1 lat1
lon2 lat2
lon3 lat3....etc
> second stroke ....etc

---------------
NOTE: By default GMT uses lon-lat instead of lat lon.
This conventions is followed here.  If the first line
in the file contains the string "latlon", however,
the entries are switched to lat-lon  (the standard lees convention)

-----------------------------
lees_format Geologic maps:
This is the same as GMT format accept:
LAT LON is the default, and the first line contains the information
for the 3D GIS data base:


> strokename  num type color code lat1 lat2 lon1 lon2

NOTE: the ">" must be in the first line of each stroke by convention
num = number of points in stroke
type = 1 = points
       2 = line
       3 = fill object
color = color to plot - see documentation on color selection
code = ascii character (0-9, a-z, A-Z) describing object.  
This is a convention chosen by the users. 
Presently I use these codes:

	a = major coasts  islands  lakes
	b = intermediate coasts islands lakes
	c = minor coasts islands lakes
	d =  very minor coasts islands lakes
	e =  major rivers
	f =  intermediate rivers
	g =  minor rivers
	h =  very minor rivers
	i = political borders
	j = major faults
	k = minor faults
	l = geology formation
	m = major high ways
	n = minor roads
	p = plates

	0 = generic

	
(when running xmap8 a plotting code may be supplied to select
   off those parts of the geologic maps one needs)

lat1 lat2 lon1 lon2 = min-max bounds on the stroke.  (this is
                       important for selections from large data-bases)


Example:


> CPLS0001  125  3  1  0    34.1767    34.3752  -116.967 -116.560
    34.0000        -116.000    
.  (etc)
.
.
...etc

.br
.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
 WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.

.br

