.TH xm_menu l "Nov 6 1996"
.SH NAME
xm_menu -  xmap8 program 
.SH SYNOPSIS
\fBxm_menu\fP - Menu Documentation for Xmap8
.SH DESCRIPTION
Following is a list of all menu items in xmap8 with a brief
description of the usage and possible pitfalls.
.nf
---------------------------------------------------------------
.br
.sp
.sp
.SH File
.TP
.B "Quit Window"
This is used to quit a window or the program.
.TP
.B "Restore Size"
Will restore a view to original target area (full zoom out) 
.TP
.B "Zoom out"
reverts back one zoom level
.TP
.B "Zoom in"
zooms in one level
.TP
.B "Screen Bound"
this button will snap a figure back to
fit the screen if it has popped out, or patially out, of view.
.TP
.B "Aspect 1-1"
changes window size so that dx=dy (one-one aspect ratio)
.TP
.B "Postscript"
dumps out a postscript file
.TP
.B "PWD"
dumps out a list of the local directory
.TP
.B "change dir"
changes the current working directory
.TP
.B "Quit"
quit program
.br
.nf
---------------------------------------------------------------
.br
.SH REFRESH 
.TP 
this is a button that simply re-draws the figure
.br
.nf
---------------------------------------------------------------
.br
.sp
.SH Sources
.TP
.B "* Plot Sources" 
Toggles the plotting of 1-st source file

.TP
.B "* Color-Depths" 
plots the source with respect to depth with color Use the MaxDepth
option in the Special menu to change the scale length.  Events below
MaxDep are not plotted.

.TP
.B "Source Size" 
changes the size of the plotted events. Sources, by default, now plot
according to their magnitude. See the scale in the corner.  If you
change the source size under the SOURCES menu, you simply
increase/decrease the minimum source size plotted (min=Magnitude <=1).
If the linear scale option is chosen (see below),
you will have to input a slope parameter if you change the
minimum source size.  The slope is currently 
entered in the main command window.

.TP
.B "Fancy Plot" 
make sources filled in instead of see-through.

.TP
.B "Mag Scale" 
toggle using the magnitude to scale the source size.  The minimum
source size is controlled by the parameter Source Size mentioned
above.  (see Mag Options below)

.TP
.B "Mag Options" 
toggle using the magnitude to scale the source size.  The minimum
source size is controlled by the parameter Source Size mentioned
above.
You have a choice of constant, exponential and linear scales.


.TP
.B "Save Source" 
all the events selected in the last selection using the left mouse drag
will be stored in a file determined by the environment variable
XMA_SPE_SRC.  This is a way to store special events that need to be
plotted on various different displays.  In a companion program called
newsig, digital seismic data that is read in automatically stores the
event locations in the file named by XMA_SPE_SRC so that xmap and
newsig can communicate with each other.  If you hit the <s> accelerator
button you will see all the events stored in the XMA_SPE_SRC file.

.TP
.B "Append Source" 
same as "Save Source" but it appends instead of over writing the file

.TP
.B "Save Extensions" 
Instead of saving the hypocenter information you can save
an extension from the end of the hypocenter card.
This allows you to access digital data stored on your system
by having the names of the files stored as extensions.

.TP
.B "SAVE FILE" 
Change the destination filepath for Save and Append commands, i.e. do not use
the ENV variable setting.  The SAVE_FILE may be changed any number of times.
Each time a new file is created: if an older file
with the same name is requested it is overwritten. Subsequent calls
to SAVE or APPEND direct output to this new file.

.TP
.B "* Src Output"
Toggles the way the sources are printed when selected by the left
button. 
Normal:
The output created by the left-mouse selection of events  is
in A-card format, i.e. you may then cut/paste these into a file and
restart xmap8 with them only. The output has time/lat/lon/magnitude
and other information - in  UW format. Furthermore I also dump out an
"origin file" which (after cut/paste to a file) can be used in a
close-up (zoomed) session of xmap8. It is better to do this than keep
zooming in with the ZOOM feature which creates many windows that are
hard to manage.
Connect:
Events from the first Source File are selected from within the target,
and they are connected to any sequentially matched events in other
Source Files.
Warning: 
Hypocenters are normally screened spatially to limit
the number stored in memory.  Normally, hypocenters
located outside of the window surrounding the target
are excluded.  To force inclusion of all hypocenters
into memory use the command line option "-force_source"  
This will force all hypocenters to be included (no spatial selection).
This is important to use when applying the "connect" option on the Source menu.
This option requires that the source files being connected
have 1-1 correspondence.

No Src Output:
Printing to the screen is suppressed.  This is useful if you are making large selections
to a file and you do not want the screen to page through them all.

.TP
.B "Get More Sources" 
Gets a new file of source events.

.TP
.B "* Plot More Sources" 
Toggles plots of all additional event files

.TP
.B "* Connect Sources"
connects the sources in sequence of input. Sources must have the same
number of events in each file.  (Otherwise there is no matching)

.TP
.B "Layer-Source"
Plot only those sources that fall within the displayed
layer in an image.  This is useful for tomographic studies
when you wish to see how seismicity is changing in each layer of
a model.

.TP
.B "Time Sources" 
this is a (defunct) button related to the plotting of time sequences
 of sources.

.TP
.B "Select Poly" - select the events inside last drawn polygon
.TP

.B "Hypo Stats" - provides basic statistics on selected hypo centers
stored in the SAVE FILE, either the file specified by the ENV variable
XMA_SPE_SRC, or otherwise changed.  The stats are dumped to standard
output.  A wireframe file of the best fitting plane to the hypocenters
is also created and can be accessed in file "hypo_plane" via the 
"Get 3D-Body" menu item under special.


.TP
.B "Select DataBase" 
 Select and plot only those events that comply with the Set Hypo
selection rules

.TP
.B "Reset DataBase" 
 undo Select Database, i.e. plot all events.

.TP
.B "Set Hypo" 
This is a database routine for selecting hypocenters based on typical
parameters, time, magnitude, gap, err, etc....

.nf
---------------------------------------------------------------
.br
.SH Stations
.TP
.B "* Plot Stations" 
Toggles the plotting of stations
.TP
.B "* Plot Station Names" 
Toggles the plotting of station names
.TP
.B "Station Size" 
changes the size of the plotted station
.TP
.B "Get Special Station" 
Plots the named station in different color (RED)   
for finding a particular station in a complicated                      
plot with many stations.
.TP
.B "Sel Stations" 
will dump out stations inside a target selection
.TP
.B "Get Points" 
get a set of points from a point_file.  See xm_points.
.TP
.B "Plot Points" 
toggles plotting of xm_points.
.TP
.B "Name Points" 
toggles plotting of xm_points names
.TP
.B "Sel Points" 
will dump out points inside a target selection


.nf
---------------------------------------------------------------
.br
.sp
.SH Map
.TP
.B "Plot Map" 
Toggles the plotting of map

.TP
.B "Plot Grid" 
Toggles the plotting of a grid defined in the Origin file

.TP
.B "Get Geo Map" 
reads in a new map defined in Lees format and plots in color his new
map overwrites the default map.

.TP
.B "* Geo Table" 
Plots out geological information (legend) defined in the Geo Map

.TP
.B "Map Code" 
Set the code for plotting geological maps (e.g. a, abcdi, abcdefghi, etc...)
Map elements that do not match the code string are excluded.

.TP
.B "Sel Map" 
if geological type map is read in and left-mouse button has been made,
this item will select from the map database all elements that
intersect the target

.TP
.B "Points Map" 
plot the points of a selected map object

.TP
.B "Dump Map"  
Dumps out a copy of the selected map elements to
output file "dump_sel_map.out".  
This new map can be called in on subsequent xmap8 calls.


.TP
.B "Lines Only" 
toggle drawing the geological map with just lines.  This is useful if
 the geological map is confusing.

.TP
.B "Add Lines" 
Add black lines around colored polygons.


.TP
.B "LAT LON" 
will plot tic-marks every degree in lat and lon.  Good for world and
other large scale maps.

.TP
.B "Outside Tics"  
plot tick marks on the outer edges of the plot.

.TP
.B "Background Col"  
Cycle the background color of target region: grey, black, white.
If some objects are hard to see, such as polygon drawing, this may be useful.


.nf
---------------------------------------------------------------
.br
.sp
.SH Vectors/Wells

.TP
.B "Plot Wells" 
puts wells on the map and cross section plots. Wells are read in from
an ASCII file.  I have added a well plotting subroutine.  This is
similar to the Map routines:  select the <Plot Wells>  under the
SPECIAL menu. type in the well-file name (wells.all on this tape).
Voila, the wells appear.  Note that you should select plot.well.names
to see which are which.  A description of the format and the programs
I used to translate your files to my format are listed below.

.B "Get Wells" 
Gets a file of vectors for plotting.

.TP
.B "Plot Well Names" 
toggles whether well names should be plotted.  Project Wells - projects
the wells onto the horizontal map plot.  (wells are projected onto the
cross sections independently from this option).

.TP
.B "Project Wells" 
plot the horizontal (surface) projections of 3D wells

.TP
.B "Dump Wells" 
dumpout the wells to standard output 

.TP
.B "Project Dips" 
 plot the horizontal (surface) projections of dipmeter information

.TP
.B "Plot Ellipses" 
 toggles plotting of error ellipsoids

.TP
.B "Get Ellipses" 
 read in a new error ellipsoid file



.nf
---------------------------------------------------------------
.br
.sp

.SH Focals

.TP
.B "Plot/Get Focals" 
get a file with A and M cards (described below)

.TP
.B "Sphere Size" 
minimum size for plotting a focal mechanism

.TP
.B "Focal Style" 
one of several ways of plotting focal spheres, include beach balls,
beach balls with P-T axis, just P-T axes, strike and dip projections,
etc...Use (r,c,v,t) for acceleration
.TP
.B "* Explode Focals" 
if balls are heavily concentrated, they will overlap.  Can use this
option to "explode" them so they do not overlap. Use (e) for
acceleration

.TP
.B "* Magnitude Scale" 
toggle so that focal spheres are scaled by magnitude.  The overall
scaling is determined by Sphere Size above.

.TP
.B "Color" 
the default is to color the focal according to rake.  If this option
is chosen, though, the focals will be colored according to input file.
For one file input, this means all will have the same color.  Each
successive file will be colored a different shade.

.TP
.B "Summary" 
All focal spheres within the most recent selection
rectangle are summarized in the output window and
a small figure showing the P and T axes projected
on an equal area net is printed in the lower left corner.
This plot is temporary and will disappear when the 
plot is refreshed. Reselecting the option will redisplay
the plot.

.TP
.B "SDR" 
Dump out (stdout) last Focal mechanism selection
(made previously with shift-left dragging) but also
print out the Strike Dip Rake information.
This appears on an extra line below the normal
focal plane information (M-card) with the following 
character flag and
floating point format:
.nf
SDR: DDAZ STRIKE DIP RAKE
.br

.TP
.B "PS Summary" 
Provides a postscript plot of the P and T axes
plotted on the stereo-net described above.

.nf
---------------------------------------------------------------
.br
.sp
.SH Contour

.TP
.B "ContourField" 
read in a file of raw XYZ data in  LAT-LON-Z for interpolation and
contouring.  The initial contour is done with default settings, but
these can be changed by accessing the "Set Cont" button on the main
panel.

.TP
.B "Plot Contour" 
toggles whether to plot the contours or not (after they have been
calculated)

.TP
.B "Raster" 
Dumps out a 2D raster file suitable for plotting in xmap8 (-I file)

.TP
.B "Dump Map" 
Dumps out a lees-map file suitable for plotting in xmap8 (-M file)

.TP
.B "Plot Points" 
plots the imported points used for contouring

.TP
.B "Plot Values" 
plots the imported data values used for contouring

.TP
.B "Palette" 
toggles the 2 image palettes for the contour plotting.


.TP
.B "Set Cont" 
Pops up a panel for changing the contouring parameters.  See following
for parameters description.

.nf
---------------------------------------------------------------
.br
.sp
.SH Set Cont
.sp
These parameters control the handling of the surface fitting program
and the contouring.  If you click SET in this box a new contour plot is
calculated with the new parameters.  Grid: grid dimensions of contour
area (taken originally from origin file)
.sp
Dx-Dy:  number of grid points in X  (DX) and Y (DY) directions to use
in interpolation.  Use this to get smoother or courser contours.
.sp
.nf
Aspect Ratio - set to 1.
Limits - 0
Max_iterations - 250
Tension - 0
X - 1.4
Contour Levels: number of contour levels.  If this is a file name, the
program will read in the contour levels from the file.  Can use this to
fix the contours at nice levels.
.br
.sp
Scale Factor:  multiply each point in field by this value.
.sp
SET - re-do the interpolation and contouring with new parameters.
.sp
Cancel - do not re-calculate contours.
---------------------------------------------------------------
.br
.sp
.SH Image

.TP
.B "Increment Z" 
goes to the next layer down in the model

.TP
.B "Decrement Z" 
goes to the next layer above in the model

.TP
.B "Plot Image" 
toggles whether to plot the images (after they have been read in) 

.TP
.B "Get Image" 
read in a new image file.

.TP
.B "Skip Value" 
Change the value which is skipped in the image file (missing values).

.TP
.B "Z-Layer" 
Jump to a specific layer in the model

.TP
.B "Top(layer 1)" 
Go Back to Layer 1

.TP
.B "Palette" 
There are currently two available color palettes for plotting images
and contour plots.  This menu item toggles between these two.

.TP
.B "Scale Lay/Glob" 
if selected this toggles between using a global scaling versus using a
separate scaling for each layer of the model.  This is useful when the
image consists of different units in each layer.

.TP
.B "Log/Lin scale" 
Toggle between Log or Linear color scales for the image displayed.

.TP
.B "User min-max" 
the User can input a set of minimum and maximum values to use in
scaling rather than the minimum and maximum values from the data.
Values outside these regions are saturated into the bins of maximum
value.
.TP
.B "Reverse_Palette" 
Flip the palette to go from blue to red or vice versa.
.TP
.B "New_Palette" 
Read in your own palette (not available yet).
.TP
.B "Integrate" 
First, select a polygon using the NewPolygon (Special menu) item and the control-left button click.
Second, select this option:  you will need to insert the minimum, maximum and
a scaling factor (e.g. to convert meters to km: use 0.001).
Those raster values that fall within these ranges inside the target are
highlighted and integrated (summed using raster pixel size as dArea).
.TP
.B "High_lite" 
After providing a min and max value, those values falling between these extremes
are highlighted and counted.  Information is dumped to startup screen.
.TP
.B "Wire Render" 
First select a target region.  After selecting this option
the program queries for an upper and lower limit for
pseudo-rendering.  This feature will isolate all blocks
within the limits and output a wire frame structure
enclosing all blocks in the target region.
Panels shared by adjacent blocks are eliminated.
The out put is currently dumpped to 
two files that must be concatonated together.
Use unix command: 
.nf

cat dumpit_wire_frame_top dumpit_wire_frame > new_wireframe

.br
This new wire frame structure, in file "new_wireframe" 
can then be used immediately
in the current xmap8 session.
Use the "Get 3D-body" under Special to access the new wire frame
structure.
.TP
.B "Image Info" 
Dumps out to startup screen information pertaining to the image read in.
.B "Satellite" 
Toggles plotting of satellite image.
This image is read in on the command line at start up so the
colormap can be calculated and adjusted.

.B "Shift Satellite" 
This will shift the satellite image in the plane to match it
with other map elements.

.B "Get File" 
This is an experiment that is still in progress.  Does nothing
at this point, but may crash the system.


.nf
---------------------------------------------------------------
.br
.sp
.SH X-Secs
.TP
.B "Max Depth"  
changes the maximum depth for scaling the color depth and selecting
events on the vertical cross sections.

.TP
.B "HalfWidth" 
changes the swath used for selecting vertically projected earthquakes
on the cross sections

.TP
.B "* Plot X-Secs" 
toggles whether to plot the cross sections in plan view on the map
display.

.TP
.B "SAVE X-Secs" 
save Cross section information to a file for later use (file="SAVE_xsecs") 

.TP
.B "Load X-Secs" 
reads in a file of lat-lon pairs for pre-set cross sections. Cross
sections can now be stored and read in from a file. As you make a new
cross section, the standard output reports on the lat-lon/lat-lon of
your cross-section. Just put these (via cut/paste) into a file and read
it in from the LOAD X-sects under the SPECIAL menu. example:
.sp
.nf
36.113754 -117.877953 35.952969 -117.736397  0.0 0.00 10.00 1.00 1.00
lat        lon        lat        lon         dip  top   bot  front  back
.br
.TP
.B "Set X-Dip" 
Pops up a panel for changing the cross section parameters

.nf
---------------------------------------------------------------
.br
.sp
.SH Special 
.TP
.B "Restore Size" 
restores from a Zooming session.

.TP
.B "Postscript"
dumps out the plot to a postscript file.  To use this option the
postscript header is required (included).  Place the header file in a
convenient directory and type in at the UNIX prompt:  % setenv PSHEAD
<your-directory>
.sp
NOTE: Most toggle switches also toggle the postscript output file, i.e.
if the names for stations, wells or what ever are turned off/ they will
appear in the postscript output accordingly.  I have added
cross-section postscript file creation. You can create any number of
postscript files as long as you call them by different names. You may
view a postscript file at any time by running pageview from a separate
command window on the file you just created.

.TP
.B "* BLACK/WHITE" 
toggles whether postscript output will be in color or black and white.

.TP
.B "Dump Colors" 
List out the current set of colors.  These may be changed by saving
them in a file and modifying the color palette.

.TP
.B "Plot Targets" 
Toggles the plotting of target regions already selected.
Plotting target regions help remind one of areas that have been considered in detail.

.TP
.B "Erase Targets" 
Starts the target counter over so that previous targets
are lost.

.TP
.B "New Polygon" 
reset the polygon so it has no points.  Polygons can be drawn by using
the meta-Left-mouse clicking action.  (Hold down the meta or
control-key and click with left mouse.   Polygons are currently not
postscriptized, however if you select "Replot Poly" the polygon is
dumped to stdout as lees-format map stroke which can be read in again
and plotted in postscript.


.TP
.B "Spline" 
smooth the last polygon so it does not have sharp corners.  Values are
dumped to screen and can be cut and pasted for later use.

.TP
.B "Replot Poly" 
Replots the last polygon selection

.TP
.B "Replot Target" 
Replots the last target selection 

.TP
.B "Get 3D Body"  
get a wireframe object from a file (see below)

.TP
.B "Plot 3D Body" 
toggle the plotting of the wireframe objects

.TP
.B "Hoz Slab" 
Only WELLS located within the depth range provided are plotted.
This is a useful option for plotting selected layers of
Wells from 3D rasters of vectors

.TP
.B "Spin Events" 
Pops up a new window for spinning earthquake hypocenters that are
selected in a target.  


---------------------------------------------------------------
.br
.sp
.SH Misc 

.TP
.B "Create Label" 
Dialogue box for inserting label text.  Use the m-n keys to locate the 
the label and the arrow head.
.sp
AFTER you select label and insert the text and click OK you need to hit
first "m"  then "n"  (the help window says this to remind you, also the
little dialogue box reminds you of this).
.sp
m sets the tail, and n the head, of the arrow.  the label is placed on
the tail.  After you place the tail (the label) you can move the arrow
with successive "n" typings.  However, if you hit "m" you must hit "n"
again to finilize the pointer.


.TP
.B "Reset Label" 
Change the text of the current label

.TP
.B "Save Labels" 
Puts all labels into a file for later use or editting.

.TP
.B "Get Labels" 
Restores labels from a file previously stored by the Save Labels command.


.TP
.B "HELP"
I have added a simple help to remind you of a few things during run time.


.nf
---------------------------------------------------------------
---------------------------------------------------------------
.br
.sp 
.SH  Cross Section Menus
.sp
.br
.sp
.sp
.SH "File"
.TP
.B" Destroy Window"
Delete cross section window
.TP
.B "Refresh"
Refreash the screen (replot).
.TP
.B "Restore"
Restore to original size (unzoom).
.TP
.B "Postscript"
Dump out a postscript file to the file provided.
This fiel may be viewed immediately.
.TP
.B "Save Xsec"
Geographic information regarding the cross section is stored in file
SAVE_one_xsec.  This can then be read in in the Map View
window under the X-secs menu LOAD Xsecs.
When zooming this is very useful for saving intermediate stages.
Note that the SAVE file is over written each time this is called.
.TP
.B "Quit"
Quit Xmap8
.br
.SH  Special
.br
.sp
.TP
.B "Dip" 
Change dip for this cross section
.TP
.B "Depth" 
Change max depth for cross section
.TP
.B "STA-EL" 
Toggles where the stations are plotted At:
.sp
A) zero elevation (datum)
.sp
B) true elevation (above/below sealevel)
.sp
C) true elevation with mean elevation removed.
.TP
.B "Label"
See label plotting above
.TP
.B "Postscript" 
See postscript above
.TP
.B "Apparent Dip"
Change the plotting of dip meter data from absolute to
apparent dip on the borehole. 
.TP
.B "Geology" 
Plot the geological features from filled objects in map view
projected onto the cross section.
.TP
.B "SDR" 
Dump out (stdout) last Focal mechanism selection
(made previously with shift-left dragging) but also
print out the Strike Dip Rake information.
This appears on an extra line below the normal
focal plane information (M-card) with the following 
character flag and
floating point format:
.nf
SDR: DDAZ STRIKE DIP RAKE
.br
.TP
.B "Sel Points" 
Dump out (stdout)all points that fall within the selection box.
This parallels a similar menu item in the Map View.
.br
.TP
.B "Distance" 
Dump out the diagonal distance, Dx and Dz in the selection box.
This can be used to measure distances in the cross section view.
.br
.TP
.B "Polygon" 
See Polygon above
.TP
.B "Re-plot Polygon" 
See re-plot polygon above
.br
.SH  Source
.br
.sp
.TP
.B "SAVE" 
same as in mapview above
.TP
.B "APPEND"
same as in mapview above 
.TP
.B "POLY SRC" 
select events inside a drawn polygon
.TP
.B "SAVE FILE" 
same as in mapview above

.br
.SH  Contour Field
.br
.sp
.TP
.B "Above"
Cut contour field and plot above the cross section
.TP
.B "In model"
Cut contour field and plot in depth within the cross section.
This option only makes sense if the contoured field has the same
units as the hypocenter depths.
.TP
.B "Image"
This function is still in development
.TP
.B "Dump"
This function dumps out the cross section field line to the screen.


 


Above


.nf
---------------------------------------------------------------
.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
 WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.


.br

