.TH xm_origin l "5 March 1995"
.SH NAME
xm_origin - Origin File format for the xmap8 program 
.SH SYNOPSIS
\fBxm_origin\fP - Input File Format
.SH DESCRIPTION
.sp
The origin file is required for starting xmap8.
It describes the layout and geometry of the intended 
study area.  It also describes the map projection used.
There are two styles of origin: terse and verbose.
.sp
.SH FORMAT
.sp
.nf

Terse Origin File:

This is a simple 3 line file that 
contains the origin and a few other 
important matters concerning the scale of the plot.
Example:	

0 1 52 52 10 2.0
33.0 47.0 0.0
-117.0 10.0 0.



The first integer numbers refer to the kind of origin file being read.
0,1 = standard (tomography) style, i.e an origin Lat-Lon pair and
 then number of x,y blocks (in KM)  to the east and 
to the north of the origin.  The origin is always the lower
   left-hand corner (South-West) of the map.

2 indicates a LAT_LON origin,  i.e. the second and third lines consist of 
   Lat-Lon pairs that define the boundaries of the map instead of the origin.
  (e.g. minlat maxlat  
        minlon maxlon )

The second integer indicates the kind of Map Projection.

0,1 the old version, ellipsoidal projection good for local coordinates.
2 = Albers Equal Area (spheroidal) projection
3 =  Mercator Projection
4 = Miller Projection
5 = No Projection
6 = UTM-spherical
7 = UTM-ellipsoidal
8 = centered UTM spherical
9 = centered UTM ellipsoidal


Grid definition:
The third (52, in this case) and forth refer to the number of 'blocks'
(grid divisions) in the x and y- directions respectively. 
The 5-th number is the number
of 'blocks' in the z-direction (for use on 3D models)  Use this to
pre-set the MaxDepth parameter.  The 6-th number is the number of km
per block in the x direction. If a 7-th parameter is provided it is the
dy, km/block on the y direction.  (So if you like to have everything in
km use 1.0)


NEW (Verbose style)
A more verbose but user friendly method of origin file is now available:
lines that start with '#' are comments lines.
E.G.:
---------------
# new origin style input file:
# file must start with a non-integer alpha character
# order of cards is not important and spaces are allowed
# between name = value
type=0
proj=0
nx=30
ny=50
nz=10
dx=5.0
dy=5.0
lat=46.4  0.0  0.0
lon=-123.0  25.0  0.0
# note lon is positive east!
#     so longitudes in the western hemisphere should be negative
#       (minutes and seconds are always positive!)
# also, you do not need minutes and second if have you only decimal degs
# note also that comments are allowed starting with '#'
# and a new parameter 'dy' is included for more flexability
#  proj=0  lees ellipsoidal projection
#  proj=1  lees ellipsoidal projection
#  proj=2  albers equal area
#  proj=3  mercator
#  proj=4  miller
#  proj=5  no projection
#  proj=6  UTM-spherical
#  proj=7  UTM-ellipsoidal
#  proj=8  centered UTM spherical
#  proj=9  centered UTM ellipsoidal
---------------

Examples:
-----------------------------------
Albers Equal Area Map of California:
1 2 60 64 25 18
32.0 15.0 0.0
-125.0 0.0 0.0
----------------------------------
Washington State:
1 2 640 500 10  1.0
45.0  0.0  0.0
-125.0  0.0  0.0
---------------------------------
Japan (this is a lat-lon style origin):
2 2 70 64 1 60
29.088596 46.766563
90.627243   90.981079
--------------------------------
Southern Califonia:
0 0 64 44 1 5.000000
33.000000 43.000000 37.822266
-119.000000 12.000000 45.197754
-----------------------------------



.br
.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Have, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
 
see article by J. M. Lees
.br

