.TH xm_raster l "5 March 1995"
.SH NAME
xm_raster - Raster format for the xmap8 program 
.SH SYNOPSIS
\fBxm_raster\fP - Input File Format
.SH DESCRIPTION
.sp
The raster file is a 2D or 3D raster image file.  There
are several formats available for input.
.sp
.SH FORMAT
.sp
.nf

Image Data may be imported into Xmap8 via either simple ascii files
(format below)  or through binary files created by the netCDF programs
available from NCAR (UCAR).  Documentation for the netCDF formats and
software is available over the internet.

The importing of files through netCDF must follow the output og the GMT
program, also available over the internet.  I have installed it this
way so that images created with GMT can be imported into Xmap8 with no
other processing.  GMT files are generally 2D images so the third
dimension in that case is artificially manufactured on the fly.


The 3D netCDF files can be easily created by extending the GMT format.
Here we simply add a few more variables and attributes so that we
conform with the ascii files written below.


---------------------------------------------------------------
Ascii image input:
The ascii image files are simple.
you must have the following lines:
2 lines to describe the model followed by a long list of data values:

lat lon nx ny nz spac-X  spac-Y
z1 z2 z3 z4 .....(nz+1) values
data1
data2
data3
.
.
.
.


Lat-Lon are respectively the latitude and longitude of the lower left
corner of the model.  All other points are referenced relative to this
point.  The spacing in x-y is considered constant, given in km.  The Z
spacng is variable and is provided by the array of values on the line
that follows.  There must be nz+1 values since these describe the
thickness of the layers.  Following these 2 header lines is a long list
of numbers which represent the images.  The images are arranged
starting from the top most layer down going from left to right across
the array and northward, i.e. Surface-to-Depth (slowest changing
dimension), South-to-North, West-to-East (fastest changing dimension).

Looking down on a map of the image:

--------------------------------------------------------------------

(Ny-1)*Nx+1		...		...		Ny*Nx
.
.
.
.
...
2Nx+1	2Nx+2	...	...	...			2Nx+Nx
Nx+1	Nx+2						Nx+Nx
1	2	3	4	5	....etc		Nx

--------------------------------------------------------------------
If you  have a 2D image that does not have a "thickness" (like topography) 
then just make one up, e.g.:
32.444 -116.43434  25 32 1 0.5 0.5
0.0 0.3
22
343
333
etc....

---------------------------------------------------------------
---------------------------------------------------------------

netCDF format:

To get a netCDF file one first creates a simple file description in a
language called CDL.  and example of a CDL file for the creation of  a
3D image suitable for Xmap is given below.  By copying this format and
running the utility ncgen  -o    file.cdf    file.cdl from the netcdf
distribution one can create 3D rasters and store them in a binary
format that is a bit more compact than the ascii format described
above.
  
See the netCDF and CDL documentation for more information.

---------------------------------------------------------------
example of a cdl file which will create a cdf file suitable for reading
into Xmap.  (The full data set has been truncated).  The data is stored
according to the format given above, Surface-to-Depth, South-to-North,
West-to-East).
  
netcdf Puget { 

dimensions:
	side = 2 ;
	side3 = 3 ;
        Ntops = 11;
	xysize = 1500 ;
        xyzsize = 15000 ;
variables:
        int ndims;
        double latlon(side);
	double x_range(side) ;
		x_range:units = "km" ;
	double y_range(side) ;
		y_range:units = "km" ;
	double D_range(side) ;
		D_range:units = "km" ;

	double z_range(side) ;
		z_range:units = "Sec/Km" ;
	double spacing(side) ;
	int  dimension(side3) ;
	float z(xyzsize) ;
		z:long_name = "slowness" ;
		z:scale_factor = 1. ;
		z:add_offset = 0. ;
		z:node_offset = 0 ;
		z:missing_value = 1000.0;
         float tops(Ntops);

// global attributes:
		:title = "Puget Sound Inversion 1990" ;
		:source = "Lees & Crosson Velocity inversion 1990" ;

data:

  ndims = 3;

 x_range = 0, 150 ;

 y_range = 0, 250 ;

 D_range = 0.0, 41.0 ;

 z_range = -12, 12 ;

 spacing = 5, 5 ;

 dimension = 30, 50, 10 ;

latlon =  46.4000015, -123.4166641 ;  

tops =    
 0.000,  2.000 , 4.000 , 6.000,  9.000, 12.000, 16.000 ,20.000, 25.000 ,32.000,  41.000;  
  
z =  
 1000.000000 , 
 1000.000000 , 
 1000.000000 , 
    1.123851 , 
    1.021553 , 
    0.826462 , 
 1000.000000 , 
 1000.000000 ,

....etc...... 

 1000.000000 , 
 1000.000000 , 
 1000.000000 , 
 1000.000000 , 
 1000.000000 , 
   -1.769204 , 
   -3.513751 , 
   -3.428546 , 
   -2.937757 , 
   -2.315268 , 
 1000.000000 , 
 1000.000000 , 
 1000.000000 , 
 1000.000000 , 
 1000.000000 ; 
}





.br
.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
 WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.

.br

