.TH xm_station l "5 March 1995"
.SH NAME
xm_station - Station format for the xmap8 program 
.SH SYNOPSIS
\fBxm_station\fP - Input File Format
.SH DESCRIPTION
.sp
There are 4 different station file formats
allowable in xmap8.  Files are checked prior
to importation, so the formats must be adhered
to strictly.
.sp
You can get point files loaded
by using the -R station_file option.
.br
.sp
If you use the -r station_file symbol  each station
file will be plotted with corresponding symbol.
.br
.sp
.SH FORMAT
.sp
.nf
STATION file is organized on the UW format (university of Washington)

Can have Several Station Files input. Use: -R file1 -R file2.....
(R = Receiver)

The default station format (the one I use for most of my work) is:
Example:
Name  lat.       long.      elevation(km)
0...|....1....|....2....|....3....|....4....|..   (Card Column)
S1V  36N00.7852 117W48.1522 1.197 
S1N  36N00.7852 117W48.1522 1.197 
S1E  36N00.7852 117W48.1522 1.197 
S2V  36N02.0210 117W47.3002 1.224 

However, the program can read station files in 3 other formats:
These must be very RIGIDLY FORMATTED if xmap8 is to properly distinguish them.
Xmap8 needs to see the fields in the correct card columns
so that it determine the incoming format.
Else all hell breaks loose.
This is done so the user does not have to specify
a format in advance, but the convention
must be adhered to ridgidly!

NOTE:
You must insert an elevation.  Use 0 if you do not have one.

Example follow:

==> My format: sta.hel <==
0...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
AAB  48N44.2020 121W48.6720  0.000
ALB  49N16.3078 124W49.6618  0.026

==> UW malone.sta <==
0...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
AAB   48 44 12.12  121 48 40.32   0.000
ALB   49 16 18.47  124 49 39.71   0.020

==> usn2.sta <==
0...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
AAB    48.7367 -121.8112      0
ALB    49.2718 -124.8277     20

==> usn1.sta <==
0...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
AAB    48.7367N 121.8112W     0
ALB    49.2718N 124.8277W    20

symbols for stations:

0 = draw_triang = upside down triangle
1 = draw_triang_2 = right side up triangle
2 = draw_square = square
3 = draw_star_david = star of david
4 = draw_ex  =   X mark
5 = draw_Plus =  + mark
6 = draw_Diamond = diamond



.br
.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
WWW:    http://love.geology.yale.edu/~lees
 
see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.

.br

