.TH xm_well l "5 March 1995"
.SH NAME
xm_well - Well format for the xmap8 program 
.SH SYNOPSIS
\fBxm_well\fP - Input File Format
.SH DESCRIPTION
.pp
Wells are simple lists of 3D lines in space.
Actually "well" is a misnomer: you can plot any
3D line using this option of xmap8.  I use this to plot
3D vectors.
There is an extended format that allows you
to also plot lithology and dip alon the well.

.nf
Format:
id = well ident
#  = number of points in well
style = 0,1,2,3   see below  default is 0 for simple well.
color = color for plotting (1-20)
lat = degrees
lon = degrees positive east
depth = km, positive downward


id    #  flag  color
lat lon  depth
 .
 .
 .


example:

32-20 68 0 11
36.011303 -117.792274 -0.087500
36.011303 -117.792267 -0.027500
36.011303 -117.792259 0.052500
36.011295 -117.792259 0.082500
36.011292 -117.792259 0.132500
36.011292 -117.792259 0.162500
 .
 .
 .etc....


Here is the extended format for the wells:
lat lon  depth dip strike length lithology
For example:

23-17 107 3 2
36.022938 -117.795868 -0.127500 45.000000 20.000000 0.200000 2
36.022938 -117.795868 -0.087500 45.000000 20.000000 0.200000 2
36.022942 -117.795860 -0.037500 45.000000 20.000000 0.200000 2
36.022942 -117.795868 -0.017500 45.000000 20.000000 0.200000 2
36.022942 -117.795868 0.002500 45.000000 20.000000 0.200000 2
36.022942 -117.795876 0.052500 45.000000 20.000000 0.200000 2
36.022942 -117.795883 0.082500 45.000000 40.000000 0.200000 4

 LAT      LON       Z         AZIM (deg) DIP     Length  Lithology

the first line includes:
name #_of_points style color

where,
name= 8 character identifier
#_of_points = total number of points for that well
              You may have numerous wells per file
style =  0 = simple well (lat lon z)
         1 = well with lithology (lat lon z lith)
         2 = well with dip meter only (lat lon z strike dip length)
         3 = well with dip and lith (lat lon z strike dip length lith)
color = one of the 28 available colors from the palette.

There are thus 4 styles one can use to insert well information at this point.  
I may expand this at a later date to include well log information plotted as a 
time series along the well.

  ----------------  3D   ARROWS     ------------------

I have written a program to convert focal mechanism P-axes into little
3D arrows - which I then rotate using spin.

All you have to do is make a "well" file which has the
lat-lon-depth of the positions you want plotted
as vectors.  Here is an example arrow plotting a P-axis direction
in Western Washington: (there are 3 "wells" here)


paxis 5 0 5
47.186123 -122.539413 3.900000
47.172630 -122.550819 2.900000
47.179489 -122.543701 3.437500
47.180271 -122.545677 3.437500
47.172630 -122.550819 2.900000
paxis 5 0 6
47.186123 -122.486626 5.200000
47.172630 -122.475220 4.200000
47.180271 -122.480354 4.737500
47.179489 -122.482338 4.737500
47.172630 -122.475220 4.200000
paxis 5 0 7
47.217281 -122.460205 6.500000
47.217281 -122.437340 5.500000
47.218060 -122.449631 6.037500
47.216503 -122.449631 6.037500
47.217281 -122.437340 5.500000


The arrows consist of 5 points in this order: 
(tail, head, UP_point, DN_point, head)


                          UP
                           \\
                            \\
Tail-------------------------Head
                            /
                           /
                         DN

The points must be inthe correct order to plot so it looks like
an arrow.  You could make a simpler plot with just 2 lines
or even just one line if you are not concerned with
directionality.

I create these arrows by first drawing them in 2D and then
rotating them and translating them to their correct 
position and orientation.  (that is the programming you may have to do.
you can modify my program for plotting P-axes if you like)


When running xmap8 you will see a well symbol plotted 
at the location of the first element in the well (the Tail)
if you select "Project Wells" you will see the horizontal projections.
When you make cross sections you will see the wells in 3D.
Wells can be imported into the spin module, but
if you have a ton of them, spnnning will be slow, of course.
The spin module allows you to plot the wells in any 3D view angle.










.br

.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
WWW:    http://love.geology.yale.edu/~lees
 
see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.


.br

