.TH xm_wire l "5 March 1995"
.SH NAME
xm_wire - Well format for the xmap8 program 
.SH SYNOPSIS
\fBxm_wire\fP - Input File Format
.SH DESCRIPTION
.sp
This is the format for wireframe structures in xmap8.
Wire frame structures are 3D objects made up of
polygonal faces.  The faces must be planar, but they can
contain more than 3 points each.
A wire from object is a set of these planar features.
Defined in this fashion, they do not have to share sides:
an object may consist of numerous polygons distributed
in space.  This format is redundant, but it allows for objects
like torn faults (not-connected) and other nice geological goodies.
.br
.sp
The format comprises a list of faces: each face may have
any number (>3) nodes, and each face has its own color.
.br
.SH Format:
.sp
Format for wire-frame objects:
You can have up to 10 files.  Each file can have
unlimited number of polygons.
Each file starts with an alpha-numeric 50 character name
followed by the number of polygons included in file.
Each polygon starts with the integer number of
verticies  (must be > 3) and an integer color index
(associated to the color map described in manual)
Following this are the 3-vector index loci:
Lat Lon Depth
(Lon is always positive east, depth is always positive down)
.br
.sp
Polygons must be planar: weird results will result
if this convention is not followed.
The polygons do not have to touch or be contiguous.
This means there is some redundancy (duplicate verticies)
but provides extra flexability.  For example, you can 
have a torn fault described by two rectangular, non-touching, planes.
.br
.sp
The following example file includes a
a west dipping rectangular fault surface (white)
and a south-west dipping triangular fault (red).
Input Example (Joshua-Tree/Landers region):
.sp
.sp
.nf
Prototype:
name number_of faces
NUmber_of vertices Color
lat lon depth
...etc





E.G.:


JT-Land 2
4 1 
  34.237736 -116.475243 1.0 
  34.050205 -116.475243 1.0
  34.050205 -116.585548 12.0
  34.237736 -116.586678 12.0
3  2
  34.380188 -116.839554 0.0
  34.271999 -116.668556 0.0
  34.201675 -116.890617 10.0
.br

.SH SEE ALSO
 xmap8 xm_well xm_wire xm_map xm_station xm_hypo xm_points
  xm_origin xm_raster xm_color xm_menu
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
 WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.


.br

