.TH xm_points l "5 March 1995"
.SH NAME
xm_xsec - cross section format for the xmap8 program 
.SH SYNOPSIS
\fBxm_xsec\fP - Input File Format
.SH DESCRIPTION
.sp
For providing XMap8 with a description of a set of cross sections.
.sp
You can get xsec files loaded
by using the -X xsec_file option
.br
.sp
.SH FORMAT
.sp
.nf
Files are free format with this input:
lat1 lon1 lat2 lon2 dip min_depth max_depth front back

where,
lat1,lat2  = latitude, positive north
lon1, lon2 = longitude, positive east

point 1 (lat1,lon1) is the start of the cross section.
dip is measured in degrees from vertical
min_depth = starting depth of cross section
max_depth = bottom depth of cross section

front = width of swath (km) to the right of cross section if you are 
        located at point 1 facing point 2.
back  = width of swath (km) to the left of cross section if you are 
        located at point 1 facing point 2.

(the swaths can have different front and back.  This is mainly useful
for dipping cross sections)

         



Example file:

47.111675 -123.488739 46.294132 -121.185463 0.000000 0.000000 30.000000 8.541667 8.541667
45.976196 -122.987541 47.157093 -121.600945 0.000000 0.000000 30.000000 8.541667 8.541667
-----------------------------------------------------------------------------------------
lat1         lon1        lat2       lon2    dip      min_depth max_depth   front   back


.br
.SH SEE ALSO
xmap8 xm_color xm_hypo xm_map xm_menu xm_origin xm_points 
xm_raster xm_station xm_well
xm_wire xm_xsec

.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.
.br

