.TH XMAP8 l "5 March 1995"
.SH NAME
xmap8 \- general 3D GIS software for geophysical/geological applications 
.SH SYNOPSIS
\fBxmap8\fP \fIorigin_file\fP  \fIstation_file\fP \fIevent_file\fP [ \fB\-options\fP ]
.SH DESCRIPTION
.sp
Xmap8 is an all purpose, three-dimensional, GIS mapping and data
exploration tool.  An origin file is required at start-up, but
station and earthquake files are optional, i.e. they can be entered as
"null".  Several ENV variables must be set properly for Postscript
output to be created properly.

.nf
The program can read in several different 3D objects:

sources - earthquakes, points, whatever
stations 
maps - geologic, gmt
wells - lines, 3D vectors, deviated boreholes with lithology and dip
points - labeled points with color and size information
wireframe objects -  3D structures
2D and 3D raster files 
irregularly spaced data fields, which can be gridded and contoured
predetermined cross sections
.br

.nf
Spin Module - Allows users to rotate objects in 3D (postscript available)
.br

.nf
Time Module - Allows users to see events plotted in time sequences
.br


.br

.SH OPTIONS
.nf
.sp
-G x y width height
.sp
-B 0=color 1=b/w
.sp
-D maximum depth for x-sects
.sp
-Z maximum depth for x-sects
.sp
-z minimum depth for x-sects
.sp
-w width for x-sects
.sp
-F filename of A-M cards for focal mechanisms (MANY)
.sp
-W filename of well lat-lon-depth (MANY)
.sp
-S filename of A-cards (MANY)
.sp
-R Receiver_filename       Station (Reciever)  (MANY)
.sp
-r Receiver_filename  symbol     Station (Reciever)  (MANY)
.sp
-M filename of geologic map  (MANY)
.sp
-m filename code of geologic map  (MANY)
.sp
-Y Wire_Frame_file  (MANY)
.sp
-E Ellipse_file  (MANY)
.sp
-C Contour_file
.sp
-I Image_file
.sp
-p Points_file  (MANY)
.sp
-T title
.sp
-X filename of cross sections
.sp
-force_source  force all hypocenters to be included (no spatial selection)
.sp 


.SH ENV VARIABLES
.nf
Several ENV variable should be set to make full use of xmap8.
These are not required to run the program, however some features
will not work without these settings.  $PWD = means present working directory,
(which should be changed to a permanent location).
Once the location of xmap8 is established, it is recommended that these
settings be inserted into the .cshrc file so they do not have
to be set for each login session.
.sp
#  postscript header file directory
.sp
setenv PSHEAD	$PWD
.sp
#   default origin file for maps
.sp
setenv XMA_ORG_FILE $PWD/org.jt1
#   default hypocenter cards for maps (in UW acard format)
.sp
setenv XMA_AC_FILE	$PWD/used.ac
.sp
# default station location file for maps
.sp
setenv XMA_STA_FILE	$PWD/sta.uw
.sp
# default 1D velocity model
.sp
setenv XMA_VEL_FILE	$PWD/nps1d.vel
.sp
#  file for saving and retreiving events (must have READ/WRITE access)
.sp
setenv XMA_SPE_SRC	$HOME/special.src
.sp
#   directory where events and other stuff gets dumped
.sp
setenv DUMPING_GROUND   $PWD
.sp
# file where default map lies
.sp
setenv XMA_THEMAP $PWD
#
#   (gmt) latlon flag for map files.  Set to 1 forces
#   reading of gmt files as LON-LAT rather than LAT-LON
.sp
setenv XMA_LONLAT 0
.sp
setenv XAPPLRESDIR $PWD
.br
.sp
---------------------------------
Example settings for lees at Yale:
---------------------------------
XMA_AC_FILE=/home/lees/inge/Hel/ring.ac
XMA_ORG_FILE=/home/lees/inge/Hel/org.ring
XMA_SPE_SRC=/home/lees/special.src
XMA_STA_FILE=/home/lees/inge/Hel/sta.uw
XMA_VEL_FILE=/home/lees/Loc/Joshua/JTdata/nps1d.vel
XMA_THEMAP=/home/lees/inge/Pug/ndal.lees
XMA_LONLAT=0
.br



.SH KEY ACCELORATORS
.nf
.sp
q - quit
.sp
w - toggles into 'photo mode' suitable for photographing the screen
.sp
p - gives info on the point where the cursor is located
.sp
o - gives info on the point where the cursor is located in X-sections
.sp
e - explode focal-mechanisms
.sp
r - plot focal mechanisms as strike and dip vectors
.sp
t - plot focal mechanisms as P-T axes
.sp
a - Animate the source sequence, leaving all events on.
.sp
z - animate the source sequence forcing disappearance of old events
.sp
f - select a focal mechanism for moving in explode mode
.sp
g - final position of selected focal mechanism
.sp
c - toggle the style of focal mechanism plotting
.sp
v - switch the focal and auxiliary planes of the selected focal mechanism
.sp
m - position start of label (this is the tail where the label resides)
.sp
n - final position of arrow for label (head of the arrow)
.sp
F1 - restore figure from a ZOOM
.sp
F3 - Descend into earth
.sp
F4 - Ascend up from depths
.sp

s - plot events stored in a file accessed via the environmental variable XMA_SPE_SRC

.br
.SH SEE ALSO
xmap8 xm_color xm_hypo xm_map xm_menu xm_origin xm_points 
xm_raster xm_station xm_well
xm_wire xm_xsec xm_ellipse
.SH REFERENCES
.br
.nf
Jonathan M. Lees 
Yale University, Dept. Geology and Geophysics 
P.O. Box 208109, New Haven, CT, 06520-8109 
Voice: (203) 432-6947    FAX (203) 432-3134 
email:  lees@lamb.geology.yale.edu 
WWW:    http://love.geology.yale.edu/~lees

see article by J. M. Lees:

Lees, J. M. (1995). Xmap8: Three-dimensional GIS for geology and geophysics: 
Seismological Research Letters: 66, 33-37.
.br

