
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* --- local headers --- */

#include "geotouch.h"
#include "user2pix.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jml.h"
#include "jutil.h"

/* --- macros --- */

#define DEG2RAD		0.017453293
#define RAD2DEG		57.295778667
#define NUM_SEL		50

/* --- typedefs --- */

typedef struct
  {
  double min, max;
  double ave, adev, sdev, var, skew, curt;
  double med, quartileu, octileu;
  double quartilel, octilel;
  } hstat;

/* --- global variables --- */

extern int screenx, screeny;

/* --- function prototypes --- */

float *alloc_fvec(long first, long last);
int *alloc_ivec(long first, long last);
double *alloc_dvec(long first, long last);
void free_dvec(double *a, long first, long last);
void free_fvec(float *a, long first, long last);
void free_ivec(int *a, long first, long last);
void XYZ_2_TP(float *v, float *t, float *p);
void get_stats(float *vec, int n, hstat *o);
void get_dstats(double *vec, int n, hstat *o);
int Num_Lines(char *source_file);
void csorta(float *bufin, int *ibufdx, float *bufout, int n);
void create_Acard(ac_rec *ac, char *acrd);
void tojul(int year, int month, int day, int *jul);
void fromjul(int yy, int *mm, int *dd, int jul);
void getmoday(int iyear, int jul, int *imo, int *iday);
void send_repaint(Widget wij, int x, int y, int w, int h);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
bool_t readac(FILE *f, ac_rec *a);
void draw_Xmark(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void jLUdecomp(float **a, int n, int *indx, float *d);
void jLUback(float **a, int n, int *indx, float b[]);

/* --- functions --- */

void backjul(int ayear, double dtime, int inine, int *jyear, int *month, int *day,
	     int *hour, int *minute, float *second)
  {
  int ii, ny, item, iyear, ijul;
  double ri;

  ii = (int)dtime;
  ri = dtime - ii;
  *hour = (int)(ri * 24);
  *minute = (int)((ri * 24 - (float)*hour) * 60.0);
  *second = ((ri * 24.0 * 60.0 - (float)*hour * 60.0
	      - (float)*minute) * 60.0);

  /* this is an approximation, maybe I can do better?  */

  ny = (int)ii / 365;
  iyear = ayear + ny;
  tojul(iyear, 1, 1, &item);
  ijul = ii - item + inine + 1;
  getmoday(iyear, ijul, month, day);
  *jyear = iyear - 1900;
  /* printf("%d %d %d %d %d\n", iyear, month, day, hour, minute ); */
  }

/*************************************************************/

void plot_SchmidtNet(mpic *mplot, float *trend, float *plunge, int *col, int num)
  {
  Display *disp;	
  Window wind;	
  GC ggc;	
  JGRAPH ngr;
  int ix, iy, hsize, circle = 23040, col_fillbox = 18, col_perim = 1,
    col_fillsphere = 25, col_perimsphere = 22, col_lines = 24,
    xstamp_pos, ystamp_pos, xstamp_width,
    ystamp_width, k, i, kx, ky, psize = 4;
  float tminx, tmaxx, tminy, tmaxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, ax, ay;
  double xi, tq, focrad = 0.5, minx = 0.0, maxx = 1.0, miny = 0.0, maxy = 1.0;
  Dimension width,height;

  wind = XtWindow(mplot->wij);
  disp = XtDisplay(mplot->wij);
  ggc = mplot->ggc;

  /*  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
      XtNheight, &height, NULL);

      fprintf(stderr, "ScreenX=%d ScreenY=%d\n", mplot->ScreenX, mplot->ScreenY);
      fprintf(stderr, "width=%d height=%d\n", width, height); */

  width = mplot->ScreenX;
  height = mplot->ScreenY;
  xstamp_pos = 4;
  ystamp_pos = (((float)height * 3.0) / 4.0);
  ystamp_width = (height - ystamp_pos) - 10;
  ystamp_pos -= 50;
  xstamp_width = ystamp_width;

  /* fprintf(stderr, "xpos=%d ypos=%d xwidth=%d  ywidth=%d\n", xstamp_pos,
     ystamp_pos,xstamp_width,ystamp_width); */

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_fillbox)]);
  XFillRectangle(disp, wind, ggc, xstamp_pos - 1, ystamp_pos - 1,
		 xstamp_width + 2, ystamp_width + 2);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_perim)]);
  XDrawRectangle(disp, wind, ggc, xstamp_pos - 1, ystamp_pos - 1,
		 xstamp_width + 2, ystamp_width + 2);

  window(&ngr, minx, maxx, miny,  maxy);
  viewport(&ngr, xstamp_pos, xstamp_pos + xstamp_width,
	   ystamp_pos + ystamp_width, ystamp_pos);
  hsize = ystamp_width;
  ix = user_to_pix_x(&ngr, (double)0.0);
  iy = user_to_pix_y(&ngr, (double)0.0);

  /* fprintf(stderr,"circle: ix=%d  iy=%d\n", ix, iy); */

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_fillsphere)]);
  XFillArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_perimsphere)]);
  XDrawArc(disp, wind, ggc, ix, iy, hsize, hsize, 0, circle);

  XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col_lines)]);
  XDrawLine(disp, wind, ggc, user_to_pix_x(&ngr, (double)0.0),
	    user_to_pix_y(&ngr, (double)0.5), user_to_pix_x(&ngr, (double)1.0), 
	    user_to_pix_y(&ngr, (double)0.5));
  XDrawLine(disp, wind, ggc, user_to_pix_x(&ngr, (double)0.5), 
	    user_to_pix_y(&ngr, (double)0.0), user_to_pix_x(&ngr, (double)0.5), 
	    user_to_pix_y(&ngr, (double)1.0));

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    tminx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    tmaxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    }
  else
    {
    tminy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    tmaxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }

  bottom_left_x = (float)tminx;
  bottom_left_y = (float)tminy;
  top_right_x = (float)tmaxx;
  top_right_y = (float)tmaxy;
  k = 0;

  for(i = 0; i < num; i++)
    {
    /* if dip and plunge are in degrees:
       xi = 1.570796327 - 0.0174532*mplot->focm[kount].focs[i].fm.pdip;
       tq = 1.414213562*sin(xi/2.0);
       ax = 0.5 + focrad*tq*sin(0.0174532*mplot->focm[kount].focs[i].fm.prot);
       ay = 0.5 + focrad*tq *cos(0.0174532*mplot->focm[kount].focs[i].fm.prot) ;
       ay = 1-ay; */

    xi = 1.570796327 - plunge[i];
    tq = XMAP_SQRT2 * sin(xi / 2.0);
    ax = 0.5 + focrad * tq * sin(trend[i]);
    ay = 0.5 + focrad * tq * cos(trend[i]);
    ay = 1 - ay;

    kx = user_to_pix_x(&ngr, (double)ax);
    ky = user_to_pix_y(&ngr, (double)ay);
    XSetForeground(disp, ggc, mplot->colors[XmapAppColor(col[i])]);
    draw_Xmark(disp, wind, ggc, kx, ky, psize);
    }
  XFlush(disp);
  }

/*********************************************************************/

void fit_a_plane(float *ex, float *why,  float *zee, int n, float *bvec)
  {
  int i, *indx;
  double sx = 0, sy = 0, sx2 = 0, sy2 = 0, sxy = 0, sz = 0, sxz = 0, syz = 0;
  float **amat, *rhs, *mod, d;

  amat = alloc_fmat(1, 3, 1, 3);
  rhs = alloc_fvec(1, 3);
  indx = alloc_ivec(1, 3);
  mod = alloc_fvec(1, 3);

  for(i = 0; i < n; i++)
    {
    sx += ex[i];
    sy += why[i];
    sxy += ex[i] * why[i];
    sx2 += sqr(ex[i]);
    sy2 += sqr(why[i]);
    sz += zee[i];
    sxz += zee[i] * ex[i];
    syz += zee[i] * why[i];
    }

  amat[1][1] = n;
  amat[1][2] = sx;
  amat[1][3] = sy;
  amat[2][1] = amat[1][2];
  amat[2][2] = sx2;
  amat[2][3] = sxy;
  amat[3][1] = amat[1][3];
  amat[3][2] = amat[2][3];
  amat[3][3] = sy2;
  rhs[1] = sz;
  rhs[2] = sxz;
  rhs[3] = syz;

  jLUdecomp(amat, 3, indx, &d);
  jLUback(amat, 3, indx, rhs);

  fprintf(stderr, "b0=%f  b1=%f b2=%f\n", rhs[1], rhs[2], rhs[3]);
  bvec[0] = rhs[1];
  bvec[1] = rhs[2];
  bvec[2] = rhs[3];

  free_fmat(amat, 1, 3, 1, 3);
  free_fvec(rhs, 1, 3);
  free_fvec(mod, 1, 3);
  free_ivec(indx, 1, 3);
  }

/* --------------------------------------------------------- */

void Hypo_Stats(Widget wij, mpic *mplot, char *call_data)
  {
  float fx, fy, bplane[3], xmin, ymin, xmax, ymax, z, phi, lam, **amat, *dis,
    *trend, *plunge, pln, t3, p3,  dip, strike, second;
  int i, j, n, num, Asq1 = 0, Bsq1 = 0, Csq1 = 0, Dsq1 = 0,
    Asq2 = 0, Bsq2 = 0, Csq2 = 0, Dsq2 = 0, *icol, rnum, cnum, inine, yy,
    iy, im, id, ih, mm, dd, hour, minute, ayear, month, day, jyear;
  double *dtimes, cenX, cenY, cenZ, dtime, dt;
  FILE *inf, *plane_file;
  ac_rec accard;
  hstat o;
  char *labs[] =
    { "time", "Lat ", "Lon ", "X   ", "Y   ", "Z   ", "mag ", "nump", "nums",
      "gap ", "delt", "rms ", "err " };

  fprintf(stderr, "Reading from input source file = %s\n", mplot->src_dump_file);
  num = Num_Lines(mplot->src_dump_file);
  rnum = num;
  cnum = 13;
  amat = alloc_fmat(0, cnum, 0, rnum);
  dtimes = alloc_dvec(0, rnum);

  if((inf = fopen(mplot->src_dump_file, "r")) == NULL)
    {
    printf("Can't open special source %s ....try again\n", mplot->src_dump_file);
    return;
    }

  yy = ayear = 1960;
  iy = 1;
  tojul(yy, iy, iy, &inine);
  i = 0;

  while(readac(inf, &accard))
    {
    phi = accard.lat1 + accard.lat2 / 6000.0;
    lam = accard.lon1 + accard.lon2 / 6000.0;
    if(accard.EW[0] == 'W') lam *= -1;
    if(accard.NS[0] == 'S') phi *= -1;

    /*fprintf(stderr, "%f %f \n", phi, lam); */
    geo2xy(mplot, phi, lam, &fx, &fy);
 

    sscanf(accard.id, "%2d%2d%2d%2d%2d", &iy, &im, &id, &ih, &mm);
    yy = 1900 + iy;
    tojul(yy, im, id, &dd);
    dd -= inine;
    /* printf("%d %d %d %d %d %d %d\n",iy,im,id,ih,mm,dd,yy); */
    dtime = (dd + (float)ih / 24.0 + (float)mm / (24.0 * 60.0)
	     + accard.sec / (24.0 * 60.0 * 60.0));

    /* backjul(ayear, dtime, inine, &jyear, &month, &day, &hour, &minute,
       &second);
       fprintf(stdout, "%d %d %d %d %d %f  %d %d %d %d %d %f %e\n", iy, im, id,
       ih, mm, accard.sec, jyear, month, day, hour, minute, second, dtime); */

    dtimes[i] = dtime;
    amat[0][i] = dtime;
    amat[1][i] = phi;
    amat[2][i] = lam;
    amat[3][i] = fx;
    amat[4][i] = fy;
    amat[5][i] = accard.depth;
    amat[6][i] = accard.mag;
    amat[7][i] = accard.nump;
    amat[8][i] = accard.nums;
    amat[9][i] = accard.gap;
    amat[10][i] = accard.delta;
    amat[11][i] = accard.rms;
    amat[12][i] = accard.err;
    if(accard.q1[0] == 'A') Asq1++;
    if(accard.q1[0] == 'B') Bsq1++;
    if(accard.q1[0] == 'C') Csq1++;
    if(accard.q1[0] == 'D') Dsq1++;
    if(accard.q2[0] == 'A') Asq2++;
    if(accard.q2[0] == 'B') Bsq2++;
    if(accard.q2[0] == 'C') Csq2++;
    if(accard.q2[0] == 'D') Dsq2++;
    i++;
    }
  fclose(inf);
  n = i;
  fprintf(stdout, "N = %d\n", n);
  if( n <= 0 )
    {
    printf(" There are no records in %s, no stats are calculated....\n", mplot->src_dump_file);
    printf(" Select a target region and then SAVE SOURCE from the Source menu\n");
    return;
    
    }
  
  fprintf(stdout, "	 MINIMUM        MAXIMUM	        MEDIAN		MEAN"
	  " 		AVE-DEV		STDEV\n");
  for(j = 1; j < cnum; j++)
    {
    get_stats(&amat[j][0], n, &o);
    fprintf(stdout, "%4s	%10f	%10f	%10f	%10f	%10f	%10f\n",
	    &labs[j][0], o.min,	o.max, o.med, o.ave, o.adev, o.sdev);

    if(j==3) cenX = o.ave, xmin =  o.min, xmax =  o.max;
    if(j==4) cenY = o.ave, ymin =  o.min, ymax =  o.max;
    if(j==5) cenZ = o.ave;
    }

  fprintf(stdout, "\n");

  get_dstats(dtimes, n, &o);

  fprintf(stdout, "            YY MM DD hh mm ssssss\n");

  dt =  o.min;
  backjul(ayear, dt, inine, &jyear, &month, &day, &hour, &minute, &second);
  /* fprintf(stdout, "min = %e\n", dt); */
  fprintf(stdout, " Min Time = %02d %02d %02d %02d %02d %6.2f\n", jyear,
	  month, day, hour, minute, second);

  dt =  o.max;
  /* fprintf(stdout, "max = %e\n", dt); */
  backjul(ayear, dt, inine, &jyear, &month, &day, &hour, &minute, &second);
  fprintf(stdout, " Max Time = %02d %02d %02d %02d %02d %6.2f\n", jyear,
	  month, day, hour, minute, second);

  dt =  o.ave;
  backjul(ayear, dt, inine, &jyear, &month, &day, &hour, &minute, &second);
  fprintf(stdout, " Ave Time = %02d %02d %02d %02d %02d %6.2f\n", jyear,
	  month, day, hour, minute, second);

  dt =  o.med;
  backjul(ayear, dt,  inine, &jyear, &month, &day, &hour, &minute, &second);
  fprintf(stdout, " Med Time = %02d %02d %02d %02d %02d %6.2f\n", jyear,
	  month, day, hour, minute, second);
  fprintf(stdout, "Average Deviation = %f days ____ Std Dev = %f days \n",
	  o.adev, o.sdev);

  dis = alloc_fvec(0, n);
  trend = alloc_fvec(0, n);
  plunge = alloc_fvec(0, n);
  icol = alloc_ivec(0, n);

  fprintf(stdout, "\n");
  fprintf(stdout, " Quality Factor Q1: A=%d  B=%d C=%d D=%d\n", Asq1, Bsq1, Csq1,
	  Dsq1);
  fprintf(stdout, " Quality Factor Q2: A=%d  B=%d C=%d D=%d\n\n", Asq2, Bsq2,
	  Csq2, Dsq2);

  for(i = 0; i < n; i++)
    {
    dis[i] =  sqrt(sqr(amat[3][i] - cenX) + sqr(amat[4][i] - cenY)
		   + sqr(amat[5][i] - cenZ));
    bplane[0] = amat[3][i] - cenX;
    bplane[1] = amat[4][i] - cenY;
    bplane[2] = amat[5][i] - cenZ;
    XYZ_2_TP(bplane, &t3, &p3);

    /* t3 += XMAP_PI_2; */
    p3 = XMAP_PI_2 - p3;
    pln = p3 ;
    if(pln > XMAP_PI_2)
      {
      pln = XMAP_PI - pln;
      t3 += XMAP_PI;
      }
    dip = pln;
    strike = t3;

    /* h = RAD2DEG*(phi); h2 = RAD2DEG*(t3); */

    /* fprintf(stderr, "strike=%f dip=%f\n", RAD2DEG*strike, RAD2DEG*dip); */

    trend[i] = strike;
    plunge[i] = dip;
    icol[i] = 9;
    if(bplane[2] < 0) icol[i] = 2;
    }

  get_stats(dis, n, &o);

  fprintf(stdout, "*******************Distance from centroid of hypocenters:\n");
  fprintf(stdout, "DIS	%10f	%10f	%10f	%10f	%10f	%10f\n",
	  o.min, o.max, o.med, o.ave, o.adev, o.sdev);
  fprintf(stdout,"\n\n");

  fit_a_plane(&amat[3][0], &amat[4][0], &amat[5][0], n, bplane);

  plane_file = fopen("hypo_plane", "w");
  fprintf(plane_file, "hypo_plane 1\n");
  fprintf(plane_file, "4 1\n");

  z = bplane[0] + bplane[1] * xmin + bplane[2] * ymin;
  xy2geo(mplot, &phi, &lam, xmin, ymin);

  fprintf(plane_file, "%f %f %f\n", phi, lam, z);
  fprintf(stdout, "%f %f %f\n", phi, lam, z);

  z = bplane[0] + bplane[1] * xmin + bplane[2] * ymax;
  xy2geo(mplot, &phi, &lam, xmin, ymax);

  fprintf(plane_file, "%f %f %f\n", phi, lam, z);
  fprintf(stdout, "%f %f %f\n", phi, lam, z);

  z = bplane[0] + bplane[1] * xmax + bplane[2] * ymax;
  xy2geo(mplot, &phi, &lam, xmax, ymax);

  fprintf(plane_file, "%f %f %f\n", phi, lam, z);
  fprintf(stdout, "%f %f %f\n", phi, lam, z);

  z = bplane[0] + bplane[1] * xmax + bplane[2] * ymin;
  xy2geo(mplot, &phi, &lam, xmax, ymin);

  fprintf(plane_file, "%f %f %f\n", phi, lam, z);
  fprintf(stdout, "%f %f %f\n", phi, lam, z);

  fprintf(stdout, "Wire frame plane stored in file: hypo_plane\n");
  fclose(plane_file);

  plot_SchmidtNet(mplot, trend, plunge, icol, n);

  free_fmat(amat, 0, cnum, 0, rnum);
  free_fvec(dis, 0, n);
  free_fvec(trend, 0, n);
  free_fvec(plunge, 0, n);
  free_ivec(icol, 0, n);
  free_dvec(dtimes, 0, rnum);
  }
