
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"

/* --- function prototypes --- */

void image_selection(mpic *mplot);

/* --- functions --- */

void PopupImage(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  /* fprintf(stderr, "in PopupImage\n");
     PrintImageParms(&mplot->imageParms); */

  iokay = CopyToImageWindow(&mplot->imageParms);
  XtPopup(mplot->imageParms.wShell, XtGrabNonexclusive);
  }

void ImageDoit(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;
  
  /* fprintf(stderr, "in ImageSet\n"); */
  iokay = CopyFromImageWindow(&mplot->imageParms);
  /* PrintImageParms(&mplot->imageParms); */
  XtPopdown(mplot->imageParms.wShell);
  image_new_parms(mplot);
  image_selection(mplot);
  }

void ImageSet(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  /* fprintf(stderr,"in ImageSet\n"); */
  iokay = CopyFromImageWindow(&mplot->imageParms);
  /* PrintImageParms(&mplot->imageParms); */
  XtPopdown(mplot->imageParms.wShell);
  }

void ImageDone(Widget w, mpic *mplot, char *call_data)
  {
  /*f printf(stderr,"in ImageDone\n"); */
  /* PrintImageParms(&mplot->imageParms); */
  XtPopdown(mplot->imageParms.wShell);
  }

void make_image_pop(Widget box, mpic *mplot)
  {
  Widget xp, view, top, imageshell;

  top = mplot->shell;
  xp = XtVaCreateManagedWidget("Set Image", smeBSBObjectClass, box, NULL);

  mplot->imageParms.wShell = imageshell =
    XtVaCreatePopupShell("imageWin", transientShellWidgetClass, top, NULL);

  view = XtVaCreateManagedWidget("imageForm", formWidgetClass, imageshell,
				 NULL);

  /* -----------NOTE:  these must be created in the correct order   !  */

  /* Create the various parameter labels and their text boxes. */

  mplot->imageParms.IFile = XtVaCreateManagedWidget("Time_Label",
    labelWidgetClass, view, NULL);

  mplot->imageParms.hIFileEdit = XtVaCreateManagedWidget("IFileEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->imageParms.Iskip = XtVaCreateManagedWidget("Depth_Label",
    labelWidgetClass, view, NULL);

  mplot->imageParms.IskipEdit = XtVaCreateManagedWidget("Depth1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->imageParms.ILayer = XtVaCreateManagedWidget("Mag_Label",
    labelWidgetClass, view, NULL);

  mplot->imageParms.ILayerEdit = XtVaCreateManagedWidget("Mag1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->imageParms.Irange = XtVaCreateManagedWidget("Nums_Label",
    labelWidgetClass, view, NULL);

  mplot->imageParms.Irange1Edit = XtVaCreateManagedWidget("Nums1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->imageParms.Irange2Edit = XtVaCreateManagedWidget("Nums2Edit",
    asciiTextWidgetClass, view, NULL);

  /* Make all of the edit boxes editable. */

  SetWidgetInt(mplot->imageParms.hIFileEdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->imageParms.hTime2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->imageParms.IskipEdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->imageParms.ILayerEdit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->imageParms.hLayerEdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->imageParms.Irange1Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->imageParms.Irange2Edit, XtNeditType, XawtextEdit);

  mplot->imageParms.wUp = XtVaCreateManagedWidget("up",
    commandWidgetClass, view, NULL);

  mplot->imageParms.wDown = XtVaCreateManagedWidget("down",
    commandWidgetClass, view, NULL);

  /* Create the Set and Cancel command buttons. */


  mplot->imageParms.wSet = XtVaCreateManagedWidget("set",
    commandWidgetClass, view, NULL);

  mplot->imageParms.wDoit = XtVaCreateManagedWidget("GoDoit",
    commandWidgetClass, view, NULL);

  mplot->imageParms.wCancel = XtVaCreateManagedWidget("cancel",
    commandWidgetClass, view, NULL);

  /* InitImageParms(&mplot->imageParms); */

  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PopupImage, mplot);

  XtAddCallback(mplot->imageParms.wSet, XtNcallback,
		(XtCallbackProc)ImageSet, mplot);
  XtAddCallback(mplot->imageParms.wDoit, XtNcallback,
		(XtCallbackProc)ImageDoit, mplot);
  XtAddCallback(mplot->imageParms.wCancel, XtNcallback,
		(XtCallbackProc)ImageDone, mplot);
  }
