/* -------------------------------------------------- */
/* CALCULATE THE LAT_LON TICS     */
/***********************************/

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"

/* --- macros --- */

#define DIAG 0

/* --- function prototypes --- */

int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
int geo2xy_2(int type, float phi1, float lam1, float phi, float lam, float *x,
	     float *y);

/* --- functions --- */

float to_deg(int ideg,int  imin,int  isec)
  {
  float frac;
  
    if(ideg<0)
    {
    frac = ideg - imin/60.0 - isec/3600.0;
    }
  
  else
    {
    frac = ideg + imin/60.0 + isec/3600.0;
    }
  
  return(frac);
  }


float refLL(float num, int *ideg, int *imin, int *isec, float *left)
  {

  double frac, nteger;
  double fmin, fsec;
  

  frac = modf(num, &nteger);
  *ideg = (int)nteger;
  
  fmin = fabs(frac)*60.0;
  
  frac = modf(fmin, &nteger);
  
  *imin = (int)nteger;
  
  fsec =  fabs(frac)*60.0;
  

  frac = modf(fsec, &nteger);

  *isec = (int) nteger;
  *left = frac;
  
  frac =   to_deg(*ideg, *imin, *isec);
  
  return(frac);

  }

float smallest_sec( float num, int *ideg, int *imin, int *isec)
  {
  float ka, left;
  int deg, min, sec;
  float frac;
 
  ka = refLL(num, &deg, &min, &sec, &left);

  if(ka<num)
    {
    sec++;
    if(sec>=60)
      {
      min++;
      sec=sec-60;
      }
    
    *ideg = deg;
    *imin = min;
    *isec = sec;
  frac =   to_deg(*ideg, *imin, *isec);

    }
  else
    {
    *ideg = deg;
    *imin = min;
    *isec = sec;
 frac =   to_deg(*ideg, *imin, *isec);

    }
  return(frac);
  
  }

float largest_sec( float num, int *ideg, int *imin, int *isec)
  {
  float ka, left;
  int deg, min, sec;
  float frac;
  
  ka = refLL(num, &deg, &min, &sec, &left);

  if(ka>num)
    {
    if(num>0)sec--;
    else sec++;
      if(sec>=60)
      {
      min++;
      sec=sec-60;
      }
      
    if(sec<0)
      {
      min--;
      sec=60+sec;
      }
    *ideg = deg;
    *imin = min;
    *isec = sec;
 frac =   to_deg(*ideg, *imin, *isec);

    
    }
  else
    {
    *ideg = deg;
    *imin = min;
    *isec = sec;
 frac =   to_deg(*ideg, *imin, *isec);

    }
  return(frac);

  }





void lltic(int type, float phi1, float lam1, float phi2, float lam2,
	   Markup_File *tics)
  {
  float ex, why, p1 = phi1, l1 = lam1, dphi, dlam, p2 = phi2, l2 = lam2, p3,
    dpmin, dlmin, x, q, start, phi, lam, q1, q2;
  int jtot,jloops, m, pinc, deginc, ideg, imin, nlams, nphis, item;
  char pchar[13];

  dphi = fabs(p2 - p1);
  dlam = fabs(l2 - l1);
  dpmin = dphi * 60.0;
  dlmin = dlam * 60.0;
  if(dpmin > dlmin) p3 = dpmin;
  else p3 = dlmin;
  
  if(p3 >= 120.0) pinc = 30;
  if(p3 >= 60.0 && p3 < 120.0) pinc = 15;
  if(p3 < 60.0 && p3 >= 30.0) pinc = 10;
  if(p3 < 30.0 && p3 >= 15.0) pinc = 6;
  if(p3 < 15.0) pinc = 3;
  m = p3 / (float)pinc;

  deginc = 1;
  jtot = nlams = nphis = jloops= 0;

  /*******   LATITUDES  *********/

#if DIAG
  fprintf(stderr,"\n Doing LAT-LON Calculations \n");
  fprintf(stderr,"p1=%f l1=%f p2=%f l2=%f\n", p1,l1, p2, l2);
  fprintf(stderr,"dphi=%f dlam=%f p3=%f m=%d\n", dphi, dlam, p3, m);
#endif

  if (dphi > 3.0)
    {
    if(dphi > 50) deginc = 10;
    if(dphi > 20 && dphi <= 50) deginc = 5;
    if(dphi > 10 && dphi <= 20) deginc = 2;
    if(dphi <= 10) deginc = 1;

    q = phi1;
    start = q;
    x = deginc * (int)(q / deginc);

#if DIAG
    fprintf(stderr, "q=%f x=%f deginc=%d\n", q, x, deginc);
#endif

    while(q < p2)
      {
      if(jtot >= MAX_TICS) break;

      x += deginc;
      ideg = x;
      q = phi = ideg;

      if(q > p1 && q < p2)
	{
	sprintf(pchar, "%d\312", abs(ideg));
	geo2xy_2(type, phi1, lam1, phi, lam1, &ex, &why);

#if DIAG
	fprintf(stderr, "phi1=%f lam1=%f phi=%f lam=%f x=%f y=%f\n", phi1,
		lam1, phi, lam1, ex, why);
	fprintf(stderr, "ideg = %d   imin = %d  pchar = %s \n", ideg, imin,
		pchar);
#endif

	strcpy(tics->stuff[jtot].name, pchar);
	tics->stuff[jtot].code1 = 1;
	tics->stuff[jtot].code2 = 0;
	tics->stuff[jtot].m.x = ex;
	tics->stuff[jtot].m.y = why;
	tics->stuff[jtot].deg = ideg;
	tics->stuff[jtot].min = 0;
	tics->stuff[jtot].ddeg = ideg + ((float)tics->stuff[jtot].min / 60.0);
	jtot++;
	nphis++;
	}
      }
    }
  else
    {
    start = q = phi1;
    x = 0.0;

    while(q < p2)
      {
      if(jtot >= MAX_TICS) break;
      if(x >= 60.0)
	{
	start++;
	x = 0;
	}
      ideg = start;
      imin = x;
      phi = ideg + imin / 60.0;
      ideg = phi;
      if(imin >= 10) sprintf(pchar, "%d\312%2d\302", abs(ideg), imin);
      else sprintf(pchar, "%d\312%02d\302", abs(ideg), imin);
      q = phi;

      /* check again and make the change  */
      if(q > p1 && q < p2)
	{
	geo2xy_2(type, phi1, lam1, phi, lam1, &ex, &why);

#if DIAG
	fprintf(stderr, "phi1=%f lam1=%f phi=%f lam=%f x=%f y=%f\n", phi1,
		lam1, phi, lam1, ex, why);
	fprintf(stderr, "ideg = %d   imin = %d  pchar = %s \n", ideg, imin,
		pchar);
#endif
                                
	strcpy(tics->stuff[jtot].name, pchar);
	tics->stuff[jtot].code1 = 1;
	tics->stuff[jtot].code2 = 0;
	tics->stuff[jtot].m.x = ex;
	tics->stuff[jtot].m.y = why;
	tics->stuff[jtot].deg = ideg;
	tics->stuff[jtot].min = imin;
	tics->stuff[jtot].ddeg = ideg + ((float)tics->stuff[jtot].min / 60.0);

	jtot++;
	nphis++;
	}
      x += pinc;
      }		/* end the while  */
    }

  /*******   LONGITUDES  *********/
#if DIAG
  fprintf(stderr,"\n Doing LONGs \n");
#endif

  if(dlam > 3.0)
    {
    if(dlam > 50) deginc = 10;
    if(dlam > 20 && dlam <= 50) deginc = 5;
    if(dlam > 10 && dlam <= 20) deginc = 2;
    if(dlam <= 10) deginc = 1;

    q = lam1;
    x = deginc * (int)(q / deginc);
#if DIAG
    fprintf(stderr,"x=%f q=%f l2=%f\n", x, q, l2);
#endif
    while(q < l2)
      {
      if(jtot >= MAX_TICS) break;
      x += deginc;
      q = lam = ideg = x;
#if DIAG
  fprintf(stderr,"x=%f q=%f l2=%f\n", x, q, l2);
#endif
      if(q < l2 && q > l1)
	{
	sprintf(pchar, "%d\312", abs(ideg));
	geo2xy_2(type, phi1, lam1, phi1, lam, &ex, &why);

#if DIAG
	fprintf(stderr, "phi1=%f lam1=%f phi=%f lam=%f x=%f y=%f\n", phi1,
		lam1, phi1, lam, ex, why);
	fprintf(stderr, "ideg = %d   imin = %d  pchar = %s \n", ideg, imin,
		pchar);
#endif

	strcpy(tics->stuff[jtot].name, pchar);
	tics->stuff[jtot].code1 = 2;
	tics->stuff[jtot].code2 = 0;
	tics->stuff[jtot].m.x = ex;
	tics->stuff[jtot].m.y = why;
	tics->stuff[jtot].deg = ideg;
	tics->stuff[jtot].min = 0;
	tics->stuff[jtot].ddeg = ideg + ((float)tics->stuff[jtot].min / 60.0);
	jtot++;
	nlams++;
	}
      }
    }
  else
    {
    start = q = l1;

#if DIAG
    x = dlam*60.0;
    ideg = (int)(x/(float)pinc);
    fprintf(stderr, "should need %d minute markers\n", ideg);
    
      fprintf(stderr, "START: q=%f l1=%f  l2=%f \n",
	      q, l1, l2);
#endif
    q1 = l1*60.0;
    q2 = l2*60.0;
    item = pinc*(int)(q1/(float)pinc);
    x = item;
#if DIAG    
    fprintf(stderr, "imin=%d q1=%f q2=%f\n", item, q1, q2);
#endif
    while( x>q1 && x<q2)
      {

      x = item;
      q = x/60.0;
      
      ideg = (int)q;
      imin = (int)floor( (60.0*fabs(q - (float)ideg))+0.5   );
      lam = abs(ideg)+abs(imin)/60.0;
      if(q<0.0)lam*=-1.0;
      
#if DIAG     
      fprintf(stderr,"x=%f q=%f lam=%f ideg=%d imin=%d\n", x, q,lam,  ideg, imin);
#endif

      if((lam>l1)&& (lam<l2) )
	{
	

	geo2xy_2(type, phi1, lam1, phi1, lam, &ex, &why);
      sprintf(pchar, "%d\312%02d\302", abs(ideg), imin);

#if DIAG
	fprintf(stderr, "phi1=%f lam1=%f phi=%f lam=%f x=%f y=%f\n", phi1,
		lam1, phi1, lam, ex, why);
	fprintf(stderr, "ideg = %d   imin = %d  pchar = %s \n", ideg, imin,
		pchar);
#endif

	strcpy(tics->stuff[jtot].name, pchar);
	tics->stuff[jtot].code1 = 2;
	tics->stuff[jtot].code2 = 0;
	tics->stuff[jtot].m.x = ex;
	tics->stuff[jtot].m.y = why;
	tics->stuff[jtot].deg = ideg;
	tics->stuff[jtot].min = imin;
	tics->stuff[jtot].ddeg = lam;
	jtot++;
	nlams++;
	}
      
      item+=pinc;   
      }
    
   
    }
  

  if(nphis < 1)
    {
    phi = (phi2 + phi1) / 2.0;
    sprintf(pchar, "%f", phi);
    geo2xy_2(type, phi1, lam1, phi, lam1, &ex, &why);

#if DIAG
    fprintf(stderr, "nphis<1 lltic phi: %f %f %f %f %f %f\n", phi1, lam1,
	    phi, lam1, ex, why);
#endif

    strcpy(tics->stuff[jtot].name, pchar);
    tics->stuff[jtot].code1 = 3;
    tics->stuff[jtot].code2 = 0;
    tics->stuff[jtot].m.x = ex;
    tics->stuff[jtot].m.y = why;
    tics->stuff[jtot].deg = (int)phi;
    tics->stuff[jtot].min = (int)(60.0 * (phi - tics->stuff[jtot].deg));
    tics->stuff[jtot].ddeg = phi;
    jtot++;
    }

  if(nlams < 1)
    {
    lam = (lam2 + lam1) / 2.0;
    sprintf(pchar, "%f", lam);
    geo2xy_2(type, phi1, lam1, phi1, lam, &ex, &why);

#if DIAG
    fprintf(stderr,"nlams<1 lltic lam: %f %f %f %f %f %f\n",  phi1, lam1,
	    phi, lam1, ex, why);
#endif

    strcpy(tics->stuff[jtot].name, pchar);
    tics->stuff[jtot].code1 = 4;
    tics->stuff[jtot].code2 = 0;
    tics->stuff[jtot].m.x = ex;
    tics->stuff[jtot].m.y = why;
    tics->stuff[jtot].deg = (int)lam;
    tics->stuff[jtot].min = (int)(60.0 * (lam - tics->stuff[jtot].deg));
    tics->stuff[jtot].ddeg = lam;
    jtot++;
    }

  tics->numpoints = jtot;

#if DIAG
  fprintf(stderr, "\n lltic tics->numpoints=%d nphis=%d nlams=%d\n",
	  tics->numpoints, nphis, nlams);
#endif

  }
