
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"

/* --- function prototypes --- */

int user_to_pix_x(JGRAPH *gr, double x);
int user_to_pix_y(JGRAPH *gr, double y);
double pix_to_user_x(JGRAPH *gr, int pix_x);
double pix_to_user_y(JGRAPH *gr, int pix_y);
int xy2geo(mpic * mplot, float *phi, float *lam, float x, float y);

void submap8(int argc, char **argv);

/* --- functions --- */

int set_input_args(mpic *mplot, char **nargv)
  {
  int i, n = 0, j, kount = 0;

  n += mplot->num_sta_files;
  n += mplot->max_more_src;
  n += mplot->num_map_files;
  n += mplot->num_wells_files;
  n += mplot->num_focm_files;
  n += mplot->wire_num;
  n += mplot->lip_num;
  n += mplot->point_flag;

  if(mplot->image_flag == 1) n++;

	n +=  n + 2;

  nargv = XmapNewArray(char *, n);

  nargv[0] = "geotouch";
  nargv[1] = "new_org.out";

  i = 2;

  j = strlen(mplot->stations[0].file_name);
  if(j == 0) nargv[i] = "null";
  else
    {
    nargv[i] = XmapNewArray(char, j);
    strcpy(nargv[i], mplot->stations[0].file_name);
    }

  i = 3;
  j = strlen(mplot->sources[0].file_name);
  if(j == 0) nargv[i] = "null";
  else
    {
    nargv[i] = XmapNewArray(char, j);
    strcpy(nargv[i], mplot->sources[0].file_name);
    }

  kount = 4;

  /* stations  */

  if(mplot->num_sta_files > 0)
    {
    for(i = 1; i < mplot->num_sta_files; i++)
      {
      nargv[kount] = "-R";
      kount++;
      j = strlen(mplot->stations[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->stations[i].file_name);
	}
      kount++;
      }
    }

     /* sources  */

  if(mplot->max_more_src > 0)
    {
    for(i = 1; i < mplot->max_more_src; i++)
      {
      nargv[kount] = "-S";
      kount++;
      j = strlen(mplot->sources[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->sources[i].file_name);
	}
      kount++;
      }
    }

  /* maps  */

  if(mplot->num_map_files > 0)
    {
    for(i = 0; i < mplot->num_map_files; i++)
      {
      nargv[kount] = "-M";
      kount++;
      j = strlen(mplot->map[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->map[i].file_name);
	}
      kount++;
      }
    }

  /* wells  */

  if(mplot->num_wells_files > 0)
    {
    for(i = 0; i < mplot->num_wells_files; i++)
      {
      nargv[kount] = "-W";
      kount++;
      j = strlen(mplot->wells[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->wells[i].file_name);
	}
      kount++;
      }
    }

  /* focals  */

  if(mplot->num_focm_files > 0)
    {
    for(i = 0; i < mplot->num_focm_files; i++)
      {
      nargv[kount] = "-F";
      kount++;
      j = strlen(mplot->focm[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->focm[i].file_name);
	}
      kount++;
      }
    }

  /* wire  */

  if(mplot->wire_num > 0)
    {
    for(i = 0; i < mplot->wire_num; i++)
      {
      nargv[kount] = "-Y";
      kount++;
      j = strlen(mplot->wire[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->wire[i].file_name);
	}
      kount++;
      }
    }

  /* ellipses  */

  if(mplot->lip_num > 0)
    {
    for(i = 0; i < mplot->lip_num; i++)
      {
      nargv[kount] = "-E";
      kount++;
      j = strlen(mplot->lip[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->lip[i].file_name);
	}
      kount++;
      }
    }

  /* points  */

  if(mplot->point_flag > 0)
    {
    for(i = 0; i < mplot->point_flag; i++)
      {
      nargv[kount] = "-p";
      kount++;
      j = strlen(mplot->Mpoint[i].file_name);
      if(j == 0) nargv[kount] = "null";
      else
	{
	nargv[kount] = XmapNewArray(char, j);
	strcpy(nargv[kount], mplot->Mpoint[i].file_name);
	}
      kount++;
      }
    }

  if(mplot->image_flag == 1)
    {
    nargv[kount] = "-I";
    kount++;
    j = strlen(mplot->image.file_name);
    if(j == 0) nargv[kount] = "null";
    else
      {
      nargv[kount] = XmapNewArray(char, j);
      strcpy(nargv[kount], mplot->image.file_name);
      }
    kount++;
    }

  fprintf(stderr, "New Command Line Arguments:\n\n");
  for(i = 0; i < kount; i++) fprintf(stderr, "%s ", nargv[i]);
  fprintf(stderr, "\n\n");

  submap8(kount, nargv);

  return(kount);
  }

/********************************/

void new_org(Widget wij, mpic *mplot, char *call_data)
  {
  int nargc, newx, newy, i;
  char **nargv;
  FILE *inf;
  float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, temspacx, temspacy, xkm, ykm, phi, lam;

  fprintf(stderr, "***********NEW ORG****************\n");
  
  fprintf(stderr, "start: %d %d spot: %d %d\n",
	  mplot->picsource_org.x,mplot->picsource_org.y,
mplot->picsource_spot.x ,mplot->picsource_spot.y );

    if( (mplot->picsource_org.x==mplot->picsource_spot.x) ||
      (mplot->picsource_org.y==mplot->picsource_spot.y) )
       {
       fprintf(stderr, " Cannot execute new_org on this input.\n\
First try selecting with the left mouse button a new target and then select the new_org option\n");
       return;
       
       
       }
  



  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    maxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    }
  else
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    maxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }

  bottom_left_x = (float)minx;
  bottom_left_y = (float)miny;
  xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);

  fprintf(stderr, "Box Coordinates:\n");
  fprintf(stderr, "Bot Left:  km: %f %f\n", bottom_left_x, bottom_left_y);
  fprintf(stderr, " LAT-LON  LAT-LON:\n %f %f ", phi, lam);

  top_right_x = (float)maxx;
  top_right_y = (float)maxy;

  xy2geo(mplot, &phi, &lam, top_right_x, top_right_y);

  fprintf(stderr, " %f %f \n", phi, lam);
  fprintf(stderr, "Top Right:  km: %f %f\n", top_right_x, top_right_y);

  /* dump out an origin file   */
  fprintf(stderr, "  \n  New ORIGIN FILE: \n");

  xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);

  xkm = fabs(top_right_x - bottom_left_x);
  ykm = fabs(top_right_y - bottom_left_y);

  fprintf(stderr, "DX = %f DY = %f \n\n", xkm, ykm);

  if(xkm <= 5)
    {
    temspacx = 0.1;
    newx = xkm / temspacx;
    while(newx <= 5)
      {
      temspacx /= 10.0;
      newx = xkm / temspacx;
      }
    }

  if(xkm > 10.0 && xkm < 80.0)
    {
    newx = xkm;
    temspacx = 1.0;
    }

  if(xkm < 10.0 && xkm > 5.0)
    {
    temspacx = 0.5;
    newx = xkm / temspacx;
    }

  if(xkm > 80.0 && xkm < 120.0)
    {
    temspacx = 2.0;
    newx = xkm / temspacx;
    }

  if(xkm > 120.0)
    {
    temspacx = 5.0;
    newx = xkm / temspacx;
    }

  if(ykm <= 5)
    {
    temspacy = 0.1;
    newy = ykm / temspacy;
    while(newy <= 5)
      {
      temspacy /=10.0;
      newy = ykm / temspacy;
      }
    }

  if(ykm > 10.0 && ykm < 80.0)
    {
    newy = ykm;
    temspacy = 1.0;
    }

  if(ykm < 10.0 && ykm > 5.0)
    {
    temspacy = 0.5;
    newy = ykm / temspacy;
    }

  if(ykm > 80.0 && ykm < 120.0)
    {
    temspacy = 2.0;
    newy = ykm / temspacy;
    }

  if(ykm > 120.0)
    {
    temspacy = 5.0;
    newy = ykm / temspacy;
    }

  i = (int)mplot->MaxDepth;

  if(newx == 0) newx++;
  if(newy == 0) newy++;

  fprintf(stdout, "1 1 %d %d %d %f %f\n", newx, newy, i, temspacx, temspacy);
  fprintf(stdout, "%f \n", phi);
  fprintf(stdout, "%f \n", lam);
  fprintf(stdout, " \n\n");
  fprintf(stdout, "---------------------------------------------- \n");

  if((inf = fopen("new_org.out", "w")) == NULL)
    {
    fprintf(stderr, "Can't open image new_org.out ....try again\n");
    return;
    }

  fprintf(stderr, "New Origin FIle is stored in file: new_org.out \n");

  fprintf(inf, "1 1 %d %d %d %f %f\n", newx, newy, i, temspacx, temspacy);
  fprintf(inf, "%f \n", phi);
  fprintf(inf, "%f \n", lam);
  fclose(inf);

  nargc = set_input_args(mplot, nargv);
  }
