
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"

/* --- function prototypes --- */

Boolean CopyToContWindow(CONT_PARMS *pcontParms);
Boolean CopyFromContWindow(CONT_PARMS *pcontParms);
void contour_new_parms(mpic *mplot);
void SetWidgetInt(Widget w, String attr, int i);
int PrintContParms(CONT_PARMS *pcontParms);
/* int InitContParms(CONT_PARMS *pcontParms); */

/* --- functions --- */

void PopupCont(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  if(mplot->contParms.datapt == NULL) return;
  /* PrintContParms(&mplot->contParms); */
  iokay = CopyToContWindow(&mplot->contParms);
  XtPopup(mplot->contParms.wShell, XtGrabNone);
  }

void ContSet(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  iokay = CopyFromContWindow(&mplot->contParms);
  /* PrintContParms(&mplot->contParms); */
  XtPopdown(mplot->contParms.wShell);
  contour_new_parms(mplot);
  }

void ContDone(Widget w, mpic *mplot, char *call_data)
  {

  /* PrintContParms(&mplot->contParms); */
  XtPopdown(mplot->contParms.wShell);
  }

void make_cont_menu(Widget box, mpic *mplot)
  {
  Widget xp, view, top, contshell;

  top = mplot->shell;
  xp = XtVaCreateManagedWidget("Set Cont", smeBSBObjectClass, box, NULL);
  
  mplot->contParms.wShell = contshell =
    XtVaCreatePopupShell("contWin", transientShellWidgetClass, top, NULL);
  
  view = XtVaCreateManagedWidget("contForm", formWidgetClass, contshell, NULL);
  
  /* -----------NOTE:  these must be created in the correct order   !  */
  
  /* Create the various parameter labels and their text boxes. */

  mplot->contParms.wRLabel = XtVaCreateManagedWidget("RLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wREdit = XtVaCreateManagedWidget("REdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wILabel = XtVaCreateManagedWidget("ILabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wIEdit = XtVaCreateManagedWidget("IEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wALabel = XtVaCreateManagedWidget("ALabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wAEdit = XtVaCreateManagedWidget("AEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wLLabel = XtVaCreateManagedWidget("LLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wLEdit = XtVaCreateManagedWidget("LEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wNLabel = XtVaCreateManagedWidget("NLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wNEdit = XtVaCreateManagedWidget("NEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wTLabel = XtVaCreateManagedWidget("TLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wTEdit = XtVaCreateManagedWidget("TEdit",
     asciiTextWidgetClass, view, NULL);

  mplot->contParms.wXLabel = XtVaCreateManagedWidget("XLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wXEdit = XtVaCreateManagedWidget("XEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wFLabel = XtVaCreateManagedWidget("FLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wFEdit = XtVaCreateManagedWidget("FEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wSLabel = XtVaCreateManagedWidget("SLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wSEdit = XtVaCreateManagedWidget("SEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->contParms.wZLabel = XtVaCreateManagedWidget("ZLabel",
    labelWidgetClass, view, NULL);

  mplot->contParms.wZEdit = XtVaCreateManagedWidget("ZEdit",
    asciiTextWidgetClass, view, NULL);
    
  /* Make all of the edit boxes editable. */

  SetWidgetInt(mplot->contParms.wREdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->contParms.wIEdit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->contParms.wAEdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->contParms.wLEdit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->contParms.wNEdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->contParms.wTEdit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->contParms.wXEdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->contParms.wFEdit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->contParms.wSEdit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->contParms.wZEdit, XtNeditType, XawtextEdit);

  /* Create the Set and Cancel command buttons. */

  mplot->contParms.wSet = XtVaCreateManagedWidget("set",
    commandWidgetClass, view, NULL);

  mplot->contParms.wCancel = XtVaCreateManagedWidget("cancel",
    commandWidgetClass, view, NULL);

  /* InitContParms(&mplot->contParms); */

  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PopupCont, mplot);

  XtAddCallback(mplot->contParms.wSet, XtNcallback, (XtCallbackProc)ContSet,
		mplot);
  XtAddCallback(mplot->contParms.wCancel, XtNcallback,
		(XtCallbackProc)ContDone, mplot);
  }

/*******************************************************/

void PopupInfo(Widget w, Widget call_data, Widget dummy)
  {	

  XtPopup(call_data, XtGrabNone);
  }

/* help dialog done button */

void InfoDone(Widget w, Widget call_data, Widget d)
  {

  XtPopdown(call_data);
  }


void make_info_menu(Widget box, mpic *mplot)
  {
  Widget xp, top, hshell, lab, labDone, view;
  static char *infostuff =
"XMAP8 Info\n\
Author: Jonathan M. Lees, Yale University\n\n\n\
Copyright (c) 1994-1997 by Jonathan M. Lees\n\

If you use this code for data exploration or producing figures\n\
please acknowledge my contribution.\n\
Add a reference in one of the figure captions to this program\n\
by citing the journal article where I describe the program:\n\n\n\
Lees, J. M. (1995): Geotouch: A Free Program for Three-Dimensional GIS,\n\
Seismological Research Letters, 66(4), 33-37.\n\n\n\
===============================================\n\n\n\
VERSION:  1: (see compilation date)  \n\n\n\
===============================================\n\n\n\
Acknowledgements=================================\n\n\n\
The author acknowledges the efforts of Craig Nicholson,  Geoff Ely, \
Jess McCullugh,  \n\n\n\
Steve Malone and Bob Crosson for numerous comments and suggestions which\
  \n\n\n\
significantly improved Geotouch.  Portions of the code were developed by Bob\
 Fischer,  \n\n\n\
Peilin Jia and Mark Lindner.  Thanks to Mark Alvarez for the original\
 suggestion to  \n\n\n\
develop this code.  \n\n\n\

Copyright (c) 1994-1997 by Jonathan M. Lees\n\

===========================================\n\
Happy Computing!";

  top = mplot->shell;

  xp = XtVaCreateManagedWidget("Information", smeBSBObjectClass, box, NULL);

  hshell = XtVaCreatePopupShell("INFO", transientShellWidgetClass, top, NULL);

  view = XtVaCreateManagedWidget("boo2", boxWidgetClass, hshell, NULL);

  labDone = XtVaCreateManagedWidget("QUIT INFO", commandWidgetClass, view,
				    NULL);

  view = XtVaCreateManagedWidget("boo",	viewportWidgetClass, view,
				 XtNallowVert, TRUE,
				 XtNallowHoriz, TRUE,
				 XtNwidth, 700, XtNheight, 700, NULL);

  lab = XtVaCreateManagedWidget("Info", labelWidgetClass, view,
				XtNlabel, infostuff, NULL);

  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PopupInfo, hshell);
  XtAddCallback(labDone, XtNcallback, (XtCallbackProc)InfoDone, hshell);
  }
