/*
 *  The following routines plot  linear  axes on the
 *  Sun workstation using X routines.
 *  Originally written by Peter Crames as part of the Graphpac package.
 *  Modified 1/88 by rbd for use by X11 on the Sun.
 *  
 *  modified Sun Jan  2 15:25:54 EST 1994  by JML
 */
/*

OLD          #include "externs.h"

xaxis will draw an x axis from (x0, y0) to (xn, y0) with major, [middle,
and minor] tick marks. A major tick mark is the biggest in size and is also
numbered. A middle tick mark is middle in size and is not numbered. A minor
tick mark is smallest in size and is also not numbered. The function will
find the length of the axis, xylen, which equals xn-x0. Then the largest
power of 10 smaller than xylen will be found.  For example, if xylen = 253,
then the power of 10 will be p = 100.  If xylen = .003, then p = .001. Major
tick marks (with numbering) will be drawn at x0, xn, and every multiple of p
between x0 and xn. For example, if the x axis is from 314 to 860, xylen
equals 546, and p equals 100. There will be major tick marks at 314, 400,
500, 600, 700, 800 and 860. The distance between each major tick mark is
divided into ndivs divisions. If ndivs <= 0, ndivs will be set to the default
of 10 divisions between major tick marks.  Minor tick marks will be drawn at
every multiple of p/ndivs between x0 and xn that is not a major tick mark. If
ndivs is even, the tick mark half way between each major tick mark will be a
middle tick mark instead of a minor tick mark.  For example, if the x axis is
from 147 to 312, and ndivs = 4, there will be major tick marks at 147, 200,
300 and 312. There will be middle tick marks at 150 and 250. There will be
minor tick marks at 175, 225, and 275. If ndivs = 1, there will be no middle
or minor tick marks.
tside and nside determine which side of the x axis tick marks and
numbers will appear. 1 is above the axis, -1 is below the axis, and 0 is not
at all. For example, xaxis(pxw, grph, 215., 50., 3490., 1, -1, 8, 0.) will
draw an x axis from (215., 50.) to (3490., 50.) with tick marks above the
axis and numbers below the axis.
offset is the label offset. This number will be added to the value of
the coordinate at major tick marks when computing the label.
grph is a pointer to the graph which describes the mapping between the
user's coordinates and the pixels of pxw. The graph structure is defined in
defines.h, and the mapping routines are contained in user_pw.c.

*/


/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "xlext.h"
#include "jgraph.h"

/* --- global variables and function prototypes --- */

void prep_d2lab(double dg, char *output);
int user_to_pix_x(JGRAPH *gr, double x);
int user_to_pix_y(JGRAPH *gr, double y);

double jaxp[77] =
  { 1e-38, 1e-37, 1e-36, 1e-35, 1e-34, 1e-33, 1e-32, 1e-31, 1e-30,
    1e-29, 1e-28, 1e-27, 1e-26, 1e-25, 1e-24, 1e-23, 1e-22, 1e-21,
    1e-20, 1e-19, 1e-18, 1e-17, 1e-16, 1e-15, 1e-14, 1e-13, 1e-12,
    1e-11, 1e-10, 1e-9, 1e-8, 1e-7, 1e-6, 1e-5, 1e-4, 1e-3, 1e-2,
    1e-1, 1e0, 1e1, 1e2, 1e3, 1e4, 1e5, 1e6, 1e7, 1e8, 1e9, 1e10,
    1e11, 1e12, 1e13, 1e14, 1e15, 1e16, 1e17, 1e18, 1e19, 1e20, 1e21,
    1e22, 1e23, 1e24, 1e25, 1e26, 1e27, 1e28, 1e29, 1e30, 1e31, 1e32,
    1e33, 1e34, 1e35, 1e36, 1e37, 1e38 };

double eps;
int pwr, ts, ns;
Display *disp;
Window wind;
GC grct;
JGRAPH *locgrph;
int majtick = 7, midtick = 5, mintick = 3; /* tick sizes in pixels */
int charwidth = 8, charheight = 10; /* character size in pixels */
double lastnum; /* position of last printed tick label */
double nextnum; /* position of next tick label to be printed */
double label_offset;

/* --- functions --- */

/* equal comparison of doubles */

int g_eq(double x, double y, double e)
  {

  return(!((x < y - e) || (x > y + e)));
  }

/* major tick x axis */

void g_xmajt(double pt, int xpt, int ypt)
  {
  char outpt[20];
  int len, hz_offset, pix_x0, pix_y0;

  double pix_to_user_x();

  /* plot tick */

  if(ts == 1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt, ypt - majtick);
  else if(ts == -1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt, ypt + majtick);

  if(ns == 0) return;

  /* create label */

  if(g_eq(0.0, pt, jaxp[pwr - 5])) pt = 0.0;
  gcvt(pt + label_offset, 4, outpt);

  /*
   * determine horizontal offset necessary for centering label
   * above/beneath tick mark; if new label will overlap the previous label,
   * don't print it
   */

  len = strlen(outpt);
  if(outpt[len - 1] == '.')
    {
    outpt[len - 1] = '\0';
    len--;
    }

  hz_offset = (charwidth * len) / 2;
  pix_x0 = xpt - hz_offset;
  nextnum = pix_to_user_x(locgrph, pix_x0);
  if (nextnum > lastnum)
    {
    /* print tick label */

    if((ns == 1) && (ts != 1)) pix_y0 = ypt - majtick;
    else if((ns == 1) && (ts == 1)) pix_y0 = ypt - 2 * majtick;
    else if((ns == -1) && (ts != -1)) pix_y0 = ypt + charheight + majtick;
    else if((ns == -1) && (ts == -1)) pix_y0 = ypt + charheight + 2 * majtick;

    XDrawString(disp, wind, grct, pix_x0, pix_y0, outpt, len);
    lastnum = pix_to_user_x(locgrph, xpt + hz_offset);
    /* fprintf(stderr,"%f %f\n",lastnum,nextnum); */
    } 
  }

/* middle tick x axis */

void g_xmidt(int xpt,int  ypt)
  {

  if(ts == 1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt, ypt - midtick);
  else if(ts == -1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt, ypt + midtick);
  }

/* minor tick x axis */

void g_xmint(int xpt, int ypt)
  {
  if(ts == 1)
    XDrawLine(disp, wind, grct, xpt, ypt, xpt, ypt - mintick);
  else if(ts == -1)
    XDrawLine(disp, wind, grct, xpt, ypt, xpt, ypt + mintick);
  }

void xaxis(Display *d, Window w, GC grc, JGRAPH *grph,
	   double x0, double y0, double xn, int tside, int nside, int ndivs, 
	   double offset)
  {
  double xylen, ptr, cnt, divcon, mincon, maxcon, true_xmin, true_xmax;
  int pix_x0, pix_x1, pix_y0;

  disp = d, wind = w, grct = grc, locgrph = grph;

  /* allow for floating point error in axis limits */

  true_xmin = locgrph->user_xmin;
  true_xmax = locgrph->user_xmax;

  mincon = (true_xmin < 0.0) ? 1.01 : 0.99;
  maxcon = (true_xmax < 0.0) ? 0.99 : 1.01;

  if((x0 < true_xmin * mincon) || (xn > true_xmax * maxcon))
    {
    fprintf(stderr, "xaxis: x axis outside xy window\n");
    }
  if(x0 > xn)
    {
    fprintf(stderr, "xaxis: start point greater than end point\n");
    exit(0);
    }
  if((tside != -1 && tside != 0 && tside != 1)
     || (nside != -1 && nside != 0 && nside != 1))
    {
    fprintf(stderr, "xaxis: tside and nside must be -1, 0 or 1\n");
    exit(0);
    }

  lastnum = true_xmin;
  if(ndivs <= 0) ndivs = 10;		/* set default ndivs */

  /* find greatest power of 10 less than axis length */

  xylen = xn - x0;
  for(pwr = 76; jaxp[pwr] >= xylen; pwr--);
  label_offset = offset;

  /* ptr will move from x0 through xn */
  ptr = 0.0;

  /* cnt will count the minor tick marks between major tick marks */
  cnt = (double)ndivs;
  divcon = jaxp[pwr] / (double) ndivs; /* minor tick mark every divcon units */
  eps = 0.5 * jaxp[pwr - 2]; /* used to compare doubles for equality in g_eq */
  ts = tside;		     /* ts and ns are global so that they          */
  ns = nside;		     /* needn't be passed to the tick functions    */

  if (x0 + label_offset != 0.0)
    {
    for(;;)
      {
      /* step ptr by jaxp[pwr] until it passes x0 */

      if(x0 + label_offset > 0.0)
	{
	ptr += jaxp[pwr];
	if(ptr > x0 + label_offset) break;
	}
      else
	{
	ptr -= jaxp[pwr];
	if(ptr < x0 + label_offset)
	break;
	}
      }

    if(x0 + label_offset < 0.0) cnt = 0.0;
    for(;;)
      {
      /*
       * now move ptr in the opposite direction by steps of divcon
       * until it passes x0 again. ptr will then equal the tick
       * mark just before or just after x0
       */

      if(x0 + label_offset > 0.0)
	{
	ptr -= divcon;
	cnt -= 1.0;
	if(ptr - eps < x0 + label_offset) break;
	}
      else
	{
	ptr += divcon;
	cnt += 1.0;
	if(ptr + eps > x0 + label_offset) break;
	}
      }
    if(x0 + label_offset > 0.0)
      {
      /*
       * now move ptr in the original direction by divcon
       */
      ptr += divcon;
      cnt += 1.0;
      }
    }

  ptr -= label_offset;

  /* draw axis line and major tick mark at start point */
  pix_x0 = user_to_pix_x(locgrph, x0);
  pix_x1 = user_to_pix_x(locgrph, xn);
  pix_y0 = user_to_pix_y(locgrph, y0);
  XDrawLine(disp, wind, grct, pix_x0, pix_y0, pix_x1, pix_y0);
  g_xmajt(x0, pix_x0, pix_y0);

  while(ptr <= xn + eps)
    {
    pix_x0 = user_to_pix_x(locgrph, ptr);
    if(g_eq(cnt, (double) ndivs, 0.1))
      {
      /* at major tick mark */
      g_xmajt(ptr, pix_x0, pix_y0);
      cnt = 1.0;
      }
    else
      {
      /*
       * output middle tick mark if ndivs even and halfway between
       * major tick marks
       */
      if(g_eq(cnt, (double) ndivs * 0.5, 0.1)) g_xmidt(pix_x0, pix_y0);
      else g_xmint(pix_x0, pix_y0);
      cnt += 1.0;
      }
    ptr += divcon;
    }
    
  g_xmajt(xn, pix_x1, pix_y0);
  }

/*
 *  yaxis will draw a y axis from (x0, y0) to (x0, yn). The rules for major,
 *  middle, and minor tick marks are the same as for the xaxis function.
 *  For tside and nside, 1 is to the right of the axis, -1 is to the left of
 *  the axis, and 0 is not at all.
 */

#define MID	0
#define BELOW   1
#define ABOVE   2

/* major tick y axis */

void g_ymajt(double pt, int xpt, int ypt, int print, int pos)
  {
  int len, hz_offset, pix_x0, pix_y0;
  char outpt[20];
  double pix_to_user_y();

  /* plot tick */

  if(ts == 1)
   XDrawLine(disp , wind, grct, xpt, ypt, xpt + majtick, ypt);
  else if(ts == -1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt - majtick, ypt);

  if(ns == 0 || print == 0) return;

  /* create label */

  prep_d2lab(pt, outpt);

  /*
   * determine length and position of tick label; if label will overlap the
   * previous label, don't print it
   */

  len = strlen(outpt);

  if(outpt[len - 1] == '.')
    {
    outpt[len - 1] = '\0';
    len--;
    }

  hz_offset = charwidth * len;
  switch(pos)
    {
    case MID:
      pix_y0 = ypt + charheight / 2;
      break;
    case BELOW:
      pix_y0 = ypt + charheight;
      break;
    case ABOVE:
      pix_y0 = ypt;
    }

  nextnum = pix_to_user_y(locgrph, pix_y0);

  /* if (nextnum > lastnum) {  */

  /* print tick label */

  if((ns == 1) && (ts != 1)) pix_x0 = xpt + majtick;
  else if((ns == 1) && (ts == 1)) pix_x0 = xpt + 2 * majtick;
  else if((ns == -1) && (ts == -1)) pix_x0 = xpt - hz_offset - 2 * majtick;
  else if((ns == -1) && (ts != -1)) pix_x0 = xpt - hz_offset - majtick;

  XDrawString(disp, wind, grct, pix_x0, pix_y0, outpt, len);
  lastnum = pix_to_user_y(locgrph, pix_y0 - charheight);

  /*    }  */
  }

/* middle tick y axis */

void g_ymidt(int xpt, int ypt)
  {
  if(ts == 1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt + midtick, ypt);
  else if(ts == -1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt - midtick, ypt);
  }

/* minor tick y axis */

void g_ymint(int xpt, int ypt)
  {
  if(ts == 1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt + mintick, ypt);
  else if(ts == -1)
    XDrawLine(disp , wind, grct, xpt, ypt, xpt - mintick, ypt);
  }

void yaxis(Display *d, Window w, GC grc, JGRAPH *grph, double  x0, double y0,
	   double yn, int tside, int nside, int ndivs, double offset)
  {
  double xylen, ptr, cnt, divcon, mincon, maxcon, true_ymin, true_ymax;
  int pix_x0, pix_y0, pix_y1;

  disp = d, wind = w, grct = grc, locgrph = grph;

  /* allow for floating point error in axis limits */

  true_ymin = locgrph->user_ymin;
  true_ymax = locgrph->user_ymax;

  mincon = (true_ymin < 0.0) ? 1.01 : 0.99;
  maxcon = (true_ymax < 0.0) ? 0.99 : 1.01;

#if 0
  if((y0 < (true_ymin * mincon)) || (yn > (true_ymax * maxcon)))
    {
    fprintf(stderr, "yaxis: y axis outside xy window %f %f %f %f %f %f\n",
	    y0, yn, true_ymin, true_ymax, mincon, maxcon);
    return;
    }
#endif

#if 1
  if(y0 > yn)
    {
    fprintf(stderr, "yaxis: start point greater than end point\n");
    return;
    }
#endif

  if((tside != -1 && tside != 0 && tside != 1)
     || (nside != -1 && nside != 0 && nside != 1))
    {
    fprintf(stderr, "yaxis: tside and nside must be -1, 0 or 1\n");
    return;
    }

  lastnum = true_ymin;
  if(ndivs <= 0) ndivs = 10;

  /* find greatest power of 10 less than axis length */

  xylen = yn - y0;
  for(pwr = 76; jaxp[pwr] >= xylen; pwr--);
  label_offset = offset;
  ptr = 0.0;
  cnt = (double)ndivs;
  divcon = jaxp[pwr] / (double)ndivs;
  eps = 0.5 * jaxp[pwr - 2];
  ts = tside;
  ns = nside;

  if(y0 + label_offset != 0.0)
    {
    for(;;)
      {
      /* step ptr by jaxp[pwr] until it passes y0 */

      if(y0 + label_offset > 0.0)
	{
	ptr += jaxp[pwr];
	if(ptr > y0 + label_offset) break;
	}
      else
	{
	ptr -= jaxp[pwr];
	if(ptr < y0 + label_offset) break;
	}
      }

    if(y0 + label_offset < 0.0) cnt = 0.0;

    for(;;)
      {
      /*
       * now move ptr in the opposite direction by steps of divcon
       * until it passes y0 again. ptr will then equal the tick
       * mark next to y0 just outside the axis
       */

      if(y0 + label_offset > 0.0)
	{
	ptr -= divcon;
	cnt -= 1.0;
	if(ptr - eps < y0 + label_offset) break;
	}
      else
	{
	ptr += divcon;
	cnt += 1.0;
	if(ptr + eps > y0 + label_offset) break;
	}
      }
    if(y0 + label_offset > 0.0)
      {
      /*
       * now move ptr in the original direction by divcon
       */
      ptr += divcon;
      cnt += 1.0;
      }
    /* ptr now equals the first tick mark after y0 */
    }
  ptr -= label_offset;

  /* draw axis line and major tick mark at start point */

  pix_x0 = user_to_pix_x(locgrph, x0);
  pix_y0 = user_to_pix_y(locgrph, y0);
  pix_y1 = user_to_pix_y(locgrph, yn);
  XDrawLine(disp , wind, grct, pix_x0, pix_y0, pix_x0, pix_y1);
  g_ymajt(y0, pix_x0, pix_y0, 1, ABOVE);

  while(ptr <= (yn + eps))
    {
    pix_y0 = user_to_pix_y(locgrph, ptr);
    if(g_eq(cnt, (double)ndivs, 0.1))
      {
      /* at major tick mark */
      g_ymajt(ptr, pix_x0, pix_y0, 0, MID);
      cnt = 1.0;
      }
    else
      {
      /*
       * output middle tick mark if ndivs even and halfway between
       * major tick marks
       */
      if(g_eq(cnt, (double)ndivs * 0.5, 0.1)) g_ymidt(pix_x0, pix_y0);
      else g_ymint(pix_x0, pix_y0);
      cnt += 1.0;
      }
    ptr += divcon;
    }

  g_ymajt(yn, pix_x0, pix_y1, 1, BELOW);
  }

