/* cascading Athena SimpleMenu with toggle menu options */
/* Mark Lindner 9/27/95 */

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>

/* --- local headers --- */

#include "rdblarrow"
#include "cascade.h"

/* --- macros and typedefs --- */

#define MENU_TRANSLATIONS \
"#override\n\
<BtnUp>: XtMenuPopdown() notify() unhighlight()\n\
<LeaveWindow>: unhighlight() cascade_popup()"

#define SUBMENU_TRANSLATIONS \
"#override\n<LeaveWindow>: XtMenuPopdown() unhighlight()"

struct cascade_entry
  {
  Widget parent;
  Widget *children;
  unsigned int *options;
  size_t nchildren;
  } cascade_entry;

struct cascade_ds
  {
  struct cascade_entry *entries;
  size_t nentries;
  Pixmap rightarrow;
  } cascade_ds;

/* --- global variables and function prototypes --- */

static struct cascade_ds data;

static void cascade_popup(Widget w, XEvent *event, String *params,
			  Cardinal *num_params);

/* --- functions --- */

void cascade_init(XtAppContext app_context, Widget top)
  {
  static XtActionsRec cactions[] =
    { { "cascade_popup", cascade_popup } };

  data.entries = NULL;
  data.nentries = 0;
  data.rightarrow = XCreateBitmapFromData(XtDisplay(top),
					  RootWindowOfScreen(XtScreen(top)),
					  next_bits, next_width, next_height);

  XtAppAddActions(app_context, cactions, XtNumber(cactions));
  }

void cascade_quit(void)
  {
  unsigned int i;
  struct cascade_entry *e;

  for(i = 0; i < data.nentries; i++)
    {
    e = &(data.entries[i]);
    XtFree((char *)e->children);
    XtFree((char *)e->options);
    }
  XtFree((char *)data.entries);
  }

static void cascade_popup(Widget w, XEvent *event, String *params,
			  Cardinal *num_params)
  {
  XLeaveWindowEvent *leave_event = (XLeaveWindowEvent *)event;
  Dimension width, h;
  Position x, y;
  /* XButtonEvent *bevent = (XButtonEvent *)event; */
  unsigned int i, j, k;
  Cardinal n;
  Widget submenu = NULL;
  WidgetList panes;

  /* obtain the list of menupanes in this menu */

  XtVaGetValues(w, XtNchildren, &panes, XtNnumChildren, &n,
		XtNwidth, &width, NULL);

  /* did we leave through right side of menu? */

  if(leave_event->x < width) return;

  /* find out which menupane we were in before we left the menu */

  for(i = 0; i < n; i++)
    {
    XtVaGetValues(panes[i], XtNheight, &h, XtNx, &x, XtNy, &y, NULL);

    if((leave_event->y >= y) && (leave_event->y <= (y + h)))
      {

      /* find out which submenu to pop up in response to this */

      for(j = 0; j < data.nentries; j++)
	{
	if(data.entries[j].parent == w)
	  {
	  for(k = 0; k < data.entries[j].nchildren; k++)
	    {
	    if(data.entries[j].options[k] == i)
	      {
	      submenu = data.entries[j].children[k];
	      }
	    }
	  }
	}

      /* move and popup the submenu directly to right of option */

      if(submenu)
	{
	Position xabs, yabs;

	XtTranslateCoords(w, x, y, &xabs, &yabs);

	XtVaSetValues(submenu, XtNx, xabs + width, XtNy, yabs, NULL);
	XtPopup(submenu, XtGrabNonexclusive);
	}
      }
    }
  }


/* initialize a menu to be a parent menu */

void cascade_menu(Widget menu)
  {
  struct cascade_entry *e;

  /* hook in for a leave window event */

  XtOverrideTranslations(menu, XtParseTranslationTable(MENU_TRANSLATIONS));

  /* create an entry in the global cascade datastructure for this menu */

  data.nentries++;
  data.entries =
    (struct cascade_entry *)XtRealloc((char *)data.entries,
				      data.nentries *
				      sizeof(struct cascade_entry));

  e = &(data.entries[data.nentries - 1]);

  e->parent = menu;
  e->children = NULL;
  e->options = NULL;
  e->nchildren = 0;

  }

/* Connect a submenu to a parent menu, and set up callbacks. */

void cascade_link(Widget parent, Widget child, unsigned int item)
  {
  WidgetList panes;
  struct cascade_entry *e;
  int i;

  /* first we add double arrow to right margin of the appropriate menu pane */

  XtVaGetValues(parent, XtNchildren, &panes, NULL);
  XtVaSetValues(panes[item], XtNrightMargin, 25,
		XtNrightBitmap, data.rightarrow, NULL);

  /* now set translations so leaving the window pops it down */

  XtOverrideTranslations(child,
			 XtParseTranslationTable(SUBMENU_TRANSLATIONS));

  /* add necessary data to the global cascade data structure */

  for(i = 0; i < data.nentries; i++)
    {
    e = &(data.entries[i]);

    if(e->parent == parent)
      {
      int j = e->nchildren;

      e->nchildren++;
      e->children = (Widget *)XtRealloc((char *)e->children,
					sizeof(Widget) * e->nchildren);
      e->children[j] = child;

      e->options = (unsigned int *)XtRealloc((char *)e->options,
					     sizeof(unsigned int) *
					     e->nchildren);
      e->options[j] = item;
      }
    }
  }
