
/* header file for single-depth menu cascading library */

/*
 *  cascade_init() : initialize the menu cascading library
 *
 *  app_context is the application context for the calling program, and
 *  top is the program's top level shell. These are needed to install the
 *  necessary bitmap and translation data.
 *
 *  Call this function BEFORE accessing any other functions in this library.
 */

extern void cascade_init(XtAppContext app_context, Widget top);

/*
 *  cascade_menu() : register a menu as a parent menu for cascading
 *
 *  The passed menu is registered with the library as a menu that will have
 *  cascading submenu children. This function must be called on a menu
 *  BEFORE any submenus are linked to it using cascade_link().
 *
 *  Note that you should only call this ONCE for any specific menu, regardless
 *  of how many times you plan to call cascade_link() on it. If you call it
 *  more than once for the same menu, then memory will be wasted and the
 *  submenus won't work right.
 */

extern void cascade_menu(Widget menu);

/*
 *  cascade_link() : link a cascading submenu to its parent menu
 *
 *  parent is the parent menu, and child is the child menu. These must
 *  have been created before this function is called. The item'th child
 *  of the parent menu (normally the item'th menupane in the menu) will
 *  cause the child menu to pop up when the mouse pointer leaves the parent
 *  menu to the right of that option. Note that if your menu has title
 *  labels and dividing lines, those count as menupanes too, and you must
 *  adjust your item value accordingly (for example, a menu with a title and
 *  dividing line would have item = 2 if it wanted the first actual option to
 *  spawn a cascading menu).
 *
 */

extern void cascade_link(Widget parent, Widget child, unsigned int item);

/*
 *  cascade_quit() : quit the cascading menu library
 *
 *  This function deallocates all space associated with the cascaded menu
 *  maintenance routines. It should be called only before the program exits;
 *  otherwise the program's state will be corrupted.
 */

extern void cascade_quit(void);
