
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"
#include "focproto.h"
#include "jutil.h"

/* --- macros --- */

#define SIGN(A, B)      ((B) < 0 ? -fabs(A) : fabs(A))
#define DEG2RAD		0.017453293
#define RAD2DEG		57.295778667

/* --- typedefs and function prototypes --- */

typedef fxy fpoint;

int inside(fpoint t, fpoint *p, int N);

/* --- functions --- */

void Proj_Pole(float strike, float dip, float *x, float *y)
  {
  double xi, tq; 

  xi = XMAP_PI_2 - dip;
  tq = XMAP_SQRT2 * sin(xi / 2.0);
  *x = tq * sin(strike);
  *y = tq * cos(strike);             
  }

/* ROUTINE RETURNS THE TREND AND PLUNGE OF A VECTOR WITH COMPONENTS
   X,Y,Z. VECTOR NEED NOT BE A UNIT VECTOR. ANGLES ARE RETURNED IN RADIANS. */

void XYZ_2_TP(float *v, float *t, float *p)
  {
  double amag, z = v[2];

  if(v[1] == 0.0 && v[0] == 0.0) *t = 0.0;
  else *t = atan2(v[1], v[0]);

  amag = sqrt(sqr(v[0]) + sqr(v[1]));
  if(amag == 0.0) *p = SIGN(1.0, z) * XMAP_PI_2;
  else *p = atan(z / amag);
  }   


void Cross_prod(float t1, float p1, float t2, float p2, float *t3, float *p3,
		float *angle)
  {
  double dprod, xprodmag;    
  float v1[3], v2[3], v3[3], a1, a2;

  TP_2_XYZ(t1, p1, v1);
  TP_2_XYZ(t2, p2, v2);

  /* calculate cross product*/

  v3[0] = v1[1] * v2[2] - v2[1] * v1[2];
  v3[1] = v1[2] * v2[0] - v2[2] * v1[0];
  v3[2] = v1[0] * v2[1] - v2[0] * v1[1];

  /* calculate dot product*/

  dprod = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];

  /* determine rotation angle. the cross product always produces a vector with
     a positive (right-handed) sense of rotation to take t1,p1 to t2,p2 */

  xprodmag = sqrt(sqr(v3[0]) + sqr(v3[1]) + sqr(v3[2]));

  if(xprodmag == 0 && dprod == 0) *angle = 0.0;
  else *angle = atan2(xprodmag, dprod);
           
  XYZ_2_TP(v3, &a1, &a2);
  *t3 = a1;
  *p3 = a2;
  }

/***********************************************************/

/* draw an arc from q1 to r1
   iflag determines the direction of arc
   vec contains the 2D vectore of points
   q1 and r1 are in degrees */

void Circarc(float q1, float r1, float **vec, int num)
  {
  float anginc;
  int i;
  double diff, rang;

  diff = r1 - q1;
  if(fabs(diff) < 180.0) anginc = diff / (num - 1);
  else
    {
    if(diff < 0.0) anginc = (diff + 360) / (num - 1);
    else anginc = (diff - 360) / (num - 1);
    }

  for(i = 0; i < num; i++)
    {
    rang = DEG2RAD * ((i - 1) * anginc + q1);
    vec[i][0] = cos(rang);
    vec[i][1] = sin(rang);
    }
  }

/***********************************************************/

void Poly_Gone(float **foc1, int ll1, int ind1, float **foc2, int ll2,
      int ind2, float x, float y, int iflip, float **poly1, int *num1,
	       float **poly2, int *num2)
  {
  float **vec, q1, q2, r1, r2;
  int i, count, num;

  vec = alloc_fmat(0,200, 0,1);
  num = 60;

  if(foc1[0][1] == 0 && foc1[0][0] == 0) q1 = 0;
  else q1 = atan2(foc1[0][1], foc1[0][0]);

  if(foc1[ll1 - 1][1] == 0 && foc1[ll1 - 1][0] == 0) q2 = 0;
  else q2 = atan2(foc1[ll1 - 1][1], foc1[ll1 - 1][0]);

  if(foc2[0][1] == 0 && foc2[0][0] == 0) r1 = 0;
  else r1 = atan2(foc2[0][1], foc2[0][0]);

  if(foc2[ll2 - 1][1] == 0 && foc2[ll2 - 1][0] == 0) r2 = 0;
  else  r2 = atan2(foc2[ll2 - 1][1], foc2[ll2 - 1][0]);

  q1 = RAD2DEG * (q1);
  q2 = RAD2DEG * (q2);
  r1 = RAD2DEG * (r1);
  r2 = RAD2DEG * (r2);

  count = 0;

  for(i = ind1; i < ll1; i++)
    {
    poly1[count][0] = foc1[i][0];
    poly1[count][1] = foc1[i][1];
    count++;
    }

  /* circular part: */

  Circarc(q2, r1, vec, num);
  for(i = 0; i < num; i++)
    {
    poly1[count][0] = vec[i][0];
    poly1[count][1] = vec[i][1];
    count++;
    }

  /* last part: */

  for(i = 0; i < ind2; i++)
    {
    poly1[count][0] = foc2[i][0];
    poly1[count][1] = foc2[i][1];
    count++;
    }

  *num1 = count;

  /* second polygon */ 

  count = 0;

  for(i = ind1; i > 0; i--)
    {
    poly2[count][0] = foc1[i][0];
    poly2[count][1] = foc1[i][1];
    count++;
    }

  /* circular part: */

  Circarc(q1, r2, vec, num);

  for(i = 0; i < num; i++)
    {
    poly2[count][0] = vec[i][0];
    poly2[count][1] = vec[i][1];
    count++;
    }

  /* last leg */ 

  for(i = ll2 - 1; i > ind2; i--)
    {
    poly2[count][0] = foc2[i][0];
    poly2[count][1] = foc2[i][1];
    count++;
    }

  *num2 = count;

  free_fmat(vec, 0, 200, 0, 1);
}

/***********************************************************/

/* function to determine if a point is inside a
   polygon or not returns 1 = inside     0 = outside
   inpoly */

int Inpoly(float x, float y, int num, float **poly)
  {
  int i, j, lowy, *indx;
  float *pys;
  fpoint *plotkin, po;

  pys = alloc_fvec(0, num);
  indx = alloc_ivec(0, num);

  plotkin = XmapNewArray(fpoint, num + 1);
  for(i = 0; i < num; i++) pys[i] = poly[i][1];

  cindex(pys, indx, num);

  lowy = indx[0];
  for(i = lowy, j = 1; i < num; i++)
    {
    plotkin[j].x = poly[i][0];
    plotkin[j].y = poly[i][1];
    j++;
    }

  for(i = 0; i < lowy; i++)
    {
    plotkin[j].x = poly[i][0];
    plotkin[j].y = poly[i][1];
    j++;
    }

  po.x = x;
  po.y = y;

  j = inside(po, plotkin, num);

  free_fvec(pys, 0, num);
  free_ivec(indx, 0, num);
  XmapFree(plotkin);

  return(j);
  }

/***********************************************************/

int Find_Near_Ind(float **foc, int ll, float x, float y)
  {
  float b, dis;            
  int ind = 0, i;

  b = 4.0;
  for(i = 0; i < ll - 1; i++)
    {         
    dis = (sqr(foc[i][0] - x) + sqr(foc[i][1] - y));
    if(dis < b)
      {
      ind = i;
      b = dis;
      }
    }

  return(ind);
  }

/***********************************************************/

/* get a focal plane
   dip, ai are in radians
   iang = angle increment
   foc is a 200,2 vector of points
   len is the actual length of foc */

void FM_traj(float dip, float az, int iang, float **foc, int *len)
  {
  float alpha, beta, lambda, phi;
  int i, j;
  double rot, co, si, tq, sint, x, y;

  rot = RAD2DEG * az;
  if(iang < 1) iang = 1;
  beta = az;
  co = cos(beta);
  si = sin(beta);
  lambda = XMAP_PI_2 - dip;

  i = 0;

  for(j = -90; j <= 90; j += iang)
    {
    phi = (j) * DEG2RAD;
    alpha = acos(cos(phi) * cos(lambda));
    if(dip < 0.0)alpha *= -1;
    tq = XMAP_SQRT2 * sin(alpha / 2.0);
    if(sin(alpha) == 0.0) sint = 1.0;
    else sint = sin(phi) / sin(alpha);
    if((1 - (sqr(sint))) <= 0.0) x = 0.0;
    else x = tq * sqrt(1-sqr(sint));              
    y = tq * sint;             
    foc[i][0] = co * x + si * y;
    foc[i][1] = -si * x + co * y;
    i++;
    }
  *len = i;
  }

/*************************************************/

/* returns a focal plane given two angles in degrees   */

void Plane_Traj(float dip, float az, float *a1, float *a2, int *len)
  {   
  float rdip, raz, **foc1;
  int i, n, iang = 1;

  rdip = dip * DEG2RAD;
  raz = az * DEG2RAD; 

  foc1 = alloc_fmat(0, 200, 0, 1);
  FM_traj(rdip, raz, iang, foc1, &n);

  for(i = 0; i < n; i++)
    {
    a1[i] = foc1[i][0];
    a2[i] = foc1[i][1];
    }

  free_fmat(foc1, 0, 200, 0, 1);
  *len = n;
  }

/*************************************************/

void Beach_ball(float *strka, float *dip1, float *strkb, float *dip2,
		float *prot, float *pdip, float *trot, float *tdip,
		int *iplotpt, int iang, float *xtr1, float *ytr1, int *num1,
		float *xtr2, float *ytr2, int *num2, int *ipol)
  {
  int iflip, ind1, ind2, ipoly1, ipoly2, i, nn1, nn2, ll1, ll2;
  float alpha, phi, **foc1, **foc2, **poly1, **poly2, v1[3],  v2[3], az1,
    rdip1, az2, rdip2, t3, p3, angle, q1, q2, r1, r2, ta, tqb, tb, xt, yt,
    strk1, strk2, x, y;
                      
  /* iang = the angle increment drawn along the focal planes and lines */

  strk1 = *strka - 90.0;
  strk2 = *strkb - 90.0;

  /* find intersection intersection is at cross prodoct of the two poles */

  az1 = DEG2RAD * strk1;
  rdip1 = DEG2RAD * *dip1;
  az2 = DEG2RAD * strk2;
  rdip2 = DEG2RAD * *dip2;

  TP_2_XYZ(az1, rdip1, v1);
  TP_2_XYZ(az2, rdip2, v2);

  foc1 = alloc_fmat(0, 200, 0, 1);
  foc2 = alloc_fmat(0, 200, 0, 1);
  poly1 = alloc_fmat(0, 1000, 0, 1);
  poly2 = alloc_fmat(0, 1000, 0, 1);

  FM_traj(rdip1, az1, iang, foc1, &ll1);
  FM_traj(rdip2, az2, iang, foc2, &ll2);

  az1 = az1 + XMAP_PI_2;
  rdip1 = XMAP_PI_2 - rdip1;
  alpha = rdip2;
  az2 = az2 + XMAP_PI_2;
  rdip2 = XMAP_PI_2 - rdip2;
  Cross_prod(az1 * RAD2DEG, rdip1 * RAD2DEG, az2 * RAD2DEG, rdip2 * RAD2DEG,
	     &t3, &p3, &angle);

  t3 += XMAP_PI_2;
  p3 = XMAP_PI_2 - p3;

  phi = p3;
  iflip = 0;
  if(phi > XMAP_PI_2)
    {
    phi = XMAP_PI - phi;
    t3 += XMAP_PI;
    iflip = 1;
    }

  /* h = RAD2DEG * (phi);
     h2 = RAD2DEG * (t3); */

  tqb = XMAP_SQRT2 * sin(phi / 2.0);
  x = tqb * cos(t3);
  y = -tqb * sin(t3);

  /* getind */

  ind1 = Find_Near_Ind(foc1, ll1, x, y);
  ind2 = Find_Near_Ind(foc2, ll2, x, y);

  if(foc1[0][1] == 0 && foc1[0][0] == 0) q1 = 0;
  else q1 = atan2(foc1[0][1], foc1[0][0]);

  if(foc1[ll1 - 1][1] == 0 && foc1[ll1 - 1][0] == 0) q2 = 0;
  else q2 = atan2(foc1[ll1 - 1][1], foc1[ll1 - 1][0]);

  if(foc2[0][1] == 0 && foc2[0][0] == 0) r1 = 0;
  else r1 = atan2(foc2[0][1], foc2[0][0]);

  if(foc2[ll2 - 1][1] == 0 && foc2[ll2 - 1][0] == 0) r2 = 0;
  else r2 = atan2(foc2[ll2 - 1][1], foc2[ll2 - 1][0]);

  /* q1 = atan2(foc1[0][1],foc1[0][0]);
     q2 = atan2(foc1[ll1-1][1],foc1[ll1-1][0]);
     r1 = atan2(foc2[0][1],foc2[0][0]);
     r2 = atan2(foc2[ll2-1][1],foc2[ll2-1][0]); */

  q1 = RAD2DEG * (q1);
  q2 = RAD2DEG * (q2);
  r1 = RAD2DEG * (r1);
  r2 = RAD2DEG * (r2);

  Poly_Gone(foc1, ll1, ind1, foc2, ll2, ind2, x, y, iflip, poly1, &nn1, poly2,
	    &nn2);

  ta = DEG2RAD* * tdip;
  tb = DEG2RAD* * trot;

  Proj_Pole(tb, ta, &xt, &yt);

  ipoly1 = Inpoly(xt, yt, nn1, poly1);
  ipoly2 = Inpoly(xt, yt, nn2, poly2);
  *ipol = 1;
  if(ipoly1 == 1 || ipoly2 == 1) *ipol = 0;

  for(i = 0;i < nn1; i++)
    {
    xtr1[i] = poly1[i][0];
    ytr1[i] = poly1[i][1];
    }

  for(i = 0;i < nn2; i++)
    {
    xtr2[i] = poly2[i][0];
    ytr2[i] = poly2[i][1];
    }

  *num1 = nn1;
  *num2 = nn2;

  free_fmat(foc1, 0, 200, 0, 1);
  free_fmat(foc2, 0, 200, 0, 1);
  free_fmat(poly1, 0, 1000, 0, 1);
  free_fmat(poly2, 0, 1000, 0, 1);
  }

/***************************************************/

int Get_polarity(float strka, float dip1, float strkb, float dip2, float prot,
		 float pdip, float trot, float tdip)
  {
  float alpha, phi, **foc1, **foc2, **poly1,**poly2, az1, rdip1, az2, rdip2,
    t3, p3, angle, h, h2, q1, q2, r1, r2, ta, tqb, tb, xt, yt, strk1,  strk2,
    x, y, d;
  int ipol, ll1, ll2, iflip, ind1, ind2, ipoly1, ipoly2, num1, num2, iang = 1;

  /* iang = the angle increment drawn along the focal planes and lines */

  foc1 = alloc_fmat(0, 200, 0, 1);
  foc2 = alloc_fmat(0, 200, 0, 1);
  poly1 = alloc_fmat(0, 1000, 0, 1);
  poly2 = alloc_fmat(0, 1000, 0, 1);

  strk1 = strka - 90.0;
  strk2 = strkb - 90.0;

  /* find intersection; intersection is at cross prodoct of the two poles */

  az1 = DEG2RAD * strk1;
  rdip1 = DEG2RAD * dip1;
  az2 = DEG2RAD * strk2;
  rdip2 = DEG2RAD * dip2;

  /* TP_2_XYZ(az1, rdip1, v1);
     TP_2_XYZ(az2, rdip2, v2); */            

  FM_traj(rdip1, az1, iang, foc1, &ll1);
  FM_traj(rdip2, az2, iang, foc2, &ll2);

  az1 += XMAP_PI_2;
  rdip1 = XMAP_PI_2 - rdip1;
  alpha = rdip2;
  az2 += XMAP_PI_2;
  rdip2 = XMAP_PI_2 - rdip2;
  Cross_prod(az1 * RAD2DEG, rdip1 * RAD2DEG, az2 * RAD2DEG, rdip2 * RAD2DEG,
	     &t3, &p3, &angle);
  t3 += XMAP_PI_2;
  p3 = XMAP_PI_2 - p3;
  phi = p3;
  iflip = 0;
  if(phi > XMAP_PI_2)
    {
    phi = XMAP_PI - phi;
    t3 += XMAP_PI;
    iflip = 1;
    } 

  h = RAD2DEG * (phi);
  h2 = RAD2DEG * (t3);

  tqb = XMAP_SQRT2 * sin(phi / 2.0);
  x = tqb * cos(t3);
  y = -tqb * sin(t3);

  ind1 = Find_Near_Ind(foc1, ll1, x, y);
  ind2 = Find_Near_Ind(foc2, ll2, x, y);

  if(foc1[0][1] == 0 && foc1[0][0] == 0) q1 = 0;
  else q1 = atan2(foc1[0][1], foc1[0][0]);
  if(foc1[ll1 - 1][1] == 0 && foc1[ll1 - 1][0] == 0) q2 = 0;
  else q2 = atan2(foc1[ll1 - 1][1],foc1[ll1 - 1][0]);
  if(foc2[0][1] == 0 && foc2[0][0] == 0) r1 = 0;
  else r1 = atan2(foc2[0][1], foc2[0][0]);
  if(foc2[ll2 - 1][1] == 0 && foc2[ll2 - 1][0] == 0) r2 = 0;
  else r2 = atan2(foc2[ll2 - 1][1], foc2[ll2 - 1][0]);

  /* q1 = atan2(foc1[0][1],foc1[0][0]);
     q2 = atan2(foc1[ll1-1][1],foc1[ll1-1][0]);
     r1 = atan2(foc2[0][1],foc2[0][0]);
     r2 = atan2(foc2[ll2-1][1],foc2[ll2-1][0]); */

  q1 = RAD2DEG * (q1);
  q2 = RAD2DEG * (q2);
  r1 = RAD2DEG * (r1);
  r2 = RAD2DEG * (r2);

  Poly_Gone(foc1, ll1, ind1, foc2, ll2, ind2, x, y, iflip, poly1, &num1,
	    poly2, &num2);
  ta = DEG2RAD * tdip;
  tb  = DEG2RAD * trot;
  Proj_Pole(tb, ta, &xt, &yt);

  d = sqrt(sqr(xt) + sqr(yt));
  if(d >= 0.9999)
    {
    xt = 0.95 * xt;
    yt = 0.95 * yt;
    }

  ipoly1 = Inpoly(xt, yt, num1, poly1);
  ipoly2 = Inpoly(xt, yt, num2, poly2);
  ipol = 1;
  if(ipoly1 == 1 || ipoly2 == 1) ipol = 0;

  free_fmat(foc1, 0, 200, 0, 1);
  free_fmat(foc2, 0, 200, 0, 1);
  free_fmat(poly1, 0, 1000, 0, 1);
  free_fmat(poly2, 0, 1000, 0, 1);

  return(ipol);
  }



