#ifndef _colorquant_h
#define _colorquant_h

typedef struct qcolor_t
  {
  unsigned int r;
  unsigned int g;
  unsigned int b;
  } qcolor_t;

#define CQ_MAXCOLOR	256

extern int CQ_Quantize(unsigned int sx,		/* image width (parameter)	*/
		       unsigned int sy,		/* image height (parameter)	*/
		       unsigned int *K,		/* # of colors (parm/result)	*/
		       qcolor_t **colors,	/* color table (result)		*/
		       unsigned int *R,		/* array of reds (parameter)	*/
		       unsigned int *G,		/* array of greens (parameter)	*/
		       unsigned int *B,		/* array of blues (parameter)	*/
		       unsigned int **pixels	/* translation table (result)	*/
		       );

#endif /* _colorquant_h */
