/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

/* --- local headers --- */

#include "geotouch.h"
#include "contour.h"
#include "mpic.h"
#include "my_grdcontour.h"
#include "my_surface.h"
#include "user2pix.h"
#include "Gen.h"
#include "xlext.h"
#include "xsec.h"

/* --- macros --- */

#define STEP_I		10.0
#define ASP_A		1.0
#define CON_L		0.0
#define ITER_N		250.0
#define TENS_T		0.0
#define REL_X		1.4
#define CONT_C		"cont_file"
#define SMT_S		0.0
#define MULT_Z		1.0
#define D_LEVELS	20

/* --- global variables --- */

int MAX_PTS; 
struct BRIGGS *briggs;
int npoints = 0;	/* Number of data points			*/
int nx = 0, ny = 0;	/* Number of nodes in x and y dirs.		*/
int mx = 0, my = 0;
int ij_sw_corner, ij_se_corner, ij_nw_corner, ij_ne_corner;
int block_nx;		/* # of nodes in x-dir for given grid factor	*/
int block_ny;		/* # of nodes in y-dir for given grid factor	*/
int max_iterations = 250; /* Max iter per call to iterate		*/
int total_iterations = 0;
int grid, old_grid;	/* Node spacings				*/
int grid_east;
int n_fact = 0;		/* Number of factors in common (ny-1, nx-1)	*/
int factors[32];	/* Array of common factors			*/
int long_verbose = FALSE;
int n_empty;		/* No of unconstrained nodes at initialization	*/
double low_limit, high_limit;	/* Constrains on range of solution	*/
double xmin, xmax, ymin, ymax;	/* minmax coordinates			*/
double xinc, yinc;		/* Size of each grid cell (final size)	*/
double xstep, ystep;		/* steps on xy axes			*/
double grid_xinc, grid_yinc;	/* size of grid cell for given grid factor */
double r_xinc, r_yinc, r_grid_xinc, r_grid_yinc;	/* Reciprocals	*/
double converge_limit = 0.0;	/* Convergence limit			*/
double tension = 0.0;		/* Tension parameter on the surface	*/
double boundary_tension = 0.0;
double interior_tension = 0.0;
double a0_const_1, a0_const_2;	/* Constants for off grid point equation*/
double e_2, e_m2, one_plus_e2;
double eps_p2, eps_m2, two_plus_ep2, two_plus_em2;
double x_edge_const, y_edge_const;
double epsilon = 1.0;
double z_scale = 1.0;          /* Root mean square range of z after
				  removing planar trend			*/
double r_z_scale = 1.0;        /* reciprocal of z_scale			*/
double plane_c0, plane_c1, plane_c2;
				/* Coefficients of best fitting plane to
				   data					*/
double small;			 /* Let data point coincide with node if
				    distance < small			*/
float *u;			/* Pointer to grid array		*/
float *v2;			/* Pointer to v.2.0 grid array		*/
char *iu;			/* Pointer to grid info array		*/
char mode_type[2] = {'I', 'D'};	/* D means include data points when
				   iterating I means just interpolate
				   from larger grid			*/
int offset[25][12];		/* Indices of 12 nearby points in 25
				   cases of edge conditions		*/
double coeff[2][12];		/* Coefficients for 12 nearby points,
				   constrained and u-constrained	*/
double relax_old, relax_new = 1.4;
				/* Coefficients for relaxation factor to
				   speed up convergence */

/* --- function prototypes --- */

int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
void send_repaint(Widget wij,int x, int y, int w, int h);
int Num_Lines(char *source_file);
int PrintContParms(CONT_PARMS *pcontParms);

/* --- functions --- */

void init_contParms(mpic *mp)
  {
  mp->contParms.cont_struct = NULL;
  mp->contParms.surf_grd = NULL;
  mp->contParms.datapt = NULL;
  mp->contParms.length_data = 0;
  mp->contParms.Which_Pal = 0;
  mp->contParms.MinCol = mp->Pal_index[mp->contParms.Which_Pal];
  mp->contParms.MaxCol = (mp->contParms.MinCol
			  + mp->Pal_num[mp->contParms.Which_Pal]-1);
  }

void cont_levels(int n, double zmin, double zmax)
  {
  int i, istep;
  double mant, rl, intpart, step, amin,  tem, val;
  FILE *fp;
  char *orgfil, ofile[100];

  if(n == 0) n = 10;

  /* fprintf(stderr," zmax=%f   zmin=%f  n=%d\n", zmax, zmin, n); */

  step = (zmax - zmin) / n;

  /* fprintf(stderr,"step = %f\n", step); */

  /* an attempt to make nicer contour levels  */

  rl = log10(step);
  mant = modf(rl, &intpart);
  if(intpart <= 0) intpart--;
  rl = pow(10.0, intpart);
  tem = step / rl;
  istep = (int)(tem + 0.5);
  step = istep * rl;
  amin = (1 + (int)(zmin / step)) * step     ;
  val = zmin;

  /* fprintf(stderr,"Cont amin=%f step =%f\n",amin, step); */

  if(step == 0.0)
    { 
    amin = zmin;
    step = (zmax - zmin) / n;
    }

  /* fprintf(stderr,"Cont amin=%f step =%f\n",amin, step); */

  /* ---------------------------------------   */

  if(!(fp = fopen("cont_file", "w")))
    {
    fprintf(stderr, "Cannot open the outout cont_file in this directory\n");
    orgfil = getenv("HOME");
    strcpy(ofile, orgfil);
    strcat(ofile, "/cont_file"); 

    fprintf(stderr, "Trying to open: %s\n", ofile);
    if(!(fp = fopen(ofile, "w")))
      {
      fprintf(fp, "failed to open: %s\n", ofile);
      return;
      } 
    }
  for(i = 0; val <= zmax; i++)
    {
    val = amin + step * i;
    /* fprintf(stderr, "%d %f\n",i, val); */
    fprintf(fp, "%e\n", val);
    }
  fclose(fp);
  }

/*************************************************/

void Surf_Cont(mpic *mplot, PT *datapt, int ln, double ix, double iy,
	       double rw, double re, double rs, double rn, double ai,
	       double ci, double ni, double ti, double xi, char *cont_f,
	       double si, double zi)
  {
  struct SURF_GRD *s_grd;
  struct RETURN_VEC *c_return;

  fprintf(stderr," doing surf\n");

  PrintContParms(&mplot->contParms);

  s_grd = surf(datapt, ln, ix, iy, rw, re, rs, rn, ai, ci, ni, ti, xi);

  /* fprintf(stderr,"Surf_Cont pointer s_grd=%d\n",s_grd); */ 

  mplot->contParms.surf_grd = s_grd;

  /* fprintf(stderr,"Surf_Cont pointer mplot s_grd=%d\n",
     mplot->contParms.surf_grd);*/
	 
  /*	nx = mplot->contParms.surf_grd->nx;
	ny = mplot->contParms.surf_grd->ny; */

  /*dump_a_bit_grd(mplot->contParms.surf_grd);*/

  /*
   * fprintf(stderr,"Before\n");
   * 
   * dump_a_bit_grd(mplot->contParms.surf_grd);
   * 
   */
  /*f printf(stderr," doing contour1\n"); */

  c_return = contour1(s_grd, cont_f, si, zi);

  /*
   * fprintf(stderr,"Before\n");
   * 
   * dump_a_bit_grd(mplot->contParms.surf_grd);
   * 
   */

  /* fprintf(stderr," done contour1\n"); */

  mplot->contParms.cont_struct = c_return;
  }

/*************************************************/

void draw_cont(mpic *mplot)
  {
  Pixel *colors;	/* Color map */
  int l, k, m, con_length, kcol, Col_Diff, lines = 0;
  XPoint p[8000];
  double valdiff;
  struct RETURN_VEC *C_r;

  /* fprintf(stderr, "draw contours\n"); */

  C_r = mplot->contParms.cont_struct;
  colors = mplot->colors;
  XSetForeground(XtDisplay(mplot->wij), mplot->ggc, colors[XmapAppColor(16)]);
  Col_Diff = (mplot->contParms.MaxCol - mplot->contParms.MinCol);
  valdiff = (mplot->contParms.minmax.zmax - mplot->contParms.minmax.zmin);

  for(k = 0; C_r->number_sections[k] != 0; k++)
    {
    /* fprintf(stderr, "cont_level=%e\n", C_r->cont_level[k]);
       fprintf(stderr, "sections=%d\n", C_r->number_sections[k]); */
    for(l = 0; l < C_r->number_sections[k]; l++)
      {
      /* fprintf(stderr, "  section #%d\n", l + 1); */

      con_length = C_r->vec[lines].length;

      /*
       * fprintf(stderr, "  C_r->vec[%d].length=%d\n",
       * lines, con_length);
       */

      for(m = 0; m < con_length; m++)
	{

	/*
	 * fprintf(stderr, "   %e   %e\n",
	 * C_r->vec[lines].x_vec[m],
	 * C_r->vec[lines].y_vec[m]);
	 */

	/*  could restrict the contour plottig here by the convex hull */

	p[m].x = user_to_pix_x(&mplot->gr, C_r->vec[lines].x_vec[m]);
	p[m].y = user_to_pix_y(&mplot->gr, C_r->vec[lines].y_vec[m]);
	}
      kcol = ((Col_Diff * (C_r->cont_level[k] - mplot->contParms.minmax.zmin)
	      / valdiff) + mplot->contParms.MinCol);

      /*
       * fprintf(stderr, "max color=%d\n",
       * mplot->MaxColor); fprintf(stderr, "min
       * color=%d\n", mplot->MinColor); fprintf(stderr,
       * "level=%f\n", C_r->cont_level[k]); fprintf(stderr,
       * "zmin=%f\n",mplot->contParms.minmax.zmin);
       * fprintf(stderr,
       * "zmax=%f\n",mplot->contParms.minmax.zmax);
       * fprintf(stderr, "kcol=%d\n", kcol);
       */

      XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		     colors[XmapAppColor(kcol)]);
      XDrawLines(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
		 p, con_length, CoordModeOrigin);
      XFlush(XtDisplay(mplot->wij));
      lines++;
      }
    }
  /* fprintf(stderr, "lines=%d\n", lines); */
  }

/*************************************************/

void get_r(char *str, double *rw, double *re, double *rs, double *rn)
  {
  char string[100], last[20];

  strcpy(string,str);
  strcpy(last, strrchr(string, '/'));
  *rn = atof(&last[1]);
  *rw = atof(strtok(string, "/"));
  *re = atof(strtok(NULL, "/"));
  *rs = atof(strtok(NULL, "/"));
  }

/*************************************************/

void get_i(char *str, double *ix, double *iy)
  {
  char string[50], last[20];

  strcpy(string, str);
  strcpy(last, strrchr(string, '/'));
  *iy = atof(&last[1]);
  *ix = atof(strtok(string,"/"));
  }

/*************************************************/

int isdigit_str(char *str)
  {
  int i;

  for(i = 0; str[i]; i++)
    if(!isdigit(str[i])) return(0);
  return(1);
  }

/*************************************************/

void contour_new_parms(mpic *mplot)
  {
  int levels;
  double ix,iy,rw,re,rs,rn;
  unsigned short int x, y, w, h;

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  
  /* fprintf(stderr,"In contour_new_parms\n"); */

#if 0
  free(mplot->contParms.cont_struct);
  free(mplot->contParms.surf_grd);
  /*PrintContParms(&mplot->contParms);*/
#endif

  PrintContParms(&mplot->contParms);

  if(isdigit_str(mplot->contParms.contfile))
    {
    levels = atoi(mplot->contParms.contfile);
    /* fprintf(stderr,"new levels = %d\n",levels); */
    cont_levels(levels, mplot->contParms.minmax.zmin,
		mplot->contParms.minmax.zmax);
    strcpy(mplot->contParms.contfile, "cont_file");
    }

  get_r(mplot->contParms.R, &rw, &re, &rs, &rn);
  get_i(mplot->contParms.I, &ix, &iy);

  /* fprintf(stderr,"ix=%f iy=%f rw=%f re=%f rs=%f rn=%f \n",
     ix,iy,rw,re,rs,rn); */

#if 0
  /* restriction on the size of the grid?  */
  if(ix > 100.00 || iy > 100.00)
    {
    fprintf(stderr,"too many steps for the grid, must expand grd dim\n");
    return;
    }
#endif

  Surf_Cont(mplot,mplot->contParms.datapt, mplot->contParms.length_data,
	    ix, iy, rw, re, rs, rn, mplot->contParms.A,
	    mplot->contParms.L, mplot->contParms.N,
	    mplot->contParms.T, mplot->contParms.X,
	    mplot->contParms.contfile, mplot->contParms.S,
	    mplot->contParms.Z);
  send_repaint(mplot->wij, 0, 0, w, h);
  /* draw_cont(mplot); */
  }

/*************************************************/

void Do_Contour_Field(Display *gdisp, char cont_infil[200], mpic *mplot)
  {
  float phi, lam, px, py, pz;
  double step_ix, step_iy, rw, re, rs, rn;
  int j, indat, numlines;
  char ichar[50], rchar[150], str[512];
  MINMAX mm;
  FILE *fp;

#if 0
  /* fprintf(stderr,"in do-contour-field, cont_infil=%s\n",cont_infil); */
  if(mplot->contParms.cont_struct != NULL)
    free(mplot->contParms.cont_struct);
  if(mplot->contParms.surf_grd != NULL)
    free(mplot->contParms.surf_grd);
#endif

  step_ix = 20;
  step_iy = 20;

  if(mplot->origin.nxblk > 70) step_ix = mplot->origin.nxblk / 2;
  if((mplot->origin.nxblk > 20 && mplot->origin.nxblk <= 70))
    step_ix = mplot->origin.nxblk;

  if(mplot->origin.nyblk>70) step_iy = mplot->origin.nyblk / 2;
  if((mplot->origin.nyblk>20 && mplot->origin.nyblk <= 70))
    step_iy = mplot->origin.nyblk;

  draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
		 100, 100, "Please Wait...", HJ_LEFT, VJ_BASELINE);
  XFlush(XtDisplay(mplot->wij));

  sprintf(ichar, "%g/%g\n", step_ix, step_iy);
  strcpy(mplot->contParms.I, ichar);
  mplot->contParms.A = ASP_A;
  mplot->contParms.L = CON_L;
  mplot->contParms.N = ITER_N;
  mplot->contParms.T = TENS_T;
  mplot->contParms.X = REL_X;
  strcpy(mplot->contParms.contfile, "cont_file");
  mplot->contParms.S = SMT_S;
  mplot->contParms.Z = MULT_Z;
  rw = 0.0;
  re = mplot->origin.maxx;
  rs = 0.0;
  rn = mplot->origin.maxy;
  sprintf(rchar, "%g/%g/%g/%g\n", rw, re, rs, rn);
  strcpy(mplot->contParms.R, rchar);

  numlines = Num_Lines(cont_infil);
  MAX_PTS = numlines;
  if(!(fp = fopen(cont_infil, "r")))
    {
    fprintf(stderr, "can't open field data file: %s\n", cont_infil);
    mplot->plot_cont_flag = 0;
    return;
    }

  if(!mplot->contParms.datapt)
    {
    if(!(mplot->contParms.datapt = XmapNewArray(PT, numlines)))
      {
      fprintf(stderr,"malloc error\n");
      mplot->plot_cont_flag = 0;
      return;
      }
    }

  for(j = 0; fgets(str, 512, fp) != NULL; j++)
    {
    if(j >= numlines)
      {
      fprintf(stderr, "numlines is not big enough for data points\n");
      exit(-1);
      }
    indat = sscanf(str, "%e %e %e", &py, &px, &pz);
    if(indat < 3)
      { 
      j--; 
      /* fprintf(stderr, "indat=%d j=%d\n",indat, j); */
      continue; 
      }
    /* fprintf(stderr, "%f   %f   %f\n",py,px,pz); */

    phi = py;
    lam = px;

    /*
       if (px < 0)
       lam = 0 - px;
       else
       lam = px;
       */

    geo2xy(mplot, phi, lam, &px, &py);

    /* fprintf(stderr," %f %f %f\n", px,py, pz); */
    if((py < 0) || (py > mplot->origin.maxy) || (px < 0.0)
       || (px > mplot->origin.maxx))
      {
      j--;
      continue;
      }
    mplot->contParms.datapt[j].lat = phi;
    mplot->contParms.datapt[j].lon = lam;

    mplot->contParms.datapt[j].x = px;
    mplot->contParms.datapt[j].y = py;
    mplot->contParms.datapt[j].z = pz;

    XDrawPoint(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
	       user_to_pix_x(&mplot->gr, px), user_to_pix_y(&mplot->gr, py));
    XFlush(XtDisplay(mplot->wij));

    if(j == 0) mm.zmin = mm.zmax = pz;
    else
      {
      if(pz > mm.zmax) mm.zmax = pz;
      if(pz < mm.zmin) mm.zmin = pz;
      }
    }
  mplot->contParms.length_data = j;
  mplot->contParms.minmax.zmin=mm.zmin;
  mplot->contParms.minmax.zmax=mm.zmax;

  /* fprintf(stderr,"length=%d, zmin=%e, zmax=%e\n",
     mplot->contParms.length_data,
     mplot->contParms.minmax.zmin,
     mplot->contParms.minmax.zmax); */

  cont_levels(D_LEVELS, mm.zmin, mm.zmax);

  /* fprintf(stderr," done cont_levels.....\n"); */

  Surf_Cont(mplot,mplot->contParms.datapt, mplot->contParms.length_data,
	    step_ix, step_iy, rw, re, rs, rn,
	    ASP_A, CON_L, ITER_N, TENS_T, REL_X,
	    CONT_C, SMT_S, MULT_Z);

  /* fprintf(stderr," done Surf_Cont.....\n"); */

/* fprintf(stderr,"do_c pointer mplot s_grd=%d\n",
   mplot->contParms.surf_grd); */

  mplot->plot_cont_flag = 1;

  /* draw_cont(mplot); */
  }

/*************************************************/

void Do_Contour_Field_NoDISP( char cont_infil[200], mpic *mplot)
  {
  float phi, lam, px, py, pz;
  double step_ix, step_iy, rw, re, rs, rn;
  int j, indat, numlines;
  char ichar[50], rchar[150], str[512];
  MINMAX mm;
  FILE *fp;

  numlines = Num_Lines(cont_infil);
  MAX_PTS = numlines;

  fprintf(stderr,"Please wait...reading in field, file=%s\n", cont_infil);

  /* step_ix = mplot->origin.nxblk / 2;
     step_iy = mplot->origin.nyblk / 2; */

  step_ix = 20;
  step_iy = 20;

  if(mplot->origin.nxblk > 70) step_ix = mplot->origin.nxblk / 2;
  if((mplot->origin.nxblk > 20 && mplot->origin.nxblk <= 70))
    step_ix = mplot->origin.nxblk;

  if(mplot->origin.nyblk > 70) step_iy = mplot->origin.nyblk / 2;
  if((mplot->origin.nyblk > 20 && mplot->origin.nyblk <= 70))
    step_iy = mplot->origin.nyblk;

  sprintf(ichar, "%g/%g\n", step_ix, step_iy);
  strcpy(mplot->contParms.I, ichar);
  mplot->contParms.A = ASP_A;
  mplot->contParms.L = CON_L;
  mplot->contParms.N = ITER_N;
  mplot->contParms.T = TENS_T;
  mplot->contParms.X = REL_X;
  strcpy(mplot->contParms.contfile, "cont_file");
  mplot->contParms.S = SMT_S;
  mplot->contParms.Z = MULT_Z;
  rw = rs = 0.0;
  re = mplot->origin.maxx;
  rn = mplot->origin.maxy;
  sprintf(rchar, "%g/%g/%g/%g\n", rw, re, rs, rn);
  strcpy(mplot->contParms.R, rchar);

  if(!(fp = fopen(cont_infil, "r")))
    {
    fprintf(stderr, "can't open contour file: %s\n", cont_infil);
    mplot->plot_cont_flag = 0;
    return;
    }
  if(!mplot->contParms.datapt)
    {
    if(!(mplot->contParms.datapt = XmapNewArray(PT, numlines)))
      {
      fprintf(stderr,"malloc error\n");
      mplot->plot_cont_flag = 0;
      return;      
      }
    }
    
  for(j = 0; fgets(str, 512, fp) != NULL; j++)
    {
    if(j >= numlines)
      {
      fprintf(stderr, "numlines is not big enough for data points\n");
      exit(-1);
      }
    indat = sscanf(str, "%e %e %e", &py, &px, &pz);
    if(indat < 3)
      { 
      j--; 
      /* fprintf(stderr, "indat=%d j=%d\n", indat, j); */
      continue;
      }

    /* fprintf(stderr, "px=%f, py=%f, pz=%f\n",py,px,pz); */

    phi = py;
    lam = px;

/*
    if(px < 0) lam = 0 - px;
    else lam = px;
*/

    geo2xy(mplot, phi, lam, &px, &py);

    /* fprintf(stderr," px=%f, py=%f\n", px,py); */
    if((py < 0) || (py > mplot->origin.maxy) || (px < 0.0)
       || (px > mplot->origin.maxx))
      {
      j--;
      continue;
      }
    mplot->contParms.datapt[j].x = px;
    mplot->contParms.datapt[j].y = py;
    mplot->contParms.datapt[j].z = pz;

    if(j == 0) mm.zmin = mm.zmax = pz;
    else
      {
      if(pz > mm.zmax) mm.zmax = pz;
      if(pz < mm.zmin) mm.zmin = pz;
      }
    }
  mplot->contParms.length_data = j;
  mplot->contParms.minmax.zmin = mm.zmin;
  mplot->contParms.minmax.zmax = mm.zmax;
  fprintf(stderr,"length=%d, zmin=%e, zmax=%e\n",
	  mplot->contParms.length_data,
	  mplot->contParms.minmax.zmin,
	  mplot->contParms.minmax.zmax);

  cont_levels(D_LEVELS, mm.zmin, mm.zmax);

  Surf_Cont(mplot,mplot->contParms.datapt, mplot->contParms.length_data,
	    step_ix, step_iy, rw, re, rs, rn,
	    ASP_A, CON_L, ITER_N, TENS_T, REL_X,
	    CONT_C, SMT_S, MULT_Z);

  mplot->plot_cont_flag = 1;

  fprintf(stderr," done getting contours.....\n");
  }

int PrintContParms(CONT_PARMS *pcontParms)
  {

  fprintf(stderr, "From Cont parms:\n");
  fprintf(stderr, "I=%s R=%s A=%g \n L=%g N=%g T=%g X=%g\n"
	  "contfile=%s S=%g Z=%g\n",
          pcontParms->I, pcontParms->R, pcontParms->A,
          pcontParms->L, pcontParms->N, pcontParms->T,
          pcontParms->X, pcontParms->contfile,
          pcontParms->S, pcontParms->Z);

  return(TRUE);
  }


