
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"

/* --- macros --- */

#define EARTHRAD	6378.163
#define ECCEN		0.0033670033
#define PO180		0.017453293
#define SIGN(A, B)	((B) < 0 ? -fabs(A) : fabs(A))

/* --- functions --- */

float fr(float t) 
  {
  float r = sin(t);

  return(1.0 - 0.0033670033 * sqr(r));
  }

float llconv(float x, float y, float z) 
  {
  float r = (x + y / 60.0 + z / 3600.0) * 0.017453293;

  return(r);
  }

void cgclc(float phio[3], float lamo[3], float phi[3], float lam[3], float *x,
	   float *y)
  {  
  float xsign = 1.0, ysign = -1.0, xlat, ylon, zlat, zlon, crlat, a, rho, b, c,
    cdist, zgcl;

  xlat = llconv(phi[0], phi[1], phi[2]);
  ylon = llconv(lam[0], lam[1], lam[2]);
  zlat = llconv(phio[0], phio[1], phio[2]);
  zlon = llconv(lamo[0], lamo[1], lamo[2]);

  crlat = atan(ECCEN * sin(2.0 * zlat) / fr(zlat));
  zgcl = zlat - crlat;
  a = fr(zgcl);
  rho = EARTHRAD * a;
  b = sqr(ECCEN * sin(2.0 * zgcl) / a) + 1.0;
  c = 2.0 * ECCEN * cos(2.0 * zgcl) * a + sqr(ECCEN * sin(2.0 * zgcl));
  cdist = c / (sqr(a) * b) + 1.0;
  *y = rho * (zlon - ylon) * cos(xlat - crlat) * ysign;
  *x = rho * xsign * (xlat - zlat) / cdist;
  }

void clcgc(float phio[3], float lamo[3], float phi[3], float lam[3],
	   float *ex, float *why)
  {
  float xsign = 1.0, ysign = -1.0, xlat, ylon, zlat, zlon, crlat, a, rho, b,
    c, cdist, rmin, zgcl, xl, t1, yl;

  /* printf( "clcgc input-> ex why: %f %f\n", *ex, *why); */ 

  zlat = llconv(phio[0], phio[1], phio[2]);
  zlon = llconv(lamo[0], lamo[1], lamo[2]);
  crlat = atan(ECCEN * sin(2.0 * zlat) / fr(zlat));
  zgcl = zlat - crlat;
  a = fr(zgcl);
  rho = EARTHRAD * a;
  c = ECCEN * sin(2.0 * zgcl) / a;
  b = sqr(c) + 1.0;
  c = (2.0 * ECCEN * cos(2.0 * zgcl) * a + ((ECCEN * sin(2.0 * zgcl)))
       * ((ECCEN * sin(2.0 * zgcl))));
  cdist = c / (sqr(a) * b) + 1.0;
  xlat = (*ex * xsign) * cdist / rho + zlat;
  xl = xlat / PO180;
  t1 = fabs(xl) + 0.5e-09;
  xl = SIGN(t1, xl);
  phi[0] = (int)xl;
  rmin = (xl - phi[0]) * 60.0;
  phi[1] = (int)rmin;
  phi[2] = (rmin - phi[1]) * 60.0;
  ylon = zlon - (*why * ysign) / (rho * cos(xlat - crlat));
  yl = ylon / PO180;
  t1 = fabs(yl) + 0.5e-09;
  yl = SIGN(t1, yl);
  lam[0] = (int)yl;
  rmin = (yl - lam[0]) * 60.0;
  lam[1] = (int)rmin;
  lam[2] = (rmin - lam[1]) * 60.0;

  /* printf( "clcgc  phi: %f %f %f lam: %f %f %f\n", phi[0], phi[1], phi[2],
     lam[0], lam[1], lam[2]); */
  }

void jgclc(float phio, float lamo, float phi, float lam, float *x, float *y)
  {  
  double  xsign = 1.0, ysign = -1.0, xlat, ylon, zlat, zlon, crlat, a, rho, b,
    c, cdist, zgcl;

  xlat = phi * 0.017453293;
  ylon = lam * 0.017453293;
  zlat = phio * 0.017453293;
  zlon = lamo * 0.017453293;

  crlat = atan(ECCEN * sin(2.0 * zlat) / fr(zlat));
  zgcl = zlat - crlat;
  a = fr(zgcl);
  rho = EARTHRAD * a;
  b = sqr(ECCEN * sin(2.0 * zgcl) / a) + 1.0;
  c = 2.0 * ECCEN * cos(2.0 * zgcl) * a + sqr(ECCEN * sin(2.0 * zgcl));
  cdist = c / (sqr(a) * b) + 1.0;
  *y = rho * (zlon - ylon) * cos(xlat - crlat) * ysign;
  *x = rho * xsign * (xlat - zlat) / cdist;
  }

void jlcgc(float phio, float lamo, float *phi, float *lam, float ex, float why)
  {
  double  xsign = 1.0, ysign = -1.0, xlat, ylon, zlat, zlon, crlat, a, rho, b,
    c, cdist, zgcl, xl, t1, yl;

 

  zlat = phio * 0.017453293;
  zlon = lamo * 0.017453293;

  crlat = atan(ECCEN * sin(2.0 * zlat) / fr(zlat));
  zgcl = zlat - crlat;
  a = fr(zgcl);
  rho = EARTHRAD * a;
  c = ECCEN * sin(2.0 * zgcl) / a;
  b = sqr(c) + 1.0;
  c = (2.0 * ECCEN * cos(2.0 * zgcl) * a + ((ECCEN * sin(2.0 * zgcl)))
       * ((ECCEN * sin(2.0 * zgcl))));
  cdist = c / (sqr(a) * b) + 1.0;
  xlat = (ex * xsign) * cdist / rho + zlat;
  xl = xlat / PO180;
  t1 = fabs(xl) + 0.5e-09;
  xl = SIGN(t1, xl);
  *phi = xl;
  ylon = zlon - (why * ysign) / (rho * cos(xlat - crlat));
  yl = ylon / PO180;
  t1 = fabs(yl) + 0.5e-09;
  yl = SIGN(t1, yl);
  *lam =  yl;

  

      
  }



