
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <ctype.h>

/* --- local headers --- */

#include "geotouch.h"
#include "origin.h"

/* --- function prototypes --- */

void break_line(char *line, int *fake_argc, char **fake_argv);
int getline(FILE *input,char s[],int lim);

/* --- functions --- */

void get_parname(char *p, char *in)
  {
  int i;
  int len = strlen(in);

  strcpy(p, in);
  for(i = 0; i < len; i++)
    {
    if(in[i] == ' ' || in[i] == '=')
      {
      p[i] = '\0';
      return;
      }
    }
  }

int get_parpoint(char *in)
  {
  int i, len = strlen(in);

  for(i = 0; i < len; i++)
    {
    if(in[i] == '=')
      {
      return(i + 1);
      break;
      }
    }
  return(0);
  }

int Get_org(ORG *org, char *file)
  {
  FILE *lf;
  char line[100], temline[100], par[100], *fake_argv[100];
  float spac, spacx, spacy, tempdeg;
  int numi, k, org_type, projtype, nxblk, nyblk, layz, fake_argc, iyesno;

  if((lf = fopen(file, "r")) == NULL)
    {
    fprintf(stderr, "Can't open input origin file %s ...STOPPING\n", file);
    exit(0);
    }

  numi = getline(lf, line, 100);
  strcpy(temline, line);
  break_line(temline, &fake_argc, fake_argv);

  /* printf("nargs = %d\n", fake_argc);
     iyesno = isalpha(fake_argv[0][0]);
     fprintf(stderr, "alpha start = %d\n", iyesno); */

  iyesno = isdigit(fake_argv[0][0]);

  /* fprintf(stderr,"digit start = %d\n",iyesno); */

  if(iyesno == 0)
    {
    fprintf(stderr, " reading in a new origin file \n");

    while((numi = getline(lf, line, 100)) > 0)
      {
      if(line[0] == '#') continue;
      get_parname(par, line);
      k = get_parpoint(line);
      /* fprintf(stderr, "par=%s line=<%s", par, line); */

      if(!strcmp(par, "type"))
        org->type = org_type = atoi(line + k);
      if(!strcmp(par, "proj"))
        org->proj = projtype = atoi(line + k);
      if(!strcmp(par, "nx"))
	org->nxblk = nxblk = atoi(line + k);
      if(!strcmp(par, "ny"))
        org->nyblk = nyblk = atoi(line + k);
      if(!strcmp(par, "nz"))
	org->nzblk =  layz = atoi(line + k);
      if(!strcmp(par, "dx"))
        org->dx = spacx = atof(line + k);
      if(!strcmp(par, "dy"))
        org->dy = spacy = atof(line + k);

      if(!strcmp(par, "lat"))
	{
	strcpy(temline, line + k);
	break_line(temline, &fake_argc, fake_argv);
	/* printf("lat nargs = %d\n", fake_argc); */

	switch(fake_argc)
	  {
	  case 1: 
	    org->phi = atof(fake_argv[0]);
	    break;

	  case 2: 
	    org->phi = atof(fake_argv[0]);
	    org->phimin = org->phi;
	    org->phimax = atof(fake_argv[1]);
	    break;

	  case 3: 

            tempdeg = atof(fake_argv[0]);
	    if(tempdeg>0)  {
		        
	      org->phi = (tempdeg + atof(fake_argv[1]) / 60.0
			  + atof(fake_argv[2]) / 3600.0);
	    }
	    else
	      {
		org->phi = (tempdeg - atof(fake_argv[1]) / 60.0
			    -  atof(fake_argv[2]) / 3600.0);
	      }
			
	    
	    break;
	  }
	}

      if(!strcmp(par, "lon"))
	{
	strcpy(temline, line + k);
	break_line(temline, &fake_argc, fake_argv);
	/* printf("lon nargs = %d\n", fake_argc); */

	switch(fake_argc)
	  {
	  case 1: 
	    org->lam = atof(fake_argv[0]);
	    break;

	  case 2: 
	    org->lam = atof(fake_argv[0]);
	    org->lammin = org->lam;
	    org->lammax = atof(fake_argv[1]);
	    break;

	  case 3:
            tempdeg = atof(fake_argv[0]);
	    if(tempdeg>0)  {
		        
	      org->lam = (tempdeg + atof(fake_argv[1]) / 60.0
			  + atof(fake_argv[2]) / 3600.0);
	    }
	    else
	      {
		org->lam = (tempdeg - atof(fake_argv[1]) / 60.0
			    -  atof(fake_argv[2]) / 3600.0);
	      }
			   
	      
	    
	    break;
	  }
	}
      if(!strcmp(par, "center"))
	{
	  strcpy(temline, line + k);
	  break_line(temline, &fake_argc, fake_argv);
        org->phi0 = atof(fake_argv[0]);
        org->lam0 = atof(fake_argv[1]);
	

	}
      }
    return(1);
    }

  if(fake_argc == 6)
    {
    sscanf(line, "%d %d %d %d %d %f", &org_type, &projtype, &nxblk, &nyblk,
	   &layz, &spac);

    org->type = org_type;
    org->proj = projtype;
    org->nxblk = nxblk;
    org->nyblk = nyblk;
    org->nzblk = layz;
    org->dx = spac;
    org->dy = spac;

    numi = getline(lf, line, 100);
    strcpy(temline, line);
    break_line(temline, &fake_argc, fake_argv);

    /* fprintf(stderr, "lat nargs=%d\n",fake_argc); */

    switch(fake_argc)
      {
      case 1: 
        org->phi = atof(fake_argv[0]);
	break;

      case 2: 
	org->phi = atof(fake_argv[0]);
	org->phimin = org->phi;
	org->phimax = atof(fake_argv[1]);
	break;

      case 3: 
            tempdeg = atof(fake_argv[0]);
	    if(tempdeg>0)  {
		        
	      org->phi = (tempdeg + atof(fake_argv[1]) / 60.0
			  + atof(fake_argv[2]) / 3600.0);
	    }
	    else
	      {
		org->phi = (tempdeg - atof(fake_argv[1]) / 60.0
			    -  atof(fake_argv[2]) / 3600.0);
	      }
			
	
	break;
      }

    numi = getline(lf, line, 100);
    strcpy(temline, line);
    break_line(temline, &fake_argc, fake_argv);

    /* fprintf(stderr, "lon nargs=%d\n", fake_argc); */

    switch(fake_argc)
      {
      case 1: 
        org->lam = atof(fake_argv[0]);
	break;

      case 2: 
	/* fprintf(stderr, "case 6 2 %s %s\n", fake_argv[0], fake_argv[1]);
	   sscanf(line, "%f %f", &org->lam, &org->lammax); */
	org->lam = atof(fake_argv[0]);
	org->lammin = org->lam;
	org->lammax = atof(fake_argv[1]);
	break;

      case 3:
            tempdeg = atof(fake_argv[0]);
	    if(tempdeg>0)  {
		        
	      org->lam = (tempdeg + atof(fake_argv[1]) / 60.0
			  + atof(fake_argv[2]) / 3600.0);
	    }
	    else
	      {
		org->lam = (tempdeg - atof(fake_argv[1]) / 60.0
			    -  atof(fake_argv[2]) / 3600.0);
	      }
			   
	break;
      }
    /* fprintf(stderr, "done 6\n"); */
    return(1);
    }

  if(fake_argc == 7)
    {
    sscanf(line, "%d %d %d %d %d %f %f", &org_type, &projtype, &nxblk,
	   &nyblk, &layz, &spacx, &spacy);
    org->type = org_type;
    org->proj = projtype;
    org->nxblk = nxblk;
    org->nyblk = nyblk;
    org->nzblk = layz;
    org->dx = spacx;
    org->dy = spacy;
    numi = getline(lf, line, 100);
    strcpy(temline, line);
    break_line(temline, &fake_argc, fake_argv);

    switch(fake_argc)
      {
      case 1: 
        org->phi = atof(fake_argv[0]);
	break;

      case 2: 
	org->phi = atof(fake_argv[0]);
	org->phimin = org->phi;
	org->phimax = atof(fake_argv[1]);
	break;

      case 3: 
           tempdeg = atof(fake_argv[0]);
	    if(tempdeg>0)  {
		        
	      org->phi = (tempdeg + atof(fake_argv[1]) / 60.0
			  + atof(fake_argv[2]) / 3600.0);
	    }
	    else
	      {
		org->phi = (tempdeg - atof(fake_argv[1]) / 60.0
			    -  atof(fake_argv[2]) / 3600.0);
	      }
			

	
	break;
      }

    numi = getline(lf, line, 100);
    strcpy(temline, line);
    break_line(temline, &fake_argc, fake_argv);

    switch(fake_argc)
      {
      case 1: 
        org->lam = atof(fake_argv[0]);
	break;

      case 2: 
	org->lam = atof(fake_argv[0]);
	org->lammin = org->lam;
	org->lammax = atof(fake_argv[1]);
	break;

      case 3: 
            tempdeg = atof(fake_argv[0]);
	    if(tempdeg>0)  {
		        
	      org->lam = (tempdeg + atof(fake_argv[1]) / 60.0
			  + atof(fake_argv[2]) / 3600.0);
	    }
	    else
	      {
		org->lam = (tempdeg - atof(fake_argv[1]) / 60.0
			    -  atof(fake_argv[2]) / 3600.0);
	      }

	
	break;
      }
    return(1);
    }
  return(0);
  }

void Dump_org(ORG *org)
  {

  /* printf("Dump: type=%d proj=%d nx=%d ny=%d nz=%d\n", org->type, org->proj,
     org->nxblk, org->nyblk, org->nzblk);
     printf("Dump: dx=%f dy=%f \n", org->dx, org->dy);
     printf("Dump: phi=%f lam=%f \n", org->phi, org->lam);
     printf("Dump: phimin=%f  phimax=%f lammin=%f lammax=%f \n", org->phimin,
     org->phimax, org->lammin, org->lammax); */
  
  printf("Input Origin:\n");
  if(org->type <= 1)
    {
    printf("%d  %d  %d  %d  %d %f %f\n", org->type, org->proj, org->nxblk,
	   org->nyblk, org->nzblk, org->dx, org->dy);
    printf("%f\n%f\n", org->phi, org->lam);
    }

  if(org->type == 2)
    {
    printf("%d  %d  %d  %d  %d %f %f\n", org->type, org->proj, org->nxblk,
	   org->nyblk, org->nzblk, org->dx, org->dy);
    printf("%f %f\n", org->phimin, org->phimax);
    printf("%f %f\n", org->lammin, org->lammax);
    }
  }
