
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"

/* --- macros --- */

#define IGREG (15 + 31L * (10 + 12L * 1582))

/* --- functions --- */

long julday(int mm, int id, int iyyy)
  {
  void nrerror(char error_text[]);
  long jul;
  int ja, jy = iyyy, jm;

  if(jy == 0) fprintf(stderr,"julday: there is no year zero.");
  if(jy < 0) ++jy;
  if(mm > 2) jm = mm + 1;
  else --jy, jm = mm + 13;

  jul = (long)(floor(365.25 * jy) + floor(30.6001 * jm) + id + 1720995);
  if(id + 31L * (mm + 12L * iyyy) >= IGREG)
    {
    ja = (int)(0.01 * jy);
    jul += 2 - ja + (int)(0.25 * ja);
    }
  return jul;
  }

#undef IGREG

/*------------------------------------------------------*/

/* given a year a month and day, return the julian day */ 

void tojul(int year, int month, int day, int *jul)
  {
  int yy, mm, dd, c, ya;

  yy = year, mm = month, dd = day;
  *jul = 0;
  if(mm > 2) yy = yy + 0;
  else yy--;
  if(mm > 2) mm -= 3;
  else mm +=9;

  c = (int)(yy / 100);
  ya = yy - 100 * c;
  *jul = ((int)((146097 * c) / 4) + (int)((1461 * ya) / 4)
	  + (int)((153 * mm + 2) / 5) + dd + 1721119);
  }

/*------------------------------------------------------*/

void fromjul(int yy, int *mm, int *dd, int jul)
  {
  int j = jul - 1721119;

  yy = (int)((4 * j - 1) / 146097);
  j = 4 * j - 1 - 146097 * yy;
  *dd = (int)(j / 4);
  j = (int)((4 * *dd + 3) / 1461);
  *dd = 4 * *dd + 3 - 1461 * j;
  *dd = (int)((*dd + 4) / 4);
  *mm = (int)((5 * *dd - 3) / 153);
  *dd = 5 * *dd - 3 - 153 * *mm;
  *dd = (int)((*dd + 5) / 5);
  yy = 100 * yy + j;
  if(*mm < 10) yy = yy + 0;
  else yy++;
  if(*mm < 10) *mm += 3;
  else *mm -= 9;
  }

/*------------------------------------------------------*/

/* given year and julian date, return the month and the day of the month */    

void getmoday(int iyear, int jul, int *imo, int *iday)
  {
  int mo, dd, inine, ijul;

  tojul(iyear, 1, 1, &inine);
  ijul = inine + jul - 1;
  fromjul(iyear, &mo, &dd, ijul);
  *imo = mo;
  *iday = dd;
  }
 
int daydiff(int iyear1, int jul1, int iyear2, int jul2)
  {
  int inine, ajul;

  tojul(iyear1, 1, 1, &inine);
  tojul(iyear2, 1, 1, &ajul);
  return ((ajul - inine) + (jul2 - jul1));
  }
