
/****   misc subroutines for plotting the Xmap stuff  ***********/

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"

#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "focproto.h"

int Foc_Color(float rake, mpic *m)
  {

  /***********FOC COLOR*******************/
  
  /* strikeslip */
  if(fabs(rake) <= 15.0) return(m->strikeslip_col);

  /* strikeslip */
  if(fabs((180.0 - fabs(rake))) <= 15.0) return(m->strikeslip_col);

  /* rev-obl strk-slp */
  if((rake >= 15.0 && rake < 45) || (rake >= 135 && rake < 165))
    return(m->rev_oblSS_col);

  /* oblique reverse */      
  if((rake >= 45.0 && rake < 75) || (rake >= 105 && rake < 135))
    return(m->obl_rev_col);

  /* reverse */            
  if(rake >= 75.0 && rake < 105.0) return(m->reverse_col);

  /* norm-oblq strkslp */   
  if((rake < -15.0 && rake >= -45) || (rake < -135 && rake >= -165))
    return(m->norm_oblSS_col);

  /* oblq norm */            
  if((rake < -45.0 && rake >= -75) || (rake < -105 && rake >= -135))
    return(m->oblq_norm_col);

  /* normal */              
  if(rake < -75.0 && rake >= -105)  return(m->normal_col);

  fprintf(stderr, "Cannot determine Focal type. rake1=%f\n",rake);
  return(0);
  }

  /*     a mechanism has been chosen and needs to be switched
         The switching involves only swapping the
         focal planes, and the type of the earthquake   */

void switch_foc(mpic *m, int kfoc)
  { 
  int i, j, num1, numft1;
  float xtr[FOC_TRACE],ytr[FOC_TRACE], strk, dip, urot, udip, ang, dipaz1,
    rake1, dipaz2, rake2, dis, focx[FAULT_TRACE], focy[FAULT_TRACE];

  /* make a copy of the information on the fault plane */
  i = m->focal_selection;
  if(i < 0) return;

  num1 = m->focm[kfoc].focs[i].num1;
  for(j = 0; j < num1; j++)
    {
    xtr[j] =  m->focm[kfoc].focs[i].traj1[j].x;
    ytr[j] =  m->focm[kfoc].focs[i].traj1[j].y;
    }
  strk = m->focm[kfoc].focs[i].fm.strk1;
  dip = m->focm[kfoc].focs[i].fm.dip1;
  urot = m->focm[kfoc].focs[i].fm.urot;
  udip = m->focm[kfoc].focs[i].fm.udip;
  numft1 =  m->focm[kfoc].focs[i].numft1;

  for(j = 0; j < numft1; j++)
    {
    focx[j]  = m->focm[kfoc].focs[i].fault[j].x;
    focy[j]=   m->focm[kfoc].focs[i].fault[j].y;
    }

  /**********   copy the information from 2 onto 1 ********/

  m->focm[kfoc].focs[i].fm.strk1 = m->focm[kfoc].focs[i].fm.strk2;
  m->focm[kfoc].focs[i].fm.dip1 = m->focm[kfoc].focs[i].fm.dip2;
  m->focm[kfoc].focs[i].fm.urot = m->focm[kfoc].focs[i].fm.vrot;
  m->focm[kfoc].focs[i].fm.udip = m->focm[kfoc].focs[i].fm.vdip;
          
  for(j = 0; j < m->focm[kfoc].focs[i].num2; j++)
    {
    m->focm[kfoc].focs[i].traj1[j].x = m->focm[kfoc].focs[i].traj2[j].x;
    m->focm[kfoc].focs[i].traj1[j].y = m->focm[kfoc].focs[i].traj2[j].y;
    }

  for(j = 0; j < m->focm[kfoc].focs[i].numft2; j++)
    {
    m->focm[kfoc].focs[i].fault[j].x = m->focm[kfoc].focs[i].aux[j].x;
    m->focm[kfoc].focs[i].fault[j].y = m->focm[kfoc].focs[i].aux[j].y;
    }
  m->focm[kfoc].focs[i].num1 = m->focm[kfoc].focs[i].num2;
  m->focm[kfoc].focs[i].numft1 = m->focm[kfoc].focs[i].numft2;

  /***************   copy from the temp to Auxilliary plane  *******/
 
  m->focm[kfoc].focs[i].fm.strk2 = strk;
  m->focm[kfoc].focs[i].fm.dip2 = dip;
  m->focm[kfoc].focs[i].fm.vrot = urot;
  m->focm[kfoc].focs[i].fm.vdip = udip;

  m->focm[kfoc].focs[i].num2 = num1;
  m->focm[kfoc].focs[i].numft2 = numft1;

  for(j = 0; j < num1; j++)
    {
    m->focm[kfoc].focs[i].traj2[j].x = xtr[j];
    m->focm[kfoc].focs[i].traj2[j].y = ytr[j];
    }
               
  for(j = 0; j < numft1; j++)
    {
    m->focm[kfoc].focs[i].aux[j].x = focx[j];
    m->focm[kfoc].focs[i].aux[j].y = focy[j];
    }

  /*   here change the color of the earthquake for future plotting  */

  if(m->focm[kfoc].focs[i].ipol == 0) ang = 1.0;
  else ang = -1.0;

  Rake_Cal(m->focm[kfoc].focs[i].fm.strk1, m->focm[kfoc].focs[i].fm.dip1,
	   m->focm[kfoc].focs[i].fm.strk2, m->focm[kfoc].focs[i].fm.dip2,
	   ang, &dipaz1, &rake1, &dipaz2, &rake2);

  dis = rake1;
  m->focm[kfoc].focs[i].type = Foc_Color(rake1, m);
  }


