#include <stdlib.h>

int tred2_(int *nm, int *n, float *a, float *d, float *e, float *z);
int tql2_(int *nm, int *n, float *d, float *e, float *z, int *ierr);

/* Subroutine */ int eigvct_(float *a, int *n, int *nm, float *wrk1, float *o, float *lam, int *ierr)

{
    /* System generated locals */
    int a_dim1, a_offset, o_dim1, o_offset;

    /* Builtin functions */
    /* Subroutine  int s_stop();*/

    /* Local variables */
    extern /* Subroutine */ int tred2_(), tql2_();

/*      c      Finds eigenvalues and eigen vectors of real symetric
c      matrix a, by orthagonal transformation to tridiagonal
c      form, and then QL decompositions on that.  See comments
c      in TRED2 and TQL2 for more info.
c
c       Inputs: a(nm,n)   n by n matrix, dimensioned a(nm,~) in main
c               n       rank of a
c               nm      row dimension of a & o in main
c       Workspace:  wrk1(n)
c       Outputs: o(nm,n)  eigenvectors (columns), matching order of lam
c               lam(n)  eigenvalues in ascending order
c               ierr    =0;    normal termination
c                       =i;    convergence failed on i'th eigenvalue
c                              i'th to n'th vectors and values are 
c                              meaningless.  1st to (i-1)'th are values
c                              unsorted.
c                a= O lam Ot
c       NOTE: a & o may be stored in same space in the main with no effect
c             other than overwriting a.
 */
    /* Parameter adjustments */
    --lam;
    --wrk1;
    o_dim1 = *nm;
    o_offset = o_dim1 + 1;
    o -= o_offset;
    a_dim1 = *nm;
    a_offset = a_dim1 + 1;
    a -= a_offset;

    /* Function Body */
    tred2_(nm, n, &a[a_offset], &lam[1], &wrk1[1], &o[o_offset]);
    tql2_(nm, n, &lam[1], &wrk1[1], &o[o_offset], ierr);
    if (*ierr != 0) {
/*         print*,'eigenvalue convergence failure in ',ierr */
/*     .         ,'''th value' */
	/*s_stop("", 0L);*/
        exit(0);
    }
    return 0;
} /* eigvct_ */

