/*
 * fileSelectWidget
 *
 * Athena-based file browsing/selector widget (a descendant of Composite)
 *
 * v1.0 - Mark A. Lindner - April, 1995
 *
 */

#ifndef _fselP_h
#define _fselP_h

/***********************************************************************
 *
 * fileSelect Widget Private Data
 *
 ***********************************************************************/

#include "fsel.h"

#include <X11/CompositeP.h>

typedef struct _FileSelectClass
  {
  int empty;
  } FileSelectClassPart;

/* Full class record declaration */
typedef struct _FileSelectClassRec
  {
  CoreClassPart core_class;
  CompositeClassPart composite_class;
  FileSelectClassPart fileSelect_class;
  } FileSelectClassRec;

extern FileSelectClassRec fileSelectClassRec;

/* New fields for the fileSelect widget record */

typedef struct
  {
  Dimension h_space, v_space;
  Dimension preferred_width, preferred_height;
  Dimension last_query_width, last_query_height;
  XtGeometryMask last_query_mode;
  char *path;
  char *file;

  /* local buffers */
  Widget w_list;
  Widget w_text;
  Widget w_vbar;
  Widget w_port;
  Widget w_setpath;
  Widget w_cancel;
  Widget w_chdir;
  Widget w_label;
  char **list;
  int listlen;
  int listsize;
  int sel;
  char *curpath;
  char *editbuf;
  XtCallbackList callbacks;
  } FileSelectPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _FileSelectRec
  {
  CorePart	  core;
  CompositePart   composite;
  FileSelectPart  fileSelect;
  } FileSelectRec;

#endif
