/* global definitions for entire program */

#ifndef _geotouch_h
#define _geotouch_h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stddef.h>
#include <math.h>
#include <sys/stat.h>

/* typedefs */

typedef char bool_t;

#ifdef TRUE
#undef TRUE
#endif

#define TRUE (1)

#ifdef FALSE
#undef FALSE
#endif

#define FALSE (0)

typedef struct phook_t
  {
  void *a;
  void *b;
  } phook_t;

typedef struct
  {
  float x, y, z;
  } fxyz;

typedef struct
  {
  float deg, min, sec;
  } angle;
 
typedef struct
  {
  int x, y, z;
  } xyz;

typedef struct
  {
  short x, y, z;
  } sxyz;

typedef struct
  {
  float x1, y1, x2, y2;
  } fxyxy;
 
typedef struct
  {
  int x1, y1, x2, y2;
  } xyxy;
 
typedef struct
  {
  float x, y;
  } fxy;
 
typedef struct
  {
  int x, y;
  } xy;

extern int isnan(double);

/* convenience constants */

#define XMAP_PI		3.14159265358979323846264338327950288 /* pi */
#define XMAP_PI_2	1.57079632679489661923132169163975144 /* pi/2 */
#define XMAP_1_PI	0.31830988618379067153776752674502872 /* 1/pi */
#define XMAP_SQRT2	1.41421356237309504880168872420969808 /* sqrt(2) */
#define XMAP_SQRT1_2	0.70710678118654752440084436210484903 /* sqrt(.5) */
#define XMAP_E		2.71828182845904523536028747135266250 /* e */

/* convenience macros */

#define sqr(X)		((X) * (X))

#define max2(A, B)	(((A) < (B)) ? (B) : (A))

#define min2(A, B)	(((A) > (B)) ? (B) : (A))

#define rad2deg(R)	((R) * 180.0 / XMAP_PI)

#define deg2rad(D)	((D) * XMAP_PI / 180.0)

#define sgn(N)		(((N) >= 0) ? (((N) > 0) ? 1 : 0) : -1)

#define inv(A)		(1.0 / (A))

#define nan(A)		isnan(A)

#define mknan(A)	(((unsigned long *) &x)[0] = 0x7fffffff, \
			 ((unsigned long *) &x)[1] = 0xffffffff)

#define dist1d(X, Y) \
	(abs((X) - (Y)))

#define dist2d(X1, Y1, X2, Y2) \
	(sqrt((float)(pow((double)((X2) - (X1)), 2)) \
	      + (float)(pow((double)((Y2) - (Y1)), 2))))

#define dist3d(X1, Y1, Z1, X2, Y2, Z2) \
	 (sqrt((float)(pow((double)((X2) - (X1)), 2)) \
	       + (float)(pow((double)((Y2) - (Y1)), 2)) \
	       + (float)(pow((double)((Z2) - (Z1)), 2))))

#define XmapNewArray(T, N) \
	(T *)calloc((size_t)(N), sizeof(T))

#define XmapNewElement(T) \
	XmapNewArray(T, 1)

#define XmapNewString(N) \
	XmapNewArray(char, N)

#define XmapFree(P) \
	free((void *)(P))




/* color macros */

/* total # of colors available */
#define COLORS_MAX		(256)	/* this one is adjustible */

/* # of colors we use for window manager color mirroring */
#define COLORS_WM		(32)	/* this one is adjustible */
#define COLORS_WM_BASE		(0)

/* # of colors we use for application */
#define COLORS_APP		(224)	/* this one is adjustible */
#define COLORS_APP_BASE		(COLORS_WM_BASE + COLORS_WM) 

/* # of colors left for quantization */
#define COLORS_QUANT		(COLORS_MAX - COLORS_APP - COLORS_WM)
#define COLORS_QUANT_BASE	(COLORS_APP_BASE + COLORS_APP)

/* to get ith window manager color */
#define XmapWMColor(I)		((I) + COLORS_WM_BASE)

/* to get ith application color */
#define XmapAppColor(I)		((I) + COLORS_APP_BASE)

/* to get ith quantization color */
#define XmapQuantColor(I)	((I) + COLORS_QUANT_BASE)


/* --- non-POSIX function declarations --- */

extern double hypot(double x, double y);
extern char *gcvt(double value, int len, char *buffer);
extern int lstat(const char *path, struct stat *buffer);

#ifdef SUNOS
#define getcwd getwd
#endif

#ifdef SOLARIS
#define XmapSleep(n) nanosleep((n)*1000)
#endif

#ifdef SUNOS
#define XmapSleep usleep
#endif

#ifdef AIX
#define XmapSleep usleep
#endif

#endif /* _geotouch_h */
