/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>


#include <ctype.h>


/* --- local headers --- */

#include "geotouch.h"

#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jutil.h"
#include "focproto.h"

#include "user2pix.h"



int Foc_Color(float dis, mpic *m);


int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);


void Init_Focs(mpic *mplot)
  {
  int i, j, kount, ipol, iplotpt = 0, iang = 5, num1, num2,
    incang;
  float xtr1[FOC_TRACE], xtr2[FOC_TRACE], ytr1[FOC_TRACE], ytr2[FOC_TRACE],
    *focx, *focy, phi, lam, px, py, meanX, meanY, maxMag, minMag, dismax, dis,
     dipaz1, rake1, dipaz2, rake2, ang, ang2;

  /* start init here  */
 
  kount = mplot->num_focm_files - 1;
  for(kount=0; kount<mplot->num_focm_files; kount++)
    {
    for(i = 0; i < mplot->focm[kount].numpoints; i++)
      {
      Beach_ball(&mplot->focm[kount].focs[i].fm.strk1, 
		 &mplot->focm[kount].focs[i].fm.dip1,
		 &mplot->focm[kount].focs[i].fm.strk2,
                 &mplot->focm[kount].focs[i].fm.dip2,
		 &mplot->focm[kount].focs[i].fm.prot,
		 &mplot->focm[kount].focs[i].fm.pdip,
                  &mplot->focm[kount].focs[i].fm.trot,
		 &mplot->focm[kount].focs[i].fm.tdip,
		 &iplotpt, iang, xtr1, ytr1,&num1, xtr2, ytr2, &num2, &ipol);

      for(j = 0; j < num1; j++)
	{
	mplot->focm[kount].focs[i].traj1[j].x = xtr1[j];
	mplot->focm[kount].focs[i].traj1[j].y = ytr1[j];
	}

      for(j = 0; j < num2; j++)
	{
	mplot->focm[kount].focs[i].traj2[j].x = xtr2[j];
	mplot->focm[kount].focs[i].traj2[j].y = ytr2[j];
	}

      mplot->focm[kount].focs[i].ipol = ipol;
      mplot->focm[kount].focs[i].num1 = num1;
      mplot->focm[kount].focs[i].num2 = num2; 

      ang = mplot->focm[kount].focs[i].fm.dip1;
      ang2 = mplot->focm[kount].focs[i].fm.strk1 - 90.0; 

      focx = alloc_fvec(0, FAULT_TRACE);
      focy = alloc_fvec(0, FAULT_TRACE);

      Plane_Traj(ang, ang2, focx, focy, &num1);
      for(j = 0; j < num1; j++)
	{
	mplot->focm[kount].focs[i].fault[j].x = focx[j];
	mplot->focm[kount].focs[i].fault[j].y = focy[j];
	}
      mplot->focm[kount].focs[i].numft1 = num1;
      ang = mplot->focm[kount].focs[i].fm.dip2;
      ang2 = mplot->focm[kount].focs[i].fm.strk2 - 90.0; 

      Plane_Traj(ang, ang2, focx, focy, &num2);
      for(j = 0; j < num2; j++)
	{
	mplot->focm[kount].focs[i].aux[j].x = focx[j];
	mplot->focm[kount].focs[i].aux[j].y = focy[j];
	}
      mplot->focm[kount].focs[i].numft2 = num2;
      free_fvec(focx, 0, FAULT_TRACE); 
      free_fvec(focy, 0, FAULT_TRACE); 

      /* determine the type of the fault: for now I am using the dip of the
	 U axis Until I figure out a better way to determine rake! */

      if(ipol == 0) ang = 1.0;
      else ang = -1.0;

      Rake_Cal(mplot->focm[kount].focs[i].fm.strk1,
	       mplot->focm[kount].focs[i].fm.dip1,
	       mplot->focm[kount].focs[i].fm.strk2,
	       mplot->focm[kount].focs[i].fm.dip2,
	       ang, &dipaz1, &rake1, &dipaz2, &rake2);

      /* from J.C. Pechmann, July 1986 */

      dis = rake1;

      /* FOC COLOR */

      mplot->focm[kount].focs[i].type = Foc_Color(dis, mplot);
      }

    maxMag = max2(maxMag, mplot->focm[kount].focs[1].ac.mag);
    minMag = min2(minMag, mplot->focm[kount].focs[1].ac.mag);

    /* get the mean X and Y positions of the focal mechs */

    maxMag = max2(maxMag, mplot->focm[kount].focs[1].ac.mag);
    minMag = min2(minMag, mplot->focm[kount].focs[1].ac.mag);
    incang = (int)(360.0 / (float)mplot->focm[kount].numpoints);
    
    for(i = 0; i <  mplot->focm[kount].numpoints; i++)
      {
      phi = mplot->focm[kount].focs[i].loc.x;
      lam = mplot->focm[kount].focs[i].loc.y;
      geo2xy(mplot, phi, lam, &px, &py);

      meanX += px;
      meanY += py;

      maxMag = max2(maxMag, mplot->focm[kount].focs[i].ac.mag);
      minMag = min2(minMag, mplot->focm[kount].focs[i].ac.mag);
      }
    meanX = meanX / (float)mplot->focm[kount].numpoints;
    meanY = meanY / (float)mplot->focm[kount].numpoints;

    /* get the max distance from the mean point!  */
    dismax = 0.0;
    for(i = 0; i < mplot->focm[kount].numpoints; i++)
      {
      phi = mplot->focm[kount].focs[i].loc.x;
      lam = mplot->focm[kount].focs[i].loc.y;
      geo2xy(mplot, phi, lam, &px, &py);
      dis = sqrt((meanX - px) * (meanX - px) + (meanY - py) * (meanY - py));
      dismax = max2(dis, dismax);

      }
    
    xy2geo(mplot,  &phi,  &lam,meanX, meanY);
    mplot->focm[kount].meanPhi = phi;
    mplot->focm[kount].meanLam = lam;

    mplot->focm[kount].maxMag = maxMag;
    mplot->focm[kount].minMag = minMag;
    mplot->focm[kount].disMax = dismax;
    }

  mplot->focal_plot_style = 1;
  mplot->focal_explode = 0;
  mplot->focal_mag_scale = 0;
  }


void Set_Explode_Focs(mpic *mplot)
{
  /* find angle for exploding display */
  int kount, i;
  float phi, lam, px, py;
  float meanX, meanY, dismax, dis,ang, ang2;
  

    
  for(kount=0; kount < mplot->num_focm_files; kount++)
    {
      dismax = mplot->focm[kount].disMax;
      
     geo2xy(mplot, mplot->focm[kount].meanPhi , mplot->focm[kount].meanLam  , &meanX, &meanY);
     
     fprintf(stderr,"dismax=%f, meanX=%f, meanY=%f\n", dismax, meanX, meanY);
	
      for(i = 0; i < mplot->focm[kount].numpoints; i++)
	{
	  phi = mplot->focm[kount].focs[i].loc.x;
	  lam = mplot->focm[kount].focs[i].loc.y;
	  geo2xy(mplot, phi, lam, &px, &py);
	  dis = sqrt((meanX - px) * (meanX - px) + (meanY - py) * (meanY - py));

	  mplot->focm[kount].focs[i].explode_dist = dismax + dis;
	  mplot->focm[kount].focs[i].explode_angle = atan2((py - meanY),
							   (px - meanX));

	  ang = 57.29578 * atan2((py - meanY), (px - meanX));
	  if(ang < 0.0) ang += 360.0;
	  ang2 = ang;
      
	  mplot->focm[kount].focs[i].explode_x = 
	    (px + mplot->focm[kount].focs[i].explode_dist
	     * cos(mplot->focm[kount].focs[i].explode_angle));
	  mplot->focm[kount].focs[i].explode_y =
	    (py + mplot->focm[kount].focs[i].explode_dist
	     * sin(mplot->focm[kount].focs[i].explode_angle));

	  if(mplot->focm[kount].focs[i].explode_x > mplot->origin.maxx)
	    mplot->focm[kount].focs[i].explode_x = mplot->origin.maxx;
	  if(mplot->focm[kount].focs[i].explode_y > mplot->origin.maxy)
	    mplot->focm[kount].focs[i].explode_y = mplot->origin.maxy;
	  if(mplot->focm[kount].focs[i].explode_x < 0.0)
	    mplot->focm[kount].focs[i].explode_x = 0.0;
	  if(mplot->focm[kount].focs[i].explode_y < 0.0)
	    mplot->focm[kount].focs[i].explode_y = 0.0;
	} 
    }
    

    
}
