#ifndef _jml_h
#define _jml_h

#include <X11/Xlib.h>

#include "primitive.h"
#include "geotouch.h"
#include "mapstroke.h"
#include "pickfile.h"

#define FOC_TRACE	1000
#define FAULT_TRACE	200
#define MAX_TICS	200
#define FILENAME_LEN	100

typedef xy pix;
typedef fxyxy FSeg;
typedef xyxy PSeg;

/* ---------------------------------------------------------------- */
/* acard and ORG are now defined in pickfile.h  */
/* ---------------------------------------------------------------- */

typedef struct
  {
  FSeg kmloc;
  FSeg latlon;
  PSeg p;
  float rotang;
  char label[50];
  } Label;

typedef struct
  {
  int n, col, index;
  fxyz *kmloc;
  fllz *latlon;
  } Slab;

typedef struct
  {
  int n;
  Slab *poly;
  char label[50];
  char file_name[FILENAME_LEN];
  } WireFrame;

/*   storage for ellipse covariance matrix:
     1   2   3
     2   4   5
     3   5   6
     */

typedef struct
  {
  float f11, f12, f13, f22, f23, f33;
  } CoVar;

typedef struct
  {
  int col, ind;
  char label[50];
  fllz latlon;
  CoVar cov; 
  fxyz ebar; 
  float lambda[3];  
  float vec[3][3]; 
  } Ellipse;

typedef struct
  {
  int n;
  Ellipse *lips;
  char file_name[FILENAME_LEN];
  } LipSet;

/* One record in a ".ac" (Acards) files */
/* ---------------------------------------------------------------- */

/* One record in UW station file files */


typedef struct
  {
  char name[5];  
  float lat1, lat2, lon1,lon2; 
  float elevation;
  char NS, EW;
  } station_rec_uw;

/* ---------------------------------------------------------------- */

typedef struct
  {
  int color;
  fxyz *loc;
  ac_rec *acard;
  int *point_color;
  int *onoff;
  float *size;
  char file_name[FILENAME_LEN];
  int numpoints;
  int style;
  } Source_File;

/* ---------------------------------------------------------------- */

typedef struct
  {
  int color;
  FSeg zooms[50];
  int numpoints;
  } Zoom_File;

/* ---------------------------------------------------------------- */
/* One generic station record   */

typedef struct
  {
  char name[5];  
  fxyz latlon;
  fxyz loc; 
  } STAREC;

typedef struct
  {
  int color;
  int symbol;
  STAREC *sta;    
  int num_special_stations;
  int special_stations[100];
  char file_name[FILENAME_LEN];
  int size_sta;
  int numpoints;
  float mean_elev;
  } Station_File;

/* ---------------------------------------------------------------- */

/*  map_type = 0  for lat-lon segment files
    map_type = 1  for lees format data base  */

typedef struct
  {
  int color;
  fxyz *km;
  fxyz *latlon;
  char file_name[FILENAME_LEN];
  int numpoints;
  int stroke_count;
  MAPSTROKE *stroke;
  char map_code[50];
  } Map_File;

typedef struct
  {
  int color;
  FSeg *km;
  char file_name[FILENAME_LEN];
  int numpoints;
  int map_numplots;
  int map_current;
  } Simple_Map_File;

/* ---------------------------------------------------------------- */

typedef struct
  {
  char name[200];
  int style;
  int color;
  int nump;
  fxyz *loc;
  fxyz *dip;
  int *lith;
  } Well;

typedef struct
  {
  char file_name[FILENAME_LEN];
  Well *well;
  int well_count;
  int point_count;
  int flag;
  } Wells_File;

/* ---------------------------------------------------------------- */

typedef struct
  {
  char name[13]; 
  int code1, code2, deg, min;
  float ddeg; 
  fxyz m;
  pix p;  
  } mark;

/* ---------------------------------------------------------------- */

typedef struct
  {
  char name[200];
  int color, fsize, symbol, symsize;
  int symcode;	/*symbol 0 = off 1 = on */
  int strcode;	/*string 0 = off 1 = on */
  int just;	/* HJ_LEFT=0, HJ_CENTER=1, HJ_RIGHT=2 */
  float lat, lon, depth; 
  } point_lab;

/* ---------------------------------------------------------------- */

typedef struct
  {
  int color;
  mark stuff[MAX_TICS];
  char file_name[FILENAME_LEN];
  int numpoints;
  } Markup_File;

typedef struct
  {
  point_lab *points;
  char file_name[FILENAME_LEN];
  int numpoints;
  } Point_File;

typedef struct
  {
  xyxy xsecline;
  fxyxy xseckm,xsecphilam;
  float xsecwidth, xsecdepth;
  float max_xsback, max_xsfront, max_xsdepth, min_xsdepth, xs_dip;
  int xsec_index;
  }  Xsec_box;

/* ---------------------------------------------------------------- */

typedef  Mech mech;
  

typedef struct
  {
  ac_rec ac;
  mech fm;
  fxy traj1[FOC_TRACE];
  fxy traj2[FOC_TRACE];
  fxy fault[FAULT_TRACE];
  fxy aux[FAULT_TRACE];
  int numft1, numft2;
  int num1,num2, ipol;
  int on_off;
  fxyz loc;
  int type;
  float explode_angle;
  float explode_dist;
  float explode_x;
  float explode_y;
  } foc_rec;

typedef struct
  {
  int color;
  foc_rec *focs;
  char file_name[FILENAME_LEN];
  int numpoints;
  int flag;
  int plot_style;
  int foc_color;
  int explode;
  int scale_by_mag;
  float meanPhi, meanLam, maxMag, minMag, disMax;
  } FocMec_File;

typedef struct
{
   char file_name[FILENAME_LEN];
   float phi, lam;
   float org_maxx, org_minx, org_maxy, org_miny;
   int nx, ny, nz;
   float *z_parts, *x_parts, *y_parts, *z_vels;
   float dx, dy, dz;
   float spac;
   int *col;
   float *val;
   float *Layer_max, *Layer_min;
   float image_skip;
   float Global_image_max, Global_image_min;
   float Temp_image_max, Temp_image_min;
   char  Xunits[4], Yunits[4];
   char Type[12];
   int KIND;
    
  } Image_File;

/* ---------------------------------------------------------------- */

#endif /* _jml_h */
