/* LU decomposition and solution of linear equations  */

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"
#include "jutil.h"

/* --- macros --- */

#define SMALL 1.0e-20;

/* --- functions --- */

void jLUdecomp(float **a, int n, int *indx, float *d)
  {
  int i, imax, j, k;
  float big, dum, sum, temp, *vv;

  vv = alloc_fvec(1,n);
  *d = 1.0;
  for(i = 1; i <= n; i++)
    {
    big = 0.0;
    for(j = 1; j <= n; j++)
      if((temp = fabs(a[i][j])) > big) big = temp;
    if(big == 0.0)
      fprintf(stderr, "Singular matrix in routine ludcmp");
    vv[i] = inv(big);
    }

  for(j = 1; j <= n; j++)
    {
    for(i = 1; i < j; i++)
      {
      sum = a[i][j];
      for(k = 1; k < i; k++) sum -= a[i][k] * a[k][j];
      a[i][j] = sum;
      }

    big = 0.0;
    for(i = j; i <= n; i++)
      {
      sum = a[i][j];
      for(k = 1; k < j; k++) sum -= a[i][k] * a[k][j];
      a[i][j] = sum;
      if((dum = vv[i] * fabs(sum)) >= big)
	{
	big = dum;
	imax = i;
	}
      }

    if(j != imax)
      {
      for(k = 1; k <= n; k++)
	{
	dum = a[imax][k];
	a[imax][k] = a[j][k];
	a[j][k] = dum;
	}
      *d *= -1;
      vv[imax] = vv[j];
      }

    indx[j] = imax;
    if(a[j][j] == 0.0) a[j][j] = SMALL;
    if(j != n)
      {
      dum = inv(a[j][j]);
      for(i = j + 1; i <= n; i++) a[i][j] *= dum;
      }
    }
  free_fvec(vv, 1, n);
  }

void jLUback(float **a, int n, int *indx, float b[])
  {
  int i, ii=0, ip, j;
  float sum;

  for(i = 1; i <= n; i++)
    {
    ip = indx[i];
    sum = b[ip];
    b[ip] = b[i];

    if(ii)
      for(j = ii; j <= i - 1; j++) sum -= a[i][j] * b[j];
    else if(sum) ii = i;

    b[i] = sum;
    }
  for(i = n; i>= 1; i--)
    {
    sum = b[i];
    for(j = i + 1; j <= n; j++) sum -= a[i][j] * b[j];
    b[i] = sum / a[i][i];
    }
  }

#undef SMALL
