
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <X11/bitmaps/star>

#include <ctype.h>


void usleep(unsigned int useconds);

   

/* --- local headers --- */

#include "geotouch.h"
#include "geotouch-help.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jutil.h"
#include "focproto.h"
#include "fsel.h"
#include "cascade.h"
#include "user2pix.h"

/* --- macros --- */

#define XYXY(a) (a).x1, (a).y1, (a).x2, (a).y2

#define CASCADES 1
#define FILESEL 1

#define MAXPATHLEN 256

#define DEG2RAD	0.017453293
#define RAD2DEG	57.295778667


/* --- global variables --- */

static Pixmap star;
extern XtAppContext apcon;
int xmarg = 50, ymarg = 70, default_depth;
static int gpolx[200], gpoly[200], global_poly, num_poly = 0;
static float CUR_pointx, CUR_pointy;

static float polylat[200], polylon[200], SELXMIN, SELYMIN, SELXMAX, SELYMAX,
  xs_dip, min_xsdepth, max_xsdepth, max_xsfront, max_xsback;
static int numx_called = 0, gscr_num;
Widget submenu, submenu1,  pane[6], subpane[3], subpane1[3];;
int modes[3] = { 0, 0, 0 };
int modes1[3] = { 0, 0, 0 };

static double BEGxkm, BEGykm;

/* --- function prototypes --- */

typedef fxy fpoint;
void blank2under(char *ident);

float ps_kmx(float x, float xorg);
float ps_kmy(float y, float yorg);
void Hypos_2_File(mpic *mplot, char *source_file, int append);
void Hypo_Stats(Widget wij, mpic *mplot, char *call_data);
Boolean readac(FILE * f, ac_rec * a);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
void create_Acard(ac_rec *ac, char *acrd);
int Get_Stuff1(mpic *m);
void Plot_LIPS(mpic *mplot);
int Get_ThreeD(char *infile, mpic *mplot);

int goget_intersex(float **p1 , int n1, float **p2, int n2, fxyxy *finline);

void plot_ThreeD(Display *dpy, Window xwin, GC gc, mpic *mplot);
void focal_summary(mpic *mplot);
void Auto_focal_summary(mpic * mplot);
void  PS_focal_summary(Widget wij, mpic *mplot, char *call_data);
void citoxyz(int nx, int ny, int nlay, int iway, int *i, int *ix, int *iy,
	     int *iz);
void Scale_Image_Layer(mpic *m);
void Scale_Image_Global(mpic *m, float max, float min);
void  flip_color_palette(mpic *m);
void change_palette_colors(mpic *m);
int Get_Lips(char *lipfile, mpic *m);
void  cut_image(xsec *xs);
void  cut_great_image(xsec *xs);

void Simple_Render(mpic *mplot, float brx, float bry, float urx, float ury);

float Get_image_value(mpic *xm, float xkm, float ykm, float zkm);
int Get_i_value(mpic *xm, float xkm, float ykm, float zkm);
void Init_Focs(mpic *mplot);
void Set_Explode_Focs(mpic *mplot);

void break_line(char *line, int *fake_argc, char **fake_argv);
void get_rect_vol(float x1, float y1, float x2, float y2, float dip,
		  float mat[3][3]);
int Get_Point_Labs(char *markfile, mpic *m);
void Plot_Points(Display *dpy, Window xwin, GC gc, mpic *m);
void Plot_Map2(Display *dpy, Window xwin, GC gc, mpic *m, int kmap);
void switch_foc(mpic *m, int kfoc);
void Add_lines_to_map(mpic *m);
void DoA_PointsMap(mpic *mplot);

void plot_project_wells(Display *dpy, Window xwin, GC gc, mpic *m, int kwell);
void plot_wells(Display *dpy, Window xwin, GC gc, mpic *m, int kwell);
/* void Spe_Src(Widget wij, mpic *mplot, char *call_data); */
void Plot_Map3(Display *dpy, Window xwin, GC gc, mpic *m, int kmap);
void plot_focs(Display *dpy, Window xwin, GC gc, mpic *m, int kfoc);
void plot_focs_BW(Display *dpy, Window xwin, GC gc, mpic *m, int kfoc);
void Plot_Cont_values(mpic *mplot);
void Plot_Cont_points(mpic *mplot);
void init_xdipParms(mpic *mp);
void make_cont_menu(Widget top, mpic *mplot);
void make_xdip_menu(Widget top, mpic *mplot);
void make_hypo_pop(Widget top, mpic *mplot);
void make_focal_pop(Widget box, mpic *mplot);

void make_info_menu(Widget box, mpic *mplot);
void jspl(float *x, float *y, int n, int ndiv, float *ex, float *ey);
void Do_Contour_Field(Display *gdisp, char ps_file[50], mpic *mplot);
void explode_selfoc(Widget wij, XButtonEvent *ev, String *params,
		    Cardinal *num_params);
void Switch_selfoc(Widget wij, XButtonEvent *ev, String *params,
		   Cardinal *num_params);
int Foc_Color(float dis, mpic *m);
void Plot_Xsec(Display *d, Window w, GC ggc, mpic *mplot, int i);
void Plot_Border(Display *dpy, Window xwin, GC gc, mpic *mplot);
void Plot_Border2(Display *dpy, Window xwin, GC gc, mpic *mplot);
void Key_s_lees(Widget wij, XKeyEvent *ev, String *params,
		Cardinal *num_params);


void Key_A_lees1(Widget wij, XKeyEvent *ev, String *params,
		 Cardinal *num_params);
void Key_A_lees(Widget wij, XKeyEvent *ev, String *params,
		Cardinal *num_params);
void Key_F1_map(Widget wij, XKeyEvent *ev, String *params,
		Cardinal *num_params);
void Plot_Map_Grid(Widget wij, mpic *mplot, char *call_data);
void SAVE_Src(Widget wij, mpic *mplot, char *call_data);
void Extend_Src(Widget wij, mpic *mplot, char *call_data);
void Run_DB(Widget wij, mpic *mplot, char *call_data);
void APPEND_Src(Widget wij, mpic *mplot, char *call_data);
void dump_color_scheme(mpic *oneplot);
void dump_color_palette(mpic *m);

void init_contParms(mpic *mp);
int Get_Sources(char source_file[50], mpic *m);
int Get_Map2(char *mapfile,mpic *m);
int Get_Focs(char foc_file[50], mpic *m);
void create_Mcard(mech *mc, char *mcrd);

void plot_image(Display * dpy, Window xwin, GC gc, mpic *m);
void plot_image_gmt( Display *dpy, Window xwin, GC gc, mpic *m);
void plot_image_glob( Display *dpy, Window xwin, GC gc, mpic *m);
     
void plot_sat_image(Display *dpy, Window xwin, GC gc, mpic *m);
void Plot_Border0(Display *d, Window w, GC ggc, mpic *mplot);
void plot_stations(Display *dpy, Window xwin, GC gc, mpic *m);
void plot_station_names(Display *dpy, Window xwin, GC gc, mpic *m);
void plot_stuff(Display *dpy, Window xwin, GC gc, mpic *m, int codeA,
		int codeB);
void Plot_Map(Display *dpy, Window xwin, GC gc, mpic *m);
void Plot_Grid(Display *dpy, Window xwin, GC gc, mpic *m);
void Plot_GeoTab(Display *dpy, Window xwin, GC gc, mpic *m);
void plot_sources(Display *dpy, Window xwin, GC gc, mpic *m);
void plot_mag_scale(Display *dpy, Window xwin, GC gc, mpic *m);
void plot_color_scale(Display *dpy, Window xwin, GC gc, mpic *m);
void connect_sources (Display *dpy, Window xwin, GC gc, mpic *m);
void Plot_Labels(Display *dpy, Window xwin, GC gc, mpic *m);
void draw_cont(mpic *mplot);
void make_xsec_window(Widget top,  xsec *xs, Pixel *colors, Font *fonts);
Boolean CopyToXDipWindow(XDIP_PARMS *pxdipParms);
void Do_Postscript(Display *gdisp, char ps_file[50], mpic *mplot);
void Do_Contour_Field(Display *gdisp, char ps_file[200], mpic *mplot);
void dump_contour_file(char ps_file[50], mpic *mplot);
int Get_Wells(char *wellfile, mpic *m);
int Load_Xsec(char *xsecfile, mpic *mplot);
int Set_an_xsec(mpic *mplot);
int Get_Image_GMT(char *file, mpic *m);
int Get_Image(char image_file[50], mpic *m);
int Get_Image_glob(char *file, mpic *m);
void Ps_Xsec(FILE *fp, mpic *mplot, int i);
void Do_Postscript_Xsect(Display *gdisp, char ps_file[50], xsec *xs);
void new_org(Widget wij, mpic *mplot, char *call_data);
void Spin_Targ(Widget wij, mpic *mplot, char *call_data);
int change_mag_scale(mpic *m, int style);
void sat_image(mpic *mplot);
int inside(fpoint t, fpoint *p, int N);

void make_leg_win(mpic *mplot);

void make_mpic_window(Widget top, mpic *mplot, Font *fonts);

 void Get_Labels(mpic *mplot);

void make_great_xsect(mpic *mplot, xyxy *l);

int Num_Lines(char *source_file);
void Get_legend(mpic *mplot, char *sfile);


float smallest_sec( float num, int *ideg, int *imin, int *isec);
float largest_sec( float num, int *ideg, int *imin, int *isec);

Boolean rect_overlap(float x1, float y1, float x2, float y2, 
                     float x3, float y3, float x4, float y4);

void reset_database_focal(Widget wij, mpic *mplot, char *call_data);

void database_focal(Widget wij, mpic *mplot, char *call_data);

void Get_Great(double lat1, double lon1, double lat2, double lon2, int num, double *phi2, double *lam2 );
double great_dist(double phi1, double lam0, double phi, double lam);

void Isolate_Image(mpic *mplot);
void Integrate_Target(mpic *mplot);
void Poly_Spline(mpic *mplot );
void Replot_Poly(mpic *mplot);

void Toggle_Replot_Target(Widget wij, mpic *mplot, char *call_data);
void Replot_Targ(mpic *mplot);

int Inpoly(float x, float y, int num, float **poly);

void GC_intersection(double deglat1, double deglon1, double deglat2, double deglon2,
				 double deglat3, double deglon3, double deglat4, double deglon4,
		     double *elat1, double *elon1, double *elat2, double *elon2);

int GC_X_LAT(double deglat1, double deglon1, double deglat2, double deglon2, 
	     double LAT, double phi[2], double lam[2] );

int In_SphereRect(double  minlat1, double minlon1, double maxlat2, double maxlon2, double pntlat,  double pntlon);

float  sample_surf(struct SURF_GRD *grd, float x, float y );

void jindexD(unsigned long n, double  arr[], int  indx[]);

 int simp_greatX(int nx, int ny, 
		 float dx, float dy, 
		 double  phi , double  lam ,
		 double phi1, double  lam1,
		 double  phi2, double lam2, 
		 int *ivec, float *rvec, double  *PHIvec,  double  *LAMvec);

/******************************************************************/
/******************************************************************/
/******************************************************************/


/*  FUNC DEF **/ int In_Rectarg(float x, float y, float minx, float maxx, float miny,
	       float maxy)
  {

  return((x >= minx) && (x <= maxx) && (y >= miny) && (y <= maxy));
  }

/*  FUNC DEF **/ int DIn_Rectarg(double x, double y, double minx, double maxx, double miny,
	       double maxy)
  {

  return((x >= minx) && (x <= maxx) && (y >= miny) && (y <= maxy));
  }


 

/* --- functions --- */

void clean_file_name(char **sfile)
  {
  int i;

  for(i = 0; i < strlen(sfile[0]); i++)
    {
    if(isspace(sfile[0][0])) sfile[0]++;
    else break;
    }

  for(i = 0; i < strlen(sfile[0]); i++)
    if(isspace(sfile[0][i])) sfile[0][i] = 0;
  }

void getbox(int g1, int h1, int g2, int h2, XPoint v[5])
  {

  v[0].x = g1; 
  v[0].y = h1;

  v[1].x = g2; 
  v[1].y = h1;

  v[2].x = g2; 
  v[2].y = h2;

  v[3].x = g1; 
  v[3].y = h2;
  
  v[4].x = g1; 
  v[4].y = h1;
  }

void getboxkm(mpic *mplot, float g1, float h1, float g2, float h2, XPoint v[5])
  {

  v[0].x = user_to_pix_x(&mplot->gr, (double)g1);
  v[0].y = user_to_pix_y(&mplot->gr, (double)h1);

  v[1].x = user_to_pix_x(&mplot->gr, (double)g2);
  v[1].y = user_to_pix_y(&mplot->gr, (double)h1);

  v[2].x = user_to_pix_x(&mplot->gr, (double)g2);
  v[2].y = user_to_pix_y(&mplot->gr, (double)h2);

  v[3].x = user_to_pix_x(&mplot->gr, (double)g1);
  v[3].y = user_to_pix_y(&mplot->gr, (double)h2);
  
  v[4].x = user_to_pix_x(&mplot->gr, (double)g1);
  v[4].y = user_to_pix_y(&mplot->gr, (double)h1);
  }

/* ---------------------------------------------------------------- */
void set_wells_layer(mpic *mplot)
   {

   if(mplot->image_layer==0)
      {
      mplot->hoz_slab_top = mplot->image.z_parts[0];
      mplot->hoz_slab_bot = mplot->image.z_parts[1];
      }
   else
      {
      mplot->hoz_slab_top = mplot->image.z_parts[mplot->image_layer - 1];
      mplot->hoz_slab_bot = mplot->image.z_parts[mplot->image_layer];
      }
   

   }
/* ---------------------------------------------------------------- */
/***************/
void Print_Image_Info(mpic *mplot)
  {

  fprintf(stderr,
	  "\n ---------------  Image Information  -----------------\n");
  fprintf(stderr, "file name: %s\n", mplot->image.file_name);
  fprintf(stderr, "Lower Right Corner: %f %f\n", mplot->image.phi,
	  mplot->image.lam);
  fprintf(stderr, " maxx=%f minx=%f maxy=%f miny=%f\n", mplot->image.org_maxx,
	  mplot->image.org_minx, mplot->image.org_maxy, mplot->image.org_miny);
  fprintf(stderr, " nx=%d  ny=%d  nz=%d  \n", mplot->image.nx, mplot->image.ny,
	  mplot->image.nz);
  fprintf(stderr, "dx=%f  dy=%f  dz=%f  \n",  mplot->image.dx, mplot->image.dy,
	  mplot->image.dz);
  fprintf(stderr, "skip=%f  \n", mplot->image.image_skip);
  fprintf(stderr, "Gmax=%f  Gmin=%f\n", mplot->image.Global_image_max,
	  mplot->image.Global_image_min);
  fprintf(stderr, "Tmax=%f  Tmin=%f\n", mplot->image.Temp_image_max,
	  mplot->image.Temp_image_min);
  fprintf(stderr, "---------------  End  -----------------\n\n");
  }


/* ---------------------------------------------------------------- */
void Key_0_lees(Widget mwij, XKeyEvent *ev, String *params,
		Cardinal *num_params)
{
   mpic *mplot;
   int i, j, kk, kount, px1, px2, py1, py2, kin;
   float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
      top_right_y, phi, lam, bx1, by1, bx2, by2, rlatmin, rlatmax, rlonmin,
      rlonmax;
   char pchar[6], *c;
   XPoint p[5000];
 
   Display *disp;	
   Window wind;	
   GC mggc;

   XtVaGetValues(mwij, XtNdata, &mplot, NULL);
   
      fprintf(stderr,"Pressing key 0\n");


   /* XtVaGetValues(mwij, XtNdata, &mplot, NULL); */
   wind = XtWindow(mwij);
   disp = XtDisplay(mwij);
   mggc = mplot->ggc;

   if(mplot->map_type <= 1) return;

   minx = SELXMIN;
   miny = SELYMIN;
   maxx = SELXMAX;
   maxy = SELYMAX;

   XSetFont(disp, mggc, mplot->fonts[0]);

   xy2geo(mplot, &phi, &lam, minx, miny);
   bx1 = phi;
   by1 = lam;

   xy2geo(mplot, &phi, &lam, maxx, maxy);
   bx2 = phi;
   by2 = lam;

   fprintf(stderr, "-------Selected Map Lines---%d\n", mplot->num_map_files);
   for(kount = 0; kount < mplot->num_map_files; kount++)
   {
      fprintf(stderr, "------checking Map ---%d\n", kount);
      for(j = 0; j < mplot->map[kount].stroke_count; j++)
      {
	 c = mplot->map[kount].map_code;
	 while(*(c++) != mplot->map[kount].stroke[j].code) 
	    if(*c == '\0') goto AGAIN;

	 rlatmin = mplot->map[kount].stroke[j].latmin;
	 rlatmax = mplot->map[kount].stroke[j].latmax;
	 rlonmin = mplot->map[kount].stroke[j].lonmin;
	 rlonmax = mplot->map[kount].stroke[j].lonmax;

	 kin = rect_overlap(  by1, bx1,  by2, bx2,
			      rlonmin, rlatmin,  rlonmax, rlatmax); 
	 if(kin==1)
	 {
	    phi = rlatmin;
	    lam = rlonmin;
	    geo2xy(mplot, phi, lam, &bottom_left_x, &bottom_left_y);
	    phi = rlatmax;
	    lam = rlonmax;
	    geo2xy(mplot, phi, lam, &top_right_x, &top_right_y);
	    px1 = user_to_pix_x(&mplot->gr, (double)bottom_left_x);
	    py1 = user_to_pix_y(&mplot->gr, (double)bottom_left_y);
	    px2 = user_to_pix_x(&mplot->gr, (double)top_right_x);
	    py2 = user_to_pix_y(&mplot->gr, (double)top_right_y);

	

	    XDrawRectangle(disp, wind,
			   mggc, px1, py2, abs(px2 - px1) , abs(py1 - py2) );
	    sprintf(pchar, "%d", j);

	    /* px1 = user_to_pix_x(&mplot->gr,
	       (double)mplot->map[kount].km[mplot->map[kount].stroke[j].index1].x);
	       py2 = user_to_pix_y(&mplot->gr,
	       (double)mplot->map[kount].km[mplot->map[kount].stroke[j].index1].y);
	    */

	    draw_just_text(disp, wind,
			   mggc, px1, py2, pchar, HJ_CENTER, VJ_BASELINE);
	    fprintf(stderr, "%d %s %d %d %d \n", j,
		    mplot->map[kount].stroke[j].name,
		    mplot->map[kount].stroke[j].num,
		    mplot->map[kount].stroke[j].style,
		    mplot->map[kount].stroke[j].col);

	    kk = 0;
	    for(i = mplot->map[kount].stroke[j].index1;
		i < (mplot->map[kount].stroke[j].index1
		     + mplot->map[kount].stroke[j].num); i++)
	    {
	       p[kk].x = user_to_pix_x(&mplot->gr,
				       (double)mplot->map[kount].km[i].x);
	       p[kk].y = user_to_pix_y(&mplot->gr,
				       (double)mplot->map[kount].km[i].y);
	       sprintf(pchar, "%d", kk);
	       draw_just_text(disp, wind, 
			      mggc, p[kk].x, p[kk].y, pchar, HJ_CENTER,
			      VJ_BASELINE);
	       kk++;
	    }
	    XDrawPoints(disp, wind, mggc,
			p, mplot->map[kount].stroke[j].num, CoordModeOrigin);
	    XFlush(disp);
	    
	    
	    
	 }
	AGAIN: ;
      }
   }
}


/* --------------------------------------------------------- */
void prep_polygon(mpic *mplot,  fpoint *plotkin  )
{
   int i,  j, lowy, num, *indx;
   float *pys, xkm, ykm, lat, lon;
   
   num = global_poly;
   if(num == 0)
   {
      fprintf(stderr,
	      "\nFIRST: Please select a poly gon using the meta-1 mouse!\n");
      return;
   }
   pys = alloc_fvec(0, num);
   indx = alloc_ivec(0, num);
   
   
   fprintf(stdout, " -------------------------------- \n\n");
   fprintf(stdout, "Selection polygon: %d points\n", num);
   fprintf(stdout, "%% the following postscript code can be inserted into"
	   " a postscript map file\n\n");
   
   geo2xy(mplot, polylat[0], polylon[0], &xkm, &ykm);
   lat = polylat[0];
   lon = polylon[0];
   fprintf(stdout, " %f bx %f bz moveto %%   %f %f \n", xkm, ykm, lat, lon);
   
   for(i = 1; i < num; i++)
   {
      geo2xy(mplot, polylat[i], polylon[i], &xkm, &ykm);
      pys[i] = ykm;
      lat = polylat[i];
      lon = polylon[i];
      fprintf(stdout, " %f bx %f bz lineto %%   %f %f \n", xkm, ykm, lat, lon);
   }
   
   fprintf(stdout, " closepath \n stroke \n\n");
   fprintf(stdout, " -------------------------------- \n");
   /* indexx((unsigned long) num, pys - 1, indx - 1); */
   
   cindex(pys, indx, num);
   lowy = indx[0];
   for(i = lowy, j = 1; i < num; i++)
   {
      geo2xy(mplot, polylat[i], polylon[i], &xkm, &ykm);
      plotkin[j].x = xkm;
      plotkin[j].y = ykm;
      j++;
   }

  for(i = 0; i < lowy; i++)
    {
    geo2xy(mplot, polylat[i], polylon[i], &xkm, &ykm);
    plotkin[j].x = xkm;
    plotkin[j].y = ykm;
    j++;
    }
  fprintf(stderr, "in prep_poly\n");
    for(i = 0; i <= num; i++)
    {
    fprintf(stderr, "%f %f\n", plotkin[i].x,  plotkin[i].y);

    }
    
  free_fvec(pys, 0, num);
  free_ivec(indx, 0, num);
  }

/* ---------------------------------------------------------------- */
static char *pr_float(float f)
  {
  static char s[20];

  if(f < 1) sprintf(s, "%f", f);
  else sprintf(s, "%2.1f", f);

  if(f == 0.0) sprintf(s, "%2.1f", f);
  return(s);
  }


/* --------------------------------------------------------- */

static void redraw_mpic(Widget wij, void *client_data, Region exposed)	
  {
  /* ======= These variables must be here ======= */
  mpic *mplot;		/* The data to redraw */
  Display *d;		/* The display we're using */
  Window w;		/* The window we're drawing in */
  GC ggc;		/* The gc to use */
  Pixel *colors;	/* Color map */
  /* ======== Variables used in the redrawing ========= */
  int ix, iy, i, ltic;
  float lensc, garb2, dotpkm, dis, deltax, deltay;
  XPoint p[5];
  Dimension win_hite, win_width;
  Position ex, why;

  /* fprintf(stderr," plotting.......redraw 1\n"); */

  /* Twin_hites must be first, before redrawing */

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  w = XtWindow(wij);
  d = XtDisplay(wij);
  ggc = mplot->ggc;
  colors = mplot->colors;
  /* XSetRegion(d, ggc, exposed); */

  XClearWindow(d,w); 

  XtVaGetValues(mplot->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

  deltax = mplot->origin.maxx;
  deltay = mplot->origin.maxy;

  /* fprintf(stderr," plotting.......redraw\n"); */

  window(&mplot->gr, (double)mplot->origin.minx, (double)mplot->origin.maxx,
	 (double)mplot->origin.miny, (double)mplot->origin.maxy);
 
  viewport(&mplot->gr, xmarg, win_width - xmarg, ymarg / 2,
	   win_hite - 2 * ymarg);

  dotpkm = mplot->gr.pix_xdif / mplot->gr.user_xdif;

  /* print_graph(&mplot->gr); */

  /* ============ Now get around to drawing ================= */

  /* plot a grey border around each layer */

  mplot->ScreenX = win_width;
  mplot->ScreenY = win_hite;

  /* fprintf(stderr, "border: %f %f %f %f\n", mplot->origin.minx,
     mplot->origin.miny,mplot->origin.maxx, mplot->origin.maxy); */

  if(mplot->satimage_flag == 1)
    {
    XSetForeground(d, ggc, mplot->colors[XmapAppColor(0)]);
    XFillRectangle(d, w, ggc, 0, 0, mplot->ScreenX, mplot->ScreenY);
    plot_sat_image(d, w, ggc, mplot);
    Plot_Border0(d, w, ggc, mplot);
    }
  else
    {
    /* for now, if there is a satellite image, do not fill, else fill */

    switch(mplot->project_type)
      {
      case 2:
      Plot_Border2(d, w, ggc, mplot);
      break;

      case 6:
      Plot_Border2(d, w, ggc, mplot);
      break;

      case 7:
      Plot_Border2(d, w, ggc, mplot);
      break;

      case 8:
      Plot_Border2(d, w, ggc, mplot);
      break;

      case 9:
      Plot_Border2(d, w, ggc, mplot);
      break;

      default:
      Plot_Border(d, w, ggc, mplot);
      break;
      }
    

    }

  if(mplot->image_flag)
    {

       /* fprintf(stderr, " PLOTTING IMAGE: %d\n", mplot->image.KIND); */

       switch(mplot->image.KIND)
       {
	  case 0:
	     plot_image_gmt(d, w, ggc, mplot);
	  break;
	  case 3:
	     plot_image_glob(d, w, ggc, mplot);
	  break;
	  default:
	     plot_image(d, w, ggc, mplot);
	  break;
       }


      Plot_Border0(d, w, ggc, mplot);

    
    }

  /* plot the map overlay */
   /* fprintf(stderr, "About to enter Plot_Map: map_type=%d map_flag=%d\n", */
/*      mplot->map_type, mplot->map_flag);  */

  XSetForeground(d, ggc, colors[XmapAppColor(mplot->map_col)]);
  if(mplot->map_flag)
    {
    switch(mplot->map_type)
      {
      case 1:
	Plot_Map(d, w, ggc, mplot);
	break;
      
      case 3:
	for(i = 0; i < mplot->num_map_files; i++)
	  Plot_Map3(d, w, ggc, mplot, i);
	break;
      
      case 2:
	for(i = 0; i < mplot->num_map_files; i++)
	  Plot_Map2(d, w, ggc, mplot, i);
	break;

      default:
	for(i = 0; i < mplot->num_map_files; i++)
	  Plot_Map2(d, w, ggc, mplot, i);
	break;
      }
      
    /* fprintf(stderr,"end plotting map...\n"); */
    }

  if(mplot->add_poly_lines) Add_lines_to_map(mplot);

  if(mplot->map_point_flag) DoA_PointsMap(mplot);

  /* do stations  */
  /* fprintf(stderr,"About to plot stations %d\n", mplot->sta_color); */

  XSetForeground(d, ggc, colors[XmapAppColor(mplot->sta_col)]);
  if(mplot->sta_flag)
    {
    for(i = 0; i < mplot->num_sta_files; i++)
      {
      mplot->current_sta = i;
      plot_stations(d, w, ggc, mplot);
      }
    }

  if(mplot->point_flag > 0)
    Plot_Points(d, w, ggc, mplot);

  /* do wells  */
  /* fprintf(stderr, "About to plot wells %d %d\n", mplot->sta_color,
     mplot->wells_flag); */

  XSetFont(d, ggc, mplot->fonts[0]);
  if(mplot->wells_flag > 1)
    {
    if((mplot->wells_symbol_flag == 1) || (mplot->wells_name_flag == 1))
      {
      for(i = 0; i < mplot->num_wells_files; i++)
      plot_wells(d, w, ggc, mplot, i);
      }

    if(mplot->wells_project_flag == 1)
      {
      for(i = 0; i < mplot->num_wells_files; i++)
      plot_project_wells(d, w, ggc, mplot, i);
      }
    }
	    
  XSetFont(d, ggc, mplot->fonts[0]);
  if(mplot->sta_name_flag)
    {
    for(i = 0; i< mplot->num_sta_files;i++)
      {
      mplot->current_sta = i;
      plot_station_names(d, w, ggc, mplot);
      }
    }

  XSetForeground(d, ggc, colors[XmapAppColor(mplot->stuff_col)]);
  /* plot latitudes and Longitudes and-or tic marks */
  if(mplot->stuff_flag)
    {
    plot_stuff(d, w, ggc, mplot, 1,1);
    plot_stuff(d, w, ggc, mplot, 2,1);
    }

  if(mplot->grid_flag) Plot_Grid(d, w, ggc, mplot);
  if(mplot->geotab_flag) Plot_GeoTab(d, w, ggc, mplot);
   
 
	
  /********* plot the SOURCES **********/

  if(mplot->src_flag)
    {
    /* fprintf(stderr,"start plotting sources...\n"); */
    XSetForeground(d, ggc, colors[XmapAppColor(mplot->src_col)]);
    mplot->current_src = 0;
    plot_sources(d, w, ggc, mplot); 
    /* fprintf(stderr,"end plotting sources...\n"); */

    if(mplot->more_src_flag)
      {
      for(i = 1; i < mplot->max_more_src; i++)
	{
	mplot->current_src = i;
	/* fprintf(stderr,"more sources plotted: current= %d\n",
	   mplot->current_src); */
	XSetForeground(d, ggc, colors[XmapAppColor(mplot->src_col - i)]);
	plot_sources(d, w, ggc, mplot);
	}
      }
    }

  /* if((mplot->mag_src_flag == 1)
     && (mplot->more_src_flag || mplot->src_flag)) */
     
  if(mplot->mag_src_flag > 0) plot_mag_scale(d, w, ggc, mplot);
  if(mplot->src_depth_color) plot_color_scale(d, w, ggc, mplot);
  if(mplot->connect_flag) connect_sources(d, w, ggc, mplot);
  if(mplot->focm_flag > 1) 
    { 
    for(i = 0; i < mplot->num_focm_files; i++)
      {
      if(default_depth < 2) plot_focs_BW(d, w, ggc, mplot, i);
      else plot_focs(d, w, ggc, mplot, i);
      }
    }

  if(mplot->lip_flag) Plot_LIPS(mplot);
  if(mplot->wire_flag) plot_ThreeD(d, w, ggc, mplot);

  if(mplot->foc_summary_flag)  focal_summary(mplot);
  if(mplot->foc_auto_summary_flag)  Auto_focal_summary(mplot);
  if(mplot->Hi_Lite_flag) Isolate_Image(mplot)  ;
  if(mplot->Integrate_flag)Integrate_Target(mplot);
  if(mplot->Draw_spline_flag)Poly_Spline(mplot );
  if(mplot->Replot_Poly_flag)Replot_Poly(mplot);
  if(mplot->Replot_target_flag)Replot_Targ(mplot);
  

  
  

  /* KM scale kmscale */

  XSetForeground(d, ggc, colors[XmapAppColor(mplot->title_col)]);
  lensc = (int)mplot->gr.user_xdif / 4;
  if(lensc == 0.0) lensc = mplot->gr.user_xdif / 4;

  /* round it off  */

  if(lensc > 100) lensc = 100 * (int)(0.5 + lensc / 100);
  if(lensc > 1000) lensc = 1000 * (int)(0.5 + lensc / 1000);

  XSetForeground(d, ggc, colors[XmapAppColor(mplot->stuff_col)]);
  /*	plot the map scale in km at bottom */
  /* iy = user_to_pix_y(&mplot->gr, 0.0)+ 0.7*ymarg; */
        
  iy = win_hite -  ymarg;
 /*  fprintf(stderr,"yloc of kmscale: %d %d %d\n", iy, win_hite, ymarg); */
  
  garb2 = (float)lensc / 2.0;         
  ix = win_width / 2 - dotpkm * garb2;
  ltic = 10;

#if 0
  if(lensc >= 100) ltic = 10;
  if(lensc >= 1000) ltic = 100;
  fprintf(stderr, "KM scale ix=%d iy=%d lensc=%f garb2=%f\n", ix, iy, lensc,
	  garb2);
#endif

  draw_scale(d, w, ggc, ix, iy, 0, (float)lensc, garb2, (int)ltic, -1, 1,
	     0.0, pr_float, HJ_CENTER, VJ_BOTTOM,
	     mplot->gr.pix_xdif / mplot->gr.user_xdif,
	     mplot->gr.pix_ydif/mplot->gr.user_ydif, 12, 7, 2);

  /*--------------------------------------------------------------------*/

  /* plot the overall title  at top */

  XSetForeground(d, ggc, colors[XmapAppColor(mplot->title_col)]);

  /* mplot->ScreenX = win_width;
     mplot->ScreenY = win_hite;
     ix = user_to_pix_x(&mplot->gr,(double)(mplot->origin.maxx
     - mplot->origin.minx)/2.);
     iy = user_to_pix_y(&mplot->gr,(double) (mplot->origin.maxy
     - mplot->origin.miny)) - 5; */

  iy = ymarg / 2 - 5;
  ix = mplot->ScreenX / 2;

  XSetFont(d, ggc, mplot->fonts[2]);

  draw_just_text(d, w, ggc, ix, iy, mplot->Overall_title, HJ_CENTER,
		 VJ_BASELINE);

  /* plot the Zoom boxes  */

  if(mplot->zoom_flag)
    {
    for(i = mplot->zoom.numpoints; i > mplot->zoom_flag2; i--)
      {
      getboxkm(mplot, mplot->zoom.zooms[i].x1, mplot->zoom.zooms[i].y1,
	       mplot->zoom.zooms[i].x2,	mplot->zoom.zooms[i].y2, p);
      XDrawLines(d, w, ggc, p, 5, CoordModeOrigin);
      }
    }

  XSetForeground(d, ggc, colors[XmapAppColor(mplot->picsource_col)]);	

  /* plot the picsource boxes  */

  if(mplot->picsource_flag)
    {
    for(i = 0; i < mplot->picsource.numpoints; i++)
      {
      getboxkm(mplot, mplot->picsource.zooms[i].x1,
	       mplot->picsource.zooms[i].y1, mplot->picsource.zooms[i].x2,
	       mplot->picsource.zooms[i].y2, p);

      XDrawLines(d,w, ggc , p, 5, CoordModeOrigin);
      }
    }

  /***********   DRAW IN THE X-SECTIONS    *******************/

  if(mplot->xsec_flag)
    {
    XSetFont(d, ggc, mplot->fonts[2]);
    for(i = 0; i <= mplot->num_xsec; i++)
      {
      dis = sqrt(sqr(mplot->cross[i].xseckm.x2 - mplot->cross[i].xseckm.x1)
		 + sqr(mplot->cross[i].xseckm.y2 - mplot->cross[i].xseckm.y1));
      if(dis != 0.0)
	if(mplot->cross[i].xsec_index > 0) Plot_Xsec(d, w, ggc, mplot, i);
      }			/* end for loop  */
    }

  /***********  DRAW IN THE LABELS   *******************/

  if(mplot->num_labels >= 0) Plot_Labels(d, w, ggc, mplot);

  /* plot contours  */

  if(mplot->plot_cont_flag == 1) draw_cont(mplot); 
  if(mplot->plot_cont_points) Plot_Cont_points(mplot);
  if(mplot->plot_cont_values) Plot_Cont_values(mplot);
  }

/* ----------------------------------------------------- */

/* Tells a widget to repaint one rectangle */

void send_repaint(Widget wij, int x, int y, int w, int h)
  {
  Region exposed;
  XRectangle r = {x, y, w, h};

  exposed = XCreateRegion();
  XUnionRectWithRegion(&r, exposed, exposed);
  redraw_mpic(wij, NULL, exposed);
  XDestroyRegion(exposed);
  }

/* --------------------------------------------------------- */

static void Start_zoom(Widget w, XButtonEvent *ev, String *params,
		       Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  mplot->zoom_org.x = ev->x;
  mplot->zoom_org.y = ev->y;
  mplot->zoom_spot = mplot->zoom_org;
  gscr_num = DefaultScreen(XtDisplay(w));
  XSetForeground(XtDisplay(w), mplot->ggc, BlackPixel(XtDisplay(w),gscr_num));
  XSetBackground(XtDisplay(w), mplot->ggc,  WhitePixel(XtDisplay(w),gscr_num));
  }



static void Resize_zoom(Widget w, XButtonEvent *ev, String *params,
			Cardinal *num_params)
  {
  GC ggc;
  mpic *mplot;
  XPoint p[5];

  char plot_lab[50];
  float plat, plon, xkm, ykm, phi, lam;



  XtVaGetValues(w, XtNdata, &mplot, NULL);
  ggc = mplot->ggc;

  XSetClipMask(XtDisplay(w), ggc, None);
  XSetFunction(XtDisplay(w), ggc, GXnor);

  getbox(mplot->zoom_org.x, mplot->zoom_org.y, mplot->zoom_spot.x,
	 mplot->zoom_spot.y, p);
  XDrawLines(XtDisplay(w), XtWindow(w), ggc, p, 5, CoordModeOrigin);

  mplot->zoom_spot.x = ev->x;
  mplot->zoom_spot.y = ev->y;

  /* Draw new... */

  getbox(mplot->zoom_org.x, mplot->zoom_org.y, mplot->zoom_spot.x,
	 mplot->zoom_spot.y, p);
  XDrawLines(XtDisplay(w), XtWindow(w), ggc, p, 5, CoordModeOrigin);




    xkm = pix_to_user_x(&mplot->gr, (int)ev->x);
    ykm = pix_to_user_y(&mplot->gr, (int)ev->y);
    xy2geo(mplot, &phi, &lam, xkm, ykm);
    plat = phi;
    plon = lam;

    sprintf(plot_lab , "km: %f %f LL: %f %f\n", xkm,
	    ykm, plat, plon);
  

   
   XtVaSetValues(mplot->labshell, XtNlabel, plot_lab, NULL);





  XSetFunction(XtDisplay(w), ggc, GXcopy);
  }

/* ------------------------------------------------------------------ */

/* Create a new window with a zoomed image */

void zoom_data(mpic *mplot, xyxy *size)
  {
  static int num_called = 0;
  char name[20];
  int x1, y1, x2, y2;
  float kx1, kx2, ky1, ky2;
  Dimension w, h;
  Position x, y;

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  /* Make new zoom-window */

  sprintf(name, "zoom-%d\n", ++num_called);

  x1 = size->x1;
  y1 = size->y1;
  x2 = size->x2;
  y2 = size->y2;

  kx1 = (float)pix_to_user_x(&mplot->gr, x1);
  kx2 = (float)pix_to_user_x(&mplot->gr, x2);
  ky1 = (float)pix_to_user_y(&mplot->gr, y1);
  ky2 = (float)pix_to_user_y(&mplot->gr, y2);

  mplot->origin.minx = kx1;
  mplot->origin.maxx = kx2;
  mplot->origin.miny = ky1;
  mplot->origin.maxy = ky2;

  fprintf(stderr, "Km Zoom Box: %f %f %f %f\n", kx1, ky1, kx2, ky2);

  mplot->zoom_flag++;
  mplot->zoom_flag2++;
  mplot->zoom.numpoints++;
  mplot->zoom.zooms[mplot->zoom.numpoints].x1 = mplot->origin.minx;
  mplot->zoom.zooms[mplot->zoom.numpoints].x2 = mplot->origin.maxx;
  mplot->zoom.zooms[mplot->zoom.numpoints].y1 = mplot->origin.miny;
  mplot->zoom.zooms[mplot->zoom.numpoints].y2 = mplot->origin.maxy;
  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w,h);
  }

/******************************/
/* --------------------------------------------------------- */
void Do_right_key(Widget wij, XKeyEvent *ev, String *params, Cardinal *num_params)
{
  static int num_called = 0;
  char name[20];
  float shiftpct=0.25;
  float kx1, kx2, ky1, ky2;
  Dimension w, h;
  Position x, y;
  mpic *mplot;


  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  /* Make new zoom-window */

  sprintf(name, "zoom-%d\n", ++num_called);

  kx1 = (float)mplot->origin.minx+(mplot->origin.maxx-mplot->origin.minx)*shiftpct;
  kx2 = (float)mplot->origin.maxx+(mplot->origin.maxx-mplot->origin.minx)*shiftpct;
  ky1 = (float)mplot->origin.miny;
  ky2 = (float)mplot->origin.maxy;

  mplot->origin.minx = kx1;
  mplot->origin.maxx = kx2;
  mplot->origin.miny = ky1;
  mplot->origin.maxy = ky2;

  /* fprintf(stderr, "Km Zoom Box: %f %f %f %f\n", kx1, ky1, kx2, ky2); */


  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w,h);
}

/* --------------------------------------------------------- */
void Do_left_key(Widget wij, XKeyEvent *ev, String *params, Cardinal *num_params)
{
  static int num_called = 0;
  char name[20];
    float shiftpct=0.25;
  float kx1, kx2, ky1, ky2;
  Dimension w, h;
  Position x, y;
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  /* Make new zoom-window */

  sprintf(name, "zoom-%d\n", ++num_called);

  kx1 = (float)mplot->origin.minx-(mplot->origin.maxx-mplot->origin.minx)*shiftpct;
  kx2 = (float)mplot->origin.maxx-(mplot->origin.maxx-mplot->origin.minx)*shiftpct;
  ky1 = (float)mplot->origin.miny;
  ky2 = (float)mplot->origin.maxy;

  mplot->origin.minx = kx1;
  mplot->origin.maxx = kx2;
  mplot->origin.miny = ky1;
  mplot->origin.maxy = ky2;

 /*  fprintf(stderr, "Km Zoom Box: %f %f %f %f\n", kx1, ky1, kx2, ky2); */


  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w,h);
}
/* --------------------------------------------------------- */
void Do_up_key(Widget wij, XKeyEvent *ev, String *params, Cardinal *num_params)
{
  static int num_called = 0;
  char name[20];
    float shiftpct=0.25;
  float kx1, kx2, ky1, ky2;
  Dimension w, h;
  Position x, y;
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  /* Make new zoom-window */

  sprintf(name, "zoom-%d\n", ++num_called);

  kx1 = (float)mplot->origin.minx;
  kx2 = (float)mplot->origin.maxx;
  ky1 = (float)mplot->origin.miny+(mplot->origin.maxy-mplot->origin.miny)*shiftpct;
  ky2 = (float)mplot->origin.maxy+(mplot->origin.maxy-mplot->origin.miny)*shiftpct;

  mplot->origin.minx = kx1;
  mplot->origin.maxx = kx2;
  mplot->origin.miny = ky1;
  mplot->origin.maxy = ky2;

 /*  fprintf(stderr, "Km Zoom Box: %f %f %f %f\n", kx1, ky1, kx2, ky2); */


  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w,h);
}
/* --------------------------------------------------------- */
void Do_down_key(Widget wij, XKeyEvent *ev, String *params, Cardinal *num_params)
{
 static int num_called = 0;
  char name[20];
    float shiftpct=0.25;
  float kx1, kx2, ky1, ky2;
  Dimension w, h;
  Position x, y;
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  /* Make new zoom-window */

  sprintf(name, "zoom-%d\n", ++num_called);
  kx1 = (float)mplot->origin.minx;
  kx2 = (float)mplot->origin.maxx;
  ky1 = (float)mplot->origin.miny-(mplot->origin.maxy-mplot->origin.miny)*shiftpct;
  ky2 = (float)mplot->origin.maxy-(mplot->origin.maxy-mplot->origin.miny)*shiftpct;

 

  mplot->origin.minx = kx1;
  mplot->origin.maxx = kx2;
  mplot->origin.miny = ky1;
  mplot->origin.maxy = ky2;

  /* fprintf(stderr, "Km Zoom Box: %f %f %f %f\n", kx1, ky1, kx2, ky2); */


  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w,h);
}



/* --------------------------------------------------------- */
static void start_great(Widget w, XButtonEvent *ev, String *params,
		       Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  mplot->zoom_org.x = ev->x;
  mplot->zoom_org.y = ev->y;
  mplot->zoom_spot = mplot->zoom_org;
  gscr_num = DefaultScreen(XtDisplay(w));
  XSetForeground(XtDisplay(w), mplot->ggc, BlackPixel(XtDisplay(w),gscr_num));
  XSetBackground(XtDisplay(w), mplot->ggc,  WhitePixel(XtDisplay(w),gscr_num));
  }

/* --------------------------------------------------------- */

static void resize_great(Widget w, XButtonEvent *ev, String *params,
			Cardinal *num_params)
  {
  GC ggc;
  mpic *mplot;
  XPoint *p;
  
  float kx1, kx2, ky1, ky2, phi1, lam1, phi2, lam2, dx, dy;
  double *phis, *lams;
   int i, num=10;
  
     
  XtVaGetValues(w, XtNdata, &mplot, NULL);
  ggc = mplot->ggc;

  XSetClipMask(XtDisplay(w), ggc, None);
  XSetFunction(XtDisplay(w), ggc, GXnor);


  kx1 = (float)pix_to_user_x(&mplot->gr, mplot->zoom_org.x);
  kx2 = (float)pix_to_user_x(&mplot->gr, mplot->zoom_spot.x);
  ky1 = (float)pix_to_user_y(&mplot->gr,mplot->zoom_org.y );
  ky2 = (float)pix_to_user_y(&mplot->gr, mplot->zoom_spot.y);
  
  xy2geo(mplot, &phi1, &lam1, kx1, ky1);
  xy2geo(mplot, &phi2, &lam2, kx2, ky2);

  phis = alloc_dvec(0, num+1);
  lams = alloc_dvec(0, num+1);
  p = (XPoint *) calloc(num+1, sizeof(XPoint));

  Get_Great(phi1, lam1, phi2, lam2, num, phis, lams );

  for(i=0; i<num+1; i++)
    {

	geo2xy(mplot, phis[i], lams[i], &dx, &dy);
	p[i].x = user_to_pix_x(&mplot->gr, (double)dx);
	p[i].y = user_to_pix_y(&mplot->gr, (double)dy);
    }

  
  XDrawLines(XtDisplay(w), XtWindow(w), ggc, p, num+1, CoordModeOrigin);

  mplot->zoom_spot.x = ev->x;
  mplot->zoom_spot.y = ev->y;
  kx2 = (float)pix_to_user_x(&mplot->gr, mplot->zoom_spot.x);
  ky2 = (float)pix_to_user_y(&mplot->gr, mplot->zoom_spot.y);
  xy2geo(mplot, &phi2, &lam2, kx2, ky2);
  Get_Great(phi1, lam1, phi2, lam2, num, phis, lams );


  
  /* Draw new... */
  for(i=0; i<num+1; i++)
    {

	geo2xy(mplot, phis[i], lams[i], &dx, &dy);
	p[i].x = user_to_pix_x(&mplot->gr, (double)dx);
	p[i].y = user_to_pix_y(&mplot->gr, (double)dy);
    }

  
  XDrawLines(XtDisplay(w), XtWindow(w), ggc, p, num+1, CoordModeOrigin);

 
  XSetFunction(XtDisplay(w), ggc, GXcopy);


  free(phis);
  free(lams);
  free(p);
  
  }

/* ------------------------------------------------------------------ */
void test_great_intersections(mpic *mplot, double phi1 , double lam1, double phi2 , double lam2)
{
   int i;
  
   double dlat1,  dlon1, dlat2, dlon2 ;
   double elat1, elon1, elat2, elon2;
   double thelat, thelon;
   float x, y, x1, y1, x2, y2;

   int iy, ix = 20, hsize=20, circle = 23040;

   double *phis, *lams;
   float rx, ry, ddis;
   int  num=10, j, pode, io1, io2;
   float **poly;
   float  cx1,  cy1, cx2, cy2 ;

   XPoint *p;

   p = (XPoint *) calloc(num+1, sizeof(XPoint));
   phis = alloc_dvec(0, num+1);
   lams = alloc_dvec(0, num+1);

   geo2xy(mplot, (float)mplot->origin.phimin, (float)mplot->origin.lammin, &cx1, &cy1);
   geo2xy(mplot, (float)mplot->origin.phimax, (float)mplot->origin.lammax, &cx2, &cy2);

   poly = alloc_fmat((long)0, (long)4,
		     (long)0 ,(long)1);
   
   poly[0][0] = cx1;
   poly[0][1] = cy1;
   
   poly[1][0] = cx2;
   poly[1][1] = cy1;
   
   poly[2][0] = cx2;
   poly[2][1] = cy2;
   
   poly[3][0] = cx1;
   poly[3][1] = cy2;
   
   poly[4][0] = cx1;
   poly[4][1] = cy1;

            /*    work on the latitudes  */
      fprintf(stderr, "work on the latitudes \n");
   ddis = (double)(mplot->origin.phimax - mplot->origin.phimin)/10.0;
   dlon1 = (double)mplot->origin.lammin;
   dlon2 = (double)mplot->origin.lammax;
   dlat1 = dlat2 = mplot->origin.phimin-ddis; 
   
   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(2)]);
   pode = 1;
   if(phi1>phi2) pode = 2;
   
   for(i=0; i<10; i++)
   {
      dlat1 += (double)ddis;
      dlat2 = dlat1;
      GC_intersection(phi1 , lam1, phi2 ,lam2,
		      dlat1, dlon1, dlat2, dlon2,
		      &elat1, &elon1, &elat2, &elon2);
 
      /* fprintf(stderr, "%f %f %f %f\n", elat1, elon1, elat2, elon2); */
      fprintf(stderr, "%f %f %f %f\n", dlat1, dlon1, dlat2, dlon2);

     geo2xy(mplot, (float)elat1, (float)elon1, &x1, &y1);
      
      io1 = Inpoly(x1, y1,  5, poly);
      geo2xy(mplot, (float)elat2, (float)elon2, &x2, &y2);
      io2 = Inpoly(x2, y2,  5, poly);

      if(io1==0 && io2 == 0)
      {

	    fprintf(stderr, "%f %f OUT  1:%f %f 2:%f %f\n",x1, y1, elat1, elon1, elat2, elon2);
	    continue;
      }

      if(io1==1)  
      {
	 thelat = elat1;
	 thelon = elon1;
	 x = x1; y = y1;
	 fprintf(stderr, "%f %f IN\n",thelat, thelon);

      }
      if(io2==1)  
      {
	 thelat = elat2;
	 thelon = elon2;
	 x = x2; y = y2;
	 fprintf(stderr, "%f %f IN\n",thelat, thelon);
      }

      
      ix = user_to_pix_x(&mplot->gr, (double)x);
      iy = user_to_pix_y(&mplot->gr, (double)y); 
      
      XDrawArc(XtDisplay(mplot->wij) , XtWindow(mplot->wij) , mplot->ggc, 
	       ix-hsize/2, iy-hsize/2, hsize, hsize, 0, circle);
      
      Get_Great(dlat1, dlon1, dlat2, dlon2, num, phis, lams );
      /* Draw new... */
      for(j=0; j<num+1; j++)
      {
	 geo2xy(mplot, phis[j], lams[j], &rx, &ry);
	 p[j].x = user_to_pix_x(&mplot->gr, (double)rx);
	 p[j].y = user_to_pix_y(&mplot->gr, (double)ry);
      }

      XDrawLines(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc, p, num+1, CoordModeOrigin);

   }
/*   work on the longitudes   */
   fprintf(stderr, "work on the longitudes \n");
   ddis = (double)(mplot->origin.lammax - mplot->origin.lammin)/10.0;
   dlon1 = (double)mplot->origin.lammin-ddis;
   dlon2 = (double)mplot->origin.lammax;
   dlat1 =  (double)mplot->origin.phimin; 
   dlat2 =  (double)mplot->origin.phimax; 
 
   
   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(1)]);
   
   for(i=0; i<10; i++)
   {
     dlon1 += (double)ddis;
      dlon2 = dlon1;
      GC_intersection(phi1 , lam1, phi2 ,lam2,
		      dlat1, dlon1, dlat2, dlon2,
		      &elat1, &elon1, &elat2, &elon2);
      
      /* fprintf(stderr, "%f %f %f %f\n", elat1, elon1, elat2, elon2); */
      fprintf(stderr, "%f %f %f %f\n", dlat1, dlon1, dlat2, dlon2);

      geo2xy(mplot, (float)elat1, (float)elon1, &x1, &y1);
      
      io1 = Inpoly(x1, y1,  5, poly);
      geo2xy(mplot, (float)elat2, (float)elon2, &x2, &y2);
      io2 = Inpoly(x2, y2,  5, poly);

      if(io1==0 && io2 == 0)
      {

	    fprintf(stderr, "%f %f OUT  1:%f %f 2:%f %f\n",x1, y1, elat1, elon1, elat2, elon2);
	    continue;
      }

      if(io1==1)  
      {
	 thelat = elat1;
	 thelon = elon1;
	 x = x1; y = y1;
	 fprintf(stderr, "%f %f IN\n",thelat, thelon);

      }
      if(io2==1)  
      {
	 thelat = elat2;
	 thelon = elon2;
	 x = x2; y = y2;
	 fprintf(stderr, "%f %f IN\n",thelat, thelon);
      }

      ix = user_to_pix_x(&mplot->gr, (double)x);
      iy = user_to_pix_y(&mplot->gr, (double)y); 

      XDrawArc(XtDisplay(mplot->wij) , XtWindow(mplot->wij) , mplot->ggc, 
	       ix-hsize/2, iy-hsize/2, hsize, hsize, 0, circle);

      Get_Great(dlat1, dlon1, dlat2, dlon2, num, phis, lams );
      /* Draw new... */
      for(j=0; j<num+1; j++)
      {
	 geo2xy(mplot, (float)phis[j], (float)lams[j], &rx, &ry);
	 p[j].x = user_to_pix_x(&mplot->gr, (double)rx);
	 p[j].y = user_to_pix_y(&mplot->gr, (double)ry);
      }

      XDrawLines(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc, p, num+1, CoordModeOrigin);
 
   }






   free(phis);
   free(lams);
   free(p);
   free_fmat(poly, 0, 4, 0, 1);




}
/* ------------------------------------------------------------------ */
void test_tomo_intersections(mpic *mplot, double phi1 , double lam1, double phi2 , double lam2)
{
   int i, KOUNT;
   double elat1, elat2, elon1;
   
   float  x,y;
   double *phis, *lams;
   int *ivec;
   float *rvec;
   int iy, ix = 20, hsize=6, circle = 23040;
   int num;

   num = mplot->image.nx+ mplot->image. ny+2;
   phis = alloc_dvec(0, num);
   lams = alloc_dvec(0, num);
   ivec = alloc_ivec(0,num);
   rvec = alloc_fvec(0, num);

   KOUNT = simp_greatX(mplot->image.nx, mplot->image. ny, 
	       mplot->image.dx, mplot->image.dy, 
	       mplot->image.phi , mplot->image.lam ,
	       phi1, lam1,
	       phi2, lam2, 
	       ivec, rvec, phis,  lams);

   fprintf(stderr, "intersection plotting the points\n");


   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(2)]);

   for(i=0; i< KOUNT; i++)
   {
      elat1=phis[i];
      elon1=lams[i];

      fprintf(stderr, "%d %f %f\n", i, elat1, elon1);
      geo2xy(mplot, (float)elat1, (float)elon1, &x, &y);
      ix = user_to_pix_x(&mplot->gr, (double)x);
      iy = user_to_pix_y(&mplot->gr, (double)y); 
      XDrawArc(XtDisplay(mplot->wij) , XtWindow(mplot->wij) , mplot->ggc, 
	       ix-hsize/2, iy-hsize/2, hsize, hsize, 0, circle);
   }

   free(phis);
   free(lams);
   free(rvec);
   free(ivec);

}

/*-------------------------------------------------------------------------*/
/* Create a new  great line */
void end_great(Widget w, XButtonEvent *ev, String *params, Cardinal *num_params)
  {
     GC ggc;
  mpic *mplot;
  
  int i;

  float kx1, kx2, ky1, ky2, phi1, lam1, phi2, lam2;
  double dis1, dis2, dx, dy;
  

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  ggc = mplot->ggc;
  
  
  kx1 = (float)pix_to_user_x(&mplot->gr, mplot->zoom_org.x);
  kx2 = (float)pix_to_user_x(&mplot->gr, mplot->zoom_spot.x);
  ky1 = (float)pix_to_user_y(&mplot->gr,mplot->zoom_org.y );
  ky2 = (float)pix_to_user_y(&mplot->gr, mplot->zoom_spot.y); 
  xy2geo(mplot, &phi1, &lam1, kx1, ky1);
  xy2geo(mplot, &phi2, &lam2, kx2, ky2);
  
  
  dx = great_dist((double)deg2rad(phi1), (double)deg2rad(lam1),
		  (double)deg2rad(phi2), (double) deg2rad(lam2));
  dy = rad2deg(dx);
  dis1 = EARTHRAD*dx;
  dis2 = sqrt(  (kx2-kx1)*(kx2-kx1) +  (ky2-ky1)*(ky2-ky1));
  fprintf(stderr," Point1: %f %f Deg Point2: %f %f Deg\n", phi1, lam1, phi2, lam2);
  fprintf(stderr," Point1: %f %f Km Point2: %f %f  Km\n", kx1, ky1, kx2, ky2);
  
  fprintf(stderr," EGAngle = %f degrees, Distance1=%f km  Distance2=%f km\n",
	  dy, dis1, dis2);
  
  test_tomo_intersections(mplot, (double)phi1 , (double)lam1, (double)phi2 , (double)lam2);
  

  }

/* Create a new great circle cross section  line */
/** FUNC DEF **/ void Do_great_xsec(Widget w, XButtonEvent *ev, String *params, Cardinal *num_params)
{
   GC ggc;
   mpic *mplot;
   static xyxy xs_line;
   
   float kx1, kx2, ky1, ky2, phi1, lam1, phi2, lam2;
   double dis1, dis2, dx, dy;
  int iokay;

   XtVaGetValues(w, XtNdata, &mplot, NULL);
   ggc = mplot->ggc;
   
   
   kx1 = (float)pix_to_user_x(&mplot->gr, mplot->zoom_org.x);
   kx2 = (float)pix_to_user_x(&mplot->gr, mplot->zoom_spot.x);
   ky1 = (float)pix_to_user_y(&mplot->gr,mplot->zoom_org.y );
   ky2 = (float)pix_to_user_y(&mplot->gr, mplot->zoom_spot.y); 
   xy2geo(mplot, &phi1, &lam1, kx1, ky1);
   xy2geo(mplot, &phi2, &lam2, kx2, ky2);
   
   
   dx = great_dist((double)deg2rad(phi1), (double)deg2rad(lam1),
		   (double)deg2rad(phi2), (double) deg2rad(lam2));
   dy = rad2deg(dx);
   dis1 = EARTHRAD*dx;
   dis2 = sqrt(  (kx2-kx1)*(kx2-kx1) +  (ky2-ky1)*(ky2-ky1));
   fprintf(stderr," Point1: %f %f Deg Point2: %f %f Deg\n", phi1, lam1, phi2, lam2);
   fprintf(stderr," Point1: %f %f Km Point2: %f %f  Km\n", kx1, ky1, kx2, ky2);
   
   fprintf(stderr," Angle = %f degrees, Distance1=%f km  Distance2=%f km\n",
	   dy, dis1, dis2);
	
   
   
   
   xs_line.x1 = mplot->zoom_org.x;
   xs_line.y1 = mplot->zoom_org.y;
   xs_line.x2 = mplot->zoom_spot.x;
   xs_line.y2 = mplot->zoom_spot.y;
   
   /* Undraw old... */
   
   
   /* fprintf(stderr,"Just did a cross section....!\n");*/
   
   mplot->xdipParms.dip = 0.0;
   mplot->xdipParms.minz = mplot->MinDepth;
   mplot->xdipParms.maxz = mplot->MaxDepth;
   mplot->xdipParms.front = mplot->halfwidth;
   mplot->xdipParms.back = mplot->halfwidth;
   
   xs_dip = 90.0;
   min_xsdepth = mplot->MinDepth;
   max_xsdepth = mplot->MaxDepth;
   max_xsfront = mplot->halfwidth;
   max_xsback = mplot->halfwidth;
   fprintf(stderr, "%f %f %f %f %f\n", xs_dip, min_xsdepth, max_xsdepth,
	   max_xsfront, max_xsback);
   iokay = CopyToXDipWindow(&mplot->xdipParms);
#if 0
   /* Cross Section! */
   n = mplot->image.nx + mplot->image.ny + 2;
   PHIvec = alloc_dvec(0, n);
   LAMvec = alloc_dvec(0, n);
   ivec = alloc_ivec(0, n);
   rvec = alloc_fvec(0, n);
     fprintf(stderr, "going to simp_greatX\n");
   nbloc = simp_greatX(
      mplot->image.nx, 
      mplot->image.ny, mplot->image.dx, mplot->image.dy, 
      mplot->image.phi, mplot->image.lam,
      phi1, lam1, phi2, lam2,
      ivec, rvec,
      PHIvec, 
      LAMvec);
     fprintf(stderr, "simp_greatX nbloc=%d\n", nbloc);
   for(i=0; i<nbloc; i++)
   {
      fprintf(stderr, "%f %f %d %f\n", PHIvec[i], LAMvec[i], ivec[i], rvec[i]);
   }
   free(PHIvec);
   free(LAMvec);
   free(ivec);
   free(rvec);
#endif
   make_great_xsect(mplot, &xs_line); 
}


/******************************/
void store_points(Widget wij, mpic *mplot, char *call_data)
  {
  char *source_file;
  char ofile[100];
  
  
  if((source_file = getenv("XMA_SPE_PPS")) == NULL)
    {
    strcpy(ofile, "DUMP_POINTS");
    }
else
  {
    strcpy(ofile, source_file);
    }
  
  
  

  mplot->points_store = !mplot->points_store;

  if(mplot->pointsFP != NULL)
    {
    fclose(mplot->pointsFP);
    }
  
  if(mplot->points_store==1)
    {
    if((mplot->pointsFP = fopen(ofile, "w"))== NULL)
      {
      fprintf(stderr,"can't open file %s....\n", ofile);
      mplot->points_store=0;
      return;
      }

      fprintf(stderr," file %s is open and recieving points\n", ofile);
  return;
      }
else
  {
  
 fprintf(stderr," file %s is closed\n", ofile);
  return;
  }
  
  
  }
/* --------------------------------------------------------- */

void select_restore(Widget wij, mpic *mplot, char *call_data)
  {
  unsigned short x, y, w, h;
  float bx1, by1, phi, lam;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  if(mplot->project_type <=1 )
    {
    mplot->origin.minx = 0.0;
    mplot->origin.maxx = mplot->origin.nxblk * mplot->origin.dx;
    mplot->origin.miny = 0.0;
    mplot->origin.maxy = mplot->origin.nyblk * mplot->origin.dy;
    }

  if(mplot->project_type > 1)
    {
    mplot->origin.minx = 0.0;
    mplot->origin.miny = 0.0;
    phi = mplot->origin.phimin;  
    lam = mplot->origin.lammax;  
    geo2xy(mplot, phi, lam, &bx1, &by1);
    mplot->origin.maxx = bx1;
    phi = mplot->origin.phimax;  
    lam = mplot->origin.lammin;  
    geo2xy(mplot, phi, lam, &bx1, &by1);
    mplot->origin.maxy = by1;
    }

  mplot->zoom_flag = 0;
  mplot->zoom_flag2 = 0;
  mplot->zoom.numpoints = 0;
  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

void Zoom_Out(Widget wij, mpic *mplot, char *call_data)
  {
  unsigned short x, y, w, h;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  if(mplot->zoom_flag2 > 0) mplot->zoom_flag2--;
  else return;

  mplot->origin.minx = mplot->zoom.zooms[mplot->zoom_flag2].x1;
  mplot->origin.maxx = mplot->zoom.zooms[mplot->zoom_flag2].x2;
  mplot->origin.miny = mplot->zoom.zooms[mplot->zoom_flag2].y1;
  mplot->origin.maxy = mplot->zoom.zooms[mplot->zoom_flag2].y2;

  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

void Zoom_In(Widget wij, mpic *mplot, char *call_data)
  {
  unsigned short x, y, w, h;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  if(mplot->zoom_flag2 < mplot->zoom.numpoints) mplot->zoom_flag2++;
  else return;

  mplot->origin.minx = mplot->zoom.zooms[mplot->zoom_flag2].x1;
  mplot->origin.maxx = mplot->zoom.zooms[mplot->zoom_flag2].x2;
  mplot->origin.miny = mplot->zoom.zooms[mplot->zoom_flag2].y1;
  mplot->origin.maxy = mplot->zoom.zooms[mplot->zoom_flag2].y2;

  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/* --------------------------------------------------------- */

void select_snap(Widget wij, mpic *mplot, char *call_data)
  {

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaSetValues(mplot->shell, XtNx, 10, XtNy, 10, XtNwidth, 900,
		XtNheight, 800, NULL);
  }

/* --------------------------------------------------------- */

void Do_zoom(Widget w, XButtonEvent *ev, String *params, Cardinal *num_params)
  {
  xyxy box;
  mpic *mplot;
  XPoint p[5];

  XtVaGetValues(w, XtNdata, &mplot, NULL);

  /*  Set up the Zooming Box */

  box.x1 = mplot->zoom_org.x;
  box.y1 = mplot->zoom_org.y;
  box.x2 = mplot->zoom_spot.x;
  box.y2 = mplot->zoom_spot.y;

  getbox(mplot->zoom_org.x, mplot->zoom_org.y, mplot->zoom_spot.x,
	 mplot->zoom_spot.y, p);
  XDrawLines(XtDisplay(w), XtWindow(w), mplot->zoom_gc, p, 5, CoordModeOrigin);

  /* if the box is backward flip it so the bottom left corner is the origin */

  if(mplot->zoom_org.x >= mplot->zoom_spot.x)
    {
    box.x1 = mplot->zoom_spot.x;
    box.x2 = mplot->zoom_org.x;
    mplot->zoom_org.x = box.x1;
    mplot->zoom_spot.x = box.x2;	
    }

  if(mplot->zoom_org.y < mplot->zoom_spot.y)
    {
    box.y1 = mplot->zoom_spot.y;
    box.y2 =  mplot->zoom_org.y;
    mplot->zoom_org.y = box.y1;
    mplot->zoom_spot.y = box.y2;	
    }

  if((box.x2-box.x1) <= 3 || (box.y1-box.y2) <= 3)
    {
    fprintf(stderr,"The zoom box is too Small, Cancelling...BOX %d %d %d %d\n",
	    box.x1, box.y1, box.x2, box.y2);
    return;
    }

  /* Zoom! */
  zoom_data(mplot, &box);
  }

/* ------------------------------------------------------------------ */

void Start_xsect(Widget w, XButtonEvent *ev, String *params,
		 Cardinal *num_params)
  {
  mpic *mplot;
  XPoint p[5];
  float dis, deltax, deltay, hx, hy;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  /* XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
     mplot->colors[mplot->xsec_col]); */

  XSetFont(XtDisplay(mplot->wij), mplot->ggc, mplot->fonts[0]);

  hx = mplot->halfwidth * mplot->gr.pix_xdif / mplot->gr.user_xdif;
  hy = mplot->halfwidth * mplot->gr.pix_ydif / mplot->gr.user_ydif;

  mplot->xsect_org.x = ev->x;
  mplot->xsect_org.y = ev->y;
  mplot->xsect_spot = mplot->xsect_org;
       
  XDrawLine(XtDisplay(w), XtWindow(w), mplot->xsect_gc, mplot->xsect_org.x,
	    mplot->xsect_org.y, mplot->xsect_spot.x, mplot->xsect_spot.y);

  dis = sqrt((float)(mplot->xsect_spot.x - mplot->xsect_org.x)
	     * (float)(mplot->xsect_spot.x - mplot->xsect_org.x)
	     + (float)(mplot->xsect_spot.y - mplot->xsect_org.y)
	     * (float)(mplot->xsect_spot.y - mplot->xsect_org.y));

  if(dis != 0.0)
    {
    deltax = hx * (float)(mplot->xsect_spot.y - mplot->xsect_org.y) / dis;
    deltay = hy * (float)(mplot->xsect_spot.x - mplot->xsect_org.x) / dis;

    p[0].x = mplot->xsect_org.x + deltax; 
    p[0].y = mplot->xsect_org.y - deltay;
    p[1].x = mplot->xsect_org.x - deltax; 
    p[1].y = mplot->xsect_org.y + deltay;
    p[2].x = mplot->xsect_spot.x - deltax; 
    p[2].y = mplot->xsect_spot.y + deltay;
    p[3].x = mplot->xsect_spot.x + deltax; 
    p[3].y = mplot->xsect_spot.y - deltay;
    p[4].x = mplot->xsect_org.x + deltax; 
    p[4].y = mplot->xsect_org.y - deltay;
     
    XDrawLines(XtDisplay(w), XtWindow(w), mplot->xsect_gc, p, 5,
	       CoordModeOrigin);
    }

  gscr_num = DefaultScreen(XtDisplay(w));
  XSetForeground(XtDisplay(w), mplot->ggc, BlackPixel(XtDisplay(w), gscr_num));
  XSetBackground(XtDisplay(w), mplot->ggc, WhitePixel(XtDisplay(w), gscr_num));

  /* fprintf(stderr, " starting Cross-Xsec \n"); */
  }

/* --------------------------------------------------------- */

void Resize_xsect(Widget w, XButtonEvent *ev, String *params,
		  Cardinal *num_params)
  {
  GC ggc;
  mpic *mplot;
  char s[30];
  float strike, dis, deltax, deltay, hx, hy;
  XPoint p[5];
  double dx, dy;
 
  XtVaGetValues(w, XtNdata, &mplot, NULL);
  ggc = mplot->ggc;
  XSetClipMask(XtDisplay(w), ggc, None);
  XSetFunction(XtDisplay(w), ggc, GXnor);

  hx = mplot->halfwidth * mplot->gr.pix_xdif / mplot->gr.user_xdif;
  hy = mplot->halfwidth * mplot->gr.pix_ydif / mplot->gr.user_ydif;

  /* Undraw old... */
  XDrawLine(XtDisplay(w), XtWindow(w), ggc, mplot->xsect_org.x,
	    mplot->xsect_org.y, mplot->xsect_spot.x, mplot->xsect_spot.y);

  dis = sqrt((float)(mplot->xsect_spot.x - mplot->xsect_org.x)
	     * (float)(mplot->xsect_spot.x - mplot->xsect_org.x)
	     + (float)(mplot->xsect_spot.y - mplot->xsect_org.y)
	     * (float)(mplot->xsect_spot.y - mplot->xsect_org.y));
  if(dis != 0.0)
    {
    deltax = hx * (float)(mplot->xsect_spot.y - mplot->xsect_org.y) / dis;
    deltay = hy * (float)(mplot->xsect_spot.x - mplot->xsect_org.x) / dis;

    p[0].x = mplot->xsect_org.x + deltax; 
    p[0].y = mplot->xsect_org.y - deltay;
    p[1].x = mplot->xsect_org.x - deltax; 
    p[1].y = mplot->xsect_org.y + deltay;
    p[2].x = mplot->xsect_spot.x - deltax; 
    p[2].y = mplot->xsect_spot.y + deltay;
    p[3].x = mplot->xsect_spot.x + deltax; 
    p[3].y = mplot->xsect_spot.y - deltay;
    p[4].x = mplot->xsect_org.x + deltax; 
    p[4].y = mplot->xsect_org.y - deltay;

    XDrawLines(XtDisplay(w), XtWindow(w), ggc, p, 5, CoordModeOrigin);
    }

  mplot->xsect_spot.x = ev->x;
  mplot->xsect_spot.y = ev->y;

  /* Draw new... */
  XDrawLine(XtDisplay(w), XtWindow(w), ggc, mplot->xsect_org.x,
	    mplot->xsect_org.y, mplot->xsect_spot.x, mplot->xsect_spot.y);

  dis = sqrt((float)(mplot->xsect_spot.x - mplot->xsect_org.x)
	     * (float)(mplot->xsect_spot.x - mplot->xsect_org.x)
	     + (float)(mplot->xsect_spot.y - mplot->xsect_org.y)
	     * (float)(mplot->xsect_spot.y - mplot->xsect_org.y));
  if(dis != 0.0)
    {
    deltax = hx * (float)(mplot->xsect_spot.y - mplot->xsect_org.y) / dis;
    deltay = hy * (float)(mplot->xsect_spot.x - mplot->xsect_org.x) / dis;

    p[0].x = mplot->xsect_org.x + deltax; 
    p[0].y = mplot->xsect_org.y - deltay;
    p[1].x = mplot->xsect_org.x - deltax; 
    p[1].y = mplot->xsect_org.y + deltay;
    p[2].x = mplot->xsect_spot.x - deltax; 
    p[2].y = mplot->xsect_spot.y + deltay;
    p[3].x = mplot->xsect_spot.x + deltax; 
    p[3].y = mplot->xsect_spot.y - deltay;
    p[4].x = mplot->xsect_org.x + deltax; 
    p[4].y = mplot->xsect_org.y - deltay;

    XDrawLines(XtDisplay(w), XtWindow(w), ggc, p, 5, CoordModeOrigin);
    }
    
  dx = ((float)pix_to_user_x(&mplot->gr, (int)mplot->xsect_spot.x)
	- (float)pix_to_user_x(&mplot->gr, (int)mplot->xsect_org.x));
  dy = ((float)pix_to_user_y(&mplot->gr, (int)mplot->xsect_spot.y)
	- (float)pix_to_user_y(&mplot->gr, (int)mplot->xsect_org.y));

  strike =  57.295778667 * atan2(dx, dy);

  dis = sqrt((double)(sqr(dx) + sqr(dy)));

  if(strike < 0.0) strike += 360;

  sprintf(s, "(%10g,%10g)", strike, dis);
  XClearArea(XtDisplay(w), XtWindow(w), mplot->ScreenX - 100, 1, 100, 18,
	     False);
  XDrawString(XtDisplay(w), XtWindow(w), ggc, mplot->ScreenX - 100, 17,
	      s, strlen(s));

  XSetFunction(XtDisplay(w), ggc, GXcopy);
  }

/* ------------------------------------------------------------------ */

void make_xsect(mpic *mplot, xyxy *l)
  {
    Colormap  xcmap;
    float Az, Len;
  fxyxy lina, line =
    {
    (float)pix_to_user_x(&mplot->gr, (int)l->x1),
    (float)pix_to_user_y(&mplot->gr, (int)l->y1),
    (float)pix_to_user_x(&mplot->gr, (int)l->x2),
    (float)pix_to_user_y(&mplot->gr, (int)l->y2)
    };
  xsec *x;
  Widget top;
  char name[20];
  float phi, lam, dis, dotpkm, **p1, **p2;
  int j, kount, i, n1, k, m, pixdis;
  Position ex,y;
  Dimension width, height;

  dis = sqrt((line.x2 - line.x1) * (line.x2 - line.x1) + (line.y2 - line.y1)
	     * (line.y2 - line.y1));

pixdis =  sqrt((double)((l->x2 - l->x1) * (l->x2 - l->x1) + (l->y2 - l->y1)
	     * (l->y2 - l->y1)));

  if(pixdis < 10)
    {
    fprintf(stderr, "X-SECTION LINE  too short (must be greater than 10 pixels): "
	    "\n****** IGNORE last cross section\n");
    return;
    }
  j = ++numx_called;

  sprintf(name, "xsec-%d\n", j);

  top = XtVaAppCreateShell(name, "Geotouch-xsect", applicationShellWidgetClass,
			   XtDisplay(mplot->wij), NULL);
  XtVaGetValues(mplot->shell, XtNcolormap, &xcmap , NULL);

  XtVaSetValues(top , XtNcolormap, xcmap , NULL);



  x = XmapNewElement(xsec);

   

  /* Load info into the cross-section */
  x->line = line;
  x->m = mplot;
  x->xwidth = mplot->halfwidth;
  x->xscale = (float)mplot->gr.pix_xdif / mplot->gr.user_xdif;
  x->index = j;
  x->X_Above = 0;
  x->X_Image_Above = 0;

  x->xs_explode = 0;
  x->sta_elevation_flag = 0;
  x->num_labels = -1;
  x->do_select = 0;
  x->Xmargin = 50;
  x->Ymargin = 60;
  x->dip_meter_flag = 0;
  xs_dip = mplot->xdipParms.dip + 90;
  x->xs_dip = mplot->xdipParms.dip + 90;
  x->dip = mplot->xdipParms.dip + 90;
  x->field_style_flag = -1;
  x->min_xsdepth = mplot->xdipParms.minz;
  x->max_xsdepth = mplot->xdipParms.maxz;
  x->max_xsfront =mplot->xdipParms.front;
  x->max_xsback = -mplot->xdipParms.back;
  get_rect_vol( x->line.x1, x->line.y1, x->line.x2, x->line.y2, xs_dip, x->RM);
  x->xdepth = x->max_xsdepth;


    if(mplot->focal_total_num>0)
       { 
       x->focpos =  XmapNewArray(fxyxy, mplot->focal_total_num);
       x->focrad =  XmapNewArray(float, mplot->focal_total_num);
       x->FOC_IN =  XmapNewArray(int, mplot->focal_total_num);
       x->focind =  XmapNewArray(int, mplot->focal_total_num);
       x->focind_file =  XmapNewArray(int, mplot->focal_total_num);
       }
 



  /* for(i = 0; i < nx ; i++)
     for (j = 0; j < ny; j++){
     fprintf(stderr, "xval[%d][%d]=%g     %d\n",i,j,
     mplot->contParms.surf_grd->val[j*nx+i], j*nx+i); } */

  /*  get the correct x->XSEC_angle first */

  if((x->line.x2 - x->line.x1) != 0.0)
    x->XSEC_angle =  57.29578 * atan((x->line.y2 - x->line.y1)
				     / (x->line.x2 - x->line.x1));
  else x->XSEC_angle = 90.0;

  /* first quadrant - Do nothing */

  /* second quadrant */

  if(x->line.x2 < x->line.x1 && x->line.y2 > x->line.y1)       
    (x->XSEC_angle) += 180.0;

  /* third quadrant */

  if(x->line.x2 < x->line.x1 && x->line.y2 < x->line.y1)
    (x->XSEC_angle) += 180.0;

  /* fourth quadrant */

  if(x->line.x2 > x->line.x1 && x->line.y2 < x->line.y1)
    (x->XSEC_angle) += 360.0;

  x->x_left = 0.0;
  x->x_right = sqrt((x->line.x1 - x->line.x2) * (x->line.x1 - x->line.x2)
		    + (x->line.y1 - x->line.y2) * (x->line.y1 - x->line.y2));
  x->y_top = x->min_xsdepth; 
  x->y_bot = x->xdepth;
  mplot->num_xsec++;        
  mplot->cross[mplot->num_xsec].xsec_index = j;
  fprintf(stderr, "X-SECTION %d LINE: %f %f %f %f \n", j, XYXY(line));
  

  mplot->cross[mplot->num_xsec].xseckm.x1 = line.x1;
  mplot->cross[mplot->num_xsec].xseckm.x2 = line.x2;
  mplot->cross[mplot->num_xsec].xseckm.y1 = line.y1;
  mplot->cross[mplot->num_xsec].xseckm.y2 = line.y2;
  mplot->cross[mplot->num_xsec].xsecline.x1 = l->x1;
  mplot->cross[mplot->num_xsec].xsecline.x2 = l->x2;
  mplot->cross[mplot->num_xsec].xsecline.y1 = l->y1;
  mplot->cross[mplot->num_xsec].xsecline.y2 = l->y2;

  /*  these values are in x,y kilometers now relative to the origin! */

  xy2geo(mplot, &phi, &lam, line.x1, line.y1);

  mplot->cross[mplot->num_xsec].xsecphilam.x1 = phi;
  mplot->cross[mplot->num_xsec].xsecphilam.y1 = lam;

  xy2geo(mplot, &phi, &lam, line.x2, line.y2);

  mplot->cross[mplot->num_xsec].xsecphilam.x2 = phi;
  mplot->cross[mplot->num_xsec].xsecphilam.y2 = lam;

  fprintf(stderr, "X-SECTION %d LAT-LON: %f %f %f %f width=%f depth=%f\n", j,
	  mplot->cross[mplot->num_xsec].xsecphilam.x1,
	  mplot->cross[mplot->num_xsec].xsecphilam.y1,
	  mplot->cross[mplot->num_xsec].xsecphilam.x2,
	  mplot->cross[mplot->num_xsec].xsecphilam.y2, x->xwidth, x->xdepth);
  fprintf(stderr, "X-SECTION %d STRIKE-DIP-Plunge: %f %f %f\n", j,
	  x->XSEC_angle, xs_dip, mplot->xdipParms.dip);
  mplot->cross[mplot->num_xsec].xsecwidth = mplot->halfwidth;
  mplot->cross[mplot->num_xsec].xsecdepth = mplot->xdipParms.minz;
  mplot->cross[mplot->num_xsec].xs_dip = xs_dip;
  mplot->cross[mplot->num_xsec].min_xsdepth = mplot->xdipParms.minz;
  mplot->cross[mplot->num_xsec].max_xsdepth = mplot->xdipParms.maxz;
  mplot->cross[mplot->num_xsec].max_xsfront = mplot->xdipParms.front;
  mplot->cross[mplot->num_xsec].max_xsback = mplot->xdipParms.back;
  Az = rad2deg( atan2( (line.y2- line.y1) ,  (line.x2-line.x1)));
  Len = sqrt( (line.x2-line.x1)*(line.x2-line.x1)+(line.y2- line.y1)*(line.y2- line.y1));
  
  fprintf(stderr, "X-SET_UP: %f %f %f %f %f %f %f\n",
	  mplot->cross[mplot->num_xsec].xsecphilam.x1,
	  mplot->cross[mplot->num_xsec].xsecphilam.y1,
	  Az,
	  Len,
	  mplot->halfwidth,
	  mplot->xdipParms.minz, mplot->xdipParms.maxz);
   
	  
  dotpkm = mplot->gr.pix_xdif/mplot->gr.user_xdif;
  fprintf(stderr, "X-SECTION: scale = %f %f \n", x->xscale, dotpkm);
    fprintf(stderr, "X-SECTION: minz=%f maxz=%f Angle=%f length=%f\n",mplot->xdipParms.minz, mplot->xdipParms.maxz, Az, Len);
    
  if(mplot->wire_num > 0)
    {
    p1 = alloc_fmat(0, 3, 0, 2);
    p1[0][0] = mplot->cross[mplot->num_xsec].xseckm.x1;
    p1[0][1] = mplot->cross[mplot->num_xsec].xseckm.y1;
    p1[0][2] = mplot->xdipParms.minz;
    p1[1][0] = mplot->cross[mplot->num_xsec].xseckm.x2;
    p1[1][1] = mplot->cross[mplot->num_xsec].xseckm.y2;
    p1[1][2] = mplot->xdipParms.minz;
    p1[2][0] = mplot->cross[mplot->num_xsec].xseckm.x2;
    p1[2][1] = mplot->cross[mplot->num_xsec].xseckm.y2;
    p1[2][2] = mplot->xdipParms.maxz;
    p1[3][0] = mplot->cross[mplot->num_xsec].xseckm.x1;
    p1[3][1] = mplot->cross[mplot->num_xsec].xseckm.y1;
    p1[3][2] = mplot->xdipParms.maxz;
    n1 = 4;
    k = 0;

    /* fprintf(stderr,"Cross Section n1\n");
       fprintf(stderr,"%d\n",n1);
       for(i=0; i<n1; i++)
       fprintf(stderr,"%f %f %f\n", p1[i][0],p1[i][1],p1[i][2]); */

    x->threeD = XmapNewArray(fxyxy, mplot->wire_tot);
    x->col3D = XmapNewArray(int, mplot->wire_tot);
    lina.x1 = 0.0;
    lina.y1 = mplot->xdipParms.minz;
    lina.x2 = dis;
    lina.y2 = mplot->xdipParms.maxz;

                /**********   get the wire frame cuts  here  *********/

    for(kount = 0; kount < mplot->wire_num; kount++)
      {
      for(i = 0; i < mplot->wire[kount].n; i++)
	{
	/* fprintf(stderr,"Poly Section n2 %d\n",i);
	   fprintf(stderr,"%d\n",mplot->wire[kount].poly[i].n); */

	p2 = alloc_fmat(0, mplot->wire[kount].poly[i].n, 0, 2);
	for(j = 0; j < mplot->wire[kount].poly[i].n; j++)
	  {
	  p2[j][0] = mplot->wire[kount].poly[i].kmloc[j].x;
	  p2[j][1] = mplot->wire[kount].poly[i].kmloc[j].y;
	  p2[j][2] = mplot->wire[kount].poly[i].kmloc[j].z;
	   /* fprintf(stdout, "P2 %d %d %f %f %f\n", i, j, p2[j][0],p2[j][1],p2[j][2] );  */
	  }





	 m = goget_intersex(p1, n1, p2, mplot->wire[kount].poly[i].n, &lina); 







/* if(m>0) fprintf(stderr,"answer: %d %f %f %f %f\n", m, lina.x1, lina.y1, lina.x2, lina.y2);  */


	if(m == 0)
	  {
	  /*fprintf(stderr, "m=0\n");*/
	  continue;
	  }

	/* if((lina.y1 >= mplot->xdipParms.minz-wire_tol) && (lina.x1 <= (dis + wire_tol))
	   && (lina.y2 >= mplot->xdipParms.minz-wire_tol) && (lina.x2 <= (dis + wire_tol)))
         */
	 if(m>1) {
	  x->threeD[k].x1 = lina.x1;
	  x->threeD[k].y1 = lina.y1;
	  x->threeD[k].x2 = lina.x2;
	  x->threeD[k].y2 = lina.y2;
	  
	  /* 
	   x->threeD[k].x1 = lina.y1;
	  x->threeD[k].y1 = lina.x1;
	  x->threeD[k].x2 = lina.y2;
	  x->threeD[k].y2 = lina.x2;
	  */

	  x->col3D[k] = mplot->wire[kount].poly[i].col;
	  k++;
	  }
	free_fmat(p2, 0, mplot->wire[kount].poly[i].n, 0, 2);
	}
      }
    x->num_threeD = k;

    /* for(i=0; i<x->num_threeD; i++)
       {
       fprintf(stderr,"X3D: %d %f %f %f %f\n",i, x->threeD[i].x1,
       x->threeD[i].y1, x->threeD[i].x2, x->threeD[i].y2);
       }
       fprintf(stderr, "\n*********\n\n"); */

    free_fmat(p1, 0, 3, 0, 2);
    }

             /**********   get the image here  *********/

  if(mplot->image.nx > 0) 
     { 
	if(mplot->image.KIND == 3)
	{
	   cut_great_image(x);
	}
	else
	{
	   cut_image(x);
	}
     }
  

               /**********   make window and plot  *********/


  make_xsec_window(top, x, mplot->colors, mplot->fonts);

   XtVaSetValues(top, XtNwidth, 500, XtNheight, 500,
		  XtNx, 50, XtNy, 50, NULL);



  XtVaGetValues(mplot->shell, XtNx, &ex, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  /* send_repaint(mplot->wij, 0, 0, width, height); */
  }
/* ------------------------------------------------------------------ */

void make_great_xsect(mpic *mplot, xyxy *l)
  {
    Colormap  xcmap;
    float Az, Len;
  fxyxy lina, line =
    {
    (float)pix_to_user_x(&mplot->gr, (int)l->x1),
    (float)pix_to_user_y(&mplot->gr, (int)l->y1),
    (float)pix_to_user_x(&mplot->gr, (int)l->x2),
    (float)pix_to_user_y(&mplot->gr, (int)l->y2)
    };
  xsec *x;
  Widget top;
  char name[20];
  float phi, lam, dis, dotpkm, **p1, **p2;
  float  phi1, lam1, phi2, lam2;
  int j, kount, i, n1, k, m, pixdis;
  Position ex,y;
  Dimension width, height;



  dis = sqrt((line.x2 - line.x1) * (line.x2 - line.x1) + (line.y2 - line.y1)
	     * (line.y2 - line.y1));

  xy2geo(mplot, &phi1, &lam1, line.x1, line.y1);
  xy2geo(mplot, &phi2, &lam2,  line.x2, line.y2  );
  

 dis = 6371*great_dist((double)deg2rad(phi1), (double)deg2rad(lam1),
		  (double)deg2rad(phi2), (double) deg2rad(lam2));

pixdis =  sqrt((double)((l->x2 - l->x1) * (l->x2 - l->x1) + (l->y2 - l->y1)
	     * (l->y2 - l->y1)));

  if(pixdis < 10)
    {
    fprintf(stderr, "X-SECTION LINE  too short (must be greater than 10 pixels): "
	    "\n****** IGNORE last cross section\n");
    return;
    }
  j = ++numx_called;

  sprintf(name, "xsec-%d\n", j);

  top = XtVaAppCreateShell(name, "Geotouch-xsect", applicationShellWidgetClass,
			   XtDisplay(mplot->wij), NULL);
  XtVaGetValues(mplot->shell, XtNcolormap, &xcmap , NULL);

  XtVaSetValues(top , XtNcolormap, xcmap , NULL);



  x = XmapNewElement(xsec);

   

  /* Load info into the cross-section */
  x->line = line;
  x->m = mplot;
  x->xwidth = mplot->halfwidth;
  x->xscale = (float)mplot->gr.pix_xdif / mplot->gr.user_xdif;
  x->index = j;
  x->X_Above = 0;
  x->X_Image_Above = 0;

  x->xs_explode = 0;
  x->sta_elevation_flag = 0;
  x->num_labels = -1;
  x->do_select = 0;
  x->Xmargin = 50;
  x->Ymargin = 60;
  x->dip_meter_flag = 0;
  xs_dip = mplot->xdipParms.dip + 90;
  x->xs_dip = mplot->xdipParms.dip + 90;
  x->dip = mplot->xdipParms.dip + 90;
  x->field_style_flag = -1;
  x->min_xsdepth = mplot->xdipParms.minz;
  x->max_xsdepth = mplot->xdipParms.maxz;
  x->max_xsfront =mplot->xdipParms.front;
  x->max_xsback = -mplot->xdipParms.back;
  get_rect_vol( x->line.x1, x->line.y1, x->line.x2, x->line.y2, xs_dip, x->RM);
  x->xdepth = x->max_xsdepth;


    if(mplot->focal_total_num>0)
       { 
       x->focpos =  XmapNewArray(fxyxy, mplot->focal_total_num);
       x->focrad =  XmapNewArray(float, mplot->focal_total_num);
       x->FOC_IN =  XmapNewArray(int, mplot->focal_total_num);
       x->focind =  XmapNewArray(int, mplot->focal_total_num);
       x->focind_file =  XmapNewArray(int, mplot->focal_total_num);
       }
 



  /* for(i = 0; i < nx ; i++)
     for (j = 0; j < ny; j++){
     fprintf(stderr, "xval[%d][%d]=%g     %d\n",i,j,
     mplot->contParms.surf_grd->val[j*nx+i], j*nx+i); } */

  /*  get the correct x->XSEC_angle first */

  if((x->line.x2 - x->line.x1) != 0.0)
    x->XSEC_angle =  57.29578 * atan((x->line.y2 - x->line.y1)
				     / (x->line.x2 - x->line.x1));
  else x->XSEC_angle = 90.0;

  /* first quadrant - Do nothing */

  /* second quadrant */

  if(x->line.x2 < x->line.x1 && x->line.y2 > x->line.y1)       
    (x->XSEC_angle) += 180.0;

  /* third quadrant */

  if(x->line.x2 < x->line.x1 && x->line.y2 < x->line.y1)
    (x->XSEC_angle) += 180.0;

  /* fourth quadrant */

  if(x->line.x2 > x->line.x1 && x->line.y2 < x->line.y1)
    (x->XSEC_angle) += 360.0;

  x->x_left = 0.0;
  x->x_right = sqrt((x->line.x1 - x->line.x2) * (x->line.x1 - x->line.x2)
		    + (x->line.y1 - x->line.y2) * (x->line.y1 - x->line.y2));
  x->y_top = x->min_xsdepth; 
  x->y_bot = x->xdepth;
  mplot->num_xsec++;        
  mplot->cross[mplot->num_xsec].xsec_index = j;
  fprintf(stderr, "X-SECTION %d LINE: %f %f %f %f \n", j, XYXY(line));
  

  mplot->cross[mplot->num_xsec].xseckm.x1 = line.x1;
  mplot->cross[mplot->num_xsec].xseckm.x2 = line.x2;
  mplot->cross[mplot->num_xsec].xseckm.y1 = line.y1;
  mplot->cross[mplot->num_xsec].xseckm.y2 = line.y2;
  mplot->cross[mplot->num_xsec].xsecline.x1 = l->x1;
  mplot->cross[mplot->num_xsec].xsecline.x2 = l->x2;
  mplot->cross[mplot->num_xsec].xsecline.y1 = l->y1;
  mplot->cross[mplot->num_xsec].xsecline.y2 = l->y2;

  /*  these values are in x,y kilometers now relative to the origin! */

  xy2geo(mplot, &phi, &lam, line.x1, line.y1);

  mplot->cross[mplot->num_xsec].xsecphilam.x1 = phi;
  mplot->cross[mplot->num_xsec].xsecphilam.y1 = lam;

  xy2geo(mplot, &phi, &lam, line.x2, line.y2);

  mplot->cross[mplot->num_xsec].xsecphilam.x2 = phi;
  mplot->cross[mplot->num_xsec].xsecphilam.y2 = lam;

  fprintf(stderr, "Great X-SECTION %d LAT-LON: %f %f %f %f width=%f depth=%f\n", j,
	  mplot->cross[mplot->num_xsec].xsecphilam.x1,
	  mplot->cross[mplot->num_xsec].xsecphilam.y1,
	  mplot->cross[mplot->num_xsec].xsecphilam.x2,
	  mplot->cross[mplot->num_xsec].xsecphilam.y2, x->xwidth, x->xdepth);
  fprintf(stderr, "Great X-SECTION %d STRIKE-DIP-Plunge: %f %f %f\n", j,
	  x->XSEC_angle, xs_dip, mplot->xdipParms.dip);
  mplot->cross[mplot->num_xsec].xsecwidth = mplot->halfwidth;
  mplot->cross[mplot->num_xsec].xsecdepth = mplot->xdipParms.minz;
  mplot->cross[mplot->num_xsec].xs_dip = xs_dip;
  mplot->cross[mplot->num_xsec].min_xsdepth = mplot->xdipParms.minz;
  mplot->cross[mplot->num_xsec].max_xsdepth = mplot->xdipParms.maxz;
  mplot->cross[mplot->num_xsec].max_xsfront = mplot->xdipParms.front;
  mplot->cross[mplot->num_xsec].max_xsback = mplot->xdipParms.back;
  Az = rad2deg( atan2( (line.y2- line.y1) ,  (line.x2-line.x1)));
  Len = sqrt( (line.x2-line.x1)*(line.x2-line.x1)+(line.y2- line.y1)*(line.y2- line.y1));
  
  fprintf(stderr, "Great X-SET_UP: %f %f %f %f %f %f %f\n",
	  mplot->cross[mplot->num_xsec].xsecphilam.x1,
	  mplot->cross[mplot->num_xsec].xsecphilam.y1,
	  Az,
	  Len,
	  mplot->halfwidth,
	  mplot->xdipParms.minz, mplot->xdipParms.maxz);
   
	  
  dotpkm = mplot->gr.pix_xdif/mplot->gr.user_xdif;
  fprintf(stderr, "Great X-SECTION: scale = %f %f \n", x->xscale, dotpkm);
    fprintf(stderr, "Great X-SECTION: minz=%f maxz=%f Angle=%f length=%f\n",mplot->xdipParms.minz, mplot->xdipParms.maxz, Az, Len);
    
  if(mplot->wire_num > 0)
    {
    p1 = alloc_fmat(0, 3, 0, 2);
    p1[0][0] = mplot->cross[mplot->num_xsec].xseckm.x1;
    p1[0][1] = mplot->cross[mplot->num_xsec].xseckm.y1;
    p1[0][2] = mplot->xdipParms.minz;
    p1[1][0] = mplot->cross[mplot->num_xsec].xseckm.x2;
    p1[1][1] = mplot->cross[mplot->num_xsec].xseckm.y2;
    p1[1][2] = mplot->xdipParms.minz;
    p1[2][0] = mplot->cross[mplot->num_xsec].xseckm.x2;
    p1[2][1] = mplot->cross[mplot->num_xsec].xseckm.y2;
    p1[2][2] = mplot->xdipParms.maxz;
    p1[3][0] = mplot->cross[mplot->num_xsec].xseckm.x1;
    p1[3][1] = mplot->cross[mplot->num_xsec].xseckm.y1;
    p1[3][2] = mplot->xdipParms.maxz;
    n1 = 4;
    k = 0;

    /* fprintf(stderr,"Cross Section n1\n");
       fprintf(stderr,"%d\n",n1);
       for(i=0; i<n1; i++)
       fprintf(stderr,"%f %f %f\n", p1[i][0],p1[i][1],p1[i][2]); */

    x->threeD = XmapNewArray(fxyxy, mplot->wire_tot);
    x->col3D = XmapNewArray(int, mplot->wire_tot);
    lina.x1 = 0.0;
    lina.y1 = mplot->xdipParms.minz;
    lina.x2 = dis;
    lina.y2 = mplot->xdipParms.maxz;

                /**********   get the wire frame cuts  here  *********/

    for(kount = 0; kount < mplot->wire_num; kount++)
      {
      for(i = 0; i < mplot->wire[kount].n; i++)
	{
	/* fprintf(stderr,"Poly Section n2 %d\n",i);
	   fprintf(stderr,"%d\n",mplot->wire[kount].poly[i].n); */

	p2 = alloc_fmat(0, mplot->wire[kount].poly[i].n, 0, 2);
	for(j = 0; j < mplot->wire[kount].poly[i].n; j++)
	  {
	  p2[j][0] = mplot->wire[kount].poly[i].kmloc[j].x;
	  p2[j][1] = mplot->wire[kount].poly[i].kmloc[j].y;
	  p2[j][2] = mplot->wire[kount].poly[i].kmloc[j].z;
	   /* fprintf(stdout, "P2 %d %d %f %f %f\n", i, j, p2[j][0],p2[j][1],p2[j][2] );  */
	  }
	 m = goget_intersex(p1, n1, p2, mplot->wire[kount].poly[i].n, &lina); 
          /* if(m>0) fprintf(stderr,"answer: %d %f %f %f %f\n", m, lina.x1, lina.y1, lina.x2, lina.y2);  */
	if(m == 0)
	  {
	  /*fprintf(stderr, "m=0\n");*/
	  continue;
	  }

	/* if((lina.y1 >= mplot->xdipParms.minz-wire_tol) && (lina.x1 <= (dis + wire_tol))
	   && (lina.y2 >= mplot->xdipParms.minz-wire_tol) && (lina.x2 <= (dis + wire_tol)))
         */
	 if(m>1) {
	  x->threeD[k].x1 = lina.x1;
	  x->threeD[k].y1 = lina.y1;
	  x->threeD[k].x2 = lina.x2;
	  x->threeD[k].y2 = lina.y2;
	  
	  /* 
	   x->threeD[k].x1 = lina.y1;
	  x->threeD[k].y1 = lina.x1;
	  x->threeD[k].x2 = lina.y2;
	  x->threeD[k].y2 = lina.x2;
	  */

	  x->col3D[k] = mplot->wire[kount].poly[i].col;
	  k++;
	  }
	free_fmat(p2, 0, mplot->wire[kount].poly[i].n, 0, 2);
	}
      }
    x->num_threeD = k;

    /* for(i=0; i<x->num_threeD; i++)
       {
       fprintf(stderr,"X3D: %d %f %f %f %f\n",i, x->threeD[i].x1,
       x->threeD[i].y1, x->threeD[i].x2, x->threeD[i].y2);
       }
       fprintf(stderr, "\n*********\n\n"); */

    free_fmat(p1, 0, 3, 0, 2);
    }

             /**********   get the image here  *********/

  if(mplot->image.nx > 0) 
  {
     cut_great_image(x);

/*      for(i=0; i<x->image_nbloc; i++) */
/*      { */
/* 	fprintf(stderr,"%d %d %f %f %f\n", */
/* 		i, x->image_ivec[i], x->image_bvec[i],  */
/* 		x->image_PHIvec[i], x->image_LAMvec[i]);		 */
/*      } */
      
  }

               /**********   make window and plot  *********/


  make_xsec_window(top, x, mplot->colors, mplot->fonts);

   XtVaSetValues(top, XtNwidth, 500, XtNheight, 500,
		  XtNx, 50, XtNy, 50, NULL);



  XtVaGetValues(mplot->shell, XtNx, &ex, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  /* send_repaint(mplot->wij, 0, 0, width, height); */
  }

/* ------------------------------------------------------------------ */

void Do_xsect(Widget w, XButtonEvent *ev, String *params, Cardinal *num_params)
  {
  static xyxy xs_line;
  int iokay;
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);

  xs_line.x1 = mplot->xsect_org.x;
  xs_line.y1 = mplot->xsect_org.y;
  xs_line.x2 = mplot->xsect_spot.x;
  xs_line.y2 = mplot->xsect_spot.y;

  /* Undraw old... */
  XDrawLine(XtDisplay(w), XtWindow(w), mplot->xsect_gc,	XYXY(xs_line));

  /* fprintf(stderr,"Just did a cross section....!\n");*/

  mplot->xdipParms.dip = 0.0;
  mplot->xdipParms.minz = mplot->MinDepth;
  mplot->xdipParms.maxz = mplot->MaxDepth;
  mplot->xdipParms.front = mplot->halfwidth;
  mplot->xdipParms.back = mplot->halfwidth;

  xs_dip = 90.0;
  min_xsdepth = mplot->MinDepth;
  max_xsdepth = mplot->MaxDepth;
  max_xsfront = mplot->halfwidth;
  max_xsback = mplot->halfwidth;
  fprintf(stderr, "%f %f %f %f %f\n", xs_dip, min_xsdepth, max_xsdepth,
	  max_xsfront, max_xsback);
  iokay = CopyToXDipWindow(&mplot->xdipParms);

  /* Cross Section! */
  make_xsect(mplot, &xs_line);
  }

/* ------------------------------------------------------------------ */

void Do_dip_xsect(Widget w, XButtonEvent *ev, String *params,
		  Cardinal *num_params)
  {
  static xyxy xs_line;
  int iokay;
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);

  xs_line.x1 = mplot->xsect_org.x;
  xs_line.y1 = mplot->xsect_org.y;
  xs_line.x2 = mplot->xsect_spot.x;
  xs_line.y2 = mplot->xsect_spot.y;

  /* Undraw old... */
  XDrawLine(XtDisplay(w), XtWindow(w), mplot->xsect_gc,	XYXY(xs_line));

  /* fprintf(stderr,"Just did a cross section....!\n"); */

  iokay = CopyToXDipWindow(&mplot->xdipParms);
  XtPopup(mplot->xdipParms.wShell, XtGrabNonexclusive);
  }

/* ------------------------------------------------------------------ */

void Key_w_lees(Widget w, XEvent *event, String *params, Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  if(mplot->screen_size_flag)
    {
    XtVaSetValues(mplot->shell, XtNx, -5, XtNy, -35, XtNwidth, 1200,
		  XtNheight, 1000, NULL);
    mplot->screen_size_flag = 0;
    }
  else
    {
    XtVaSetValues(mplot->shell, XtNx, 0, XtNy, 0, XtNwidth, 1000,
		  XtNheight, 800, NULL);
    mplot->screen_size_flag = 1;
    }

  /* fprintf(stderr,"Don't press 'w' any more, got it?"
     "  Hey change the window!\n"); */
  }

/* ------------------------------------------------------------------ */

void Key_F12_map(Widget w, XEvent *event, String *params, Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  XtVaSetValues(mplot->shell, XtNx, 1, XtNy, 1, XtNwidth, 1000,
                XtNheight, 800, NULL);
 
  /* fprintf(stderr,"Don't press 'w' any more, got it?"
     "  Hey change the window!\n"); */
  }

/* --------------------------------------------------------- */

/* fix the plot so the aspect ratio is 1:1  i.e.  1 km in x = 1 km in y   */

void Key_u_lees(Widget w, XEvent *event, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  float dx, dy, marx, mary;
  int wix, wiy;
  Position x,y;
  Dimension wi, h;

/*  
  window(&mplot->gr, (double)mplot->origin.minx, (double)mplot->origin.maxx,
	 (double)mplot->origin.miny, (double)mplot->origin.maxy);
 
  viewport(&mplot->gr, xmarg, win_width - xmarg, ymarg / 2,
	   win_hite - 2 * ymarg);
*/


  XtVaGetValues(w, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &wi,XtNheight, &h,
                NULL);

  

  marx = 2*xmarg;
  mary = (ymarg/2 + 2 * ymarg);
  
  dx = wi - marx;
  dy = h -  mary ;

  if(dy <= dx)
    {
    wiy = dy;
    wix = (int)((float)wiy * mplot->gr.user_xdif / mplot->gr.user_ydif);
    }
  else
    {
    wix = dx;
    wiy = (int)((float)wix * mplot->gr.user_ydif / mplot->gr.user_xdif);
    }

  wix += marx;
  wiy += mary;


  XtVaSetValues(mplot->shell, XtNx, x, XtNy, y, XtNwidth, wix,
                XtNheight, wiy, NULL);
  }

/********************************/

void Aspect_1_1(Widget wij, mpic *mplot, char *call_data)
  {
  float dx, dy, marx, mary;
  int wix, wiy;
  Position x, y;
  Dimension wi, h;

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &wi, XtNheight, &h,
                NULL);

  marx = 2*xmarg;
  mary = (ymarg/2 + 2 * ymarg);
  
  dx = wi - marx;
  dy = h -  mary ;

  if(dy <= dx)
    {
    wiy = dy;
    wix = (int)((float)wiy * mplot->gr.user_xdif / mplot->gr.user_ydif);
    }
  else
    {
    wix = dx;
    wiy = (int)((float)wix * mplot->gr.user_ydif / mplot->gr.user_xdif);
    }
  wix += marx;
  wiy += mary;


  XtVaSetValues(mplot->shell, XtNx, x, XtNy, y, XtNwidth, wix ,
                XtNheight, wiy , NULL);

  /* send_repaint(mplot->wij, 0, 0, width, height); */
  }


/********************************/
void Set_1_1( mpic *mplot)
  {
  float dx, dy, marx, mary;
  int wix, wiy;
  Position x, y;
  Dimension wi, h;


  window(&mplot->gr, (double)mplot->origin.minx, (double)mplot->origin.maxx,
	 (double)mplot->origin.miny, (double)mplot->origin.maxy);
 
  viewport(&mplot->gr, xmarg, mplot->ScreenX - xmarg, ymarg / 2,
	  mplot->ScreenY  - 2 * ymarg);
  
 /*  fprintf(stderr,"Set_1_1 %d %d %d %d %d %d\n", */
/* 	  mplot ->LocX, mplot->LocY, mplot->ScreenX, mplot->ScreenY, xmarg, ymarg); */
  
/*   fprintf(stderr,"Set_1_1 %f %f\n",  mplot->gr.user_xdif , mplot->gr.user_ydif); */
  
  x =  mplot ->LocX;
  y =   mplot->LocY;

  wi = mplot->ScreenX;
  h = mplot->ScreenY;

  marx = 2*xmarg;
  mary = (ymarg/2 + 2 * ymarg);
  
  dx = wi - marx;
  dy = h -  mary ;

  if(dy <= dx)
    {
    wiy = dy;
    wix = (int)((float)wiy * mplot->gr.user_xdif / mplot->gr.user_ydif);
    }
  else
    {
    wix = dx;
    wiy = (int)((float)wix * mplot->gr.user_ydif / mplot->gr.user_xdif);
    }
  wix += marx;
  wiy += mary;

  
  XtVaSetValues(mplot->shell, XtNx, x, XtNy, y, XtNwidth, wix ,
                XtNheight, wiy , NULL);
 

  /* send_repaint(mplot->wij, 0, 0, width, height); */
  }
/********************************/
void Key_l_lees(Widget w, XEvent *event, String *params, Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  XtVaSetValues(mplot->shell, XtNx, 100, XtNy, 100, XtNwidth, 400,
		XtNheight, 500, NULL);
 send_repaint(mplot->wij, 0, 0, 400, 500);

  }
/********************************/
void Refresh(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  send_repaint(mplot->wij, 0, 0, width, height);
  }

/********************************/

void list_PWD(Widget wij, mpic *mplot, char *call_data)
  {
  char *pwd = getenv("PWD");
  fprintf(stderr,"PWD:\n%s\n", pwd);
  system("ls");
  }

/********************************/

void change_dir(Widget wij, mpic *mplot, char *call_data)
  {
  char *pwd, indir[200];

  pwd = getenv("PWD");
  fprintf(stderr, "PWD:\n%s\n", pwd);
  fprintf(stderr, "Type in new dir path name:\n");
  fscanf(stdin, "%s", indir);
  chdir(indir);
  }

/********************************/

static void Quit()
  {
  exit(0);
  }

/* --------------------------------------------------------- */

static void Quit_window(Widget wij, mpic *mplot, char *call_data)
  {
  XtDestroyWidget(mplot->shell);
  }

/* --------------------------------------------------------- */

void Key_q_lees(Widget w, XEvent *ev, String *params, Cardinal *num_params)
  {
  fprintf(stderr," Bye! Quitting geotouch......\n");
  Quit();
  }

void Key_p_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  double t, u, ans, y1, y2, y3, y4;
  float xkm, ykm, plat, plon, phi, lam, val;
  int i, j, k, ix, iy, iz, iway;

  XtVaGetValues(w, XtNdata, &mplot, NULL);       
  xkm = pix_to_user_x(&mplot->gr, (int)ev->x);
  ykm = pix_to_user_y(&mplot->gr, (int)ev->y);
  xy2geo(mplot, &phi, &lam, xkm, ykm);
  plat =  phi;
  plon = lam;
      val = 0.0;
    if(mplot->image_flag == 1) val=mplot->image.z_parts[mplot->image_layer - 1];
  fprintf(stderr, "POINT: %d %d km: %f %f LL: %f %f\n", ev->x, ev->y, xkm,
	  ykm, plat, plon);
  fprintf(stderr, " LAT-LON: %f %f  %f\n", plat, plon, val);
  CUR_pointx = xkm;
  CUR_pointy = ykm;
  
  if(mplot->points_store==1)
    {
    val=0.0;
    if(mplot->image_flag == 1) val=mplot->image.z_parts[mplot->image_layer - 1];
    fprintf(mplot->pointsFP, "%f %f %f\n",plat, plon, val);
    }
  

  if(mplot->image_flag == 1)
    {
    i = Get_i_value(mplot, xkm, ykm,
		    mplot->image.z_parts[mplot->image_layer - 1]);
    if(i >= 0)
      {
      val = Get_image_value(mplot, xkm, ykm,
			    mplot->image.z_parts[mplot->image_layer - 1]);
      iway = 1;
      citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway,
	      &i, &ix, &iy, &iz);
      fprintf(stderr, " Image Value = %f\n", val);
      fprintf(stderr, "i=%d ix=%d iy=%d  iz=%d\n", i, ix, iy, iz);
      }
    else fprintf(stderr," Point not in image...\n");
    }

  if(mplot->plot_cont_flag == 1)
    {
    /* fprintf(stderr,"---------------------\n");
       fprintf(stderr,"Dims: %d %d %f %f %f %f\n ",
       mplot->contParms.surf_grd->nx, mplot->contParms.surf_grd->ny,
       mplot->contParms.surf_grd->xinc, mplot->contParms.surf_grd->yinc, 
       mplot->contParms.surf_grd->ymax, mplot->contParms.surf_grd->xmax); */

    i = (int)(xkm / mplot->contParms.surf_grd->xinc);
    j = (int)((mplot->contParms.surf_grd->ymax - ykm)
	      / mplot->contParms.surf_grd->yinc);

    /*  p1 = user_to_pix_x(&mplot->gr, mplot->contParms.surf_grd->xinc*i);
	p2 = user_to_pix_y(&mplot->gr, mplot->contParms.surf_grd->yinc
	*(mplot->contParms.surf_grd->ny-(j+2)) );
	XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
	mplot->colors[XmapAppColor(1)]  );
	draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij),
	mplot->ggc,  p1,  p2, "1", HJ_CENTER, VJ_BASELINE);
	XDrawPoint(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
	p1,  p2);
	XFlush(XtDisplay(mplot->wij)); */

    k = (j + 1) * mplot->contParms.surf_grd->nx + i; 
    y1 = mplot->contParms.surf_grd->val[k];

    /* p1 = user_to_pix_x(&mplot->gr, mplot->contParms.surf_grd->xinc* (i+1) );
       p2 = user_to_pix_y(&mplot->gr, mplot->contParms.surf_grd->yinc
       *(mplot->contParms.surf_grd->ny-(j+2) ) );
       draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
       p1,  p2, "2", HJ_CENTER, VJ_BASELINE);
       XDrawPoint(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
       p1,  p2);
       XFlush(XtDisplay(mplot->wij)); */

    k = (j + 1) * mplot->contParms.surf_grd->nx + (i + 1); 
    y2 = mplot->contParms.surf_grd->val[k];

    /* p1 = user_to_pix_x(&mplot->gr, mplot->contParms.surf_grd->xinc* (i+1) );
       p2 = user_to_pix_y(&mplot->gr, mplot->contParms.surf_grd->yinc
       *(mplot->contParms.surf_grd->ny-(j+1) ) );
       draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
       p1,  p2, "3", HJ_CENTER, VJ_BASELINE);
       XDrawPoint(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
       p1,  p2);
       XFlush(XtDisplay(mplot->wij)); */

    k = (j) * mplot->contParms.surf_grd->nx + (i + 1); 
    y3 = mplot->contParms.surf_grd->val[k];

    /* p1 = user_to_pix_x(&mplot->gr, mplot->contParms.surf_grd->xinc*(i) );
       p2 = user_to_pix_y(&mplot->gr, mplot->contParms.surf_grd->yinc
       *(mplot->contParms.surf_grd->ny-(j+1) ) );
       draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
       p1,  p2, "4", HJ_CENTER, VJ_BASELINE);
       XDrawPoint(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
       p1,  p2);
       XFlush(XtDisplay(mplot->wij)); */

    k = (j) * mplot->contParms.surf_grd->nx + i; 
    y4 = mplot->contParms.surf_grd->val[k];

    t = ((xkm - mplot->contParms.surf_grd->xinc * i)
	 / (mplot->contParms.surf_grd->xinc));
    u = ((ykm -  mplot->contParms.surf_grd->yinc
	  * (mplot->contParms.surf_grd->ny - (j + 2)))
	 / (mplot->contParms.surf_grd->yinc));

    /* fprintf(stderr,"%f %f %f %f     %f %f\n",y1,y2,y3,y4,t,u);
       p1 = user_to_pix_x(&mplot->gr, xkm);
       p2 = user_to_pix_y(&mplot->gr, ykm );
       XDrawPoint(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
       p1,  p2);
       XFlush(XtDisplay(mplot->wij)); */

    ans = ((1 - t) * (1 - u) * y1 + t * (1 - u) * y2 + t * u * y3 + (1 - t)
	   * u * y4);

    fprintf(stderr, "FIELD VALUE:  %f \n", ans);
    }
  }

/*************************************/

void Key_F2_map(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  int i, j, k, p1, p2;
  char pchar[6];

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  if(mplot->plot_cont_flag == 1)
    {
    XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		   mplot->colors[XmapAppColor(1)]);
    XSetFont(XtDisplay(mplot->wij), mplot->ggc, mplot->fonts[0]);
    fprintf(stderr, "---------------------\n");
    fprintf(stderr, "Dims: %d %d %f %f %f %f\n ",
	    mplot->contParms.surf_grd->nx, mplot->contParms.surf_grd->ny,
	    mplot->contParms.surf_grd->xinc, mplot->contParms.surf_grd->yinc,
	    mplot->contParms.surf_grd->ymax, mplot->contParms.surf_grd->xmax);
    for(i = 0; i < mplot->contParms.surf_grd->nx; i++)
      {
      for(j = 0; j < mplot->contParms.surf_grd->ny; j++)
	{
	k = (j) * mplot->contParms.surf_grd->nx + (i);
	fprintf(stderr, "%d %d %d ", i, j, k);
	p1 = user_to_pix_x(&mplot->gr, mplot->contParms.surf_grd->xinc * i);
	p2 = user_to_pix_y(&mplot->gr, mplot->contParms.surf_grd->yinc
			   * (mplot->contParms.surf_grd->ny - (j + 1)));
	sprintf(pchar, "%d", k);
	draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij),
		       mplot->ggc, p1, p2, pchar, HJ_CENTER, VJ_BASELINE);
	XFlush(XtDisplay(mplot->wij));
	}
      }
    }
  }

/*************************************/

void Key_F3_map(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  mplot->image_layer++;
  if(mplot->image_layer > mplot->image.nz)
    mplot->image_layer = mplot->image.nz;
  if(mplot->wells_in_layer==1)
     {
     set_wells_layer(mplot);
      }
  
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/*************************************/

void Key_F4_map(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  mplot->image_layer--;
  if(mplot->image_layer < 1) mplot->image_layer = 1;
  if(mplot->wells_in_layer==1)
     {
     set_wells_layer(mplot);
      }
  

  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/*************************************/

void Key_c_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(w, XtNdata, &mplot, NULL);

  switch(mplot->focal_plot_style)
    {
    case 1:
      mplot->focal_plot_style = 2;
      break;

    case 2:
      mplot->focal_plot_style = 4;
      break;

    case 3:
      mplot->focal_plot_style = 4;
      break;

    case 4:
      mplot->focal_plot_style = 5;
      break;

    case 5:
      mplot->focal_plot_style = 4;
      break;

    default:
      mplot->focal_plot_style = 4;
      break;
    }
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

void Key_t_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  Position x, y;
  Dimension width, height;

  XtVaGetValues(w, XtNdata, &mplot, NULL);

  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  switch(mplot->focal_plot_style)
    {
    case 3:
      mplot->focal_plot_style = 7;
      break;

    case 7:
      mplot->focal_plot_style = 8;
      break;

    case 8:
      mplot->focal_plot_style = 3;
      break;

    default:
      mplot->focal_plot_style = 3;
      break;
    }

  send_repaint(mplot->wij, 0, 0, width, height);
  }

void Key_ralph_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  Position x, y;
  Dimension width, height;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  switch(mplot->focal_plot_style)
    {
    case 6:
      mplot->focal_plot_style = 4;
      break;

    default:
      mplot->focal_plot_style = 6;
      break;
    }

  send_repaint(mplot->wij, 0, 0, width, height);
  }
/************************************/
void Key_r_lees(Widget wij, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;

  unsigned short x, y, w, h;
  float bx1, by1, phi, lam;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);

  if(mplot->project_type <=1 )
    {
    mplot->origin.minx = 0.0;
    mplot->origin.maxx = mplot->origin.nxblk * mplot->origin.dx;
    mplot->origin.miny = 0.0;
    mplot->origin.maxy = mplot->origin.nyblk * mplot->origin.dy;
    }

  if(mplot->project_type > 1)
    {
    mplot->origin.minx = 0.0;
    mplot->origin.miny = 0.0;
    phi = mplot->origin.phimin;  
    lam = mplot->origin.lammax;  
    geo2xy(mplot, phi, lam, &bx1, &by1);
    mplot->origin.maxx = bx1;
    phi = mplot->origin.phimax;  
    lam = mplot->origin.lammin;  
    geo2xy(mplot, phi, lam, &bx1, &by1);
    mplot->origin.maxy = by1;
    }

  mplot->zoom_flag = 0;
  mplot->zoom_flag2 = 0;
  mplot->zoom.numpoints = 0;
  Get_Stuff1(mplot);
  send_repaint(mplot->wij, 0, 0, w, h);

  }

/***************************   END TIME PLOT ***********************/

  
/*   switch planes of one focal mechanism if found  */

void Key_v_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  float dis, rx, ry, dx, dy, phi, lam, focrad, kmscale;
  int i, found, kount, kfoc;
  Position x, y;
  Dimension width, height;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  rx = (float)pix_to_user_x(&mplot->gr, (int)ev->x);
  ry = (float)pix_to_user_y(&mplot->gr, (int)ev->y);

  found = 0;

  kmscale = mplot->gr.user_xdif / mplot->gr.pix_xdif;
  for(kount = 0; kount < mplot->num_focm_files; kount++)
    {
    for(i = 0; i < mplot->focm[kount].numpoints; i++)
      {
      focrad = mplot->size_focm / 2;
      if(mplot->focal_mag_scale == 1)
	{
	if(mplot->focm[kount].minMag < mplot->focm[kount].maxMag)
	  focrad += (focrad * (mplot->focm[kount].focs[i].ac.mag
			       - mplot->focm[kount].minMag)
		     / (mplot->focm[kount].maxMag
			- mplot->focm[kount].minMag));
	else focrad = mplot->size_focm / 2;
	}
      focrad *= kmscale;

      if(mplot->focal_explode == 1)
	{
	dx = mplot->focm[kount].focs[i].explode_x;
	dy = mplot->focm[kount].focs[i].explode_y;
	}
      else
	{
	phi = mplot->focm[kount].focs[i].loc.x;
	lam = mplot->focm[kount].focs[i].loc.y;
	geo2xy(mplot, phi, lam, &dx, &dy);
	}
      dis = sqrt(sqr(rx - dx) + sqr(ry - dy));
      if(dis < focrad)
	{
	mplot->focal_selection  = i;
	kfoc = kount;
	found = 1;
	break;
	}
      }
    }

  if(found == 1)
    {
    /* fprintf(stderr," GET-FOC %d at %f %f found at %f %f \n",
       mplot->focal_selection, rx,ry, mplot->focm[kount].focs[i].explode_x,
       mplot->focm[kount].focs[i].explode_y); */

    /*  switch the planes for this focal mechanism   */

    switch_foc(mplot, kfoc);
    }
  else
    {
    mplot->focal_selection = -1;
    fprintf(stderr, " NO FOC NEAR  %f %f \n",  rx, ry);
    }

  send_repaint(mplot->wij, 0, 0, width, height);                
  }

void Key_f_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  float dis, rx, ry, focrad, kmscale;
  int i, found, kount;

  XtVaGetValues(w, XtNdata, &mplot, NULL);

  if(mplot->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal Files available\n");
    return;
    }

  rx = (float)pix_to_user_x(&mplot->gr, (int)ev->x);
  ry = (float)pix_to_user_y(&mplot->gr, (int)ev->y);
  kmscale = mplot->gr.user_xdif / mplot->gr.pix_xdif;

  for(kount = 0; kount < mplot->num_focm_files; kount++)
    {
    found = 0;
    for(i = 0; i < mplot->focm[kount].numpoints; i++)
      {
      focrad = mplot->size_focm / 2;
      if(mplot->focal_mag_scale == 1)
	{
	if(mplot->focm[kount].minMag < mplot->focm[kount].maxMag)
	  focrad += (focrad * (mplot->focm[kount].focs[i].ac.mag
			       - mplot->focm[kount].minMag)
		     / (mplot->focm[kount].maxMag
			- mplot->focm[kount].minMag));
	else focrad = mplot->size_focm / 2;
	}
      focrad *= kmscale;

      dis = sqrt(sqr(rx - mplot->focm[kount].focs[i].explode_x)
		 + sqr(ry - mplot->focm[kount].focs[i].explode_y));
      if(dis < focrad)
	{
	mplot->focal_selection = i;
	found = 1;
	mplot->focal_current = kount;
	break;
	}
      }            
    }
  }

void Key_g_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  int i, kount;
  Position x, y;
  Dimension width, height;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  if(mplot->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal Files available\n");
    return;
    }

  i = mplot->focal_selection;
  kount = mplot->focal_current;

  if(i >= 0)
    {
    mplot->focm[kount].focs[i].explode_x = (float)pix_to_user_x(&mplot->gr,
								(int) ev->x);
    mplot->focm[kount].focs[i].explode_y = (float)pix_to_user_y(&mplot->gr,
								(int) ev->y);

    /* fprintf(stderr,"Mec %d moving to: %d %d\n",mplot->focal_selection,
       ev->x,ev->y); */

    fprintf(stderr, "Focal Mec: %s mag = %3.1f \n",
	    mplot->focm[kount].focs[i].ac.id,
	    mplot->focm[kount].focs[i].ac.mag);
    }

  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* locating points for arrows */

void Key_m_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  mpic *mplot;


  XtVaGetValues(w, XtNdata, &mplot, NULL);
  if(mplot->num_labels < 0)
    {
    fprintf(stderr, " need a label...\n");
    return;
    }

  mplot->marrow_org.x = ev->x;
  mplot->marrow_org.y = ev->y;
  mplot->marrow_spot = mplot->marrow_org;
  fprintf(stderr," Must type in n for the arrow head....\n");

  }

void Key_n_lees(Widget w, XKeyEvent *ev, String *params, Cardinal *num_params)
  {
  GC ggc;
  mpic *mplot;
  float rx, ry, phi, lam;
  Position x, y;
  Dimension width, height;
  int current_lab;
  

  XtVaGetValues(w, XtNdata, &mplot, NULL);


  if(mplot->num_labels < 0)
    {
    fprintf(stderr, " need a label...\n");
    return;
    }

  current_lab = mplot->current_label;
  


  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  ggc = mplot->ggc;
  mplot->marrow_spot.x = ev->x;
  mplot->marrow_spot.y = ev->y;

  /* Draw Line... */

  /* XDrawLine(XtDisplay(w), XtWindow(w), ggc, mplot->marrow_org.x,
     mplot->marrow_org.y, mplot->marrow_spot.x,	mplot->marrow_spot.y); */

  mplot->labels[current_lab].p.x1 = mplot->marrow_org.x;
  mplot->labels[current_lab].p.x2 = mplot->marrow_spot.x;
  mplot->labels[current_lab].p.y1 = mplot->marrow_org.y;
  mplot->labels[current_lab].p.y2 = mplot->marrow_spot.y;

  rx = (float)pix_to_user_x(&mplot->gr, (int)mplot->marrow_org.x);
  ry = (float)pix_to_user_y(&mplot->gr, (int)mplot->marrow_org.y);

  mplot->labels[current_lab].kmloc.x1 = rx;
  mplot->labels[current_lab].kmloc.y1 = ry;

  xy2geo(mplot,  &phi,  &lam, rx, ry);
 
  mplot->labels[current_lab].latlon.x1 = phi;
  mplot->labels[current_lab].latlon.y1 = lam;

  rx = (float)pix_to_user_x(&mplot->gr, (int)mplot->marrow_spot.x);
  ry = (float)pix_to_user_y(&mplot->gr, (int)mplot->marrow_spot.y);

  mplot->labels[current_lab].kmloc.x2 = rx;
  mplot->labels[current_lab].kmloc.y2 = ry;

  xy2geo(mplot,  &phi,  &lam, rx, ry);

  mplot->labels[current_lab].latlon.x2 = phi;
  mplot->labels[current_lab].latlon.y2 = lam;

  fprintf(stderr, "%d %d %d %d %d %s\n\n", current_lab,
	  mplot->labels[current_lab].p.x1,
	  mplot->labels[current_lab].p.y1,
	  mplot->labels[current_lab].p.x2,
	  mplot->labels[current_lab].p.y2,
	  mplot->labels[current_lab].label);

  fprintf(stderr," %%-------------------------------PostScript Label\n");
  fprintf(stderr, " newpath \n");
  fprintf(stderr, " %f bx %f bz %f bx %f bz 2 10 16 arrow fill\n",
	  ps_kmx(mplot->labels[current_lab].kmloc.x1,
		 mplot->origin.minx),
	  ps_kmy(mplot->labels[current_lab].kmloc.y1,
		 mplot->origin.miny),
	  ps_kmx(mplot->labels[current_lab].kmloc.x2,
		 mplot->origin.minx),
	  ps_kmy(mplot->labels[current_lab].kmloc.y2,
		 mplot->origin.miny));

  fprintf(stderr, "       (%s)  %f bx %f bz moveto cen_labshow \n",
	  mplot->labels[current_lab].label,
	  ps_kmx(mplot->labels[current_lab].kmloc.x1,
		 mplot->origin.minx),
	  ps_kmy(mplot->labels[current_lab].kmloc.y1,
		 mplot->origin.miny));

  fprintf(stderr," %%----------------------------------------------\n");

  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* ------------------------------------------------------------------ */

void Key_e_lees(Widget w, XEvent *event, String *params, Cardinal *num_params)
  {
  mpic *mplot;
  Position x, y;
  Dimension width, height;

  XtVaGetValues(w, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->focal_explode = !mplot->focal_explode;
  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* --------------------------------------------------------- */

void Start_picsource(Widget wij, XButtonEvent *event, String *params,
		     Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  mplot->picsource_flag = 1;
  mplot->picsourcemove_flag = 0;
  mplot->picsource_org.x = event->x;
  mplot->picsource_org.y = event->y;
  mplot->picsource_spot.x  = event->x;
  mplot->picsource_spot.y  = event->y;
    BEGxkm = pix_to_user_x(&mplot->gr, (int)event->x);
    BEGykm = pix_to_user_y(&mplot->gr, (int)event->y);
  gscr_num = DefaultScreen(XtDisplay(wij));
  XSetForeground(XtDisplay(wij), mplot->ggc, BlackPixel(XtDisplay(wij),
							gscr_num));
  XSetBackground(XtDisplay(wij), mplot->ggc, WhitePixel(XtDisplay(wij),
							gscr_num));
  }

/* --------------------------------------------------------- */

void Start_draw(Widget wij, XButtonEvent *event, String *params,
		Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  fprintf(stderr," Here I am shifting: %d %d\n", event->x, event->y);
  }

/* --------------------------------------------------------- */

void Resize_picsource(Widget wij, XButtonEvent *event, String *params,
		      Cardinal *num_params)
  {
  GC ggc;
  mpic *mplot;
  XPoint p[5];
  char plot_lab[50];
  float  xkm, ykm,  dis;
  float phi, lam;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  ggc = mplot->ggc;

  XSetClipMask(XtDisplay(wij), ggc, None);
  XSetFunction(XtDisplay(wij), ggc, GXnor);

  getbox(mplot->picsource_org.x, mplot->picsource_org.y,
	 mplot->picsource_spot.x, mplot->picsource_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);

  mplot->picsource_spot.x = event->x;
  mplot->picsource_spot.y = event->y;

  getbox(mplot->picsource_org.x,mplot->picsource_org.y,
	 mplot->picsource_spot.x,mplot->picsource_spot.y, p);

  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);

  mplot->picsourcemove_flag = 1;

    xkm = pix_to_user_x(&mplot->gr, (int)event->x);
    ykm = pix_to_user_y(&mplot->gr, (int)event->y);


    dis = sqrt( (xkm-BEGxkm)*(xkm-BEGxkm) + (ykm-BEGykm)*(ykm-BEGykm) );

    xy2geo(mplot, &phi, &lam, xkm, ykm);


    sprintf(plot_lab , "dist km: %f LL: %f %f\n", 
	    dis, phi, lam);
  

   
   XtVaSetValues(mplot->labshell, XtNlabel, plot_lab, NULL);




  XSetFunction(XtDisplay(wij), ggc, GXcopy);
  }

/* ------------------------------------------------------------------ */

void Do_picsource(Widget wij, XButtonEvent *ev, String *params,
		  Cardinal *num_params)
  {
  mpic *mplot;
  XPoint p[5];
  char acrd[80];
  int i, j, k, ix, iy, iz, iway, newx, newy;
  float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, temspacx, temspacy, xkm, ykm, phi, lam, plat, plon, val;
  float dist;
  float Uorgx, Uorgy, Uspotx, Uspoty;


 float bot=10000.0, top=-10000.0;
 float az;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);


  Uspotx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
  Uorgx  =pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
  Uspoty = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
  Uorgy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);


  if(mplot->picsourcemove_flag)
    {
    XSetClipMask(XtDisplay(wij), mplot->ggc, None);
    if(mplot->picsource_org.x > mplot->picsource_spot.x)
      {
      minx = Uspotx;
      maxx = Uorgx;
      }
    else
      {
      minx = Uorgx;
      maxx = Uspotx;
      } 

    if(mplot->picsource_org.y < mplot->picsource_spot.y)
      {
      miny = Uspoty;
      maxy = Uorgy;
      }
    else
      {
      miny = Uorgy;
      maxy = Uspoty;
      }

    mplot->picsource_flag = 1;
    mplot->picsource.zooms[mplot->picsource.numpoints].x1 = minx;
    mplot->picsource.zooms[mplot->picsource.numpoints].y1 = miny;
    mplot->picsource.zooms[mplot->picsource.numpoints].x2 = maxx;
    mplot->picsource.zooms[mplot->picsource.numpoints].y2 = maxy;

    SELXMIN = minx;
    SELYMIN = miny;
    SELXMAX = maxx;
    SELYMAX = maxy;

    global_poly = 4;
    gpolx[0] = mplot->picsource_org.x;
    gpoly[0] = mplot->picsource_org.y;
    gpolx[1] = mplot->picsource_org.x;
    gpoly[1] = mplot->picsource_spot.y;
    gpolx[2] = mplot->picsource_spot.x;
    gpoly[2] = mplot->picsource_spot.y;
    gpolx[3] = mplot->picsource_spot.x;
    gpoly[3] = mplot->picsource_org.y;

    k = 0;
    /* fprintf(stderr," picsource_outflag=%d\n",mplot->picsource_outflag); */ 

    fprintf(stderr,"minx=%f maxx=%f  miny=%f  maxy=%f\n", minx, maxx, miny, maxy);

    if(minx != maxx) 
    {
       az = 90 - rad2deg( atan2( 	( Uspoty -   Uorgy      )  ,  (Uspotx -   Uorgx  ) ) );
    }
    else
    {
       az = 0;

    }

    dist = sqrt( (maxx-minx)*(maxx-minx)+(maxy-miny)*(maxy-miny));

    fprintf(stderr, "Dx=%f km    Dy=%f km    Diagonal Distance=%f km Azimuth=%f\n", (maxx-minx), (maxy-miny), 
	    dist,   az);
    

    xy2geo(mplot, &phi, &lam, Uorgx, Uorgy);
    fprintf(stderr, "VEC: %f %f %f %f\n", phi, lam, dist, az);

            
    if(!mplot->src_flag) return;

   if( mplot->src_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }
  

    switch(mplot->picsource_outflag)
      {
      case 1:
      for(j = 0; j <= mplot->max_more_src - 1; j++)
	 {
	 fprintf(stdout,
		 "\n-------------From Source File %s ---------------\n",
		 mplot->sources[j].file_name);

	 for(i = 0; i < mplot->sources[j].numpoints; i++)
	    {
	    if((mplot->sources[j].loc[i].x >= minx)
	       && (mplot->sources[j].loc[i].x <= maxx)
	       && (mplot->sources[j].loc[i].y >= miny)
	       && (mplot->sources[j].loc[i].y <= maxy))
	       {
	       if(mplot->sources[j].onoff[i] == 1)
		  {
       
		  if( mplot->src_in_layer == 0 || 
		     (mplot->src_in_layer == 1 && 
		      mplot->sources[j].loc[i].z < bot  && 
		      mplot->sources[j].loc[i].z >= top) )  
		     {
	     
		     create_Acard(&mplot->sources[j].acard[i], acrd);
		     fprintf(stdout, "%s", acrd);
		     k++;
		     }
		  }
	       }
	    
	    }
	 }
	break;

      case 2:
	/* here print out the related sources choosing only the 0 pics
	   in a window.  This is for looking at earthquake locations. */

/* this will not work if some of the events have been
rejected because they are not in the target...  */


	for(i = 0; i < mplot->sources[0].numpoints; i++)
	  {
	  if((mplot->sources[0].loc[i].x >= minx)
	     && (mplot->sources[0].loc[i].x <= maxx)
	     && (mplot->sources[0].loc[i].y >= miny)
	     && (mplot->sources[0].loc[i].y <= maxy))
	    {
	    k++;
	    for(j = 0; j < (mplot->max_more_src - 1) ; j++)
	      {
	      create_Acard(&mplot->sources[j].acard[i], acrd);
	      fprintf(stdout, "%s", acrd);
	      create_Acard(&mplot->sources[j+1].acard[i], acrd);
	      fprintf(stdout, "%s", acrd);

	      fprintf(stderr, "%d %d : %s %s \n", j, i,
		      mplot->sources[j].acard[i].id,
		      mplot->sources[j+1].acard[i].id  );

                
		XDrawLine(XtDisplay(wij), XtWindow(wij), mplot->ggc,
			  user_to_pix_x(&mplot->gr,
			    (double)mplot->sources[j].loc[i].x),
			  user_to_pix_y(&mplot->gr,
			    (double)mplot->sources[j].loc[i].y),
			  user_to_pix_x(&mplot->gr,
			    (double)mplot->sources[j + 1].loc[i].x),
			  user_to_pix_y(&mplot->gr,
			    (double) mplot->sources[j + 1].loc[i].y));

		fprintf(stdout, " %f %f %f %f %f %f connect \n",
			mplot->sources[j].loc[i].x,
			mplot->sources[j].loc[i].y,
			mplot->sources[j].loc[i].z,
			mplot->sources[j + 1].loc[i].x,
			mplot->sources[j + 1].loc[i].y,
			mplot->sources[j + 1].loc[i].z);
		
	      }
	    /* fprintf(stdout, "\n"); */
	    }
	  }
	break;
	
      case 0:
	fprintf(stderr," No source output, but target is stored...\n");
	break;
	
      }
	
    mplot->picsource.numpoints++;
    fprintf(stdout, "\n\n number of points = %d\n", k);

    bottom_left_x = (float) minx;
    bottom_left_y = (float)miny;
    xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);
    fprintf(stdout, "Box Coordinates:\n");
    fprintf(stdout, "Bot Left:  km: %f %f\n", bottom_left_x, bottom_left_y);
    fprintf(stdout," LAT-LON  LAT-LON:\n %f %f ", phi, lam);
    top_right_x = (float)maxx;
    top_right_y = (float)maxy;
    xy2geo(mplot, &phi, &lam, top_right_x, top_right_y);
    fprintf(stdout, " %f %f \n", phi, lam);
    fprintf(stdout, "Top Right:  km: %f %f\n", top_right_x, top_right_y);

    /* dump out an origin file */
    fprintf(stdout, "  \n  New ORIGIN FILE: \n");
    xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);
    xkm = top_right_x - bottom_left_x;
    ykm = top_right_y - bottom_left_y;
    fprintf(stdout, "DX = %f DY = %f \n\n", xkm, ykm);

    if(xkm <= 5)
      {
      temspacx = 0.1;
      newx = xkm / temspacx;
      }
    if(xkm > 10.0 && xkm < 80.0)
      {
      newx = xkm;
      temspacx = 1.0;
      }
    if(xkm < 10.0 && xkm > 5.0)
      {
      temspacx = 0.5;
      newx = xkm / temspacx;
      }
    if(xkm > 80.0 && xkm < 120.0)
      {
      temspacx = 2.0;
      newx = xkm / temspacx;
      }
    if(xkm > 120.0)
      {
      temspacx = 5.0;
      newx = xkm / temspacx;
      }
    if(ykm <= 5)
      {
      temspacy = 0.1;
      newy = ykm / temspacy;
      }
    if(ykm > 10.0 && ykm < 80.0)
      {
      newy = ykm;
      temspacy = 1.0;
      }
    if(ykm < 10.0 && ykm > 5.0)
      {
      temspacy = 0.5;
      newy = ykm / temspacy;
      }
    if(ykm > 80.0 && ykm < 120.0)
      {
      temspacy = 2.0;
      newy = ykm / temspacy;
      }
    if(ykm > 120.0)
      {
      temspacy = 5.0;
      newy = ykm / temspacy;
      }

    i = (int)mplot->MaxDepth;
    fprintf(stdout, "1 1 %d %d %d %f %f\n", newx, newy, i, temspacx, temspacy);
    fprintf(stdout, "%f \n", phi);
    fprintf(stdout, "%f \n", lam);       
    fprintf(stdout, " \n\n");
    fprintf(stdout, "---------------------------------------------- \n");
    /* printf("minx=%f miny=%f maxx=%f maxy=%f \n", minx, miny, maxx, maxy); */
    getboxkm(mplot, minx, miny, maxx, maxy, p);
    /* for(j=0;j<5; j++) { fprintf(stderr, "minmax Point %d : x=%d y=%d\n",j,
       p[j].x,p[j].y);} fprintf(stderr,"orgx=%d orgy=%d spotx=%d spoty=%d \n",
       mplot->picsource_org.x, mplot->picsource_org.y, mplot->picsource_spot.x,
       mplot->picsource_spot.y); */
    }
  else
    {
    /*  otherwise just plot the point value  */

    xkm = pix_to_user_x(&mplot->gr, (int)ev->x);
    ykm = pix_to_user_y(&mplot->gr, (int)ev->y);
    xy2geo(mplot, &phi, &lam, xkm, ykm);
    plat = phi;
    plon = lam;
      val = 0.0;
    if(mplot->image_flag == 1) val=mplot->image.z_parts[mplot->image_layer - 1];
    fprintf(stderr, "POINT: %d %d km: %f %f LL: %f %f\n", ev->x , ev->y, xkm,
	    ykm, plat, plon);
    fprintf(stderr, " LAT-LON: %f %f %f\n", plat, plon, val);

    if(mplot->points_store==1)
      {
      val = 0.0;
    if(mplot->image_flag == 1) val=mplot->image.z_parts[mplot->image_layer - 1];
      fprintf(mplot->pointsFP, "%f %f %f\n", plat, plon, val);
      }
    

    if(mplot->image_flag == 1)
    {
       i = Get_i_value(mplot, xkm, ykm,
		       mplot->image.z_parts[mplot->image_layer - 1]);
       if(i >= 0)
       {
	  val = Get_image_value(mplot, xkm, ykm,
				mplot->image.z_parts[mplot->image_layer - 1]);

	  iway = 1;
	  citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway,
		  &i, &ix, &iy, &iz);

	  fprintf(stderr, " Image Value = %f\n", val);
	  fprintf(stderr, "i=%d ix=%d iy=%d  iz=%d\n", i, ix, iy, iz);
       }
       else fprintf(stderr," Point not in image...\n");
    }

    if(mplot->plot_cont_flag == 1)
    {
       val =  sample_surf(mplot->contParms.surf_grd, xkm, ykm);
    	  fprintf(stderr, "LL_Surface Value = %f %f %f\n", plat, plon, val);
    }

    }
  mplot->picsourcemove_flag = 0;
  }

/* ------------------------------------------------------------------ */
void Dump_Map_All(Widget wij, mpic *m, char *call_data)
  {
  int i, kk = 0, j, k;
  int kmap;
  int px, py;
  
  /* printf("In plot_map2...stroke count = %d\n",
     m->map[kmap].stroke[k].count); */

  for(kmap = 0; kmap < m->num_map_files; kmap++)
    {
    fprintf(stdout, "------dumping Map ---%d   %s\n", kmap,
	    m->map[kmap].file_name);
    for(k = 0; k < m->map[kmap].stroke_count; k++)
      {
	fprintf(stdout, "%d *********%s %d \n", k,
		m->map[kmap].stroke[k].name,
		m->map[kmap].stroke[k].num );
   
      j = 0;
      for(i = kk; i < kk + m->map[kmap].stroke[k].num; i++)
	{
	px = user_to_pix_x(&m->gr, (double)m->map[kmap].km[i].x);
	py = user_to_pix_y(&m->gr, (double)m->map[kmap].km[i].y);

	fprintf(stdout,"%d %d %f %f %f %f\n", i, j, 
		m->map[kmap].km[i].x, m->map[kmap].km[i].y,
		 m->map[kmap].latlon[i].x, m->map[kmap].latlon[i].y );
	
	j++;
	}
      kk += m->map[kmap].stroke[k].num;
      
      
      }
    }
  }

void Do_SelMap(Widget wij, mpic *mplot, char *call_data)
  {
  int j, kount, px1, px2, py1, py2, idx, idy, kin;
  float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, phi, lam, bx1, by1, bx2, by2, rlatmin, rlatmax, rlonmin,
    rlonmax;
  char pchar[6], *c;

  if(mplot->map_type <= 1) return;

  minx = SELXMIN;
  miny = SELYMIN;
  maxx = SELXMAX;
  maxy = SELYMAX;

  xy2geo(mplot, &phi, &lam, minx, miny);
  bx1 = phi;
  by1 = lam;

  xy2geo(mplot, &phi, &lam, maxx, maxy);
  bx2 = phi;
  by2 = lam;

  fprintf(stderr, "-------Selected Map Lines---%d\n", mplot->num_map_files);
  /* XSetForeground(XtDisplay(wij), mplot->ggc,
     mplot->colors[mplot->zoom_box_col]);*/

  for(kount = 0; kount < mplot->num_map_files; kount++)
    {
    fprintf(stderr, "------checking Map ---%d   %s\n", kount,
	    mplot->map[kount].file_name);
    for(j = 0; j < mplot->map[kount].stroke_count; j++)
      {
      c = mplot->map[kount].map_code;
      while(*(c++) != mplot->map[kount].stroke[j].code) 
	if(*c == '\0') goto AGAIN;

      rlatmin = mplot->map[kount].stroke[j].latmin;
      rlatmax = mplot->map[kount].stroke[j].latmax;
      rlonmin = mplot->map[kount].stroke[j].lonmin;
      rlonmax = mplot->map[kount].stroke[j].lonmax;

      /*  this is problematic  need to solve this problem some way.
          I removed these lines here for working on Ecuador 
      if(rlonmin<0) rlonmin += 360;
      if(rlonmax<0) rlonmax += 360; 
      */     

    kin = rect_overlap(  by1, bx1,  by2, bx2,
		       rlonmin, rlatmin,  rlonmax, rlatmax); 
      if(kin==1)
	{
	phi = rlatmin;
	lam = rlonmin;
	geo2xy(mplot, phi, lam, &bottom_left_x, &bottom_left_y);
	phi = rlatmax;
	lam = rlonmax;
	geo2xy(mplot, phi, lam, &top_right_x, &top_right_y);

	px1 = user_to_pix_x(&mplot->gr, (double)bottom_left_x);
	py1 = user_to_pix_y(&mplot->gr, (double)bottom_left_y);
	px2 = user_to_pix_x(&mplot->gr, (double)top_right_x);
	py2 = user_to_pix_y(&mplot->gr, (double)top_right_y);
 
	idx = abs( px2 - px1) ;
	idy = abs( py1 - py2) ;

	
	
	  
	XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		       mplot->colors[XmapAppColor(1)]);

	
	XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij),
		       mplot->ggc, px1, py2, idx , idy);

	XFlush(XtDisplay(mplot->wij));
	sprintf(pchar, "%d", j);
	draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij),
		       mplot->ggc, px1, py2, pchar, HJ_CENTER, VJ_BASELINE);
	fprintf(stderr, "%d %s %d %d %d \n", j,
		mplot->map[kount].stroke[j].name,
		mplot->map[kount].stroke[j].num,
		mplot->map[kount].stroke[j].style,
		mplot->map[kount].stroke[j].col);
	}
      AGAIN: ;
      }
    }
  }


void Do_FindMap(Widget wij, mpic *mplot, char *call_data)
  {
  int j, kount;
  char pchar[6], *c;
  double dis, disold;
  int i, kk, THEK, THEJ, THEI, strkn, n;
    XPoint p[5000];
 
  if(mplot->map_type <= 1) return;

  fprintf(stderr, "-------Looking For Map Lines---%d\n", mplot->num_map_files);
 

  kount = 0;
  j = 0;
  i = 0;
  THEK = 0;
  THEJ = 0;
  THEI = 0;
  
  disold = (mplot->map[kount].km[i].x-CUR_pointx)*(mplot->map[kount].km[i].x-CUR_pointx)+
  (mplot->map[kount].km[i].y-CUR_pointy)*(mplot->map[kount].km[i].y-CUR_pointy);
	
  for(kount = 0; kount < mplot->num_map_files; kount++)
     {
     fprintf(stderr, "------checking Map ---%d   %s\n", kount,
	     mplot->map[kount].file_name);
     for(j = 0; j < mplot->map[kount].stroke_count; j++)
	{
	c = mplot->map[kount].map_code;
	while(*(c++) != mplot->map[kount].stroke[j].code) 
	if(*c == '\0') goto AGAIN;
	
	strkn = 0;
	n = 0;
	
	for(i = mplot->map[kount].stroke[j].index1;
	    i < (mplot->map[kount].stroke[j].index1
		 + mplot->map[kount].stroke[j].num); i++)
	   {
	   n++;
	   
	   
	   dis = (mplot->map[kount].km[i].x - CUR_pointx)*(mplot->map[kount].km[i].x - CUR_pointx)+
	   (mplot->map[kount].km[i].y - CUR_pointy)*(mplot->map[kount].km[i].y - CUR_pointy);
	   
           if(dis < disold)
	      {
	      THEK = kount;
	      THEJ = j;
	      THEI = i;
	      disold = dis;
	      strkn = n;
	      
	      }
	   
	   
	   
	   }
	
	}
     AGAIN: ;
     }


    fprintf(stderr, "%d %s %d %d %d : %d\n", THEJ,
		mplot->map[THEK].stroke[THEJ].name,
		mplot->map[THEK].stroke[THEJ].num,
		mplot->map[THEK].stroke[THEJ].style,
		mplot->map[THEK].stroke[THEJ].col, strkn);

  kount = THEK;
  j = THEJ;
  kk =0;
  
    XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		 mplot->colors[XmapAppColor(mplot->spline_col)]);

	for(i = mplot->map[kount].stroke[j].index1;
	    i < (mplot->map[kount].stroke[j].index1
		 + mplot->map[kount].stroke[j].num); i++)
	  {
	  p[kk].x = user_to_pix_x(&mplot->gr,
				  (double)mplot->map[kount].km[i].x);
	  p[kk].y = user_to_pix_y(&mplot->gr,
				  (double)mplot->map[kount].km[i].y);
	  sprintf(pchar, "%d", kk);
	  draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij), 
			 mplot->ggc, p[kk].x, p[kk].y, pchar, HJ_CENTER,
			 VJ_BASELINE);
	  kk++;
	  }


	XDrawPoints(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
		    p, mplot->map[kount].stroke[j].num, CoordModeOrigin);
	XFlush(XtDisplay(mplot->wij));


	
  }



void Dump_SelMap(Widget wij, mpic *mplot, char *call_data)
  {
  int j,i, kount, px1, px2, py1, py2, idx, idy, kin;
  float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, phi, lam, bx1, by1, bx2, by2, rlatmin, rlatmax, rlonmin,
    rlonmax;
  char  *c;
  FILE  *fout, *fopen();
 
  int number_sel=0;
  

  if(mplot->map_type <= 1) return;

/*
  fprintf(stderr,"Type in the name of the file output\n");
  fscanf("%s", fname);
*/
  
    if((fout = fopen("dump_sel_map.out", "w")) == NULL)
    {
    printf("Can't open dump_sel_map.out ....try again\n");
    return;
    }


  minx = SELXMIN;
  miny = SELYMIN;
  maxx = SELXMAX;
  maxy = SELYMAX;

  xy2geo(mplot, &phi, &lam, minx, miny);
  bx1 = phi;
  by1 = lam;

  xy2geo(mplot, &phi, &lam, maxx, maxy);
  bx2 = phi;
  by2 = lam;

  fprintf(stderr, "-------Selected Map Lines---%d\n", mplot->num_map_files);
  /* XSetForeground(XtDisplay(wij), mplot->ggc,
     mplot->colors[mplot->zoom_box_col]);*/

  for(kount = 0; kount < mplot->num_map_files; kount++)
    {
    fprintf(stderr, "------checking Map ---%d   %s\n", kount,
	    mplot->map[kount].file_name);
    for(j = 0; j < mplot->map[kount].stroke_count; j++)
      {
      c = mplot->map[kount].map_code;
      while(*(c++) != mplot->map[kount].stroke[j].code) 
	if(*c == '\0') goto AGAIN;

      rlatmin = mplot->map[kount].stroke[j].latmin;
      rlatmax = mplot->map[kount].stroke[j].latmax;
      rlonmin = mplot->map[kount].stroke[j].lonmin;
      rlonmax = mplot->map[kount].stroke[j].lonmax;

      if(rlonmin<0) rlonmin += 360;
      if(rlonmax<0) rlonmax += 360;      

    kin = rect_overlap(  by1, bx1,  by2, bx2,
		       rlonmin, rlatmin,  rlonmax, rlatmax); 
      if(kin==1)
	{
	phi = rlatmin;
	lam = rlonmin;
	geo2xy(mplot, phi, lam, &bottom_left_x, &bottom_left_y);
	phi = rlatmax;
	lam = rlonmax;
	geo2xy(mplot, phi, lam, &top_right_x, &top_right_y);

	px1 = user_to_pix_x(&mplot->gr, (double)bottom_left_x);
	py1 = user_to_pix_y(&mplot->gr, (double)bottom_left_y);
	px2 = user_to_pix_x(&mplot->gr, (double)top_right_x);
	py2 = user_to_pix_y(&mplot->gr, (double)top_right_y);
 
	idx = abs( px2 - px1) ;
	idy = abs( py1 - py2) ;

	
	

	fprintf(stderr, "%d %s %d %d %d \n", j,
		mplot->map[kount].stroke[j].name,
		mplot->map[kount].stroke[j].num,
		mplot->map[kount].stroke[j].style,
		mplot->map[kount].stroke[j].col);
	number_sel++;
	
	fprintf(fout, 
		"> %s %d %d %d %c %f %f %f %f\n",
		mplot->map[kount].stroke[j].name,
		mplot->map[kount].stroke[j].num,
		mplot->map[kount].stroke[j].style,
		mplot->map[kount].stroke[j].col, 
		*(mplot->map[kount].map_code),
		mplot->map[kount].stroke[j].latmin, mplot->map[kount].stroke[j].latmax,
		mplot->map[kount].stroke[j].lonmin, mplot->map[kount].stroke[j].lonmax );
	
	for(i = mplot->map[kount].stroke[j].index1;
	    (i < mplot->map[kount].stroke[j].index1 + mplot->map[kount].stroke[j].num); i++)
	   {
	   fprintf(fout, "%f %f\n", mplot->map[kount].latlon[i].x, mplot->map[kount].latlon[i].y);
	   }
	
	
	}
      AGAIN: ;
      }
    }
  fclose(fout);
  fprintf(stderr,"The new Selected map file is in: dump_sel_map.out\n");
  fprintf(stderr,"number of strokes is: %d\n", number_sel);

  
  
  }


/***************************************************************************/
void Dump_FullMap(Widget wij, mpic *mplot, char *call_data)
  {
  int j,i, kount, px1, px2, py1, py2, idx, idy, kin;
  float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, phi, lam, bx1, by1, bx2, by2, rlatmin, rlatmax, rlonmin,
    rlonmax;
  char  *c;
  FILE  *fout, *fopen();
 
  int number_sel=0;
  

  if(mplot->map_type <= 1) return;

/*
  fprintf(stderr,"Type in the name of the file output\n");
  fscanf("%s", fname);
*/
  
    if((fout = fopen("dump_sel_map.out", "w")) == NULL)
    {
    printf("Can't open dump_sel_map.out ....try again\n");
    return;
    }


  minx = SELXMIN;
  miny = SELYMIN;
  maxx = SELXMAX;
  maxy = SELYMAX;

  xy2geo(mplot, &phi, &lam, minx, miny);
  bx1 = phi;
  by1 = lam;

  xy2geo(mplot, &phi, &lam, maxx, maxy);
  bx2 = phi;
  by2 = lam;

  fprintf(stderr, "-------Selected Map Lines---%d\n", mplot->num_map_files);
  /* XSetForeground(XtDisplay(wij), mplot->ggc,
     mplot->colors[mplot->zoom_box_col]);*/

  for(kount = 0; kount < mplot->num_map_files; kount++)
    {
    fprintf(stderr, "------checking Map ---%d   %s\n", kount,
	    mplot->map[kount].file_name);
    for(j = 0; j < mplot->map[kount].stroke_count; j++)
      {
      c = mplot->map[kount].map_code;
      while(*(c++) != mplot->map[kount].stroke[j].code) 
	if(*c == '\0') goto AGAIN;

      rlatmin = mplot->map[kount].stroke[j].latmin;
      rlatmax = mplot->map[kount].stroke[j].latmax;
      rlonmin = mplot->map[kount].stroke[j].lonmin;
      rlonmax = mplot->map[kount].stroke[j].lonmax;

      if(rlonmin<0) rlonmin += 360;
      if(rlonmax<0) rlonmax += 360;      

    kin = rect_overlap(  by1, bx1,  by2, bx2,
		       rlonmin, rlatmin,  rlonmax, rlatmax); 
      if(1>0)
	{
	phi = rlatmin;
	lam = rlonmin;
	geo2xy(mplot, phi, lam, &bottom_left_x, &bottom_left_y);
	phi = rlatmax;
	lam = rlonmax;
	geo2xy(mplot, phi, lam, &top_right_x, &top_right_y);

	px1 = user_to_pix_x(&mplot->gr, (double)bottom_left_x);
	py1 = user_to_pix_y(&mplot->gr, (double)bottom_left_y);
	px2 = user_to_pix_x(&mplot->gr, (double)top_right_x);
	py2 = user_to_pix_y(&mplot->gr, (double)top_right_y);
 
	idx = abs( px2 - px1) ;
	idy = abs( py1 - py2) ;

	
	

	fprintf(stderr, "%d %s %d %d %d \n", j,
		mplot->map[kount].stroke[j].name,
		mplot->map[kount].stroke[j].num,
		mplot->map[kount].stroke[j].style,
		mplot->map[kount].stroke[j].col);
	number_sel++;
	
	fprintf(fout, 
		"> %s %d %d %d %c %f %f %f %f\n",
		mplot->map[kount].stroke[j].name,
		mplot->map[kount].stroke[j].num,
		mplot->map[kount].stroke[j].style,
		mplot->map[kount].stroke[j].col, 
		*(mplot->map[kount].map_code),
		mplot->map[kount].stroke[j].latmin, mplot->map[kount].stroke[j].latmax,
		mplot->map[kount].stroke[j].lonmin, mplot->map[kount].stroke[j].lonmax );
	
	for(i = mplot->map[kount].stroke[j].index1;
	    (i < mplot->map[kount].stroke[j].index1 + mplot->map[kount].stroke[j].num); i++)
	   {
	   fprintf(fout, "%f %f\n", mplot->map[kount].latlon[i].x, mplot->map[kount].latlon[i].y);
	   }
	
	
	}
      AGAIN: ;
      }
    }
  fclose(fout);
  fprintf(stderr,"The new Selected map file is in: dump_sel_map.out\n");
  fprintf(stderr,"number of strokes is: %d\n", number_sel);

  
  
  }



/***************************************************************************/

void DoA_PointsMap(mpic *mplot)
  {
  int i, j, kk, kount, px1, px2, py1, py2, kin;
  float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, phi, lam, bx1, by1, bx2, by2, rlatmin, rlatmax, rlonmin,
    rlonmax;
  char pchar[6], *c;
  XPoint p[5000];
  Widget mwij;
   Display *disp;	
  Window wind;	
  GC mggc;
  
  mwij = mplot->wij;
  /* XtVaGetValues(mwij, XtNdata, &mplot, NULL); */
  wind = XtWindow(mwij);
  disp = XtDisplay(mwij);
  mggc = mplot->ggc;

  if(mplot->map_type <= 1) return;
  
  minx = SELXMIN;
  miny = SELYMIN;
  maxx = SELXMAX;
  maxy = SELYMAX;
  
  XSetFont(disp, mggc, mplot->fonts[0]);

  xy2geo(mplot, &phi, &lam, minx, miny);
  bx1 = phi;
  by1 = lam;

  xy2geo(mplot, &phi, &lam, maxx, maxy);
  bx2 = phi;
  by2 = lam;

  fprintf(stderr, "-------Selected Map Lines---%d\n", mplot->num_map_files);
  for(kount = 0; kount < mplot->num_map_files; kount++)
     {
	fprintf(stderr, "------checking Map ---%d\n", kount);
	for(j = 0; j < mplot->map[kount].stroke_count; j++)
	   {
	      c = mplot->map[kount].map_code;
	      while(*(c++) != mplot->map[kount].stroke[j].code) 
	      if(*c == '\0') goto AGAIN;

	      rlatmin = mplot->map[kount].stroke[j].latmin;
	      rlatmax = mplot->map[kount].stroke[j].latmax;
	      rlonmin = mplot->map[kount].stroke[j].lonmin;
	      rlonmax = mplot->map[kount].stroke[j].lonmax;
	      
	      kin = rect_overlap(  by1, bx1,  by2, bx2,
				   rlonmin, rlatmin,  rlonmax, rlatmax); 
	      if(kin==1)
	      {
		 phi = rlatmin;
		 lam = rlonmin;
		 geo2xy(mplot, phi, lam, &bottom_left_x, &bottom_left_y);
		 phi = rlatmax;
		 lam = rlonmax;
		 geo2xy(mplot, phi, lam, &top_right_x, &top_right_y);
		 px1 = user_to_pix_x(&mplot->gr, (double)bottom_left_x);
		 py1 = user_to_pix_y(&mplot->gr, (double)bottom_left_y);
		 px2 = user_to_pix_x(&mplot->gr, (double)top_right_x);
		 py2 = user_to_pix_y(&mplot->gr, (double)top_right_y);

	

		 XDrawRectangle(disp, wind,
				mggc, px1, py2, abs(px2 - px1) , abs(py1 - py2) );
		 sprintf(pchar, "%d", j);
		 
		 /* px1 = user_to_pix_x(&mplot->gr,
		    (double)mplot->map[kount].km[mplot->map[kount].stroke[j].index1].x);
		    py2 = user_to_pix_y(&mplot->gr,
					(double)mplot->map[kount].km[mplot->map[kount].stroke[j].index1].y);
		 */
		 
		 draw_just_text(disp, wind,
				mggc, px1, py2, pchar, HJ_CENTER, VJ_BASELINE);
		 fprintf(stderr, "%d %s %d %d %d \n", j,
			 mplot->map[kount].stroke[j].name,
			 mplot->map[kount].stroke[j].num,
			 mplot->map[kount].stroke[j].style,
			 mplot->map[kount].stroke[j].col);
		 
		 kk = 0;
		 for(i = mplot->map[kount].stroke[j].index1;
			i < (mplot->map[kount].stroke[j].index1
			     + mplot->map[kount].stroke[j].num); i++)
		    {
		       p[kk].x = user_to_pix_x(&mplot->gr,
					       (double)mplot->map[kount].km[i].x);
		       p[kk].y = user_to_pix_y(&mplot->gr,
					       (double)mplot->map[kount].km[i].y);
		       sprintf(pchar, "%d", kk);
		       draw_just_text(disp, wind, 
				      mggc, p[kk].x, p[kk].y, pchar, HJ_CENTER,
				      VJ_BASELINE);
		       kk++;
		    }
			XDrawPoints(disp, wind, mggc,
				    p, mplot->map[kount].stroke[j].num, CoordModeOrigin);
			XFlush(disp);

            
			}
			
		 AGAIN: ;
	      }
	   }
	       }

/* --------------------------------------------------------- */
void Toggle_foc_summary(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->foc_summary_flag = !mplot->foc_summary_flag;
  if(mplot->foc_summary_flag < 1) mplot->foc_summary_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }
/* --------------------------------------------------------- */
void Toggle_auto_foc_summary(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->foc_auto_summary_flag = !mplot->foc_auto_summary_flag;
  if(mplot->foc_auto_summary_flag < 1) mplot->foc_auto_summary_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }
/* --------------------------------------------------------- */
void Toggle_HiLite(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->Hi_Lite_flag = !mplot->Hi_Lite_flag;
  if(mplot->Hi_Lite_flag < 1) mplot->Hi_Lite_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }
/* --------------------------------------------------------- */
void Toggle_Integrate_Image(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->Integrate_flag = !mplot->Integrate_flag;
  if(mplot->Integrate_flag < 1) mplot->Integrate_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }
/* --------------------------------------------------------- */
void Toggle_Draw_Spline(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->Draw_spline_flag = !mplot->Draw_spline_flag;
  if(mplot->Draw_spline_flag < 1) mplot->Draw_spline_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }
/* --------------------------------------------------------- */
void Toggle_Replot_Poly(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->Replot_Poly_flag = !mplot->Replot_Poly_flag;
  if(mplot->Replot_Poly_flag < 1) mplot->Replot_Poly_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }
/* --------------------------------------------------------- */
void Toggle_Replot_Target(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->Replot_target_flag = !mplot->Replot_target_flag;
  if(mplot->Replot_target_flag < 1) mplot->Replot_Poly_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }





/* --------------------------------------------------------- */
void Toggle_PointsMap(Widget wij, mpic *mplot, char *call_data)
  {  
  short x, y, w, h;
  mplot->map_point_flag = !mplot->map_point_flag;
  if(mplot->map_point_flag < 1) mplot->map_point_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }
/* --------------------------------------------------------- */
void Start_middle(Widget wij, XButtonEvent *event, String *params,
		  Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  mplot->picsource_flag = 1;
  mplot->picsourcemove_flag = 0;
  mplot->picsource_org.x = event->x;
  mplot->picsource_org.y = event->y;
  mplot->picsource_spot = mplot->picsource_org;
  gscr_num = DefaultScreen(XtDisplay(wij));
  XSetForeground(XtDisplay(wij), mplot->ggc, BlackPixel(XtDisplay(wij),
							gscr_num));
  XSetBackground(XtDisplay(wij), mplot->ggc, WhitePixel(XtDisplay(wij),
							gscr_num));
  }

/* --------------------------------------------------------- */

void Resize_middle(Widget wij, XButtonEvent *event, String *params,
		   Cardinal *num_params)
  {
  GC ggc;
  mpic *mplot;
  XPoint p[5];

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  ggc = mplot->ggc;
  XSetClipMask(XtDisplay(wij), ggc, None);
  XSetFunction(XtDisplay(wij), ggc, GXnor);

  getbox(mplot->picsource_org.x,mplot->picsource_org.y,
	 mplot->picsource_spot.x,mplot->picsource_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);

  mplot->picsource_spot.x = event->x;
  mplot->picsource_spot.y = event->y;

  getbox(mplot->picsource_org.x,mplot->picsource_org.y,
	 mplot->picsource_spot.x,mplot->picsource_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);

  mplot->picsourcemove_flag = 1;
  XSetFunction(XtDisplay(wij), ggc, GXcopy);
  }

/* ------------------------------------------------------------------ */

void Do_middle(Widget wij, XButtonEvent *ev, String *params,
	       Cardinal *num_params)
  {
  mpic *mplot;
  int i, newx, newy;
  float minx, maxx, miny, maxy, bottom_left_x, bottom_left_y, top_right_x,
    top_right_y, temspacx, temspacy, xkm, ykm, phi, lam;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  XSetClipMask(XtDisplay(wij), mplot->ggc, None);

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    maxy = pix_to_user_y(&mplot->gr, (int) mplot->picsource_org.y);
    }
  else
    {
    miny = pix_to_user_y(&mplot->gr, (int) mplot->picsource_org.y);
    maxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    } 

  SELXMIN = minx;
  SELYMIN = miny;
  SELXMAX = maxx;
  SELYMAX = maxy;

  bottom_left_x = (float)minx;
  bottom_left_y = (float)miny;
 xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);

  fprintf(stderr, "Box Coordinates:\n");
  fprintf(stderr, "Bot Left:  km: %f %f\n", bottom_left_x, bottom_left_y);
  fprintf(stderr, " LAT-LON  LAT-LON:\n %f %f ", phi, lam);

  top_right_x = (float)maxx;
  top_right_y = (float)maxy;
  xy2geo(mplot, &phi, &lam, top_right_x, top_right_y);
  fprintf(stderr, " %f %f \n", phi, lam);
  fprintf(stderr, "Top Right:  km: %f %f\n", top_right_x, top_right_y);

  /* dump out an origin file */
  fprintf(stderr, "  \n  New ORIGIN FILE: \n");
  xy2geo(mplot, &phi, &lam, bottom_left_x, bottom_left_y);                
  xkm = fabs(top_right_x - bottom_left_x);
  ykm = fabs(top_right_y - bottom_left_y);                
  fprintf(stderr, "DX = %f DY = %f \n\n", xkm, ykm);

  if(xkm <= 5)
    {
    temspacx = 0.1;
    newx = xkm / temspacx;
    }
  if(xkm > 10.0 && xkm < 80.0)
    {
    newx = xkm;
    temspacx = 1.0;
    }
  if(xkm < 10.0 && xkm > 5.0)
    {
    temspacx = 0.5;
    newx = xkm / temspacx;
    }
  if(xkm > 80.0 && xkm < 120.0)
    {
    temspacx = 2.0;
    newx = xkm / temspacx;
    }
  if(xkm > 120.0)
    {
    temspacx = 5.0;
    newx = xkm / temspacx;
    }
  if(ykm <= 5)
    {
    temspacy = 0.1;
    newy = ykm / temspacy;
    }
  if(ykm > 10.0 && ykm < 80.0)
    {
    newy = ykm;
    temspacy = 1.0;
    }
  if(ykm < 10.0 && ykm > 5.0)
    {
    temspacy = 0.5;
    newy = ykm / temspacy;
    }
  if(ykm > 80.0 && ykm < 120.0)
    {
    temspacy = 2.0;
    newy = ykm / temspacy;
    }
  if(ykm > 120.0)
    {
    temspacy = 5.0;
    newy = ykm / temspacy;
    }

  i = (int)mplot->MaxDepth;
  fprintf(stdout, "1 1 %d %d %d %f %f\n", newx, newy, i, temspacx, temspacy);
  fprintf(stdout, "%f \n", phi);
  fprintf(stdout, "%f \n", lam);       
  fprintf(stdout, " \n\n");
  fprintf(stdout, "---------------------------------------------- \n");
  global_poly = 4;
  gpolx[0] = mplot->picsource_org.x; gpoly[0] = mplot->picsource_org.y;
  gpolx[1] = mplot->picsource_org.x; gpoly[1] = mplot->picsource_spot.y;
  gpolx[2] = mplot->picsource_spot.x; gpoly[2] = mplot->picsource_spot.y;
  gpolx[3] = mplot->picsource_spot.x; gpoly[3] = mplot->picsource_org.y;
  }

/* --------------------------------------------------------- */

void Start_selfoc(Widget wij, XButtonEvent *event, String *params,
		  Cardinal *num_params)
  {
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  mplot->picsource_flag = 1;
  mplot->picsourcemove_flag = 0;
  mplot->picsource_org.x = event->x;
  mplot->picsource_org.y = event->y;
  mplot->picsource_spot = mplot->picsource_org;
  gscr_num = DefaultScreen(XtDisplay(wij));
  XSetForeground(XtDisplay(wij), mplot->ggc, BlackPixel(XtDisplay(wij),
							gscr_num));
  XSetBackground(XtDisplay(wij), mplot->ggc, WhitePixel(XtDisplay(wij),
							gscr_num));
  }

/* --------------------------------------------------------- */

void Resize_selfoc(Widget wij, XButtonEvent *event, String *params,
		   Cardinal *num_params)
  {
  GC ggc;
  mpic *mplot;
  XPoint p[5];

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  ggc = mplot->ggc;
  XSetClipMask(XtDisplay(wij), ggc, None);
  XSetFunction(XtDisplay(wij), ggc, GXnor);

  getbox(mplot->picsource_org.x, mplot->picsource_org.y,
	 mplot->picsource_spot.x, mplot->picsource_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);
  mplot->picsource_spot.x = event->x;
  mplot->picsource_spot.y = event->y;
  getbox(mplot->picsource_org.x, mplot->picsource_org.y,
	 mplot->picsource_spot.x, mplot->picsource_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);
  mplot->picsourcemove_flag = 1;
  XSetFunction(XtDisplay(wij), ggc, GXcopy);
  }

/* ------------------------------------------------------------------ */
void Do_selfoc(Widget wij, XButtonEvent *ev, String *params,
	       Cardinal *num_params)
  {
  mpic *mplot;
  int i,  k, kount;
  char acard[80], mcard[80];
  float px, py, minx, maxx, miny, maxy, bottom_left_x, bottom_left_y,
    top_right_x, top_right_y, phi, lam;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);

  if(mplot->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal Files available\n");
    return;
    }
  if(mplot->picsourcemove_flag)
    {
    XSetClipMask(XtDisplay(wij), mplot->ggc, None);
    if(mplot->picsource_org.x > mplot->picsource_spot.x)
      {
      minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
      maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
      }
    else
      {
      minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
      maxx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
      }
    if(mplot->picsource_org.y < mplot->picsource_spot.y)
      {
	miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
	maxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
      }
    else
      {
	miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
	maxy = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
      }

    bottom_left_x = (float) minx;
    bottom_left_y = (float) miny;
    top_right_x = (float) maxx;
    top_right_y = (float) maxy;

    k = 0;
    for(kount = 0; kount < mplot->num_focm_files; kount++)
      {
	for(i = 0; i < mplot->focm[kount].numpoints; i++)
	  {
	    phi = mplot->focm[kount].focs[i].loc.x;
	    lam = mplot->focm[kount].focs[i].loc.y;
	    geo2xy(mplot, phi, lam, &px, &py);

	    if((px >= bottom_left_x) && (px <= top_right_x)
	       && (py >= bottom_left_y) && (py <= top_right_y))
	      {
		create_Acard(&mplot->focm[kount].focs[i].ac, acard);
		fprintf(stdout, "%s", acard);
		create_Mcard(&mplot->focm[kount].focs[i].fm, mcard);
		fprintf(stdout, "%s", mcard);
	      }
	  }
      }
    }

  SELXMIN = minx;
  SELYMIN = miny;
  SELXMAX = maxx;
  SELYMAX = maxy;

  global_poly = 4;
  gpolx[0] = mplot->picsource_org.x;
  gpoly[0] = mplot->picsource_org.y;
  gpolx[1] = mplot->picsource_org.x;
  gpoly[1] = mplot->picsource_spot.y;
  gpolx[2] = mplot->picsource_spot.x;
  gpoly[2] = mplot->picsource_spot.y;
  gpolx[3] = mplot->picsource_spot.x;
  gpoly[3] = mplot->picsource_org.y;
  }
/* ------------------------------------------------------------------ */
void Dump_Focs(char *sfile, mpic *mplot)
{

  int i,  jcount;
  char acard[80], mcard[80], exmcard[80];
  float phi, lam, px, py;
  FILE *ofile, *fopen();
  int klen;
  
  if(mplot->num_focm_files < 1)
    {
      fprintf(stderr, "No Focal Files available\n");
      return;
    }
  
  if((ofile = fopen(sfile, "w")) == NULL)
    {
    printf("Can't open %s ....try again\n", sfile);
    return;
    }



    for(jcount = 0; jcount < mplot->num_focm_files; jcount++)
    {
     
      
      for(i = 0; i < mplot->focm[jcount].numpoints; i++)
	{
	 
	  px = mplot->focm[jcount].focs[i].explode_x;
	  py = mplot->focm[jcount].focs[i].explode_y;
	  xy2geo(mplot,  &phi,  &lam, px, py);
 
	  create_Acard(&mplot->focm[jcount].focs[i].ac, acard);
	  fprintf(ofile, "%s", acard);
	  create_Mcard(&mplot->focm[jcount].focs[i].fm, mcard);
      
           klen = strlen(mcard);
	   strcpy(exmcard, mcard);
	   exmcard[klen-1]= '\0'; 
	  fprintf(ofile, "%s", exmcard);
	  fprintf(ofile, " %f %f \n", phi, lam);
	  
	
	}
     
      

    }
}





/* ------------------------------------------------------------------ */
static void SDR_selfoc(Widget w, mpic *mplot, char *call_data)
{
  
  int i,  k, kount;
  char acard[80], mcard[80];
  float px, py, minx, maxx, miny, maxy, bottom_left_x, bottom_left_y,
    top_right_x, top_right_y, phi, lam;

  float ang, dipaz1,rake1, dipaz2, rake2;

  if(mplot->num_focm_files < 1)
    {
      fprintf(stderr, "No Focal Files available\n");
      return;
    }

  minx = SELXMIN;
  miny = SELYMIN;
  maxx = SELXMAX  ;
  maxy = SELYMAX  ;
  
  {
    

    bottom_left_x = (float) minx;
    bottom_left_y = (float) miny;
    top_right_x = (float) maxx;
    top_right_y = (float) maxy;

    k = 0;
    for(kount = 0; kount < mplot->num_focm_files; kount++)
      {
	for(i = 0; i < mplot->focm[kount].numpoints; i++)
	  {
	    phi = mplot->focm[kount].focs[i].loc.x;
	    lam = mplot->focm[kount].focs[i].loc.y;
	    geo2xy(mplot, phi, lam, &px, &py);

	    if((px >= bottom_left_x) && (px <= top_right_x)
	       && (py >= bottom_left_y) && (py <= top_right_y))
	      {


		create_Acard(&mplot->focm[kount].focs[i].ac, acard);
		fprintf(stdout, "%s", acard);
		create_Mcard(&mplot->focm[kount].focs[i].fm, mcard);
		fprintf(stdout, "%s", mcard);

		if(mplot->focm[kount].focs[i].ipol == 0) ang = 1.0;
		else ang = -1.0;

		Rake_Cal(mplot->focm[kount].focs[i].fm.strk1, mplot->focm[kount].focs[i].fm.dip1,
			 mplot->focm[kount].focs[i].fm.strk2, mplot->focm[kount].focs[i].fm.dip2,
			 ang, &dipaz1, &rake1, &dipaz2, &rake2);

		fprintf(stdout,"SDR: %f %f %f %f\n", mplot->focm[kount].focs[i].fm.strk1, dipaz1, mplot->focm[kount].focs[i].fm.dip1,  rake1);

	      }
	  }
      }
  }

 
}

/* --------------------------------------------------------- */

void Poly_Start(Widget wij, mpic *mplot, char *call_data)
{

  fprintf(stderr,"starting new polygon...\n");
  if(global_poly > 0)
    fprintf(stderr,"old global=%d\n",global_poly);
  num_poly++;
  global_poly = 0;
}

/* --------------------------------------------------------- */

void Poly_Spline(mpic *mplot )
{
  float xkm, ykm, phi, lam, lat, lon, maxlat, minlat, maxlon, minlon, *x, *y,
    *rex, *rey;
  int nside, i, ndiv = 20;
  XPoint p[2000];

  if(global_poly < 2) return;

  nside = (global_poly - 1) * ndiv + 1;

  x = alloc_fvec(0, global_poly);
  y = alloc_fvec(0, global_poly);
  rex = alloc_fvec(0, nside);
  rey = alloc_fvec(0, nside);

  for(i = 0; i < global_poly; i++)
    {
      x[i] = pix_to_user_x(&mplot->gr, (int)gpolx[i]);
      y[i] = pix_to_user_y(&mplot->gr, (int)gpoly[i]);        
    }

  jspl(x, y, global_poly, ndiv, rex, rey);

  /* for(i=0; i<  nside; i++)fprintf(stderr,"%d %f %f\n",i,rex[i],rey[i]);*/
  xkm = rex[0];
  ykm = rey[0];
  xy2geo(mplot, &phi, &lam, xkm, ykm);
  lat = phi;
  lon = lam;
  maxlat = minlat = lat;
  maxlon = minlon = lon;
  for(i = 0; i < nside; i++)
    {
    xkm = rex[i];
    ykm = rey[i];
    xy2geo(mplot, &phi, &lam, xkm, ykm);
    lat = phi;
    lon = lam;
    maxlat = max2(lat, maxlat);
    minlat = min2(lat, minlat);
    maxlon = max2(lon, maxlon);
    minlon = min2(lon, minlon);
    }

  fprintf(stderr, "> SPL_%-4d %d 2 1  o %f %f %f %f\n", num_poly,nside,
	  minlat, maxlat, minlon, maxlon );
  for(i = 0; i < nside; i++)
    {
    p[i].x = user_to_pix_x(&mplot->gr, (double)rex[i]);
    p[i].y = user_to_pix_y(&mplot->gr, (double)rey[i]);
    xkm = rex[i];
    ykm = rey[i];
    xy2geo(mplot, &phi, &lam, xkm, ykm);
    lat = phi;
    lon = lam;
    fprintf(stderr, "%f  %f \n", lat, lon);
    }
  XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		 mplot->colors[XmapAppColor(mplot->spline_col)]);
  XDrawLines(XtDisplay(mplot->wij),XtWindow(mplot->wij), mplot->ggc, p, nside,
	     CoordModeOrigin);
  XFlush(XtDisplay(mplot->wij));

  free_fvec(x, 0, global_poly);
  free_fvec(y, 0, global_poly);
  }

void Poly_Points(Widget wij, XButtonEvent *ev, String *params,
		 Cardinal *num_params)
  {
  mpic *mplot;
  float xkm, ykm, phi, lam, lat, lon;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  xkm = pix_to_user_x(&mplot->gr, (int)ev->x);
  ykm = pix_to_user_y(&mplot->gr, (int)ev->y);
  xy2geo(mplot, &phi, &lam, xkm, ykm);
  lat = phi;
  lon = lam;
  gpolx[global_poly] = ev->x;
  gpoly[global_poly] = ev->y;
  polylat[global_poly] = phi;
  polylon[global_poly] = lam;
  fprintf(stderr, "%f %f \n", lat, lon);
  if(global_poly > 0)
    {
    XSetForeground(XtDisplay(wij), mplot->ggc,
		   mplot->colors[XmapAppColor(mplot->spline_points_col)]);
    XDrawLine(XtDisplay(wij),XtWindow(wij), mplot->ggc, gpolx[global_poly - 1],
	      gpoly[global_poly - 1], gpolx[global_poly], gpoly[global_poly]);
    }
  global_poly++;
  XFlush(XtDisplay(wij));
  }

void Replot_Poly(mpic *mplot)
  {
  int i;
  float xkm, ykm, lat, lon, maxlat, minlat, maxlon, minlon;
  XPoint p[200];

  fprintf(stderr, "num poly = %d\n", global_poly);

  if(global_poly > 0)
    {
    for(i = 0; i < global_poly; i++)
      {
      geo2xy(mplot, polylat[i], polylon[i], &xkm, &ykm);
      fprintf(stderr, "%f bx  %f bz lineto\n", xkm, ykm);
      p[i].x = user_to_pix_x(&mplot->gr, xkm);
      p[i].y = user_to_pix_y(&mplot->gr, ykm);
      }
    fprintf(stderr, " closepath stroke \n ");
    p[global_poly].x = p[0].x;
    p[global_poly].y = p[0].y;

    XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		   mplot->colors[XmapAppColor(mplot->spline_points_col)]);
    XDrawLines(XtDisplay(mplot->wij),XtWindow(mplot->wij), mplot->ggc,
	       p, global_poly + 1,CoordModeOrigin);
    }
  XFlush(XtDisplay(mplot->wij));

  if(global_poly > 0)
    {
    maxlat = minlat = polylat[0];
    maxlon = minlon = polylon[0];
    for(i = 1; i < global_poly; i++)
      {
      lat = polylat[i];
      lon = polylon[i];
      fprintf(stderr, "%f  %f \n", lat, lon);
      maxlat = max2(lat, maxlat);
      minlat = min2(lat, minlat);
      maxlon = max2(lon, maxlon);
      minlon = min2(lon, minlon);
      }

    fprintf(stderr, "> PLY_%-4d %d 2 1  o %f %f %f %f\n", num_poly,
	    global_poly, minlat, maxlat, minlon, maxlon);
    for(i = 0; i < global_poly; i++)
      {
      lat = polylat[i];
      lon = polylon[i];
      fprintf(stderr, "%f  %f \n", lat, lon);
      }
    }
  }

void Replot_Targ(mpic *mplot)
  {
  XPoint p[200];

  fprintf(stderr, "num poly = %d\n", global_poly);
  if(global_poly > 3)
    {    
    p[0].x = user_to_pix_x(&mplot->gr, (double)SELXMIN);
    p[0].y = user_to_pix_y(&mplot->gr, (double)SELYMIN);
    p[1].x = user_to_pix_x(&mplot->gr, (double)SELXMAX);
    p[1].y = user_to_pix_y(&mplot->gr, (double)SELYMIN);
    p[2].x = user_to_pix_x(&mplot->gr, (double)SELXMAX);
    p[2].y = user_to_pix_y(&mplot->gr, (double)SELYMAX);
    p[3].x = user_to_pix_x(&mplot->gr, (double)SELXMIN);
    p[3].y = user_to_pix_y(&mplot->gr, (double)SELYMAX);

    p[4].x = p[0].x;
    p[4].y = p[0].y;
    }

  XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		 mplot->colors[XmapAppColor(mplot->spline_points_col)]);
  XDrawLines(XtDisplay(mplot->wij),XtWindow(mplot->wij), mplot->ggc, p, 5,
	     CoordModeOrigin);
  XFlush(XtDisplay(mplot->wij));
  }

void Toggle_LIPS(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->lip_flag = !mplot->lip_flag;
  if(mplot->lip_num < 1) mplot->lip_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/***********************************************************/

void ThreeD_Body(Widget wij, mpic * mplot, char *call_data)
  {
  short x, y, w, h;
  char           infile[200];

  fprintf(stderr, "type in the file name of the three-D wireframe object:\n");
  fscanf(stdin, "%s", infile);
  Get_ThreeD(infile, mplot);
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

void Toggle_ThreeD_Body(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->wire_flag = !mplot->wire_flag;
  if(mplot->wire_tot < 1) mplot->wire_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

void Toggle_Boxes(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->picsource_flag = !mplot->picsource_flag;
  if(mplot->picsource_flag < 1) mplot->picsource_flag = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

void Erase_Boxes(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->picsource.numpoints = 0;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }


/* --------------------------------------------------------- */

void select_station(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->sta_flag = !mplot->sta_flag;
  if(mplot->sta_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Plot Stations", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot Stations", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/* --------------------------------------------------------- */

void select_station_names(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->sta_name_flag = !mplot->sta_name_flag;
  if(mplot->sta_name_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Plot Station Names", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot Station Names", NULL);
  send_repaint(mplot->wij, 0, 0, width, height);
  }
/* --------------------------------------------------------- */

void select_wells_names(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->wells_name_flag = !mplot->wells_name_flag;
  if(mplot->wells_name_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Plot Well Names", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot Well Names", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* --------------------------------------------------------- */

void Toggle_Symbol_wells(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->wells_symbol_flag = !mplot->wells_symbol_flag;
  if(mplot->wells_symbol_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Well Symbols", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Well Symbols", NULL);
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  send_repaint(mplot->wij, 0, 0, width, height);
  }
/* --------------------------------------------------------- */

void Toggle_wells_in_layers(Widget wij, mpic *mplot, char *call_data)
   {
   Position x, y;
   Dimension width, height;

   XtVaGetValues(wij, XtNdata, &mplot, NULL);
   XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		 XtNheight, &height, NULL);

   mplot->wells_in_layer = !mplot->wells_in_layer ;
   if(mplot->wells_in_layer == 0)
      {
     
      XtVaSetValues(wij, XtNlabel, "- Wells in Layer", NULL);
      }
  
   else 
      {
     
      XtVaSetValues(wij, XtNlabel, "+ Wells in Layer", NULL);
      mplot->hoz_slab_flag =1;
      set_wells_layer(mplot);
      

      }
  
   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &width,
		 XtNheight, &height, NULL);
   send_repaint(mplot->wij, 0, 0, width, height);
   }


void Toggle_wells_Project_all(Widget wij, mpic *mplot, char *call_data)
   {
   
 

   mplot->wells_proj_all = !mplot->wells_proj_all ;
   if(mplot->wells_proj_all == 0)
      {
     
      XtVaSetValues(wij, XtNlabel, "No Proj XS-wells", NULL);
      }
  
   else 
      {
     
      XtVaSetValues(wij, XtNlabel, "Proj All XS-wells", NULL);

      }
  

   }

/************************************/
void Thicker_wells(Widget wij, mpic *mplot, char *call_data)
   {
   
   mplot->wells_thickness++;
   }
/************************************/
void Thinner_wells(Widget wij, mpic *mplot, char *call_data)
   {
   
   mplot->wells_thickness--;
   if(mplot->wells_thickness<0) mplot->wells_thickness=0;
   }
/************************************/


/* --------------------------------------------------------- */

void project_wells(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->wells_project_flag = !mplot->wells_project_flag;
  if(mplot->wells_project_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Project Wells", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Project Wells", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* --------------------------------------------------------- */

void project_well_dips(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;
  int kount, a, i, pix_x1, pix_y1, pix_y2, pix_x2;
  float px, py, px2, py2, pz2, dx, dy, dz, phi, lam;
  
  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  for(kount = 0; kount < mplot->num_wells_files; kount++)
    {
    for(a = 0; a < mplot->wells[kount].well_count; a++)
      {
      for(i = 0; i < mplot->wells[kount].well[a].nump; i++)
	{
	XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
	  mplot->colors[XmapAppColor(mplot->wells[kount].well[a].lith[i])]);
	phi = mplot->wells[kount].well[a].loc[i].x;
	lam = mplot->wells[kount].well[a].loc[i].y;
	geo2xy(mplot, phi, lam, &px, &py); 

	/* dx = cos(mplot->wells[kount].well[a].dip[i].x)
	 * cos(mplot->wells[kount].well[a].dip[i].y);
	 dy = sin(mplot->wells[kount].well[a].dip[i].x)
	 * cos(mplot->wells[kount].well[a].dip[i].y); */

	dx = cos(mplot->wells[kount].well[a].dip[i].x);
	dy = sin(mplot->wells[kount].well[a].dip[i].x);
	dz = sin(mplot->wells[kount].well[a].dip[i].y);
	px2 = px + mplot->wells[kount].well[a].dip[i].z * dx;
	py2 = py + mplot->wells[kount].well[a].dip[i].z * dy;
	pz2 = (mplot->wells[kount].well[a].loc[i].z
	       + mplot->wells[kount].well[a].dip[i].z * dz);
	pix_x1 = user_to_pix_x(&mplot->gr, (double)px);
	pix_y1 = user_to_pix_y(&mplot->gr, (double)py);
	pix_x2 = user_to_pix_x(&mplot->gr, (double)px2);
	pix_y2 = user_to_pix_y(&mplot->gr, (double)py2);

	XDrawLine(XtDisplay(mplot->wij),XtWindow(mplot->wij), mplot->ggc,
                  pix_x1, pix_y1, pix_x2, pix_y2);
	XFlush(XtDisplay(mplot->wij));
	}
      }
    }
  }

/* --------------------------------------------------------- */

void Dump_wells(Widget wij, mpic *mplot, char *call_data)
  {
  int i, j, k;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  for(i = 0; i < mplot->num_wells_files; i++)
    {
    for(j = 0; j < mplot->wells[i].well_count; j++)
      {
      fprintf(stdout, "%s %d %d %d\n", mplot->wells[i].well[j].name,
	      mplot->wells[i].well[j].nump, mplot->wells[i].well[j].style,
	      mplot->wells[i].well[j].color);

      for(k = 0; k < mplot->wells[i].well[j].nump; k++)
	{
	fprintf(stdout, "%f %f %f %f %f %f %d\n",
		mplot->wells[i].well[j].loc[k].x,
		mplot->wells[i].well[j].loc[k].y,
		mplot->wells[i].well[j].loc[k].z,
		mplot->wells[i].well[j].dip[k].x,
		mplot->wells[i].well[j].dip[k].y,
		mplot->wells[i].well[j].dip[k].z,
		mplot->wells[i].well[j].lith[k]);
	}
      }
    }
  }

/* --------------------------------------------------------- */

void select_explode(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->focal_explode = !mplot->focal_explode;
  if(mplot->focal_explode == 0)
    XtVaSetValues(wij, XtNlabel, "- Explode Focals", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Explode Focals",	NULL);

  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* --------------------------------------------------------- */

void select_scale_by_mag(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->focal_mag_scale = !mplot->focal_mag_scale;
  if(mplot->focal_mag_scale == 0)
    XtVaSetValues(wij, XtNlabel, "- Scale Mag", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Scale Mag", NULL);

  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* --------------------------------------------------------- */

void select_focal_color(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  if(mplot->focm_color > 0) mplot->focm_color = 0;
  else mplot->focm_color = 20;

  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* --------------------------------------------------------- */

void select_B_W(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);

  mplot->BW_flag = !mplot->BW_flag;
  if(mplot->BW_flag == 0) XtVaSetValues(wij, XtNlabel, "-> COLOR-PS", NULL);
  else XtVaSetValues(wij, XtNlabel, "-> BW PS",	NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  send_repaint(mplot->wij, 0, 0, width, height);
  }

void Dump_Colors(Widget wij, mpic *mplot, char *call_data)
  {

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  dump_color_scheme(mplot);
  }

void select_xsec_plot(Widget wij, mpic *mplot, char *call_data)
  {
  Position x, y;
  Dimension width, height;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XtVaGetValues(mplot->shell, XtNx, &x, XtNy, &y, XtNwidth, &width,
		XtNheight, &height, NULL);
  mplot->xsec_flag = !mplot->xsec_flag;
  if(mplot->xsec_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Plot X-Secs", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot X-Secs", NULL);

  send_repaint(mplot->wij, 0, 0, width, height);
  }

/* --------------------------------------------------------- */

mpic *DialogDone_mplot;
Widget dialogDone;

void DialogDoneAction(Widget wij, XButtonEvent *event, String *params,
		      Cardinal *num_params)
  {

  XtCallCallbacks(dialogDone, XtNcallback, DialogDone_mplot);
  }

/* --------------------------------------------------------- */

/* dialog done button */

void DialogDone_More_Sources(Widget wij, mpic *mplot, char *call_data)
  {
  String sfile;
  int x, y, w, h, i;

  XtPopdown(mplot->pshell);

  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);

  mplot->more_src_flag = 1;
  /* fprintf(stderr,"Sources = %d \n", mplot->more_src_flag); */
  mplot->current_src = mplot->max_more_src;
  /*  fprintf(stderr," New Sources number: %d\n",  mplot->current_src); */
  i =  Get_Sources(sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  /* fprintf(stderr,"User typed: %s\n", sfile); */
  }

void DialogDone_change_save_file(Widget wij, mpic *mplot, char *call_data)
  {
  String sfile;

  XtPopdown(mplot->pshell);

  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  strcpy(mplot->src_dump_file, sfile);
  Hypos_2_File(mplot, sfile, 0);
  }
/* --------------------------------------------------------- */
void DialogDone_wells_leg(Widget wij, mpic *mplot, char *call_data)
  {
  String sfile;
  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  Get_legend(mplot, sfile);
  }



/* Keys keys Buttons mouse Left left Right right middle Middle  */
/* --------------------------------------------------------- */
static char defaultTranslations[] =
  "#augment\n"
   "None<Btn1Down>: start_picsource()\n"
   "None<Btn1Motion>: resize_picsource()\n"
   "None<Btn1Up>: do_picsource()\n"
   "s<Btn1Down>: start_selfoc()\n"
   "s<Btn1Motion>: resize_selfoc()\n"
   "s<Btn1Up>: do_selfoc()\n"
   "Ctrl<Btn1Down>: poly_points()\n"
   "Meta<Btn1Down>: start_great()\n"
   "Meta<Btn1Motion>: resize_great()\n"
   "Meta<Btn1Up>: end_great()\n"

   "None<Btn2Down>: start_zoom()\n"
   "None<Btn2Motion>: resize_zoom()\n"
   "None<Btn2Up>: do_zoom()\n"
   "s<Btn2Down>: start_middle()\n"
   "s<Btn2Motion>: resize_middle()\n"
   "s<Btn2Up>: do_middle()\n"
   "Meta<Btn2Down>: start_selfoc()\n"
   "Meta<Btn2Motion>: resize_selfoc()\n"
   "Meta<Btn2Up>: Switch_selfoc()\n"
   "Ctrl<Btn2Down>: start_selfoc()\n"
   "Ctrl<Btn2Motion>: resize_selfoc()\n"
   "Ctrl<Btn2Up>: do_exp_selfoc()\n"

   "None<Btn3Down>: start_xsect()\n"
   "None<Btn3Motion>: resize_xsect()\n"
   "None<Btn3Up>: do_xsect()\n"
   "s<Btn3Down>: start_xsect()\n"
   "s<Btn3Motion>: resize_xsect()\n"
   "s<Btn3Up>: do_dip_xsect()\n"

   "Meta<Btn3Down>: start_great()\n"
   "Meta<Btn3Motion>: resize_great()\n"
   "Meta<Btn3Up>: do_great_xsec()\n"

   "Ctrl<Btn3Down>: start_zoom()\n"
   "Ctrl<Btn3Motion>: resize_zoom()\n"
   "Ctrl<Btn3Up>: do_zoom()\n"

  "<Key>Return: key_ok()\n"
  "<Key>w: key_w_lees()\n"
  "<Key>u: key_u_lees()\n"
  "<Key>l: key_l_lees()\n"
  "<Key>q: key_q_lees()\n"
  "<Key>c: key_c_lees()\n"
  "<Key>v: key_v_lees()\n"
  "<Key>f: key_f_lees()\n"
  "<Key>g: key_g_lees()\n"
  "<Key>m: key_m_lees()\n"
  "<Key>n: key_n_lees()\n"
  "<Key>p: key_p_lees()\n"
  "<Key>space: key_p_lees()\n"
  "<Key>e: key_e_lees()\n"
  "<Key>t: key_t_lees()\n"
  "<Key>r: key_r_lees()\n"
  "<Key>s: key_s_lees()\n"
  "<Key>0: key_0_lees()\n"
  "None<Key>a: key_A_lees()\n"
  "<Key>a: key_A_lees()\n"
  "<Key>F1: key_F1_map()\n"
  "<Key>F2: key_F2_map()\n"
  "<Key>F3: key_F3_map()\n"
  "<Key>F4: key_F4_map()\n"
  "<Key>F12: key_F12_map()\n"
  "<Key>z: key_A_lees1()\n"

   "<Key>Right: key_right_lees()\n"
   "<Key>Left: key_left_lees()\n"
   "<Key>Up: key_up_lees()\n"
   "<Key>Down: key_down_lees()\n"


;

static XtActionsRec actions[] =
  {
    { "start_zoom", (XtActionProc)Start_zoom },
    { "resize_zoom", (XtActionProc)Resize_zoom },
    { "do_zoom", (XtActionProc)Do_zoom },
    { "start_middle", (XtActionProc)Start_middle },
    { "resize_middle", (XtActionProc)Resize_middle },
    { "do_middle", (XtActionProc)Do_middle },
  /* { "destroy", (XtActionProc)Destroy }, */
    { "start_xsect", (XtActionProc)Start_xsect },
    { "resize_xsect", (XtActionProc)Resize_xsect },
    { "do_xsect", (XtActionProc)Do_xsect },
    { "do_dip_xsect", (XtActionProc)Do_dip_xsect },
    { "key_ok",(XtActionProc)DialogDoneAction },
    { "key_w_lees", (XtActionProc)Key_w_lees },
    { "key_u_lees", (XtActionProc)Key_u_lees },
    { "key_l_lees", (XtActionProc)Key_l_lees },
    { "key_q_lees", (XtActionProc)Key_q_lees },
    { "key_c_lees", (XtActionProc)Key_c_lees },
    { "key_v_lees", (XtActionProc)Key_v_lees },
    { "key_f_lees", (XtActionProc)Key_f_lees },
    { "key_g_lees", (XtActionProc)Key_g_lees },
    { "key_m_lees", (XtActionProc)Key_m_lees },
    { "key_n_lees", (XtActionProc)Key_n_lees },
    { "key_p_lees", (XtActionProc)Key_p_lees },
    { "key_e_lees", (XtActionProc)Key_e_lees },
    { "key_t_lees", (XtActionProc)Key_t_lees },
    { "key_r_lees", (XtActionProc)Key_r_lees },
    { "key_s_lees", (XtActionProc)Key_s_lees },
    { "key_0_lees", (XtActionProc)Key_0_lees },
    { "key_A_lees", (XtActionProc)Key_A_lees },
    { "key_A_lees1", (XtActionProc)Key_A_lees1 },
    { "key_F1_map", (XtActionProc)Key_F1_map },
    { "key_F2_map", (XtActionProc)Key_F2_map },
    { "key_F3_map", (XtActionProc)Key_F3_map },
    { "key_F4_map", (XtActionProc)Key_F4_map },
    { "key_F12_map", (XtActionProc)Key_F12_map },
	{"key_right_lees", (XtActionProc)Do_right_key},
	{"key_left_lees", (XtActionProc)Do_left_key},
	{"key_up_lees", (XtActionProc)Do_up_key},
	{"key_down_lees", (XtActionProc)Do_down_key},
    { "start_picsource", (XtActionProc)Start_picsource },
    { "resize_picsource", (XtActionProc)Resize_picsource },
    { "do_picsource", (XtActionProc)Do_picsource },
    { "start_selfoc", (XtActionProc)Start_selfoc },
    { "resize_selfoc", (XtActionProc)Resize_selfoc },
    { "do_selfoc", (XtActionProc)Do_selfoc },
    { "do_exp_selfoc", (XtActionProc)explode_selfoc },
    { "Switch_selfoc", (XtActionProc)Switch_selfoc },
    { "poly_points", (XtActionProc)Poly_Points },
        { "start_great", (XtActionProc)start_great },
        { "resize_great", (XtActionProc)resize_great },
        { "end_great", (XtActionProc)end_great },
        { "do_great_xsec", (XtActionProc)Do_great_xsec },
      { "poly_points", (XtActionProc)Poly_Points },  
    { "DialogDone", (XtActionProc)DialogDoneAction }
  };

static char Dialog_Accelerator[] =
  "#augment\n"
  "<Key>Return: notify()\n"
  "<Key>q: key_q_lees()\n"
  "<Key>w: key_w_lees()\n"
  "<Key>u: key_u_lees()\n"
  "<Key>l: key_l_lees()\n"
  "<Key>c: key_c_lees()\n"
  "<Key>v: key_v_lees()\n"
  "<Key>m: key_m_lees()\n"
  "<Key>n: key_n_lees()\n"
  "<Key>p: key_p_lees()\n"
  "<Key>space: key_p_lees()\n"
  "<Key>e: key_e_lees()\n"
  "<Key>t: key_t_lees()\n"
  "<Key>r: key_r_lees()\n"
  "<Key>s: key_s_lees()\n"
  "<Key>0: key_0_lees()\n"
  "None<Key>a: key_A_lees()\n"
  "<Key>a: key_A_lees()\n"
  "<Key>z: key_A_lees1()\n"
  "None<Key>F1: key_F1_map()\n"
  "None<Key>F2: key_F2_map()\n"
  "None<Key>F12: key_F12_map()\n"
   "<Key>Right: key_right_lees()\n"
   "<Key>Left: key_left_lees()\n"
   "<Key>Up: key_up_lees()\n"
   "<Key>Down: key_down_lees()\n"

;


#if 0
static XtActionsRec Dialog_actions[] =
  {
    { "key_ok",(XtActionProc)DialogDoneAction },
    { "key_q_lees", (XtActionProc)Key_q_lees },
    { "key_w_lees", (XtActionProc)Key_w_lees },
    { "key_u_lees", (XtActionProc)Key_u_lees },
    { "key_c_lees", (XtActionProc)Key_c_lees },
    { "key_v_lees", (XtActionProc)Key_v_lees },
    { "key_f_lees", (XtActionProc)Key_f_lees },
    { "key_g_lees", (XtActionProc)Key_g_lees },
    { "key_m_lees", (XtActionProc)Key_m_lees },
    { "key_n_lees", (XtActionProc)Key_n_lees },  
    { "key_p_lees", (XtActionProc)Key_p_lees },
    { "key_e_lees", (XtActionProc)Key_e_lees },
    { "key_t_lees", (XtActionProc)Key_t_lees },
    { "key_r_lees", (XtActionProc)Key_r_lees },
    { "key_s_lees", (XtActionProc)Key_s_lees },
    { "key_0_lees", (XtActionProc)Key_0_lees },
    { "key_A_lees", (XtActionProc)Key_A_lees },
    { "key_A_lees1", (XtActionProc)Key_A_lees1 },
    { "key_F1_map", (XtActionProc)Key_F1_map },
    { "key_F2_map", (XtActionProc)Key_F2_map },
    { "key_F3_map", (XtActionProc)Key_F3_map },
    { "key_F4_map", (XtActionProc)Key_F4_map },
    { "key_F12_map", (XtActionProc)Key_F12_map },
  };
#endif

/* ------------------------------------------------------------------ */

static void destroy_mpic(Widget wij, void *client_data, void *server_data)
  {
  mpic *mplot;

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  XmapFree(mplot);
  }

/* ------------------------------------------------------------------ */

void init_mpic_class(XtAppContext apcon)
  {

  XtAppAddActions(apcon, actions, XtNumber(actions));
  }

/* ------------------------------------------------------------------ */

/* Given an already-created GenWidget, and an mpic structure with
   data in it, initializes the rest of the stuff in mpic, and attaches it
   and the widget together, also puts translations into the widget. */

void init_mpic_wij(Widget w, mpic *mplot, Font *fonts)
  {
  XGCValues xgc;

  xgc.function = GXnor;
  xgc.foreground = BlackPixelOfScreen(XtScreen(w));
  if(mplot == NULL) return;
  mplot->zoom_gc = XtGetGC(w, GCFunction | GCForeground, &xgc);
  mplot->xsect_gc = XtGetGC(w, GCFunction | GCForeground, &xgc);
  mplot->ggc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
			 GCForeground, &xgc);
  /* mplot->colors = colors; */
  mplot->fonts = fonts;
  mplot->wij = w;
  init_contParms(mplot);

  XtVaSetValues(w, XtNdata, mplot, NULL);
  XtAddCallback(w, XtNredraw, (XtCallbackProc)redraw_mpic, NULL);
  XtAddCallback(w, XtNdestroy, (XtCallbackProc)destroy_mpic, NULL);
  /* fprintf(stderr,"Done-init\n"); */
  }

/* ------------------------------------------------------------------ */

static void PopupDialog(Widget w, mpic *mplot, XtCallbackProc ddone)
  {
  Position x, y;
  Dimension width, height;
  Arg arg[5];
  int i;
  /* char lab[200]; */
  
  /* HERE is the NEW LINE to remove the input LINE! */

  XtVaSetValues(mplot->dialog, XtNvalue, "", NULL);
/*
  XtVaGetValues(mplot->dialog, XtNlabel, &lab, NULL);
  fprintf(stderr,"%s\n", lab);
 */
  /* get the coordinates of the middle of topLevel widget. */

  XtVaGetValues(mplot->shell, XtNwidth, &width, XtNheight, &height, NULL);
  XtRemoveAllCallbacks(dialogDone, XtNcallback);
  XtAddCallback(dialogDone, XtNcallback, (XtCallbackProc)ddone, mplot);

  /* translate coordinates in application top-level window into coordinates
     from root window origin. */

  XtTranslateCoords(mplot->shell, (Position)width / 2,
		    (Position)height / 2, &x, &y);

  /* move popup shell to this position (it's not visible yet) */

  i = 0;
  XtSetArg(arg[i], XtNx, x); i++;
  XtSetArg(arg[i], XtNy, y); i++;
  XtSetArg(arg[i], XtNwidth, 600); i++;
  XtSetArg(arg[i], XtNheight, 200); i++;
  XtSetValues(mplot->pshell, arg, i);
  XtPopup(mplot->pshell, XtGrabNonexclusive);

  /* Move the mouse here, too */

  XWarpPointer(XtDisplay(mplot->pshell), None, XtWindow(mplot->pshell),
	       0, 0, 0, 0, x - 100, y + 100); 
  }
/* --------------------------------------------------------- */

static void DialogQuit(Widget wij, XButtonEvent *event, String *params,
		       Cardinal *num_params)
  {

  XtPopdown(DialogDone_mplot->pshell);
  }

/* --------------------------------------------------------- */

/* dialog done button */

static void DialogDone_MoreMap(Widget wij, mpic *mplot, char *call_data)
  {
  String sfile;
  int x, y, w, h, i;

  XtPopdown(mplot->pshell);

  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  i =  Get_Map2(sfile, mplot);
  strcpy(mplot->map[mplot->num_map_files-1].map_code,
	 "0abcdefghijklmnopqrstuvwxyz");

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  /*  fprintf(stderr,"User typed: %s\n", sfile); */
  }

/* --------------------------------------------------------- */

static void DialogDone_MapCode(Widget wij, mpic *mplot, char *call_data)
  {
  String sfile;
  int x, y, w, h, kmap;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);

  for(kmap = 0; kmap < mplot->num_map_files; kmap++)
    strcpy(mplot->map[kmap].map_code, sfile);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  /* fprintf(stderr,"User typed: %s\n", sfile); */
  }

/* --------------------------------------------------------- */

/* dialog box to change max depth of color earthquake plotting   */

static void DialogDone_ChangeDepth(Widget wij, mpic *mplot, char *call_data) 
  {
  int x, y, w, h;
  String sfile;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  sscanf(sfile, "%f %f",&mplot->MinDepth, &mplot->MaxDepth);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

static void DialogDone_MoreWire(Widget wij, mpic *mplot, char *call_data)
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(mplot->pshell);

  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  Get_ThreeD(sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  /* fprintf(stderr,"User typed: %s\n", sfile); */
  }

/* --------------------------------------------------------- */

static void DialogDone_HozDef(Widget wij, mpic *mplot, char *call_data)
  {
  String sfile;
  int x, y, w, h;
  float top, bot;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  sscanf(sfile, "%f %f", &top, &bot);
  mplot->hoz_slab_flag =1;
  mplot->hoz_slab_top =top;
  mplot->hoz_slab_bot =bot;

  fprintf(stderr, " TOP SLAB=%f  BOT SLAB=%f  Flag=%d\n", mplot->hoz_slab_top,
	  mplot->hoz_slab_bot, mplot->hoz_slab_flag);
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

  /* fprintf(stderr,"User typed: %s\n", sfile); */
  }

/* --------------------------------------------------------- */

/* dialog box to change max depth of color earthquake plotting   */

static void DialogDone_Time_Plot(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  sscanf(sfile, "%f", &mplot->time_plot_wait);
  }

/* --------------------------------------------------------- */

/* dialog box to swath width for xsections   */

static void DialogDone_HalfWidth(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  sscanf(sfile, "%f", &mplot->halfwidth);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* dialog box to GetField   */

static void DialogDone_GetField(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  mplot->field_name = sfile;
  Do_Contour_Field(XtDisplay(wij), sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  /* send_repaint(mplot->wij, 0, 0, w, h); */
  }

#if 1
/* dialog box to Postscript   */
void Postscript_all_lay(Widget wij, mpic *mplot, char *call_data)
   {
   int i;
   char ident[11];
   char sfile[50];

   for (i=0; i<mplot->image.nz; i++)
      {
     
      mplot->image_layer = i;
   
      strcpy(sfile, "PS.Lay.");
      sprintf(ident,"%03d", i);
    
      strcat(sfile, ident);
     
      fprintf(stderr, "postscripting layer: %d <%s>\n", i, sfile);
      
      /* clean_file_name(sfile); */

      Do_Postscript(XtDisplay(mplot->wij), sfile, mplot);

      }
  

   }
#endif


static void DialogDone_Postscript(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  Do_Postscript(XtDisplay(wij), sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/* -------------------------------------------------------- */

/* dialog box to Wells   */

static void DialogDone_Wells(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h, i;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  i = Get_Wells(sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* -------------------------------------------------------- */


static void DialogDone_Lips(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h, i;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  i = Get_Lips(sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* -------------------------------------------------------- */
static void DialogDone_Scale_Lips(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h;
  float scal;
  int klip, k;
  
  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
   sscanf(sfile, "%f", &scal);
  for(klip = 0; klip < mplot->lip_num; klip++)
    {
    for(k = 0; k < mplot->lip[klip].n; k++)
      {
	mplot->lip[klip].lips[k].lambda[0] = scal*mplot->lip[klip].lips[k].lambda[0] ;
	mplot->lip[klip].lips[k].lambda[1] = scal*mplot->lip[klip].lips[k].lambda[1];
	mplot->lip[klip].lips[k].lambda[2] = scal*mplot->lip[klip].lips[k].lambda[2];
	}
    }
  
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* -------------------------------------------------------- */
/* dialog box to Wells   */


static void Set_1_Xsec(Widget wij, mpic *mplot, char *call_data) 
{

  Set_an_xsec(mplot);
 
}


static void DialogDone_Load_Xsec(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h, i;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  i = Load_Xsec(sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* -------------------------------------------------------- */

/* dialog box to Wells   */

static void DialogDone_Labels(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  strcpy(mplot->labels[++mplot->num_labels].label, sfile);
  mplot->current_label = mplot->num_labels;
  fprintf(stderr,"Number of labels: %d  current=%d\n", mplot->num_labels, mplot->current_label);
  fprintf(stderr,"  YOU MUST NEXT POST THE LABEL WITH THE m (tail) AND"
	  " n (head) KEYS!\n");

  /* XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
     NULL);
     send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY); */
  }

/* -------------------------------------------------------- */

/* dialog box to Wells   */

static void DialogDone_Image(Widget wij, mpic *mplot, char *call_data) 
  {
  String sfile;
  int x, y, w, h, i;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  clean_file_name(&sfile);
  i = Get_Image(sfile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }
/* --------------------------------------------------------- */
/* --------------------------------------------------------- */
static void DialogDone_Image_MINMAX(Widget wij, mpic *mplot, char
*call_data){
  int x, y, w, h;
  String sfile;
  float newMin, newMax;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  sscanf(sfile, "%f %f",&newMin, &newMax);
  
  if(mplot->image_scale_flag ==0){
    Scale_Image_Global(mplot,newMax, newMin);
  }else{
    int k;
    k = mplot->image_layer - 1;
    mplot->image.Layer_min[k] = newMin;
   mplot->image.Layer_max[k] = newMax;
    Scale_Image_Layer(mplot);
  }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight,
&h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

}
/* --------------------------------------------------------- */

static void Popup_Image_MINMAX(Widget w,mpic* mplot, char *call_data){
  char lab[100];

  if(mplot->image_scale_flag ==0){
    sprintf(lab,"Curr Min %.2f; Curr Max %.2f Global Min %.2f Global Max %.2f ",
	    mplot->image.Temp_image_min,     mplot->image.Temp_image_max,
	    mplot->image.Global_image_min, mplot->image.Global_image_max );
  }else{
    sprintf(lab,"Layer %i; Curr Min %.2f Curr Max %.2f ",
	    mplot->image_layer,
	    mplot->image.Layer_min[mplot->image_layer-1], mplot->image.Layer_max[mplot->image_layer-1] );
  }
  XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Image_MINMAX);
}
/* --------------------------------------------------------- */

void Popup_Get_wells_leg(Widget wij, mpic *mplot, char *call_data)
  {

    XtVaSetValues(mplot->dialog, XtNlabel, "Type in the file name for Legend:", NULL);
    PopupDialog(wij, mplot, (XtCallbackProc)DialogDone_wells_leg);
    
  }

/* --------------------------------------------------------- */
static void DialogDone_Image_Min(Widget wij, mpic *mplot, char
*call_data){
  int x, y, w, h;
  String sfile;
  float newMin;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  newMin=atof(sfile);

  if(mplot->image_scale_flag ==0){
    Scale_Image_Global(mplot,mplot->image.Temp_image_max, newMin);
  }else{
    int k;
    k = mplot->image_layer - 1;
    mplot->image.Layer_min[k] = newMin;
    Scale_Image_Layer(mplot);
  }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight,
&h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

}
/* --------------------------------------------------------- */

static void Popup_Image_Min(Widget w,mpic* mplot, char *call_data){
  char lab[100];

  if(mplot->image_scale_flag ==0){
    sprintf(lab,"Curr Min %.2f; Global Min %.2f",
	    mplot->image.Temp_image_min,
	    mplot->image.Global_image_min);
  }else{
    sprintf(lab,"Layer %i; Curr Min %.2f",
	    mplot->image_layer,
	    mplot->image.Layer_min[mplot->image_layer-1]);
  }
  XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Image_Min);
}
/* --------------------------------------------------------- */

static void DialogDone_Image_Max(Widget wij, mpic *mplot, char
*call_data){
  int x, y, w, h;
  String sfile;
  float newMax;

  XtPopdown(mplot->pshell);
  sfile = XawDialogGetValueString(mplot->dialog);
  newMax=atof(sfile);

  if(mplot->image_scale_flag ==0){
    Scale_Image_Global(mplot,newMax,mplot->image.Temp_image_min);
  }else{
    int k;
    k = mplot->image_layer - 1;
    mplot->image.Layer_max[k] = newMax;
    Scale_Image_Layer(mplot);
  }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight,
&h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

}

/* --------------------------------------------------------- */
void Dump_Image_Layer_Values(mpic *m, char *sfile)
   {
   /*   subroutine to dump out the values of an image to
	be contoured by the contouring routines later */
   FILE *inf;

 
   int j, i,   npoints, ix, iy, iz, iway = 1, start;
   float xorg, yorg, x, y;
 
   float phio, lamo;


   if((inf = fopen(sfile, "w")) == NULL)
      {
      printf("Can't open %s ....try again\n", sfile);
      return;
      }

   
   if(m->image_layer > m->image.nz) m->image_layer = m->image.nz;
   if(m->image_layer < 1) m->image_layer = 1;

   npoints = m->image.nx * m->image.ny;
   xorg = m->image.org_minx;
   yorg = m->image.org_miny;

   start = (m->image_layer - 1) * npoints;
   for(i = start; i < start + npoints; i++)
      {
      j = i;

      if(m->image.col[i] != 0)
	 {
	 citoxyz(m->image.nx, m->image.ny, m->image.nz, iway, &j, &ix, &iy, &iz);
	 x = xorg + (ix - 1) * m->image.dx+0.5*m->image.dx;
	 y = yorg + (iy) * m->image.dy- 0.5*m->image.dy;

       
	 xy2geo(m,  &phio, &lamo, x, y);
         fprintf(inf, "%f %f %f\n", phio, lamo, m->image.val[i]);
	 

	 }
      }
   fclose(inf);


   }/* --------------------------------------------------------- */
void Dump_Image_Layer_Raw(mpic *m, char *sfile)
   {
   /*   subroutine to dump out the values of an image to
	be contoured by the contouring routines later */

   FILE *inf;
  int  i,   npoints, start;
   float xorg, yorg, x, y;

   if((inf = fopen(sfile, "w")) == NULL)
      {
      printf("Can't open %s ....try again\n", sfile);
      return;
      }

   
   if(m->image_layer > m->image.nz) m->image_layer = m->image.nz;
   if(m->image_layer < 1) m->image_layer = 1;

   npoints = m->image.nx * m->image.ny;
   xorg = m->image.org_minx;
   yorg = m->image.org_miny;
   
   fprintf(inf, "%f %f %d %d %f %f %f %f %f\n" , xorg, yorg,  m->image.nx,  m->image.ny, 
	   m->image.image_skip ,  m->image.phi,  m->image.lam , m->image.dx,  m->image.dy);

 
   start = (m->image_layer - 1) * npoints;
   for(i = start; i < start + npoints; i++)
      {
         fprintf(inf, "%f\n",  m->image.val[i]);
      }
   fclose(inf);

   }

/* --------------------------------------------------------- */
static void DialogDone_Image_Export(Widget wij, mpic *mplot, char  *call_data)
   {
   int x, y, w, h;
   char *sfile, *dfile;
   char     f1[100], f2[100];

   
   XtPopdown(mplot->pshell);
   sfile = XawDialogGetValueString(mplot->dialog);
fprintf(stderr, "sfile is in %s\n",sfile );


   strcpy(f1, sfile);


   strcpy(f2, f1);
   
   strcat(f2, ".RIMAGE");

   fprintf(stderr, "outputfile is in %s\n", f1);
      fprintf(stderr, "outputfile is in %s\n", f2);
   
    Dump_Image_Layer_Values(mplot, f1); 

    Dump_Image_Layer_Raw(mplot, f2); 

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight,
		 &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   
   }

/* --------------------------------------------------------- */

static void Popup_Image_Max(Widget w,mpic* mplot, char *call_data){
  char lab[100];

  if(mplot->image_scale_flag ==0){
    sprintf(lab,"Curr Max %.2f; Global Max %.2f",
	    mplot->image.Temp_image_max,
	    mplot->image.Global_image_max);
  }else{
    sprintf(lab,"Layer %i; Curr Max %.2f",
	    mplot->image_layer,
	    mplot->image.Layer_max[mplot->image_layer-1]);
  }
  XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Image_Max);
}
/* --------------------------------------------------------- */

static void Popup_Image_Export(Widget w,mpic* mplot, char *call_data){
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Image_Export);
}

/* --------------------------------------------------------- */

void Plot_Image(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  if(mplot->image.nx > 0)
    {
    mplot->image_flag = !mplot->image_flag;
    if(mplot->image_flag == 0)
      XtVaSetValues(wij, XtNlabel, "- Image", NULL);
    else XtVaSetValues(wij, XtNlabel, "+ Image", NULL);

    XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		  NULL);
    send_repaint(mplot->wij, 0, 0, w, h);
    }
  }

/* --------------------------------------------------------- */

void Change_Skip(Widget wij, mpic *mplot, char *call_data)
  {

  /* fprintf(stderr, "this function is not available at this time\n"); */


  short x, y, w, h;
  float skip;
  
 

  fprintf(stderr, "type in the skip value:\n");
  fscanf(stdin, "%f", &skip);
  
   mplot->image.image_skip=skip;

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight,
&h,
		NULL);
  send_repaint(mplot->wij, 0, 0, w, h);

  }

/* --------------------------------------------------------- */
void Switch_Log_Linear_Image_Scale(Widget wij, mpic *mplot, char
*call_data){
  short x, y, w, h;

  if(mplot->image_flag){
    mplot->image_scale_log_flag=!mplot->image_scale_log_flag;
    if(mplot->image_scale_flag == 0)
      Scale_Image_Global(mplot, mplot->image.Global_image_max,
			 mplot->image.Global_image_min);
    else 
      Scale_Image_Layer(mplot);
  }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight,
&h,
		NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
}
/* --------------------------------------------------------- */
void User_Image_Scale(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;
  float vmin, vmax;
  int k;

  if(mplot->image_scale_flag == 0)
    {
    fprintf(stderr, "Currently Min=%f Max=%f\n", mplot->image.Temp_image_min,
	    mplot->image.Temp_image_max);
    fprintf(stderr, "Global Min=%f Max=%f\n", mplot->image.Global_image_min,
	    mplot->image.Global_image_max );
    fprintf(stderr,
	    "\nType in the minimum and Maximum values used for scaling:\n");
    fscanf(stdin, "%f %f", &vmin, &vmax);
    Scale_Image_Global(mplot,vmax, vmin);
    }
  else
    {
    k = mplot->image_layer - 1;
    fprintf(stderr, " Working on Layer: %d\n", k + 1);
    fprintf(stderr, "Currently Min=%f Max=%f\n", mplot->image.Layer_min[k],
	    mplot->image.Layer_max[k]);
    fprintf(stderr, 
	    "Type in the minimum and Maximum values used for scaling:\n");
    fscanf(stdin, "%f %f", &vmin, &vmax);
    mplot->image.Layer_min[k] = vmin;
    mplot->image.Layer_max[k] = vmax;
    Scale_Image_Layer(mplot);
    }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/* --------------------------------------------------------- */

void Change_Layer(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;
  int num;

  fprintf(stderr, "current layer=%d \n number of layers=%d\ntype in the"
	  " Layer number:\n", mplot->image_layer, mplot->image.nz);
  fscanf(stdin, "%d", &num);
  mplot->image_layer = num;

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/* --------------------------------------------------------- */

void Top_Layer(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->image_layer = 1;
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/* --------------------------------------------------------- */
/***************/
static void Get_Image_GLOBE2(Widget win, mpic *mplot, char *call_data)
{

   char  infile[100];
 
 
  int x, y, w, h, i;


  fprintf(stderr, "type in the file name of the image file:\n");
  fscanf(stdin, "%s", infile);

 /*  clean_file_name(&infile); */
  i = Get_Image_glob(infile, mplot);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
}



void Image_Info(Widget wij, mpic *mplot, char *call_data)
  {
     Print_Image_Info(mplot);

  }

/* --------------------------------------------------------- */


void Image_Render(Widget wij, mpic *mplot, char *call_data)
  {
  
  float  urx, ury, blx, bly;

  blx = SELXMIN;
  bly = SELYMIN;
  urx = SELXMAX;
  ury = SELYMAX;

  Simple_Render(mplot, blx, bly, urx, ury);
  


  }




void RGB_Info(Widget wij, mpic *mplot, char *call_data)
   {
   int i, hsizex, hsizey, npoints, nblocks,
   start, i1;
   float xorg, yorg;
   double sum, area;
   FILE *inf;

   fprintf(stderr,
	   "\n ---------------  Image Information  -----------------\n");
   fprintf(stderr, "file name: %s\n", mplot->image.file_name);
   fprintf(stderr, "Lower Left Corner: %f %f\n", mplot->image.phi,
	   mplot->image.lam);
   fprintf(stderr, " maxx=%f minx=%f maxy=%f miny=%f\n", mplot->image.org_maxx,
	   mplot->image.org_minx, mplot->image.org_maxy, mplot->image.org_miny);
   fprintf(stderr, " nx=%d  ny=%d  nz=%d  \n", mplot->image.nx, mplot->image.ny,
	   mplot->image.nz);
   fprintf(stderr, "dx=%f  dy=%f  dz=%f  \n", mplot->image.dx, mplot->image.dy,
	   mplot->image.dz);
   fprintf(stderr, "skip=%f  \n", mplot->image.image_skip);
   fprintf(stderr," Gmax=%f  Gmin=%f\n", mplot->image.Global_image_max,
	   mplot->image.Global_image_min);
   fprintf(stderr, "Tmax=%f  Tmin=%f\n", mplot->image.Temp_image_max,
	   mplot->image.Temp_image_min);
   fprintf(stderr, "---------------  End  -----------------\n\n");
   /* fprintf(stderr, "Type in the file name:\n"); */

   if((inf = fopen("RGB_geotouch_out", "w")) == NULL)
      {
      printf("Can't open RGB_geotouch_out ....try again\n");
      return;
      }

   npoints = mplot->image.nx * mplot->image.ny;

   xorg = mplot->image.org_minx;
   yorg = mplot->image.org_miny;

   start = (mplot->image_layer - 1) * npoints;
   sum = area = nblocks = 0;

   /* the next two lines are inefficient because abs() evaluates args more
      than once */

   hsizex = abs((user_to_pix_x(&mplot->gr, (double)mplot->image.dx)
		 - user_to_pix_x(&mplot->gr, (double)0)));
   hsizey = abs((user_to_pix_y(&mplot->gr, (double)0)
		 - user_to_pix_y(&mplot->gr, (double)mplot->image.dy)));

   fprintf(inf, "# %d %d %f %f %f %f %f %f\n", mplot->image.nx,
	   mplot->image.ny, mplot->image.phi, mplot->image.lam,
	   mplot->image.org_minx, mplot->image.org_miny, mplot->image.dx,
	   mplot->image.dy);

   for(i = start; i < start + npoints; i++)
      {
      i1 = mplot->image.col[i] - mplot->MinColor;
      fprintf(inf, "%d\n", i1);
      }
   fclose(inf);
   }

void Plot_Sat(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;

   mplot->satimage_flag = !mplot->satimage_flag;
   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

void Shift_Sat(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;
   float phi, lam;

   fprintf(stderr, "Current Coordinates: \n");
   fprintf(stderr, "%f %f\n", mplot->satimage.lat, mplot->satimage.lon);
   fprintf(stderr, "Type in the new Coordinates: LAT LON:\n");
   fscanf(stdin, "%f %f", &phi, &lam);

   mplot->satimage.lat = phi;
   mplot->satimage.lon = lam;
   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

void Get_Sat(Widget wij, mpic *mplot, char *call_data)
   {

   sat_image(mplot);
   }

/* --------------------------------------------------------- */

void Change_Palette(Widget wij, mpic * mplot, char *call_data)
   {
   short x, y, w, h;
   char cpal[12];

   mplot->Which_Pal = !mplot->Which_Pal;

   sprintf(cpal, "Palette %d", mplot->Which_Pal);
   XtVaSetValues(wij, XtNlabel, cpal, NULL);

   /* change the palette location in the color map  */

   mplot->MinColor = mplot->Pal_index[mplot->Which_Pal];
   mplot->MaxColor
   = mplot->MinColor + mplot->Pal_num[mplot->Which_Pal]-1;
   if(mplot->image_flag)
      {
      if(mplot->image_scale_flag == 0)
      Scale_Image_Global(mplot, mplot->image.Global_image_max,
			 mplot->image.Global_image_min);
      else Scale_Image_Layer(mplot);
      }

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

/* --------------------------------------------------------- */

void Reverse_Palette(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;

   /* change the palette location in the color map  */
   mplot->Reverse_Pal = !mplot->Reverse_Pal;

   flip_color_palette(mplot);
  

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

/* --------------------------------------------------------- */

void Reset_Palette(Widget wij, mpic * mplot, char *call_data)
   {
   short x, y, w, h;
   mplot->Which_Pal = 0;
   mplot->Pal_index[0] = mplot->num_fixed_colors;
   mplot->Pal_num[0] = 90;
/* change the palette location in the color map  */

   mplot->MinColor = mplot->Pal_index[mplot->Which_Pal];
   mplot->MaxColor
     = mplot->MinColor + mplot->Pal_num[mplot->Which_Pal]-1;
   if(mplot->image_flag)
      {
      if(mplot->image_scale_flag == 0)
      Scale_Image_Global(mplot, mplot->image.Global_image_max,
			 mplot->image.Global_image_min);
      else Scale_Image_Layer(mplot);
      }

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

/* --------------------------------------------------------- */

void Bound_Palette(Widget wij, mpic * mplot, char *call_data)
   {
      int i, ind, num;
      short x, y, w, h;

/* change the palette location in the color map  */
      
      fprintf(stderr, "Palette settings: Current Palette=%d\n", mplot->Which_Pal);
      for(i=0; i<mplot->NumPal; i++)
      {
	 fprintf(stderr,"Palette:%d Index=%d Number=%d\n", i, mplot->Pal_index[i], mplot->Pal_num[i]);
      }
      fprintf(stderr, "For each Palette, type in the new numbers\n");
      for(i=0; i<mplot->NumPal; i++)
      {

	 fprintf(stderr, "%d  Index  Number\n", i);
	 fscanf(stdin, "%d %d", &ind, &num);

         if(ind<0)break;

	 mplot->Pal_index[i]=ind;
	 mplot->Pal_num[i]=num;

      }




   mplot->MinColor = mplot->Pal_index[mplot->Which_Pal];
   mplot->MaxColor
     = mplot->MinColor + mplot->Pal_num[mplot->Which_Pal]-1;
   if(mplot->image_flag)
      {
      if(mplot->image_scale_flag == 0)
      Scale_Image_Global(mplot, mplot->image.Global_image_max,
			 mplot->image.Global_image_min);
      else Scale_Image_Layer(mplot);
      }

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }


/* --------------------------------------------------------- */
/* --------------------------------------------------------- */

void New_Palette(Widget wij, mpic * mplot, char *call_data)
   {
   short x, y, w, h;

#if 1
   change_palette_colors(mplot);
#endif 

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }
/* --------------------------------------------------------- */

void Palette_Info(Widget wij, mpic *mplot, char *call_data)
   {
   fprintf(stderr,"-------------------------------\n");
  
   fprintf(stderr,"Palette Info------------------------\n");
  
   fprintf(stderr,"Palette Info: min=%d max=%d which=%d status=%d\n",mplot->MinColor,mplot->MaxColor, mplot->Which_Pal, mplot->Reverse_Pal);
   fprintf(stderr,"-------------------------------\n");

   fprintf(stderr,"-----colors:\n");

   dump_color_palette(mplot);
   fprintf(stderr,"-------------------------------\n");

   }

/*****************************************/

void Integrate_Target(mpic *mplot)
   {  
   float mult, base, top, xorg, yorg,  xkm, ykm, lat, lon, ave;
   int j, i,  px, py,  num, hsizex, hsizey, npoints, nblocks,
   ix, iy, iz, iway = 1, start;
   fpoint *plotkin, po;
   double sum, psum, Dxy, area;

   if(mplot->image_flag == 0) return;

   num = global_poly;
   if(num == 0)
      {
      fprintf(stderr,
	      "\nFIRST: Please select a polygon using the meta-1 mouse!\n");
      return;
      }

   if(num == 4 && polylat[0] == 0)
      {
      for(i = 0; i < num; i++)
	 {
	 xkm = (float)pix_to_user_x(&mplot->gr, gpolx[i]);
	 ykm = (float)pix_to_user_y(&mplot->gr, gpoly[i]);
	 xy2geo(mplot, &lat, &lon, xkm, ykm);
	 polylat[i] = lat;
	 polylon[i] = lon;
	 fprintf(stderr, "gpx=%d gpy=%d  polyla=%f  polylo=%f\n", gpolx[i],
		 gpoly[i], polylat[i], polylon[i]);
	 }
      }

   /* first set up the polygon  */

   
   plotkin = XmapNewArray(fpoint, num + 1);
    prep_polygon(mplot,  plotkin);

   

   fprintf(stderr, " Type in: baseline topline  mult_factor\n");
   fscanf(stdin, "%f %f %f", &base, &top, &mult);

   if(base == top)
      {
      fprintf(stderr," base=top, returning.... \n");
      return;
      }

   Dxy = mult * mplot->image.dx * mplot->image.dy;
   if(mplot->image_layer > mplot->image.nz)
   mplot->image_layer = mplot->image.nz;
   if(mplot->image_layer < 1) mplot->image_layer = 1;

   npoints = mplot->image.nx * mplot->image.ny;
   xorg = mplot->image.org_minx;
   yorg = mplot->image.org_miny;
   start = (mplot->image_layer - 1) * npoints;
   sum = area = nblocks = 0;

   /* inefficient calls because abs() evaluates args more than once */

   hsizex = abs((user_to_pix_x(&mplot->gr, (double)mplot->image.dx)
		 - user_to_pix_x(&mplot->gr, (double)0)));
   hsizey = abs((user_to_pix_y(&mplot->gr, (double)0)
		 - user_to_pix_y(&mplot->gr, (double) mplot->image.dy)));

   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(0)]);

   for(i = start; i < start + npoints; i++)
      {
      j = i;
      if((mplot->image.col[i] != 0) && (mplot->image.val[i] >= base)
	 && (mplot->image.val[i] <= top))
	 {
	 citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway, &j,
		 &ix, &iy, &iz);
	 po.x = xorg + (ix - 1) * mplot->image.dx;
	 po.y = yorg + (iy) * mplot->image.dy;

	 if(inside(po, plotkin, num) == 1)
	    {
	    px = user_to_pix_x(&mplot->gr, (double)po.x);
	    py = user_to_pix_y(&mplot->gr, (double)po.y);
	    XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij),
			   mplot->ggc, px, py, hsizex + 1, hsizey + 1);
	    XFlush(XtDisplay(mplot->wij));
	    nblocks++;
	    sum += (mplot->image.val[i]-base) * Dxy;
	    }
	 }
      }

   psum = 0;
   fprintf(stdout, "Perimeter Nodes(km):\n");
   for(i = 0; i < (num - 1); i++)
      {
      psum += sqrt(sqr(plotkin[i].x - plotkin[i + 1].x)
		   +  sqr(plotkin[i].y - plotkin[i + 1].y));
      fprintf(stdout, "%f %f\n", plotkin[i].x, plotkin[i].y); 
      }

   fprintf(stdout, "dx=%f dy=%f (km)\n", mplot->image.dx, mplot->image.dy);
   fprintf(stdout, "Blocks=%d Perimeter(km)=%f   Area=%f (km2)\n", nblocks,
	   psum, nblocks * (mplot->image.dx * mplot->image.dy));
   fprintf(stdout, "Integration = %f\n", sum);
   if(nblocks>0) 
      {
     
      ave = sum/nblocks;
     
      fprintf(stdout, "Average for layer %d = %f\n",iz, ave);
      }
  
   
   XmapFree(plotkin);
   }

/*****************************************/

void Isolate_Image(mpic *mplot)
   {  
   double sum, psum, Dxy;
   float base, min, max, xorg, yorg;
   short x, y, w, h;
   int j, i,  px, py, num, hsizex, hsizey, npoints, ix, iy, iz, iway = 1,
   start;
   fpoint po;

   if(mplot->image_flag == 0) return;

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   fprintf(stderr, " Type in: min max (min=max => forget it)\n");
   fscanf(stdin, "%f %f", &min, &max);
   if(min == max)
      {
      fprintf(stderr, " min=max, returning.... \n");
      return;
      }

   base = min;
   Dxy = mplot->image.dx * mplot->image.dy;
   if(mplot->image_layer > mplot->image.nz)
   mplot->image_layer = mplot->image.nz;
   if(mplot->image_layer < 1) mplot->image_layer = 1;
   npoints = mplot->image.nx * mplot->image.ny;
   xorg = mplot->image.org_minx;
   yorg = mplot->image.org_miny;
   start = (mplot->image_layer - 1) * npoints;
   sum = psum = num = 0;

   /* inefficient because abs() evaluates args more than once */

   hsizex = abs((user_to_pix_x(&mplot->gr, (double)mplot->image.dx)
		 - user_to_pix_x(&mplot->gr, (double)0)));
   hsizey = abs((user_to_pix_y(&mplot->gr, (double)0)
		 - user_to_pix_y(&mplot->gr, (double)mplot->image.dy)));
   send_repaint(mplot->wij, 0, 0, w, h);
   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(1)]);

   for(i = start; i < start + npoints; i++)
      {
      j = i;
      if(mplot->image.col[i] != 0)
	 {
	 citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway, &j,
		 &ix, &iy, &iz);
	 po.x = xorg + (ix - 1) * mplot->image.dx;
	 po.y = yorg + (iy) * mplot->image.dy;
	 if((mplot->image.val[i] >= min) && (mplot->image.val[i] <= max))
	    {
	    px = user_to_pix_x(&mplot->gr, (double)po.x);
	    py = user_to_pix_y(&mplot->gr, (double)po.y);
	    XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
			   px, py, hsizex + 1, hsizey + 1);
	    XFlush(XtDisplay(mplot->wij));

	    sum += (mplot->image.val[i] - base) * Dxy;
	    psum +=  Dxy;
	    num++;
	    }
	 }
      }

   base = 100 * (float)num / (float)npoints;
   fprintf(stdout, "Blocks=%d Integration = %f Area = %f Percent=%f%%\n", num,
	   sum, psum, base);
   }
/*****************************************/
/*****************************************/

void Save_Target_Image(Widget wij, mpic *mplot, char *call_data)
   {  
   float  base,  xorg, yorg,  xkm, ykm, lat, lon;
   int j, i,  px, py,  num, hsizex, hsizey, npoints, nblocks,
   ix, iy, iz, iway = 1, start;
   fpoint *plotkin, po;
   double sum, psum, Dxy, area;

   FILE *fout;
  
   if((fout = fopen("Dump_Image_Values", "w")) == NULL)
      {
      printf("Can't open  Dump_Image_Values....try again\n");
      return;
      }

   if(mplot->image_flag == 0) return;

   num = global_poly;
   if(num == 0)
      {
      fprintf(stderr,
	      "\nFIRST: Please select a poly gon using the meta-1 mouse!\n");
      return;
      }

   if(num == 4 && polylat[0] == 0)
      {
      for(i = 0; i < num; i++)
	 {
	 xkm = (float)pix_to_user_x(&mplot->gr, gpolx[i]);
	 ykm = (float)pix_to_user_y(&mplot->gr, gpoly[i]);
	 xy2geo(mplot, &lat, &lon, xkm, ykm);
	 polylat[i] = lat;
	 polylon[i] = lon;
	 fprintf(stderr, "gpx=%d gpy=%d  polyla=%f  polylo=%f\n", gpolx[i],
		 gpoly[i], polylat[i], polylon[i]);
	 }
      }

   /* first set up the polygon  */

  plotkin = XmapNewArray(fpoint, num + 1);
 
  
  prep_polygon(mplot,  plotkin);

 
   npoints = mplot->image.nx * mplot->image.ny;
   xorg = mplot->image.org_minx;
   yorg = mplot->image.org_miny;
   start = (mplot->image_layer - 1) * npoints;
   sum = area = nblocks = 0;

   /* inefficient calls because abs() evaluates args more than once */

   hsizex = abs((user_to_pix_x(&mplot->gr, (double)mplot->image.dx)
		 - user_to_pix_x(&mplot->gr, (double)0)));
   hsizey = abs((user_to_pix_y(&mplot->gr, (double)0)
		 - user_to_pix_y(&mplot->gr, (double) mplot->image.dy)));

   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(0)]);

   for(i = start; i < start + npoints; i++)
      {
      j = i;
      if((mplot->image.col[i] != 0))
	 {
	 citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway, &j,
		 &ix, &iy, &iz);
	 po.x = xorg + (ix - 1) * mplot->image.dx;
	 po.y = yorg + (iy) * mplot->image.dy;

	 if(inside(po, plotkin, num) == 1)
	    {
	    px = user_to_pix_x(&mplot->gr, (double)po.x);
	    py = user_to_pix_y(&mplot->gr, (double)po.y);
	    XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij),
			   mplot->ggc, px, py, hsizex + 1, hsizey + 1);
	    XFlush(XtDisplay(mplot->wij));
	    nblocks++;
	    sum += (mplot->image.val[i]-base) * Dxy;
	    xy2geo(mplot, &lat, &lon, po.x, po.y);
	    fprintf(fout, "%f %f %f\n", lat, lon, mplot->image.val[i]);
	


	    }
	 }
      }

   psum = 0;
   fprintf(stdout, "Perimeter Nodes(km):\n");
   for(i = 0; i < (num - 1); i++)
      {
      psum += sqrt(sqr(plotkin[i].x - plotkin[i + 1].x)
		   +  sqr(plotkin[i].y - plotkin[i + 1].y));
      fprintf(stdout, "%f %f\n", plotkin[i].x, plotkin[i].y); 
      }

   printf("Image Values can be found in file: Dump_Image_Values\n");

   fclose(fout);
  
   
   XmapFree(plotkin);
   }

/*****************************************/

/* --------------------------------------------------------- */
void Mask_Image(Widget wij, mpic *m, char *call_data)
{
  short x, y, w, h;


  
  int i, nelements, COL_diff;

  nelements = m->image.nx * m->image.ny * m->image.nz;
  
  fprintf(stderr, "Global Scaling  min=%f max=%f\n", m->image.Temp_image_min, m->image.Temp_image_max);
  fprintf(stderr, "Global Scaling MinColor=%d  MaxColor=%d  Reverse Palette status=%d\n",
	  m->MinColor, m->MaxColor , m->Reverse_Pal );

  if(m->MaxColor > m->MinColor) COL_diff = (m->MaxColor - m->MinColor - 1);
  else COL_diff = (m->MaxColor - m->MinColor);

  for(i = 0; i < nelements; i++)
    {
      if(m->image.val[i] == m->image.image_skip || m->image.val[i]<m->image.Temp_image_min || m->image.val[i]>m->image.Temp_image_max)
	{
	  m->image.col[i] = 0;
	}
    
    }

 
   
  XtVaGetValues(m->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(m->wij, 0, 0, w, h);
}

/* --------------------------------------------------------- */
void Switch_Image_Scale(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;

   if(mplot->image_flag)
      {
      mplot->image_scale_flag = !mplot->image_scale_flag;
      if(mplot->image_scale_flag == 0)
	 {
	 fprintf(stderr, " Min = %f   Max = %f\n", mplot->image.Global_image_max,
		 mplot->image.Global_image_min);
	 Scale_Image_Global(mplot, mplot->image.Global_image_max,
			    mplot->image.Global_image_min);
	 }
      else Scale_Image_Layer(mplot);
      }

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

void Increment_Layer(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;

   mplot->image_layer++;
   if(mplot->image_layer > mplot->image.nz)
   mplot->image_layer = mplot->image.nz;

   if(mplot->wells_in_layer==1)
      {
      set_wells_layer(mplot);
      }
  

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

/* --------------------------------------------------------- */

void Decrement_Layer(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;

   mplot->image_layer--;
   if(mplot->image_layer < 1) mplot->image_layer = 1;
   if(mplot->wells_in_layer==1)
      {
      set_wells_layer(mplot);
      }

  
   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

void Change_Cont_Palette(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;
   char cpal[12];

   mplot->contParms.Which_Pal = !mplot->contParms.Which_Pal;
   sprintf(cpal, "Palette %d", mplot->contParms.Which_Pal);
   XtVaSetValues(wij, XtNlabel, cpal, NULL);

   /* change the palette location in the color map  */

   mplot->contParms.MinCol = mplot->Pal_index[mplot->contParms.Which_Pal];
   mplot->contParms.MaxCol = (mplot->contParms.MinCol
			      + mplot->Pal_num[mplot->contParms.Which_Pal]-1);

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

/* -------------------------------------------------------- */

/* dialog box to Focs   */

static void DialogDone_Foc(Widget wij, mpic *mplot, char *call_data) 
   {
   String sfile;
   int x, y, w, h, i;

   XtPopdown(mplot->pshell);

   sfile = XawDialogGetValueString(mplot->dialog);
   clean_file_name(&sfile);
   i = Get_Focs(sfile, mplot);
   if(i > 0) 
      {
      Init_Focs(mplot);
      Set_Explode_Focs(mplot);
      
      }
  

   /* DONE SETTING UP FOCALS, NOW REPAINT! */

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   }
/* --------------------------------------------------------- */
static void DialogDone_FocDump(Widget wij, mpic *mplot, char *call_data) 
   {
   String sfile;
   int x, y, w, h;

   XtPopdown(mplot->pshell);

   sfile = XawDialogGetValueString(mplot->dialog);
   clean_file_name(&sfile);
   Dump_Focs(sfile, mplot);


   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

   }



/* --------------------------------------------------------- */

/* dialog box to change size of earthquake plotting   */

static void DialogDone_SourceSize(Widget wij, mpic *mplot, char *call_data) 
   {
   String sfile;
   int x, y, w, h;
   float slop;
  

   XtPopdown(mplot->pshell);
   sfile = XawDialogGetValueString(mplot->dialog);
   sscanf(sfile, "%d", &mplot->SourceSize);

   if( mplot->mag_src_flag==2)
      {
      fprintf(stderr,"Type in the Slope for the linear magnitude scale (current=%f)\nINPUT SLOPE>",
	      mplot->SourceSlope);
      fscanf(stdin,"%f",&slop);
      mplot->SourceSlope = slop;
    
      }
  


   change_mag_scale(mplot, mplot->mag_src_flag);

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   }

/* --------------------------------------------------------- */

/* dialog box to change size of station plotting   */

static void DialogDone_StationSize(Widget wij, mpic *mplot, char *call_data) 
   {
   String sfile;
   int x, y, w, h;

   XtPopdown(mplot->pshell);
   sfile = XawDialogGetValueString(mplot->dialog);
   sscanf(sfile, "%d", &mplot->size_sta);

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   }

/* --------------------------------------------------------- */

static void DialogDone_SpecSta(Widget wij, mpic *mplot, char *call_data)
   {
   String stname;
   int i, k, kount;

   XtPopdown(mplot->pshell);
   stname = XawDialogGetValueString(mplot->dialog);
   fprintf(stderr, " Input station= %s \n", stname);

   if(strlen(stname) == 3)
      {
      stname[3] = ' ';
      stname[4] = '\0';
      }
   if(strlen(stname) == 2)
      {
      stname[2] = ' ';
      stname[3] = ' ';
      stname[4] = '\0';
      }
   if(strlen(stname) == 1)
      {
      stname[1] = ' ';
      stname[2] = ' ';
      stname[3] = ' ';
      stname[4] = '\0';
      }

   for(kount = 0; kount < mplot->num_sta_files; kount++)
      {
      /* fprintf(stderr, "Station file %d number of stations = %d \n", kount,
	 mplot->stations[kount].num_special_stations); */
      i = 0;
      k = -1;

      while(k < 0 && i < mplot->stations[kount].numpoints)
	 {
	 if(strcmp(stname, mplot->stations[kount].sta[i].name) == 0)
	    {
	    mplot->special_station_flag = 1;
	    k = i;
	    }
	 i++;
	 }

      if(k < 0) fprintf(stderr, "No station by the name %s\n", stname);
      else
	 {
	 /* fprintf(stderr,"%d %s\n", k, mplot->stations[kount].sta[k].name); */
	 mplot->stations[kount].special_stations[mplot->
						 stations[kount].num_special_stations] = k;
	 mplot->stations[kount].num_special_stations++;
	 }
      }
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   }

static void DialogDone_Pfile(Widget wij, mpic *mplot, char *call_data)
   {
   String filename;

   XtPopdown(mplot->pshell);
   filename = XawDialogGetValueString(mplot->dialog);
   fprintf(stderr, "trying file %s\n", filename);
   Get_Point_Labs(filename, mplot);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   }

void Dump_Sta(Widget wij, mpic *mplot, char *call_data)
   {
   int i, kount, lat1, lon1;
   char c1, c2;
   float lat2, lon2, a;

   for(kount = 0; kount < mplot->num_sta_files; kount++)
      {
      fprintf(stdout, "%s\n", mplot->stations[kount].file_name);
      for(i = 0; i < mplot->stations[kount].numpoints; i++)
	 {
	 if((mplot->stations[kount].sta[i].loc.x > SELXMIN)
	    && (mplot->stations[kount].sta[i].loc.x < SELXMAX)
	    && (mplot->stations[kount].sta[i].loc.y > SELYMIN)
	    && (mplot->stations[kount].sta[i].loc.y < SELYMAX))
	    {
	    /*
	       LON  46N45.0000 121W48.6000  0.853
	       BOW  46N28.5000 123W13.6833  0.870
	       GSM  47N12.1900 121W47.6700  1.305
	       c...|....1....|....2....|....3....|....4....|....5....|....6....
	       |....7.*/
       
	    if(mplot->stations[kount].sta[i].latlon.x < 0)
	       {
	       c1='S';
	       a = -mplot->stations[kount].sta[i].latlon.x;
	       }
	    else
	       {
	       a = mplot->stations[kount].sta[i].latlon.x;
	       c1 = 'N';
	       }

	    lat1 = (int)a;
	    lat2 = (a - lat1) * 60.0;

	    if(mplot->stations[kount].sta[i].latlon.y < 0)
	       {
	       c2 = 'W';
	       a = -mplot->stations[kount].sta[i].latlon.y;
	       }
	    else
	       {
	       a = mplot->stations[kount].sta[i].latlon.y;
	       c2 = 'E';
	       }
	    lon1 = (int)a;
	    lon2 = (a - lon1) * 60.0;
       
	    fprintf(stdout, "%4s %2d%c%07.4f %3d%c%07.4f %6.3f\n",
		    mplot->stations[kount].sta[i].name, lat1, c1, lat2, lon1, c2,
		    lon2, mplot->stations[kount].sta[i].loc.z);
	    }
	 }
      }

   fprintf(stdout, "\n");
   }

/* --------------------------------------------------------- */

/* dialog box to change size of station plotting */

static void DialogDone_SphereSize(Widget wij, mpic *mplot, char *call_data) 
   {
   String sfile;
   int x, y, w, h;

   XtPopdown(mplot->pshell);
   sfile = XawDialogGetValueString(mplot->dialog);
   sscanf(sfile, "%d", &mplot->size_focm);

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   }

/* --------------------------------------------------------- */

/* dialog box to change size of station plotting   */

static void DialogDone_FocStyle(Widget wij, mpic *mplot, char *call_data) 
   {
   String sfile;
   int x, y, w, h;

   XtPopdown(mplot->pshell);
   sfile = XawDialogGetValueString(mplot->dialog);
   sscanf(sfile, "%d", &mplot->focal_plot_style);
   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
   }

/* --------------------------------------------------------- */

static void Popup_moresrc(Widget w, mpic *mplot, char *call_data)
   {
   char lab[200];
   sprintf(lab, "Additional Sources File: last=%s",
	   mplot->sources[mplot->max_more_src - 1].file_name);
   XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_More_Sources);
   }

/* --------------------------------------------------------- */

static void Popup_change_save_file(Widget w, mpic *mplot, char *call_data)
   {
   char lab[200];

   sprintf(lab, "File for Saving Sources: last=%s", mplot->src_dump_file);
   XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_change_save_file);
   }

/* --------------------------------------------------------- */

static void Popup_time_source(Widget w, mpic *mplot, char *call_data)
   {
   char lab[200];

   sprintf(lab, "time for source plot: last=%f", mplot->time_plot_wait);
   XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Time_Plot);
   }

static void Popup_moremap(Widget w, mpic *mplot, char *call_data)
   {

   XtVaSetValues(mplot->dialog, XtNlabel, "Additional Map File:", NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_MoreMap);
   }

static void Popup_moreWire(Widget w, mpic *mplot, char *call_data)
   {
   XtVaSetValues(mplot->dialog, XtNlabel, "Wire Frame File:", NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_MoreWire);
   }

static void Popup_HozDef(Widget w, mpic *mplot, char *call_data)
   {
   XtVaSetValues(mplot->dialog, XtNlabel,
		 "Type in the Top and Bottom of the Slab", NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_HozDef);
   }

static void Popup_map_code(Widget w, mpic *mplot, char *call_data)
   {

   XtVaSetValues(mplot->dialog, XtNlabel, "Code for Map File:", NULL);

   fprintf(stderr, "\nsome geologic codes\n"
	   "\ta = major coasts  islands  lakes\n"
	   "\tb = intermediate coasts islands lakes\n"
	   "\tc = minor coasts islands lakes\n"
	   "\td = very minor coasts islands lakes\n"
	   "\te = major rivers\n"
	   "\tf = intermediate rivers\n"
	   "\tg = minor rivers\n"
	   "\th = very minor rivers\n"
	   "\ti = political borders\n"
	   "\tj = major faults\n"
	   "\tk = minor faults\n"
	   "\tl = geology formation\n"
	   "\tm = major high ways\n"
	   "\tn = minor roads\n"
	   "\tp = plates\n");

   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_MapCode);
   }

static void Popup_changedepth(Widget w, mpic *mplot, char *call_data)
   {
   char lab[200];

   sprintf(lab, "Minimum Maximum Depth: current=%5f %5f", mplot->MinDepth, mplot->MaxDepth);
   XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_ChangeDepth);
   }

static void Popup_SourceSize(Widget w, mpic *mplot, char *call_data)
   {
   char lab[100];

   sprintf(lab, "Source Size: current=%d", mplot->SourceSize);
   XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_SourceSize);
   }

static void Popup_StationSize(Widget w, mpic *mplot, char *call_data)
   {
   char lab[50];

   sprintf(lab, "Station Size: current=%d", mplot->size_sta);
   XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_StationSize);
   }

static void Popup_specsta(Widget w, mpic *mplot, char *call_data)
   {
   XtVaSetValues(mplot->dialog, XtNlabel, "Station to find:", XtNwidth, 100,
		 XtNheight, 200, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_SpecSta);
   }

static void Popup_pfile(Widget w, mpic *mplot, char *call_data)
   {
   XtVaSetValues(mplot->dialog, XtNlabel, "Points File:", XtNwidth, 100,
		 XtNheight, 200, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Pfile);
   }

static void Plot_pfile(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;

   mplot->point_flag = !mplot->point_flag;
   if(mplot->point_flag == 0)
   XtVaSetValues(wij, XtNlabel, "- Plot Points", NULL);
   else XtVaSetValues(wij, XtNlabel, "+ Plot Points", NULL);

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

static void Name_pfile(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;
   int i, kount;
   static int name_point_flag = 0;

   name_point_flag = !name_point_flag;

   for(kount = 0; kount < mplot->point_flag; kount++)
      {
      for(i = 0; i < mplot->Mpoint[kount].numpoints; i++)
      mplot->Mpoint[kount].points[i].strcode = name_point_flag;
      }

   if(name_point_flag == 0)
   XtVaSetValues(wij, XtNlabel, "- Name Plot Points", NULL);
   else XtVaSetValues(wij, XtNlabel, "+ Name Plot Points", NULL);

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

void Do_SelPoints(Widget wij, mpic *mplot, char *call_data)
   {
   int j, kount, icount;
   char staname[200];
   float x, y, urx, ury, blx, bly, phi, lam;

   blx = SELXMIN;
   bly = SELYMIN;
   urx = SELXMAX;
   ury = SELYMAX;

   fprintf(stderr, "-------Selected Points---%d\n", mplot->point_flag);
   for(kount = 0; kount < mplot->point_flag; kount++)
      {
      fprintf(stderr, "------checking Point file ---%d %s\n", kount,
	      mplot->Mpoint[kount].file_name);
      for(j = 0; j < mplot->Mpoint[kount].numpoints; j++)
	 {
	 phi = mplot->Mpoint[kount].points[j].lat;
	 lam = mplot->Mpoint[kount].points[j].lon;
	 geo2xy(mplot, phi, lam, &x, &y);
	 if(x < urx && x > blx && y < ury && y > bly)
	    {
	    strcpy(staname, mplot->Mpoint[kount].points[j].name);
	    for(icount = 0; icount < strlen(staname); icount++)
	    if(staname[icount]==' ') staname[icount]='_';

	    fprintf(stderr, "%s %f %f %f %d %d %d %d %d %d %d\n", staname,
		    mplot->Mpoint[kount].points[j].lat,
		    mplot->Mpoint[kount].points[j].lon,
		    mplot->Mpoint[kount].points[j].depth,
		    mplot->Mpoint[kount].points[j].color,
		    mplot->Mpoint[kount].points[j].symbol,
		    mplot->Mpoint[kount].points[j].symcode,
		    mplot->Mpoint[kount].points[j].symsize,
		    mplot->Mpoint[kount].points[j].strcode,
		    mplot->Mpoint[kount].points[j].fsize,
		    mplot->Mpoint[kount].points[j].just);
	    }
	 }
      }
   }
/****************************/
void Do_SelPolyPoints(Widget wij, mpic *mplot, char *call_data)
{
  int j, kount, icount, num;
  char staname[200];
  float x, y, phi, lam;
  fpoint *plotkin, po;
 
  num = global_poly;
plotkin = XmapNewArray(fpoint, num + 1);
 
  fprintf(stderr, "global_poly num=%d\n",num);
  prep_polygon(mplot,  plotkin);
fprintf(stderr, "in Do_SelPolyPoints\n");
  for(j=0; j<=num; j++)
    {
fprintf(stderr, "%f %f\n", plotkin[j].x,  plotkin[j].y);

    }
 
  fprintf(stderr, "-------Selected Points---%d\n", mplot->point_flag);
  for(kount = 0; kount < mplot->point_flag; kount++)
    {
      fprintf(stderr, "------checking Point file ---%d %s\n", kount,
	      mplot->Mpoint[kount].file_name);
      for(j = 0; j < mplot->Mpoint[kount].numpoints; j++)
	{
	  phi = mplot->Mpoint[kount].points[j].lat;
	  lam = mplot->Mpoint[kount].points[j].lon;
	  geo2xy(mplot, phi, lam, &x, &y);
	  po.x = x;
	  po.y = y;
	 
	  if(inside(po, plotkin, num) == 1)
	    {    
	      strcpy(staname, mplot->Mpoint[kount].points[j].name);
	      for(icount = 0; icount < strlen(staname); icount++)
		if(staname[icount]==' ') staname[icount]='_';

	      fprintf(stderr, "%s %f %f %f %d %d %d %d %d %d %d\n", staname,
		      mplot->Mpoint[kount].points[j].lat,
		      mplot->Mpoint[kount].points[j].lon,
		      mplot->Mpoint[kount].points[j].depth,
		      mplot->Mpoint[kount].points[j].color,
		      mplot->Mpoint[kount].points[j].symbol,
		      mplot->Mpoint[kount].points[j].symcode,
		      mplot->Mpoint[kount].points[j].symsize,
		      mplot->Mpoint[kount].points[j].strcode,
		      mplot->Mpoint[kount].points[j].fsize,
		      mplot->Mpoint[kount].points[j].just);
	    }
	}
    }
  XmapFree(plotkin); 
}
/****************************/
static void Popup_halfwidth(Widget w, mpic *mplot, char *call_data)
   {
   char lab[50];

   sprintf(lab, "Half Width: current=%f", mplot->halfwidth);
   XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_HalfWidth);
   }

static void Popup_GetField(Widget w, mpic *mplot, char *call_data)
   {

   XtVaSetValues(mplot->dialog, XtNlabel, "Field Data:", NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_GetField);
   }

static void Plot_Contour(Widget wij, mpic *mplot, char *call_data)
   {
   short x, y, w, h;

   if(mplot->contParms.datapt == NULL) return;

   mplot->plot_cont_flag = !mplot->plot_cont_flag;
   if(mplot->plot_cont_flag == 0)
   XtVaSetValues(wij, XtNlabel, "- Plot Contours", NULL);
   else XtVaSetValues(wij, XtNlabel, "+ Plot Contours", NULL);

   XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		 NULL);
   send_repaint(mplot->wij, 0, 0, w, h);
   }

/*******************/

void Contour_Points(Widget wij, mpic *mplot, char *call_data)
   {
   int j, size = 3;
   float px, py, pz;

   XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		  mplot->colors[XmapAppColor(1)]);

   mplot->plot_cont_points = !mplot->plot_cont_points;
   if(mplot->plot_cont_points)
      {
      for(j = 0; j < mplot->contParms.length_data; j++)
	 {
	 px = mplot->contParms.datapt[j].x;
	 py = mplot->contParms.datapt[j].y;
	 pz = mplot->contParms.datapt[j].z;
	 XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
			user_to_pix_x(&mplot->gr, px),
			user_to_pix_y(&mplot->gr, py), size, size);
	 XFlush(XtDisplay(mplot->wij));
	 }
      }
   }

/*******************/

void Contour_Vals(Widget wij, mpic *mplot, char *call_data)
   {
   int j, size = 3;
   float px, py, pz;
   char pchar[8];

   mplot->plot_cont_values = !mplot->plot_cont_values;
   if(mplot->plot_cont_values)
      {
      XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
		     mplot->colors[XmapAppColor(1)]);
      XSetFont(XtDisplay(mplot->wij), mplot->ggc, mplot->fonts[0]);

      for(j = 0; j < mplot->contParms.length_data; j++)
	 {
	 px = mplot->contParms.datapt[j].x;
	 py = mplot->contParms.datapt[j].y;
	 pz = mplot->contParms.datapt[j].z;

	 XDrawRectangle(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
			user_to_pix_x(&mplot->gr, px),
			user_to_pix_y(&mplot->gr, py), size, size);
	 sprintf(pchar, "%g", pz);
	 draw_just_text(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc,
			user_to_pix_x(&mplot->gr, px),
			user_to_pix_y(&mplot->gr, py), pchar, HJ_CENTER,
			VJ_BASELINE);
	 XFlush(XtDisplay(mplot->wij));
	 }
      }
   }
/*******************/

void Dump_Contour_Points(Widget wij, mpic *mplot, char *call_data)
   {
   int j;
   float px, py, pz;

    FILE *fp;

   if((fp = fopen("cont_points_out", "w")) == NULL)
      {
      fprintf(stderr,"Can't  cont_points_out....try again\n");
      return;
      }

   
      for(j = 0; j < mplot->contParms.length_data; j++)
	 {
	 px = mplot->contParms.datapt[j].lat;
	 py = mplot->contParms.datapt[j].lon;
	 pz = mplot->contParms.datapt[j].z;
	 fprintf(fp, "%f %f %f\n", px, py, pz);
	 }
      fclose(fp);
    fprintf(stderr,"contour point written in file:  cont_points_out\n");
   }

/*******************/

void Contour_Map(Widget wij, mpic *mplot, char *call_data)
   {
   char *dump_file = "cont_dump.lees";

   dump_contour_file(dump_file, mplot);
   }

void Raster_Contour(Widget wij, mpic *mplot, char *call_data)
   {
   struct SURF_GRD *grd;
   int i, j, k, n, nx, ny;
   float phi, lam;
   FILE *inf;

   if((inf = fopen("raster_out", "w")) == NULL)
      {
      printf("Can't open raster ....try again\n");
      return;
      }

   /*
    * 46.4000015 -123.4166641   30   50  10  5.000000 0.000  2.000
    * 4.000  6.000  9.000 12.000 16.000 20.000 25.000 32.000 41.000
    */

   grd = mplot->contParms.surf_grd;
   nx = grd->nx;
   ny = grd->ny;
   fprintf(stderr, "inx = %f   incy = %f\n", grd->xinc, grd->yinc);
   xy2geo(mplot, &phi, &lam, -grd->xinc / 2, -grd->yinc / 2);

   /*   offset...	
	fprintf(inf, "%f %f %d %d 1 %f %f \n",
	mplot->origin.phi, -mplot->origin.lam, nx-1, ny-1, grd->xinc,
	grd->yinc); */

   fprintf(inf, "%f %f %d %d 1 %f %f \n", phi, lam, nx, ny, grd->xinc,
	   grd->yinc);
   fprintf(inf, "0.0 %f\n", 0.1 * mplot->MaxDepth);
   for(j = ny - 1, n = 0; j >= 0; j--)
      {
      for(i = 0; i < nx; i++)
	 {
	 k = j * nx + i;
	 /* fprintf(stderr,"%d %d %d %d %f\n", n,k,i,j, grd->val[k]); */
	 fprintf(inf, "%f\n", grd->val[k]);
	 n++;
	 }
      }
   fclose(inf);
   fprintf(stderr, "\n\n RASTER IMAGE IN FILE: raster_out\n");
   /* for(i=0; i< nx*ny; i++) { fprintf(stderr,"%d %f\n", i, grd->val[i]); } */
   }

static void Popup_Postscript(Widget w, mpic *mplot, char *call_data)
   {

   XtVaSetValues(mplot->dialog, XtNlabel, "Output Postscript:", NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Postscript);
   }

static void Popup_Load_Xsec(Widget w, mpic *mplot, char *call_data)
   {

   XtVaSetValues(mplot->dialog, XtNlabel, "Cross section File:", NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Load_Xsec);
   }

static void SAVE_Xsec(Widget wij, mpic *mplot, char *call_data)
   {
   FILE *outf;
   int i;
   
   XtVaGetValues(wij, XtNdata, &mplot, NULL);
   if((outf = fopen("SAVE_xsecs", "w")) == NULL)
      {
      printf("Can't open file SAVE_xsecs ....try again\n");
      return;
      }
   
   for(i = 0; i <= mplot->num_xsec; i++)
   fprintf(outf, "%f %f %f %f %f %f %f %f %f\n",
	   mplot->cross[i].xsecphilam.x1, mplot->cross[i].xsecphilam.y1,
	   mplot->cross[i].xsecphilam.x2, mplot->cross[i].xsecphilam.y2,
	   90 - mplot->cross[i].xs_dip, mplot->cross[i].min_xsdepth,
	   mplot->cross[i].max_xsdepth, mplot->cross[i].max_xsfront,
	   mplot->cross[i].max_xsback);

  fprintf(stderr,"\n\n X-secs are saved in file: SAVE_xsecs\n\n");
  fclose(outf);
  }
/***************/
static void Popup_Labels(Widget w, mpic *mplot, char *call_data)
  {

  XtVaSetValues(mplot->dialog, XtNlabel,
		"Label Marker: (use key m then n to mark point)", NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Labels);
  }
/***************/
static void Set_Cur_Label(Widget w, mpic *mplot, char *call_data)
  {
  int cur;
  int i;

  for(i=0; i<=mplot->num_labels; i++)
    {
    fprintf(stderr,"Label %d: %s\n", i, mplot->labels[i].label);
    }

  fprintf(stderr,"Type in the number of the Label you want to change:\n");
  fscanf(stdin,"%d",&cur);
  mplot->current_label = cur;
  
  }
/***************/
static void Save_Labels(Widget w, mpic *mplot, char *call_data)
  {
  
  int i;
  char  savefile[200];
  FILE  *sf;
  char lab[200];
  

  fprintf(stderr,"Type in the file for the labels:\n");
  fscanf(stdin,"%s", savefile);
  
    if((sf = fopen(savefile, "w")) == NULL)
    {
    fprintf(stderr,"Can't open file: %s ....try again\n",
	   savefile);
    return;
    }

  for(i=0; i<=mplot->num_labels; i++)
    {
    strcpy(lab, mplot->labels[i].label);
    
    blank2under(lab);
    
    fprintf(sf,"%s %f %f %f %f\n",
	    lab,
	    mplot->labels[i].latlon.x1,
	    mplot->labels[i].latlon.y1,
	    mplot->labels[i].latlon.x2,
	    mplot->labels[i].latlon.y2
	    );
    }
  fclose(sf);
  
  
  }
/***************/
static void Read_Labels(Widget widg, mpic *mplot, char *call_data)
  {
  short w,h;
  
  Get_Labels(mplot);
    XtVaGetValues(mplot->wij, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/***************/
static void Popup_Get_Image(Widget w, mpic *mplot, char *call_data)
{

   XtVaSetValues(mplot->dialog, XtNlabel, "Image File:", NULL);
   PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Image);
}
/***************/

void image_getfile_accept(Widget w, XtPointer clidat, XtPointer calldat)
{
   char *path;
   int val = (int)calldat;
   /* mpic *mplot = (mpic *)clidat; */

   if(val)
   {
      XtVaGetValues(w, XtNpathName, &path, NULL);
      printf("File selected: %s\n", path);

      /* do whatever you need to do with the filename now */

      /* mplot is the plot structure */
   }
   else puts("Nothing was selected.\n");
}
/***************/

static void Get_Image_FILE(Widget w, XtPointer clidat, XtPointer calldat)
{
   Widget fsw = (Widget)clidat;

   XtPopup(fsw, XtGrabExclusive);
}
/***************/
static void Toggle_Wells(Widget wij, mpic *mplot, char *call_data)
  {

  if(mplot->wells_flag == 1)
    {
    mplot->wells_flag = 2;
    XtVaSetValues(wij, XtNlabel, "+ Plot Wells", NULL);
    send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
    return;
    }

  if(mplot->wells_flag == 2)
    {
    mplot->wells_flag = 1; 
    XtVaSetValues(wij, XtNlabel, "- Plot Wells", NULL);
    send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
    return;
    }
  }

static void Popup_Wells(Widget wij, mpic *mplot, char *call_data)
{

  mplot->wells_flag = 2;

  XtVaSetValues(mplot->dialog, XtNlabel, "Well-File:", NULL);
  PopupDialog(wij, mplot, (XtCallbackProc)DialogDone_Wells);
  }

static void Popup_Lips(Widget wij, mpic *mplot, char *call_data)
  {

  mplot->lip_flag = 1;

  XtVaSetValues(mplot->dialog, XtNlabel, "Ellipse-File:", NULL);
  PopupDialog(wij, mplot, (XtCallbackProc)DialogDone_Lips);
  }

static void Popup_Scale_Lips(Widget wij, mpic *mplot, char *call_data)
  {



  XtVaSetValues(mplot->dialog, XtNlabel, "globally scale ellipses:", NULL);
  PopupDialog(wij, mplot, (XtCallbackProc)DialogDone_Scale_Lips);
  }




static void Popup_Foc(Widget w, mpic *mplot, char *call_data)
  {

  /* the flag is first set to 0 and then it toggles between 1 and 2 */
 
  XtVaSetValues(mplot->dialog, XtNlabel, "Focal Mech File:", NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_Foc);
  mplot->focm_flag = 2;
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

static void PLOT_Foc(Widget w, mpic *mplot, char *call_data)
  {

  /* the flag is first set to 0 and then it toggles between 1 and 2 */

  if(mplot->focm_flag == 0)
    {
    mplot->focm_flag = 2;
    XtVaSetValues(w, XtNlabel, "+ Plot MECH", NULL);
    }
  if(mplot->focm_flag == 1)
    {
    mplot->focm_flag = 2;
    XtVaSetValues(w, XtNlabel, "+ Plot MECH", NULL);
    send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
    return;
    }

  if(mplot->focm_flag == 2)
    {
    mplot->focm_flag = 1; 
    XtVaSetValues(w, XtNlabel, "- Plot MECH", NULL);
    send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
    return;
    }
  }

static void Popup_SphereSize(Widget w, mpic *mplot, char *call_data)
  {
  char lab[50];

  sprintf(lab, "Focal Sphere Size: current=%d", mplot->size_focm);

  XtVaSetValues(mplot->dialog, XtNlabel, lab, NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_SphereSize);
  }

static void Popup_FocalStyle(Widget w, mpic *mplot, char *call_data)
  {
  char lab[100], *codes = "Plot Style:\n1=planes(only)\n2=planes/PT\n"
    "3=PT (only)\n4=add fault plane\n5=fault plane only\n";
  char  doc[200];
  strcpy(doc,codes);
  sprintf(lab, "current=%d", mplot->focal_plot_style);
  strcat(doc, lab);
  fprintf(stderr,"Choose a Focal Style:\n%s\n", doc);
  XtVaSetValues(mplot->dialog, XtNlabel, doc, NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_FocStyle);
  }

static void Popup_DumpFocal(Widget w, mpic *mplot, char *call_data)
  {

  /* the flag is first set to 0 and then it toggles between 1 and 2 */
 
  XtVaSetValues(mplot->dialog, XtNlabel, "Focal Mech Dump File:", NULL);
  PopupDialog(w, mplot, (XtCallbackProc)DialogDone_FocDump);
 
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

  }

/* --------------------------------------------------------- */

void select_source(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->src_flag = !mplot->src_flag;

  /* printf("Sources = %d \n", mplot->src_flag); */
  if(mplot->src_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Plot Sources", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot Sources", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

void Fancy_Src(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;
  int j;

  mplot->fancy_src_flag = !mplot->fancy_src_flag;
  /* fprintf(stderr,"Sources = %d \n", mplot->src_flag); */
  if(mplot->fancy_src_flag == 0)
    {
    XtVaSetValues(wij, XtNlabel, "- Fancy Plot", NULL);
    for(j = 0; j < mplot->max_more_src; j++)
      mplot->sources[j].style = 0;
    }
  else
    {
    XtVaSetValues(wij, XtNlabel, "+ Fancy Plot", NULL);
    for(j = 0; j < mplot->max_more_src; j++)
      mplot->sources[j].style = 1;
    }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

void Mag_Src(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;
  int i, j, hsize;

  mplot->mag_src_flag = !mplot->mag_src_flag;
  /* fprintf(stderr,"Sources = %d \n", mplot->src_flag); */
  if(mplot->mag_src_flag == 0)
    {
    XtVaSetValues(wij, XtNlabel, "- Mag Plot", NULL);

    for(j = 0; j < mplot->max_more_src; j++)
      {
      for(i = 0; i < mplot->sources[j].numpoints; i++)
	mplot->sources[j].size[i] = mplot->SourceSize;
      }
    }
  else
    {
    XtVaSetValues(wij, XtNlabel, "+ Mag Plot", NULL);
    for(j = 0; j < mplot->max_more_src; j++)
      {
      for(i = 0; i < mplot->sources[j].numpoints; i++)
	{
	hsize = mplot->SourceSize + 0.08 * exp(mplot->sources[j].acard[i].mag);
	if(hsize > 50.0) hsize = 37.5 + 0.25 * hsize;
	mplot->sources[j].size[i] = hsize;
	}
      }
    }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

void accept_mag_opt(Widget wij, XtPointer clidat, XtPointer calldat)
  {
  phook_t *hook = (phook_t *)clidat;
  int j, pane = (int)(hook->a); 
  static int lastpane = -1;
  Dimension w, h;
  Position x, y;
  mpic *mplot = (mpic *)(hook->b);

  XtVaGetValues(wij, XtNdata, &mplot, NULL);
  fprintf(stderr, "mag_src_flag = %d option=%d  \n", mplot->mag_src_flag,
	  pane);
  mplot->mag_src_flag = pane;
     
  change_mag_scale(mplot, mplot->mag_src_flag);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y,	XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  fprintf(stderr, " option=%d  \n", pane);

  /* this chunk below would toggle the behavior of option #_pane_ if
   * you want each option to function like a checkbox, and have its own
   * setting irrespective of the settings of the other options
   */

  /*
  if(modes[pane])
    {
    XtVaSetValues(subpane[pane], XtNleftBitmap, None, NULL);
    modes[pane]--;
    }
  else
    {
    XtVaSetValues(subpane[pane], XtNleftBitmap, star, NULL);
    modes[pane]++;
    }
  */

  /* this chunk of code treats the set of options like a set of radio
   * buttons, with one-of-many behavior
   */

  if(lastpane >= 0)
    {
    XtVaSetValues(subpane[lastpane], XtNleftBitmap, None, NULL);
    modes[lastpane]--;
    }
  
  XtVaSetValues(subpane[pane], XtNleftBitmap, star, NULL);
  modes[pane]++;
  lastpane = pane;

  /***/
  
  for(j = 0; j < 3; j++) fprintf(stderr, "modes[%d]=%d ", j, modes[j]);
  fprintf(stderr,"\n");
  }

void Mag_Scale(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->mag_src_flag++;
  if(mplot->mag_src_flag > 2) mplot->mag_src_flag = 0;

  switch(mplot->mag_src_flag)
    {
    case 0:
      XtVaSetValues(wij, XtNlabel, "Constant Scale", NULL);
      break;

    case 1:
      XtVaSetValues(wij, XtNlabel, "Exp Scale", NULL);
      break;

    case 2:
      XtVaSetValues(wij, XtNlabel, "Linear Scale", NULL);
      break;
    }

  change_mag_scale(mplot, mplot->mag_src_flag);
  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

void time_source(Widget wij, mpic *mplot, char *call_data)
  {
  }

/* --------------------------------------------------------- */

void Color_depth_source(Widget wij, mpic * mplot, char *call_data)
  {
  short x, y, w, h;
  int i, j;
 /*  int mincol, maxcol; */
  
  mplot->src_depth_color = !mplot->src_depth_color;
  if(mplot->src_depth_color == 0)
    {
    XtVaSetValues(wij, XtNlabel, "- Color-Depths", NULL);

    for(j = 0; j < mplot->max_more_src; j++)
      for(i = 0; i < mplot->sources[j].numpoints; i++)
	mplot->sources[j].point_color[i] = mplot->src_col - j;
    }
  else
     {
     
     fprintf(stderr, "Scaling Colors by Focal Depth\n");
     fprintf(stderr, "Note: colors will range from\n");
     fprintf(stderr, "  MinDepth=%f to MaxDepth=%f \n",   mplot->MinDepth, mplot->MaxDepth );
     
     
     XtVaSetValues(wij, XtNlabel, "+ Color-Depths", NULL);
     mplot->MinColor = mplot->num_fixed_colors;
     mplot->MaxColor =   mplot->MinColor + mplot->Pal_num[mplot->Which_Pal]-1;
     
     for(j = 0; j < mplot->max_more_src; j++)
	{
	
	for(i = 0; i < mplot->sources[j].numpoints; i++)
	   {
	   
	   mplot->sources[j].point_color[i] =
	   (((mplot->MaxColor - mplot->MinColor)
	     * (mplot->sources[j].acard[i].depth - mplot->MinDepth)
	     / (mplot->MaxDepth - mplot->MinDepth)) + mplot->MinColor);
	   if( mplot->sources[j].point_color[i] > mplot->MaxColor ) 
	   mplot->sources[j].point_color[i]=mplot->MaxColor;
	   if( mplot->sources[j].point_color[i] < mplot->MinColor ) 
	   mplot->sources[j].point_color[i]=mplot->MinColor;
	   }
	}
     
     
    }

#if 0
  fprintf(stderr, "done changing source colors....\n");
  
  mincol=maxcol=mplot->sources[0].point_color[0];
  
  for(j = 0; j < mplot->max_more_src; j++)
     { 
     for(i = 0; i < mplot->sources[j].numpoints; i++)
	{
	if(mplot->sources[j].point_color[i]>maxcol) maxcol=mplot->sources[j].point_color[i];
	if(mplot->sources[j].point_color[i]<mincol) mincol=mplot->sources[j].point_color[i];
	
	
	}
     }
  fprintf(stderr, " maxcol=%d   mincol=%d  mplot->MaxDepth=%f  mplot->MinDepth=%f \n", maxcol, mincol,mplot->MaxDepth,  mplot->MinDepth );
  
#endif


  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/*-------------------------------------------------------*/

void output_source(Widget wij, mpic *mplot, char *call_data)
  {

  switch(mplot->picsource_outflag)
    {
    case 0:
      mplot->picsource_outflag = 1;
      XtVaSetValues(wij, XtNlabel, "Src Output Normal", NULL);
      break;

    case 1:
      mplot->picsource_outflag = 2;
      XtVaSetValues(wij, XtNlabel, "Src Output = Connect", NULL);
      break;

    case 2:
      mplot->picsource_outflag = 0;
      XtVaSetValues(wij, XtNlabel, "No Src Output", NULL);
      break;

    default:
      mplot->picsource_outflag = 0;
      XtVaSetValues(wij, XtNlabel, "No Src Output", NULL);
      break;
    }

  /* fprintf(stderr, "Flip flag: picsource_outflag  = %d\n",
     mplot->picsource_outflag); */
  }

/* --------------------------------------------------------- */

void select_more_source(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->more_src_flag = !mplot->more_src_flag;

  if(mplot->more_src_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Plot More Sources",	NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot More Sources", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0,mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

void connect_source(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;
  int a = 0, b = 1, i, j, ndist;
  char acrd[80];
  double distance, meandist, std;
  

  mplot->connect_flag = !mplot->connect_flag;
  if(mplot->connect_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Connect Sources", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Connect Sources", NULL);

#if 1
if(mplot->force_source==0)
   {
   fprintf(stderr,"Warning:\n");
   fprintf(stderr,"The -force_source option  was not used at start up time.\n");
   fprintf(stderr,"This may cause a mismatch in the connecting events and strange results will ensue.\n");
   fprintf(stderr,"Recommend re-running the program with this feature selected\n");
   }
  


if(mplot->connect_flag==1)
   {
   
  for(j = 0; j < mplot->max_more_src - 1; j++) 
      {
      a = j, b = j + 1, ndist=0, std=0.0, meandist=0.0;
      
      for(i = 0; i < mplot->sources[a].numpoints; i++)
	 { 
	 /* temporary: require that the sources be above MaxDepth for */
	 /* a connection to be made   */

	 if(mplot->sources[a].loc[i].z <= mplot->MaxDepth)
	    {
	     distance = dist3d( mplot->sources[a].loc[i].x, mplot->sources[b].loc[i].x,
			       mplot->sources[a].loc[i].y, mplot->sources[b].loc[i].y,
			       mplot->sources[a].loc[i].z, mplot->sources[b].loc[i].z);

             meandist += distance;
	     std += distance*distance;
	     ndist++;
	     
           if( strcmp(mplot->sources[a].acard[i].id, mplot->sources[b].acard[i].id) )
	      {
	      fprintf(stderr,"POTENTIAL MISMATCH:   dist=%f\n", distance);
	      create_Acard(&mplot->sources[a].acard[i], acrd);
	      fprintf(stderr,"%s", acrd);
	      create_Acard(&mplot->sources[b].acard[i], acrd);
	      fprintf(stderr,"%s", acrd);	  
	      }
	     
	     
	     
	    
	    }
	 }

      std = sqrt(  ((ndist*std)-meandist*meandist)/(ndist*(ndist-1)));
      
      meandist/=ndist;
      fprintf(stderr,"Stats for connecting groups n=%d mean=%f std=%f\n", ndist,  meandist, std);
      
      }
  }
  
#endif



  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);



  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }
/* --------------------------------------------------------- */

void layer_source(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->src_in_layer = !mplot->src_in_layer;
  if(mplot->src_in_layer == 0)
    XtVaSetValues(wij, XtNlabel, "- Layer Sources", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Layer Sources", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

void layer_foc(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->foc_in_layer = !mplot->foc_in_layer;
  if(mplot->foc_in_layer == 0)
    XtVaSetValues(wij, XtNlabel, "- Layer Focs", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Layer Foc", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }



/**********************************/
void poly_source(Widget wij, mpic *mplot, char *call_data)
  {
  int i, k = 0, j,  num;
  
  fpoint *plotkin, po;
  char acrd[80];
  FILE *inf;

  fprintf(stderr, "source file = %s\n", mplot->src_dump_file);

  if((inf = fopen(mplot->src_dump_file, "w")) == NULL)
    {
    printf("Can't open special source %s ....try again\n",
	   mplot->src_dump_file);
    return;
    }

  num = global_poly;
  plotkin = XmapNewArray(fpoint, num + 1);
 
  fprintf(stderr, "global_poly num=%d\n",num);
  prep_polygon(mplot,  plotkin);

  for(j = 0; j <= mplot->max_more_src - 1; j++)
    {
    fprintf(stdout, "\n-------------From Source File %s ---------------\n",
	    mplot->sources[j].file_name);
    for(i = 0; i < mplot->sources[j].numpoints; i++)
      {
      po.x = mplot->sources[j].loc[i].x;
      po.y = mplot->sources[j].loc[i].y;
      if(inside(po, plotkin, num) == 1)
	{
	create_Acard(&mplot->sources[j].acard[i], acrd);
	if( mplot->picsource_outflag != 0) fprintf(stdout, "%s", acrd);
	fprintf(inf, "%s", acrd);
	k++;
	}
      }
    } 

  fprintf(stdout, "\n\n number of points = %d\n", k);
  fprintf(stdout, "---------------------------------\n");
  fclose(inf);
  
  XmapFree(plotkin); 
  }

void break_line2(char *line, int *fake_argc, char **fake_argv)
  {
  int i = 0;

  fake_argv[i++] = strtok(line, " "); 

  while((fake_argv[i++] = strtok(NULL, " ")) != NULL);
  *fake_argc = i - 1;
  }

/* --------------------------------------------------------- */

/*
int getl(char *line, int max)
  {

  if(gets(line, max) == NULL) return 0;
  else return strlen(line);
  }
*/

void hypo_selection( mpic *mplot)
  {
  int i, k = 0, j, icode, inout, kk, numcode, codes[20];
  char acrd[80];
  float tim;
  FILE *inf;

  fprintf(stdout, " -------------------------------- \n\n");

  /* make a vector of the options  */

  numcode = 0;

  if(mplot->hypoParms.t2 > mplot->hypoParms.t1) codes[numcode++] = 11;
  if(mplot->hypoParms.z2 > mplot->hypoParms.z1) codes[numcode++] = 1;
  if(mplot->hypoParms.m2 > mplot->hypoParms.m1) codes[numcode++] = 2;
  if(mplot->hypoParms.np2 > mplot->hypoParms.np1) codes[numcode++] = 3;
  if(mplot->hypoParms.ns2 > mplot->hypoParms.ns1) codes[numcode++] = 4;
  if(mplot->hypoParms.g2 > mplot->hypoParms.g1) codes[numcode++] = 5;
  if(mplot->hypoParms.del2 > mplot->hypoParms.del1) codes[numcode++] = 6;
  if(mplot->hypoParms.rms2 > mplot->hypoParms.rms1) codes[numcode++] = 7;
  if(mplot->hypoParms.err2 > mplot->hypoParms.err1) codes[numcode++] = 8;
  if(mplot->hypoParms.q1 > 0) codes[numcode++] = 9;
  if(mplot->hypoParms.q2 > 0) codes[numcode++] = 10;
  if(mplot->hypoParms.intarg > 0) codes[numcode++] = 0;

  fprintf(stderr, "done setting options\n");
  fprintf(stderr, "source file = %s\n", mplot->src_dump_file);
  if((inf = fopen(mplot->src_dump_file, "w")) == NULL)
    {
    printf("Can't open special source %s ....try again\n",
	   mplot->src_dump_file);
    return;
    }

  for(j = 0; j <= mplot->max_more_src - 1; j++)
    {
    fprintf(stdout, "\n-------------From Source File %s ---------------\n",
	    mplot->sources[j].file_name);
    for(i = 0; i < mplot->sources[j].numpoints; i++)
      {
      inout = 0;
      for(kk = 0; kk < numcode; kk++)
	{
	icode = codes[kk];
	switch(icode)
	  {
	  case 0:
	    if((mplot->sources[j].loc[i].x > SELXMIN)
	       && (mplot->sources[j].loc[i].x < SELXMAX)
	       && (mplot->sources[j].loc[i].y > SELYMIN)
	       && (mplot->sources[j].loc[i].y < SELYMAX))
	      inout++;
	    break;

	  case 11:
	    tim = atof(mplot->sources[j].acard[i].id);
	    if(tim >= mplot->hypoParms.t1 && tim <= mplot->hypoParms.t2)
	      inout++;
	    break;

	  case 1:
	    if((mplot->sources[j].acard[i].depth >= mplot->hypoParms.z1)
	       && (mplot->sources[j].acard[i].depth <= mplot->hypoParms.z2))
	    inout++;
	    break;

	  case 2:
	    if((mplot->sources[j].acard[i].mag >= mplot->hypoParms.m1)
	       && (mplot->sources[j].acard[i].mag <= mplot->hypoParms.m2))
	      inout++;
	    break;

	  case 3:
	    if((mplot->sources[j].acard[i].nump >= mplot->hypoParms.np1)
	       && (mplot->sources[j].acard[i].nump <= mplot->hypoParms.np2))
	      inout++;
	    break;

	  case 4:
	    if((mplot->sources[j].acard[i].nums >= mplot->hypoParms.ns1)
	       && (mplot->sources[j].acard[i].nums <= mplot->hypoParms.ns2))
	      inout++;
	    break;

	  case 5:
	    if((mplot->sources[j].acard[i].gap >= mplot->hypoParms.g1)
	       && (mplot->sources[j].acard[i].gap <= mplot->hypoParms.g2))
	      inout++;
	    break;

	  case 6:
	    if((mplot->sources[j].acard[i].delta >= mplot->hypoParms.del1)
	       && (mplot->sources[j].acard[i].delta <= mplot->hypoParms.del2))
	      inout++;
	    break;

	  case 7:
	    if((mplot->sources[j].acard[i].rms >= mplot->hypoParms.rms1)
	       && (mplot->sources[j].acard[i].rms <= mplot->hypoParms.rms2))
	      inout++;
	    break;

	  case 8:
	    if((mplot->sources[j].acard[i].err >= mplot->hypoParms.err1)
	       && (mplot->sources[j].acard[i].err <= mplot->hypoParms.err2))
	      inout++;
	    break;

	  case 9:
	    if((mplot->sources[j].acard[i].q1[0]) < (mplot->hypoParms.q1 + 63))
	      inout++;
	    break;

	  case 10:
	    if((mplot->sources[j].acard[i].q2[0]) < (mplot->hypoParms.q2 + 63))
	      inout++;
	    break;
	  }
	}

      if(inout >= numcode)
	{
	create_Acard(&mplot->sources[j].acard[i], acrd);
	fprintf(stdout, "%s", acrd);
	fprintf(inf, "%s", acrd);
	k++;
	}
      }
    }

  fprintf(stdout, "\n\n number of points = %d\n", k);
  fprintf(stdout, "---------------------------------\n");
  fclose(inf);
  }

void reset_hypo_onoff(mpic *mplot)
  {
  int i, j;

  for(j = 0; j <= mplot->max_more_src - 1; j++)
    for (i = 0; i < mplot->sources[j].numpoints; i++)
      mplot->sources[j].onoff[i] = 1;
  }

void hypo_selection2(mpic *mplot)
  {
  int i, k = 0, j, icode, inout, kk, numcode, codes[20];
  float tim;

  fprintf(stdout, " -------------------------------- \n\n");

  /* make a vector of the options  */
  numcode = 0;

  if(mplot->hypoParms.t2 > mplot->hypoParms.t1) codes[numcode] = 11;
  if(mplot->hypoParms.z2 > mplot->hypoParms.z1) codes[numcode++] = 1;
  if(mplot->hypoParms.m2 > mplot->hypoParms.m1) codes[numcode++] = 2;
  if(mplot->hypoParms.np2 > mplot->hypoParms.np1) codes[numcode++] = 3;
  if(mplot->hypoParms.ns2 > mplot->hypoParms.ns1) codes[numcode++] = 4;
  if(mplot->hypoParms.g2 > mplot->hypoParms.g1) codes[numcode++] = 5;
  if(mplot->hypoParms.del2 > mplot->hypoParms.del1) codes[numcode++] = 6;
  if(mplot->hypoParms.rms2 > mplot->hypoParms.rms1) codes[numcode++] = 7;
  if(mplot->hypoParms.err2 > mplot->hypoParms.err1) codes[numcode++] = 8;
  if(mplot->hypoParms.q1 > 0) codes[numcode++] = 9;
  if(mplot->hypoParms.q2 > 0) codes[numcode++] = 10;
  if(mplot->hypoParms.intarg > 0) codes[numcode++] = 0;

  if(numcode <= 0)
    {
    reset_hypo_onoff(mplot); 
    return;
    }
   
  fprintf(stderr, "done setting options\n");

  for(j = 0; j <= mplot->max_more_src - 1; j++)
    {
    fprintf(stdout, "\n-------------From Source File %s ---------------\n",
	    mplot->sources[j].file_name);
    for(i = 0; i < mplot->sources[j].numpoints; i++)
      {
      inout = 0;
      for(kk = 0; kk < numcode; kk++)
	{
	icode = codes[kk];
	switch(icode)
	  {
	  case 0:
	    if((mplot->sources[j].loc[i].x > SELXMIN)
	       && (mplot->sources[j].loc[i].x < SELXMAX)
	       && (mplot->sources[j].loc[i].y > SELYMIN)
	       && (mplot->sources[j].loc[i].y < SELYMAX))
	      inout++;
	    break;

	  case 11:
	    tim = atof(mplot->sources[j].acard[i].id);
	    if(tim >= mplot->hypoParms.t1 && tim <= mplot->hypoParms.t2)
	      inout++;
	    break;

	  case 1:
	    if((mplot->sources[j].acard[i].depth >= mplot->hypoParms.z1)
	       && (mplot->sources[j].acard[i].depth <= mplot->hypoParms.z2))
	      inout++;
	    break;

	  case 2:
	    if((mplot->sources[j].acard[i].mag >= mplot->hypoParms.m1)
	       && (mplot->sources[j].acard[i].mag <= mplot->hypoParms.m2))
	      inout++;
	    break;

	  case 3:
	    if((mplot->sources[j].acard[i].nump >= mplot->hypoParms.np1)
	       && (mplot->sources[j].acard[i].nump <= mplot->hypoParms.np2))
	      inout++;
	    break;

          case 4:
	    if((mplot->sources[j].acard[i].nums >= mplot->hypoParms.ns1)
	       && (mplot->sources[j].acard[i].nums <= mplot->hypoParms.ns2))
	      inout++;
	    break;

	  case 5:
	    if((mplot->sources[j].acard[i].gap >= mplot->hypoParms.g1)
	       && (mplot->sources[j].acard[i].gap <= mplot->hypoParms.g2))
	      inout++;
	    break;

	  case 6:
	    if((mplot->sources[j].acard[i].delta >= mplot->hypoParms.del1)
	       && (mplot->sources[j].acard[i].delta <= mplot->hypoParms.del2))
	      inout++;
	    break;

	  case 7:
	    if((mplot->sources[j].acard[i].rms >= mplot->hypoParms.rms1)
	       && (mplot->sources[j].acard[i].rms <= mplot->hypoParms.rms2))
	      inout++;
	    break;

	  case 8:
	    if((mplot->sources[j].acard[i].err >= mplot->hypoParms.err1)
	       && (mplot->sources[j].acard[i].err <= mplot->hypoParms.err2))
	      inout++;
	    break;

	  case 9:
	    if((mplot->sources[j].acard[i].q1[0]) < (mplot->hypoParms.q1 + 63))
	      inout++;
	    break;

	  case 10:
	    if((mplot->sources[j].acard[i].q2[0]) < (mplot->hypoParms.q2 + 63))
	      inout++;
	    break;
	  }
	}
       
      if(inout >= numcode)
	{
	mplot->sources[j].onoff[i] = 1;
	k++;
	}
      else mplot->sources[j].onoff[i] = 0;
      }
    }

  fprintf(stdout, "\n\n number of points = %d\n", k);
  fprintf(stdout, "---------------------------------\n");
  }

void database_source(Widget wij, mpic *mplot, char *call_data)
  {

  hypo_selection2(mplot);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

void reset_database_source(Widget wij, mpic *mplot, char *call_data)
  {

  reset_hypo_onoff(mplot);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

void Add_Outside_Tics(Widget wij, mpic *m, char *call_data)
  {
/*

THIS NEEDS TO BE FIXED UP


*/

  short x, y, w, h;
  int i, ideg, imin, isec;
  char pchar[13];
  float phio, lamo, phi, lam, phimax, lammax, ex, why;

  
  phio = m->origin.phi;
  lamo = m->origin.lam;
  if(m->origin.type <= 1)
    {
    ex = m->origin.maxx;
    why = 0;
    xy2geo(m, &phi, &lam, ex, why);
    lammax = lam;
    ex = 0;
    why = m->origin.maxy;
    xy2geo(m, &phi, &lam, ex, why);
    phimax = phi;
    }
  else
    {
    phimax = m->origin.phimax;
    lammax = m->origin.lammax;
    }

  fprintf(stderr, "orgtype=%d phimin=%f lammin=%f phimax=%f lammax=%f\n",
	  m->origin.type, phio, lamo, phimax, lammax);
  i = m->markup.numpoints;


 phi = smallest_sec(phio, &ideg, &imin, &isec);

  geo2xy(m, phi, lamo, &ex, &why);

  sprintf(pchar, "%d:%2d:%2d", abs(ideg), abs(imin), abs(isec));
  fprintf(stderr, "%d %d %d x=%f y=%f\n", ideg, imin, isec,  ex, why);
  m->markup.stuff[i].m.x = ex;
  m->markup.stuff[i].m.y = why;
  m->markup.stuff[i].code1 = 5;
  m->markup.stuff[i].code2 = 0;
  m->markup.stuff[i].deg = ideg;
  m->markup.stuff[i].min = imin;
  m->markup.stuff[i].ddeg = phi;
  strcpy(m->markup.stuff[i].name, pchar);
  i = ++(m->markup.numpoints);


 lam = smallest_sec(lamo, &ideg, &imin, &isec);

  geo2xy(m, phio, lam, &ex, &why);

  sprintf(pchar, "%d:%2d:%2d", abs(ideg), imin, isec);
  fprintf(stderr, "%d %d %d x=%f y=%f\n", ideg, imin,isec, ex, why);
  m->markup.stuff[i].m.x = ex;
  m->markup.stuff[i].m.y = why;
  m->markup.stuff[i].code1 = 6;
  m->markup.stuff[i].code2 = 0;
  m->markup.stuff[i].deg = ideg;
  m->markup.stuff[i].min = imin;
  m->markup.stuff[i].ddeg = lam;
  strcpy(m->markup.stuff[i].name, pchar);
  i = ++(m->markup.numpoints);

 phi = largest_sec(phimax, &ideg, &imin, &isec);

 
  geo2xy(m, phi, lamo, &ex, &why);
 sprintf(pchar, "%d:%2d:%2d", abs(ideg), imin, isec);
   fprintf(stderr, "%d %d %d x=%f y=%f\n", ideg, imin,isec, ex, why);
 
  m->markup.stuff[i].m.x = ex;
  m->markup.stuff[i].m.y = why;
  m->markup.stuff[i].code1 = 5;
  m->markup.stuff[i].code2 = 0;
  m->markup.stuff[i].deg = ideg;
  m->markup.stuff[i].min = imin;
  m->markup.stuff[i].ddeg = phi;
  strcpy(m->markup.stuff[i].name, pchar);
  i = ++(m->markup.numpoints);


 lam = largest_sec(lammax, &ideg, &imin, &isec);


  geo2xy(m, phio, lam, &ex, &why);

 sprintf(pchar, "%d:%2d:%2d", abs(ideg), imin, isec);
   fprintf(stderr, "%d %d %d x=%f y=%f\n", ideg, imin,isec, ex, why);

  m->markup.stuff[i].m.x = ex;
  m->markup.stuff[i].m.y = why;
  m->markup.stuff[i].code1 = 6;
  m->markup.stuff[i].code2 = 0;
  m->markup.stuff[i].deg = ideg;
  m->markup.stuff[i].min = imin;
  m->markup.stuff[i].ddeg = lam;
  strcpy(m->markup.stuff[i].name, pchar);
  m->markup.numpoints++;

  XtVaGetValues(m->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h, NULL);
  send_repaint(m->wij, 0, 0, m->ScreenX, m->ScreenY);
  }

/* --------------------------------------------------------- */

void Change_Back(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  switch(mplot->back_fill_col)
    {
    case 24:
      mplot->back_fill_col = 0;
      break;

    case 0:
      mplot->back_fill_col = 1;
      break;

    default:
      mplot->back_fill_col = 24;
      break;
    }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

void select_map(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->map_flag = !mplot->map_flag;
  if(mplot->map_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Plot Map", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot Map", NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

void DoGrid_map(Widget wij, mpic *mplot, char *call_data)
  {
  short x, y, w, h;

  mplot->grid_flag = !mplot->grid_flag;
  if(mplot->grid_flag == 0)
    XtVaSetValues(wij,XtNlabel, "- Plot Grid", NULL);
  else XtVaSetValues(wij, XtNlabel, "+ Plot Grid",
	NULL);

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint(mplot->wij, 0, 0, w, h);
  }

/* --------------------------------------------------------- */

void DoGeoTable(Widget wij, mpic *mplot, char *call_data)
  {
  short  x, y, w, h;
  int i, j, k, match, kount, lenlab = 4;

  mplot->geotab_flag = !mplot->geotab_flag;
  if(mplot->geotab_flag == 0)
    XtVaSetValues(wij, XtNlabel, "- Geo Table", NULL);
  else
    {
    XtVaSetValues(wij, XtNlabel, "+ Geo Table", NULL);
    i = 0;
    /* this routine needs some more work! */
    mplot->Formation_count = 0;

    for(kount = 0; kount < mplot->num_map_files; kount++)
      {
      /* while(mplot->map[kount].stroke[i].style != 3) i++;
	 strncpy(mplot->Formation_name[0], mplot->map[kount].stroke[i].name,
	 lenlab);
	 mplot->Formation_color[0] = mplot->map[kount].stroke[i].col; */

      for(i = 0; i < mplot->map[kount].stroke_count; i++)
	{
	if(mplot->map[kount].stroke[i].style == 3)
	  {
	  match = 0;
	  for(j = 0; j < mplot->Formation_count; j++)
	    if(strncmp(mplot->map[kount].stroke[i].name,
		       mplot->Formation_name[j], lenlab) == 0)
	      match = 1;
	  if(match == 0)
	    {
	    strncpy(mplot->Formation_name[mplot->Formation_count],
		    mplot->map[kount].stroke[i].name, lenlab);
	    mplot->Formation_color[mplot->Formation_count] =
	      mplot->map[kount].stroke[i].col;
	    mplot->Formation_count++;
	    }
	  }
	}
      }
    }

  /* clean up the names by removing the underscores  */

  for(i = 0; i < mplot->Formation_count; i++)
    {
    for(k = 0; k < lenlab; k++)
      if(mplot->Formation_name[i][k] == '_')
        mplot->Formation_name[i][k] = ' ';
    }

  XtVaGetValues(mplot->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
		NULL);
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

/* --------------------------------------------------------- */

void Line_Map_Tog(Widget wij, mpic *mplot, char *call_data)
  {


      switch(mplot->map_type)
	{
	case 2:
	  mplot->map_type = 3;
	  XtVaSetValues(wij, XtNlabel, "FILL MAP", NULL);
	  break;

	case 3:   
	  mplot->map_type = 2;
	  XtVaSetValues(wij, XtNlabel, "LINES Only", NULL);
	  break;

	default:

	  break;
	}
   
  
  send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);
  }

void Line_Map_Add(Widget wij, mpic *mplot, char *call_data)
  {

  mplot->add_poly_lines = !mplot->add_poly_lines;
  if(mplot->add_poly_lines == 0)
    XtVaSetValues(wij, XtNlabel, "ADD Lines", NULL);
  else XtVaSetValues(wij, XtNlabel, "NO Lines", NULL);

  if(mplot->add_poly_lines)
    Add_lines_to_map(mplot);
  else 
    send_repaint(mplot->wij, 0, 0, mplot->ScreenX, mplot->ScreenY);

  }

/********************************************************************/

void PopupHelp(Widget w, Widget call_data, Widget dummy)
  {

  XtPopup(call_data, XtGrabNone);
  }

/* help dialog done button */

void HelpDone(Widget w, Widget call_data, Widget d)
  {

  XtPopdown(call_data);
  }

/********************************************************************/

void make_mpic_window(Widget top, mpic *mplot, Font *fonts)
  {
  Widget xp, box, menu, gen, pane, fsel, fsel_shell, subline,
    pshell, hshell, lab, labDone, view;
  int i, bc;
  static phook_t cascadehook[3];
  const char magoptions[3][20] =
    { "Constant", "Exponential", "Linear" };
  char path[MAXPATHLEN+1], *helpstuff = GEOTOUCH_HELP;

  void image_getfile_accept(Widget w, XtPointer clidat, XtPointer calldat);

#if CASCADES
  star = XCreateBitmapFromData(XtDisplay(top),
			       RootWindowOfScreen(XtScreen(top)),
			       star_bits, star_width, star_height);

  cascade_init(apcon, top);   /* initialize cascade library */
#endif

  /* build the interface */

  pane = XtVaCreateManagedWidget("pane", panedWidgetClass, top,
				 XtNwidth, mplot->ScreenX,
				 XtNheight, mplot->ScreenY,
				 XtNx, 10, XtNy, 10, NULL);

  box = XtVaCreateManagedWidget("control", boxWidgetClass, pane, NULL);

  xp = XtVaCreateManagedWidget("viewport", viewportWidgetClass, pane,
			       XtNallowHoriz, FALSE, XtNallowVert, FALSE,
			       NULL);

  gen = XtVaCreateManagedWidget("core", genWidgetClass, xp,
				XtNtranslations,
				XtParseTranslationTable(defaultTranslations),
				XtNdata, mplot, NULL);

  init_mpic_wij(gen, mplot,  fonts);

  mplot->shell = top;
  mplot->vport = xp;

  xp = XtVaCreateManagedWidget("File", menuButtonWidgetClass, box, NULL);
  XtVaGetValues(xp, XtNbackground, &bc, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Quit Window", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Quit_window, mplot);

  xp = XtVaCreateManagedWidget("Restore Size", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_restore, mplot);

  xp = XtVaCreateManagedWidget("Zoom Out", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Zoom_Out, mplot);

  xp = XtVaCreateManagedWidget("Zoom In", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Zoom_In, mplot);

  xp = XtVaCreateManagedWidget("Screen Bound", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_snap, mplot);

  xp = XtVaCreateManagedWidget("Aspect 1-1", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Aspect_1_1, mplot);

  xp = XtVaCreateManagedWidget("PostScript", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Postscript, mplot);

  xp = XtVaCreateManagedWidget("PWD", smeBSBObjectClass, menu, NULL);    
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)list_PWD, mplot);

  xp = XtVaCreateManagedWidget("change dir", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)change_dir, mplot);

  xp = XtVaCreateManagedWidget("New Org", smeBSBObjectClass, menu, NULL);    
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)new_org, mplot);
  
  xp = XtVaCreateManagedWidget("Legend", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Get_wells_leg, mplot);
  

  make_info_menu( menu, mplot); 

  xp = XtVaCreateManagedWidget("Quit", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Quit, mplot);

  xp = XtVaCreateManagedWidget("REFRESH", commandWidgetClass, box, NULL);    
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Refresh, mplot);

  /* sources Menu  */

  xp = XtVaCreateManagedWidget("Sources", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("* Plot Sources", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_source, mplot);

  xp = XtVaCreateManagedWidget("* Color-Depths", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Color_depth_source, mplot);

  xp = XtVaCreateManagedWidget("Source Size", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_SourceSize, mplot);

  xp = XtVaCreateManagedWidget("Fancy Plot", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Fancy_Src, mplot);

  /* xp = XtVaCreateManagedWidget("Mag Size", smeBSBObjectClass, menu, NULL);
     XtAddCallback(xp, XtNcallback, (XtCallbackProc)Mag_Src, mplot); */


  xp = XtVaCreateManagedWidget("Mag Scale", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Mag_Scale, mplot);


#if CASCADES

  xp = XtVaCreateManagedWidget("Mag Options", smeBSBObjectClass, menu, NULL);
  submenu = XtVaCreatePopupShell("submenu", simpleMenuWidgetClass, top,
				 XtNlabel, "Mag Options",
				 XtNbackground, bc, NULL);

  subline = XtVaCreateManagedWidget("subline", smeLineObjectClass, submenu,
				    NULL);

  for(i = 0; i < 3; i++)
    {
    cascadehook[i].a = (void *)i;
    cascadehook[i].b = (void *)mplot;

    subpane[i] = XtVaCreateManagedWidget("subpane", smeBSBObjectClass, submenu,
					 XtNlabel, magoptions[i],
					 XtNleftMargin, 30,
					 XtNrightMargin, 5,
					 /* XtNleftBitmap, star, */ NULL);
    
    XtAddCallback(subpane[i], XtNcallback, accept_mag_opt,
		  (XtPointer)&(cascadehook[i]));
    }

  /* register menu as a parent menu */

  cascade_menu(menu);

  /* link the submenu to option 5 of the parent menu */

  cascade_link(menu, submenu, 5);

#endif

  xp = XtVaCreateManagedWidget("Save Source", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)SAVE_Src, mplot);


  xp = XtVaCreateManagedWidget("Append Source", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)APPEND_Src, mplot);

  xp = XtVaCreateManagedWidget("Save Extensions", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Extend_Src, mplot);

  xp = XtVaCreateManagedWidget("Set DISCO", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Run_DB, mplot);


  xp = XtVaCreateManagedWidget("SAVE FILE", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_change_save_file,
		mplot);

  xp = XtVaCreateManagedWidget("* Src Output", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)output_source, mplot);

  xp = XtVaCreateManagedWidget("Get More Sources", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_moresrc, mplot);

  xp = XtVaCreateManagedWidget("* Plot More Sources", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_more_source, mplot);

  xp = XtVaCreateManagedWidget("* Connect Sources", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)connect_source, mplot);

  xp = XtVaCreateManagedWidget("Layer-Source", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)layer_source, mplot);

  xp = XtVaCreateManagedWidget("Time Sources", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_time_source, mplot);

  xp = XtVaCreateManagedWidget("Select Poly", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)poly_source, mplot);

  xp = XtVaCreateManagedWidget("Hypo Stats", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Hypo_Stats, mplot);

  xp = XtVaCreateManagedWidget("Select DataBase", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)database_source, mplot);
  
    xp = XtVaCreateManagedWidget("Reset DataBase", smeBSBObjectClass, menu,
				 NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)reset_database_source, mplot);

  make_hypo_pop( menu, mplot);

  /* DIALOG STUFF */

  mplot->pshell = pshell = XtCreatePopupShell("pshell",
					      transientShellWidgetClass,
					      top, NULL, 0);
  mplot->dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass,
    pshell, XtNaccelerators, XtParseAcceleratorTable(Dialog_Accelerator),
    NULL);

  dialogDone = XtVaCreateManagedWidget("OK", commandWidgetClass,
				       mplot->dialog, XtNwidth, 60,
				       NULL);

  DialogDone_mplot = mplot;
  XtInstallAccelerators( mplot->dialog, dialogDone);

  xp = XtVaCreateManagedWidget("Cancel", commandWidgetClass, mplot->dialog,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)DialogQuit, mplot);

  /* Station menu */

  xp = XtVaCreateManagedWidget("Stations", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("* Plot Stations", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_station, mplot);

  xp = XtVaCreateManagedWidget("* Plot Station Names", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_station_names, mplot);

  xp = XtVaCreateManagedWidget("Station Size", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_StationSize, mplot);

  xp = XtVaCreateManagedWidget("Get Special Station", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_specsta, mplot);

  xp = XtVaCreateManagedWidget("Sel Stations", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_Sta, mplot);

  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);

  xp = XtVaCreateManagedWidget("Get Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_pfile, mplot);

  xp = XtVaCreateManagedWidget("Plot Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Plot_pfile, mplot);

  xp = XtVaCreateManagedWidget("Name Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Name_pfile, mplot);

  xp = XtVaCreateManagedWidget("Sel Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Do_SelPoints, mplot);
  
  xp = XtVaCreateManagedWidget("SelPoly Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Do_SelPolyPoints, mplot);

  /* Map Menu */

  xp = XtVaCreateManagedWidget("Map", menuButtonWidgetClass, box, NULL);

  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("* Plot Map", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_map, mplot);

  xp = XtVaCreateManagedWidget("* Plot Grid", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)DoGrid_map, mplot);

  xp = XtVaCreateManagedWidget("Get Geo Map", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_moremap, mplot);

  xp = XtVaCreateManagedWidget("* Geo Table", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)DoGeoTable, mplot);

  xp = XtVaCreateManagedWidget("Map Code", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_map_code, mplot);

  xp = XtVaCreateManagedWidget("Sel Map", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Do_SelMap, mplot);

  xp = XtVaCreateManagedWidget("Points Map", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_PointsMap, mplot);

  xp = XtVaCreateManagedWidget("Find Point", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Do_FindMap, mplot);


  xp = XtVaCreateManagedWidget("Dump Sel Map", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_SelMap, mplot);

  xp = XtVaCreateManagedWidget("Dump Full Map", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_FullMap, mplot);


  xp = XtVaCreateManagedWidget("Lines Only", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Line_Map_Tog, mplot);

  xp = XtVaCreateManagedWidget("Add Lines", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Line_Map_Add, mplot);

  xp = XtVaCreateManagedWidget("LAT LON", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Plot_Map_Grid, mplot);

  xp = XtVaCreateManagedWidget("Outside Tics", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Add_Outside_Tics, mplot);

  xp = XtVaCreateManagedWidget("BackGround Col", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Change_Back, mplot);

 
 /* 
    xp = XtVaCreateManagedWidget("Dump Map", smeBSBObjectClass, menu,
    NULL);
    XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_Map, mplot);
*/



  /* Wells Menu */

  xp = XtVaCreateManagedWidget("Vector/Well", menuButtonWidgetClass, box,
			       NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("* Plot Wells", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_Wells, mplot);

  xp = XtVaCreateManagedWidget("Get Wells", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Wells, mplot);

  xp = XtVaCreateManagedWidget("* Plot Well Names", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_wells_names, mplot);

  xp = XtVaCreateManagedWidget("* Project Wells", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)project_wells, mplot);

  xp = XtVaCreateManagedWidget("* Well Symbols", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_Symbol_wells, mplot);

  xp = XtVaCreateManagedWidget("Wells in Layers", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_wells_in_layers, mplot);

  xp = XtVaCreateManagedWidget("Xsec Project All", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_wells_Project_all, mplot);

  xp = XtVaCreateManagedWidget("Increase Thickness", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Thicker_wells, mplot);

  xp = XtVaCreateManagedWidget("Decrease Thickness", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Thinner_wells, mplot);

  xp = XtVaCreateManagedWidget("Legend", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Get_wells_leg, mplot);

  xp = XtVaCreateManagedWidget("Dump Wells", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_wells, mplot);

  xp = XtVaCreateManagedWidget("* Project Dips", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)project_well_dips, mplot);



  

  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);

  xp = XtVaCreateManagedWidget("Plot Ellipses", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_LIPS, mplot);

  xp = XtVaCreateManagedWidget("Get Ellipses", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Lips , mplot);

  xp = XtVaCreateManagedWidget("Scale Ellipses", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Scale_Lips , mplot);


  /* Focals Menu */

  xp = XtVaCreateManagedWidget("Focals", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("* Plot Focals", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback,(XtCallbackProc) PLOT_Foc, mplot);

  xp = XtVaCreateManagedWidget("Get Focals", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback,(XtCallbackProc) Popup_Foc, mplot);

  xp = XtVaCreateManagedWidget("Sphere Size", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_SphereSize, mplot);

  xp = XtVaCreateManagedWidget("Focal Style", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback,(XtCallbackProc) Popup_FocalStyle, mplot);

  xp = XtVaCreateManagedWidget("* Explode Focals", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_explode, mplot);

  xp = XtVaCreateManagedWidget("* Magnitude Scale", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_scale_by_mag, mplot);

  xp = XtVaCreateManagedWidget("Color", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_focal_color, mplot);

  xp = XtVaCreateManagedWidget("SDR", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)SDR_selfoc , mplot);

  xp = XtVaCreateManagedWidget("Summary", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_foc_summary   , mplot);

  xp = XtVaCreateManagedWidget("PS Summary", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PS_focal_summary, mplot);

  xp = XtVaCreateManagedWidget("Auto Summary", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_auto_foc_summary , mplot);
  
  xp = XtVaCreateManagedWidget("Layer-Foc", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)layer_foc, mplot);

  xp = XtVaCreateManagedWidget("Dump Ext", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_DumpFocal , mplot);


  xp = XtVaCreateManagedWidget("Select Foc DataBase", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)database_focal, mplot);
  
    xp = XtVaCreateManagedWidget("Reset Foc DataBase", smeBSBObjectClass, menu,
				 NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)reset_database_focal, mplot);

  make_focal_pop( menu, mplot);

  /* Contour Menu */

  xp = XtVaCreateManagedWidget("Contour", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("ContourField", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_GetField, mplot);

  xp = XtVaCreateManagedWidget("Plot Contour", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Plot_Contour, mplot);

  xp = XtVaCreateManagedWidget("Raster", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Raster_Contour, mplot);

  xp = XtVaCreateManagedWidget("Dump Map", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Contour_Map, mplot);

  xp = XtVaCreateManagedWidget("Plot Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Contour_Points, mplot);

  xp = XtVaCreateManagedWidget("Plot Values", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Contour_Vals, mplot);

  xp = XtVaCreateManagedWidget("Dump Values", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_Contour_Points, mplot);




  xp = XtVaCreateManagedWidget("Palette", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Change_Cont_Palette , mplot);

  make_cont_menu(menu, mplot); 

  /* Image Menu */

  xp = XtVaCreateManagedWidget("Image", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Increment Z", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Increment_Layer, mplot);

  xp = XtVaCreateManagedWidget("Decrement Z", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Decrement_Layer, mplot);

  xp = XtVaCreateManagedWidget("Plot Image", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Plot_Image, mplot);

  xp = XtVaCreateManagedWidget("Get Image", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Get_Image, mplot);

/*   xp = XtVaCreateManagedWidget("Get Image 2", smeBSBObjectClass, menu, NULL); */
/*   XtAddCallback(xp, XtNcallback, (XtCallbackProc)Get_Image_GLOBE2, mplot); */

  xp = XtVaCreateManagedWidget("Skip Value", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Change_Skip, mplot);
  
  xp = XtVaCreateManagedWidget("Z-Layer", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Change_Layer, mplot);

  xp = XtVaCreateManagedWidget("Top(Layer 1)", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Top_Layer, mplot);

  xp = XtVaCreateManagedWidget("Palette", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Change_Palette, mplot);

  xp = XtVaCreateManagedWidget("Scale Lay/Glob", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Switch_Image_Scale, mplot);

  xp = XtVaCreateManagedWidget("Log/Linear Scale", smeBSBObjectClass,
                               menu, NULL);
  XtAddCallback(xp, XtNcallback,
                (XtCallbackProc)Switch_Log_Linear_Image_Scale, mplot);

  xp = XtVaCreateManagedWidget("User Min-Max", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Image_MINMAX, mplot);


  xp = XtVaCreateManagedWidget("User Min", smeBSBObjectClass, menu,
NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Image_Min, mplot);

  xp = XtVaCreateManagedWidget("User Max", smeBSBObjectClass, menu,
NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Image_Max, mplot);

xp = XtVaCreateManagedWidget("Export Layer", smeBSBObjectClass, menu,
NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Image_Export, mplot);

xp = XtVaCreateManagedWidget("Mask", smeBSBObjectClass, menu,
NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Mask_Image, mplot);





  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);

  xp = XtVaCreateManagedWidget("Integrate", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_Integrate_Image , mplot);

  xp = XtVaCreateManagedWidget("Hi_Lite", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_HiLite, mplot);

  xp = XtVaCreateManagedWidget("Save_Target", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Save_Target_Image, mplot);

  xp = XtVaCreateManagedWidget("Wire Render", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Image_Render, mplot);



  xp = XtVaCreateManagedWidget("Image Info", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Image_Info, mplot);

  xp = XtVaCreateManagedWidget("Dump RGB", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)RGB_Info, mplot);

  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);

#if 1
  xp = XtVaCreateManagedWidget("PostScript All Lay", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Postscript_all_lay, mplot);
#endif


  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);

  xp = XtVaCreateManagedWidget("Satellite Plot", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Plot_Sat, mplot);

  xp = XtVaCreateManagedWidget("Shift Sat", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Shift_Sat, mplot);

#if FILESEL
    {
    Colormap cmap;  

    XtVaGetValues(top, XtNcolormap, &cmap, NULL);

    fsel_shell = XtVaCreatePopupShell("fshell", transientShellWidgetClass, top,
				      XtNtitle, "Get Image File",
				      XtNcolormap, cmap, NULL);
    getcwd(path, MAXPATHLEN);

    fsel = XtVaCreateManagedWidget("fsel", fileSelectWidgetClass, fsel_shell,
				   XtNpathName, path, NULL);
    XtAddCallback(fsel, XtNcallback, (XtCallbackProc)image_getfile_accept,
		  (XtPointer)mplot);

    xp = XtVaCreateManagedWidget("Get FILE", smeBSBObjectClass, menu, NULL);
    XtAddCallback(xp, XtNcallback, (XtCallbackProc)Get_Image_FILE,
		  (XtPointer)fsel_shell);
    }
#endif


  /* Palette Menu */

  xp = XtVaCreateManagedWidget("Palette", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);


  xp = XtVaCreateManagedWidget("Reverse_Palette", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Reverse_Palette, mplot);

  xp = XtVaCreateManagedWidget("New_Palette", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)New_Palette, mplot);

  xp = XtVaCreateManagedWidget("Reset_Palette", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Reset_Palette, mplot);

  xp = XtVaCreateManagedWidget("Change_Pal Bounds", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Bound_Palette, mplot);

 xp = XtVaCreateManagedWidget("Palette Info", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Palette_Info, mplot);




  /* X-sec Menu */

  xp = XtVaCreateManagedWidget("X-Secs", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Depth Range", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_changedepth, mplot);

  xp = XtVaCreateManagedWidget("HalfWidth", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_halfwidth, mplot);

  xp = XtVaCreateManagedWidget("* Plot X-Secs", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_xsec_plot, mplot);

  xp = XtVaCreateManagedWidget("SAVE X-Secs", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)SAVE_Xsec, mplot);

  xp = XtVaCreateManagedWidget("Load X-Secs", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Load_Xsec, mplot);
  
  xp = XtVaCreateManagedWidget("Set X-Secs", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Set_1_Xsec, mplot);

  make_xdip_menu(menu, mplot);

  /* Special Menu */

  xp = XtVaCreateManagedWidget("Special", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Restore Size", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_restore, mplot);

  xp = XtVaCreateManagedWidget("Postscript", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Postscript, mplot);

  xp = XtVaCreateManagedWidget("* BLACK/WHITE", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_B_W, mplot);

  xp = XtVaCreateManagedWidget("Dump Colors", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_Colors, mplot);


  xp = XtVaCreateManagedWidget("Plot Targets", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_Boxes, mplot);

  xp = XtVaCreateManagedWidget("Erase Targets", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Erase_Boxes, mplot);

  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);


  xp = XtVaCreateManagedWidget("New Polygon", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Poly_Start, mplot);

  xp = XtVaCreateManagedWidget("Spline", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_Draw_Spline, mplot);

  xp = XtVaCreateManagedWidget("Replot Poly", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_Replot_Poly, mplot);

  xp = XtVaCreateManagedWidget("Replot Target", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_Replot_Target , mplot);

 xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);

  xp = XtVaCreateManagedWidget("Get 3D-Body", smeBSBObjectClass, menu, NULL);
  /* XtAddCallback(xp, XtNcallback, (XtCallbackProc)ThreeD_Body, mplot); */
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_moreWire, mplot);

  xp = XtVaCreateManagedWidget("Plot 3D-Body", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Toggle_ThreeD_Body, mplot);

  xp = XtVaCreateManagedWidget("Hoz Slab", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_HozDef, mplot);

  xp = XtVaCreateManagedWidget("Spin Events", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Spin_Targ, mplot);


  /* Misc Menu */

  xp = XtVaCreateManagedWidget("Misc", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);
  xp = XtVaCreateManagedWidget("Restore Size", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)select_restore, mplot);
  xp = XtVaCreateManagedWidget("Store Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)store_points, mplot);

  xp = XtVaCreateManagedWidget("=========", smeLineObjectClass, menu, NULL);

  xp = XtVaCreateManagedWidget("Create Label", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Labels , mplot);
  xp = XtVaCreateManagedWidget("ReSet Label", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Set_Cur_Label , mplot);
  xp = XtVaCreateManagedWidget("Save Labels", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Save_Labels , mplot);
  xp = XtVaCreateManagedWidget("Get Labels", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Read_Labels , mplot);


  xp = XtVaCreateManagedWidget("HELP", commandWidgetClass, box,	NULL);

  hshell = XtVaCreatePopupShell("pshell", transientShellWidgetClass, top,
				NULL);

  view = XtVaCreateManagedWidget("boo2", boxWidgetClass, hshell, NULL);

  labDone = XtVaCreateManagedWidget("QUIT HELP", commandWidgetClass, view,
				    NULL);

  view = XtVaCreateManagedWidget("boo", viewportWidgetClass, view,
				 XtNallowVert, TRUE, XtNallowHoriz, TRUE,
				 XtNwidth, 600, XtNheight, 700,	NULL);

  lab = XtVaCreateManagedWidget("Help", labelWidgetClass, view,
				XtNlabel, helpstuff, NULL);

  mplot->labshell= XtVaCreateManagedWidget("dislabel", labelWidgetClass, box,
    XtNborderWidth, 0, XtNlabel, "Click Info                                     ", XtNfromVert, 0,
    XtNleft, XtChainLeft, NULL);


  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PopupHelp, hshell);
  XtAddCallback(labDone, XtNcallback, (XtCallbackProc)HelpDone, hshell);

  /* fprintf(stderr,"Done panel\n"); */

  XtVaSetValues(mplot->shell, XtNx, 10, XtNy, 10, NULL);

  XtRealizeWidget(top);

  

  

  /* fprintf(stderr,"Done realizing\n"); */
  }

/* --------------------------------------------------------- */
