
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"

/* --- global variables --- */

double XSHIFT, YSHIFT;

/* --- function prototypes --- */

void albers_EAsphr_xy(float phi,float lam, float *x, float *y);
void albers_EAsphr_ll(float *phi, float *lam, float x, float y);
void set_albers_EA_sphere(float phi1, float phi2, float phi0, float lam0);
/*******************/
void set_merc_sphere(float lam0);
void merc_sphr_xy(float phi, float lam, float *x, float *y);
void merc_sphr_ll(float *phi, float *lam, float x, float y);
/*******************/
void set_miller_sphere(float lam0);
void miller_sphr_xy(float phi, float lam, float *x, float *y);
void miller_sphr_ll(float *phi, float *lam, float x, float y);
/*******************/
void jgclc(float phio, float lamo, float phi, float lam, float *x, float *y);
void jlcgc(float phio, float lamo, float *phi, float *lam, float ex,
	   float why);
/*******************/
void set_ngclc(float phi, float lam);
void ngclc(float phi, float lam, float *x, float *y);
void nlcgc(float *phi, float *lam, float ex, float why);
/*******************/
void set_no_proj(float phi, float lam);
void no_proj_2lc(float phi, float lam, float *x, float *y);
void no_proj_2gc(float *phi, float *lam, float ex, float why);
/*******************/

void set_UTM_sphere(float phi0, float lam0);
void utm_sphr_xy(float phi, float lam, float *x, float *y);
void utm_sphr_ll(float *phi, float *lam, float x, float y);
/*******************/
void set_UTM_ellipsoid(float phi0, float lam0);

void utm_ellipsoid_xy(float phi, float lam, float *x, float *y);
void utm_ellipsoid_ll(float *phi, float *lam, float x, float y);
/*******************/
void set_Lambert_Az_sphere(float lam0, float phi1);
void Lambert_Az_sphr_xy(float phi, float lam, float *x, float *y);
void Lambert_Az_sphr_ll(float *phi, float *lam, float x, float y);

/******************/
/* FUNC DEF */ float fix_lon(float lon)
  {
     if(lon>=-180. && lon<180.0) return(lon);
     if(lon>=180) return( lon - 360.0);
     if(lon < (-180.0) ) return( 360.0+lon);
     return(lon);
  }




/* --- functions --- */
/* FUNC DEF */void get_TARG_bounds(ORG *origin, float *lat, float *lon)
  {
  float phi, lam;
  
  /*  upper left corner  */
  jlcgc(origin->phi, origin->lam, &phi, &lam,
	origin->maxy, origin->minx);
  *lat = phi;
  /* fprintf(stderr,"get_TARG 1: %f %f\n", phi, lam); */
  
     
  /*  lower right  corner  */
  jlcgc(origin->phi, origin->lam, &phi, &lam, 
	origin->miny, origin->maxx);
  /* fprintf(stderr,"get_TARG 2: %f %f\n", phi, lam); */
      
  *lon = lam;

  /*  upper right corner  */
  jlcgc(origin->phi, origin->lam, &phi, &lam, 
	origin->maxy, origin->maxx);
  *lat = phi;
  *lon = lam;
  /* fprintf(stderr,"get_TARG 3: %f %f\n", phi, lam); */
 
  /*  upper right corner  */
/*
  fprintf(stderr,"get_TARG_bounds O: %f %f\n", origin->phi, origin->lam); 
  fprintf(stderr,"get_TARG_bounds: %f %f\n", phi, lam); 
  fprintf(stderr,"get_TARG: P1 %f %f P2 %f %f\n",  
	  origin->minx, origin->maxy, origin->maxx,  origin->miny ); 
  fprintf(stderr," Org min: %f %f\n", origin->phimin, origin->lammin); 
  fprintf(stderr," Org max: %f %f\n", origin->phimax, origin->lammax); 
*/
  }

/* FUNC DEF */void start_Lambert_Az_sphr( float phi0, float lam0, float phi,  float lam)
  {
  float x1=0, y1=0;

  set_Lambert_Az_sphere( phi0, lam0);

  Lambert_Az_sphr_xy(phi, lam, &x1, &y1);

  /* */
  XSHIFT = x1, YSHIFT = y1;

  fprintf(stderr,"setting Lambert_Az_sphere: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
  }


/* FUNC DEF */void start_utm_sphr(float phi1, float lam1)
  {
  float x1=0, y1=0;

  set_UTM_sphere(phi1, lam1);

  /* utm_sphr_xy(phi1, lam1, &x1, &y1); */
  XSHIFT = x1, YSHIFT = y1;

  fprintf(stderr,"setting utm_sphr: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
  }

/* FUNC DEF */void start_utm_ellipsoid(float phi1, float lam1)
  {
  float x1=0, y1=0;

  set_UTM_ellipsoid(phi1, lam1);

  /* utm_ellipsoid_xy(phi1, lam1, &x1, &y1); */
  XSHIFT = x1, YSHIFT = y1;

  fprintf(stderr,"setting utm_ellpsoid: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
  }

/* FUNC DEF */void start_cen_utm_sphr(ORG *origin)
  {

  float bx1, bx2, by1, by2, phio, lamo,  phi, lam, x1, y1;

  jlcgc(origin->phi, origin->lam, &phi, &lam,
	origin->maxy, origin->minx);

  bx2 = phi, by1 = lam;

  jlcgc(origin->phi, origin->lam, &phi, &lam, 
	origin->miny, origin->maxx);
  bx1 = phi, by2 = lam;

  phio = origin->phi;
  phio = (bx1 + bx2) / 2.0;
  lamo = (by1 + by2) / 2.0;

  fprintf(stderr,"setting cen_utm_sphere: bx2=%f bx1=%f phio=%f lamo=%f \n",
	  bx2, bx1, phio,lamo);

  set_UTM_sphere(phio, lamo);

  utm_sphr_xy(origin->phi, origin->lam, &x1, &y1);
  XSHIFT = x1, YSHIFT = y1;


  fprintf(stderr,"setting cen_utm_sphr: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
  }

/* FUNC DEF */void start_cen_utm_ellipsoid(ORG *origin )
  {

  float bx1, bx2, by1, by2, phio, lamo,  phi, lam, x1, y1;

  jlcgc(origin->phi, origin->lam, &phi, &lam,
	origin->maxy, origin->minx);

  bx2 = phi, by1 = lam;

  jlcgc(origin->phi, origin->lam, &phi, &lam, 
	origin->miny, origin->maxx);
  bx1 = phi, by2 = lam;

  phio = origin->phi;
  phio = (bx1 + bx2) / 2.0;
  lamo = (by1 + by2) / 2.0;

  fprintf(stderr,"setting cen_utm_ellipsoid: bx2=%f bx1=%f phio=%f lamo=%f \n",
	  bx2, bx1, phio,lamo);

  set_UTM_ellipsoid(phio, lamo);

  utm_ellipsoid_xy(origin->phi, origin->lam, &x1, &y1);
  XSHIFT = x1, YSHIFT = y1;

  fprintf(stderr,"setting cen_utm_ellipsoid: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
  }


/* FUNC DEF */void start_albers(ORG *origin)
  {
  float bx1, bx2, by1, by2, phio, lamo, phi1, lam1, phi, lam, x1, y1;
  
  

  switch(origin->type)
    {
    case 1:
      {


      get_TARG_bounds(origin, &phi, &lam);
      
      bx1 = origin->phi;
      by1 = origin->lam;
      bx2 = phi;
      by2 = lam;

      phio = (bx1 + bx2) / 2.0;
      lamo = (by1 + by2) / 2.0;
fprintf(stderr,"%f %f\n",by1,  by2);
      fprintf(stderr,"setting albers: bx2=%f bx1=%f phio=%f lamo=%f \n",
	      bx2, bx1, phio,lamo);
    

      bx1 = origin->phimin;
      bx2 = origin->phimax;
      by1 = origin->lammin;
      by2 = origin->lammax;
    
      phio = (bx1 + bx2) / 2.0;
      lamo = (by1 + by2) / 2.0;
    
      fprintf(stderr,"setting albers: bx2=%f bx1=%f phio=%f lamo=%f \n",
	      bx2, bx1, phio,lamo);
    
      set_albers_EA_sphere(bx1, bx2, phio, lamo);
      phi1 = origin->phi;
      lam1 = origin->lam;
    
      albers_EAsphr_xy(phi1, lam1, &x1, &y1);
      XSHIFT = x1, YSHIFT = y1;
    
      fprintf(stderr,"setting albers: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
      }
  
    break;
  
    case 2:
      {
    
      bx1 = origin->phimin;
      bx2 = origin->phimax;
      by1 = origin->lammin;
      by2 = origin->lammax;
  
      phio = (bx1 + bx2) / 2.0;
      lamo = (by1 + by2) / 2.0;



      set_albers_EA_sphere(bx1, bx2, phio, lamo);
      phi1 = origin->phi;
      lam1 = origin->lam;
      albers_EAsphr_xy( phi1, lam1, &x1, &y1);
      XSHIFT = x1, YSHIFT = y1;

      fprintf(stderr,"setting albers2: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
      }
  
    break;
  
  
    default:
      {
    
      get_TARG_bounds(origin, &phi, &lam);
      
      bx1 = origin->phi;
      by2 = lam;
      bx2 = phi;
      by2 = origin->lam;
    
      phio = origin->phi;
      phio = (bx1 + bx2) / 2.0;
      lamo = (by1 + by2) / 2.0;

      fprintf(stderr,"setting albers: bx2=%f bx1=%f phio=%f lamo=%f \n",
	      bx2, bx1, phio,lamo);

      set_albers_EA_sphere(bx2, bx1, phio, lamo);
      phi1 = origin->phi;
      lam1 = origin->lam;

      albers_EAsphr_xy(phi1, lam1, &x1, &y1);
      XSHIFT = x1, YSHIFT = y1;

      fprintf(stderr,"setting albers: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
      }
  
    break;
  
  
  
  
    }
  
  }



/* FUNC DEF */void start_merc_sphr(ORG *origin)
  {
  float x1, y1, phi, lam, lon1, lon2;
  float bx1, by1, bx2, by2, cenlon, phi1, lam1;
  

  switch(origin->type)
    {
    case 1:
      {

      get_TARG_bounds(origin, &phi, &lam);
      bx1 = origin->phi;
      by2 = lam;
      bx2 = phi;
      by1 = origin->lam;
      cenlon = (by1+by2) / 2;
      set_merc_sphere(cenlon);
      phi1 = origin->phi;
      lam1 = origin->lam;
      merc_sphr_xy(phi1, lam1, &x1, &y1);
      XSHIFT = x1, YSHIFT = y1;
      
      fprintf(stderr,"setting merc: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
      }
    break;
    
    case 2:
      {

      lon1 = origin->lammin;
      lon2 = origin->lammax;
      cenlon = (lon1 + lon2) / 2;
      set_merc_sphere(cenlon);
      phi1 = origin->phi;
      lam1 = origin->lam;
      merc_sphr_xy(phi1, lam1, &x1, &y1);
      XSHIFT = x1, YSHIFT = y1;
      
      fprintf(stderr,"setting merc: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
      }
    break;
    

    default:
      {

      get_TARG_bounds(origin, &phi, &lam);
      bx1 = origin->phi;
      by2 = lam;
      bx2 = phi;
      by1 = origin->lam;
      cenlon = (by1+by2) / 2;
      set_merc_sphere(cenlon);
      phi1 = origin->phi;
      lam1 = origin->lam;
      merc_sphr_xy(phi1, lam1, &x1, &y1);
      XSHIFT = x1, YSHIFT = y1;
      
      fprintf(stderr,"setting merc: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
      }
    break;
    
    }
  
  }

    
/* FUNC DEF */void start_miller_sphr(float phi1, float lam1, float lamo)
  {
  float x1, y1;
  fprintf(stderr,"%f %f %f\n",phi1, lam1, lamo);
  
  set_miller_sphere(lamo);

  miller_sphr_xy( phi1, lam1, &x1, &y1);
  XSHIFT = x1, YSHIFT = y1;

  fprintf(stderr,"setting miller: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
  }

/* FUNC DEF */void start_ngclc(float phi1, float lam1)
  {
  float x1, y1;

  set_ngclc(phi1, lam1);
  ngclc(phi1, lam1, &x1, &y1);
  XSHIFT = x1, YSHIFT = y1;

  fprintf(stderr, "setting ngclc: XSHIFT=%f YSHIFT=%f \n", XSHIFT, YSHIFT);
  }

/* FUNC DEF */void start_no_proj(float phi1, float lam1)
  {

  set_no_proj(phi1, lam1);
  }

/* FUNC DEF */int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y)
  {
  float x1, y1, p1, p2;

  switch(mplot->project_type)
    {
    case 0:
      p1 = phi, p2 = lam;

      ngclc(p1, p2, &y1, &x1);
      *x = x1, *y = y1;
      return(1);
      break;

    case 1:
      jgclc(mplot->origin.phi, mplot->origin.lam, phi, lam, &y1, &x1);
      *x = x1, *y = y1;
      return(1);
      break;

    case 2:
      p1 = phi, p2 = lam;

      albers_EAsphr_xy(p1, p2, &x1, &y1);
      *x = x1 - XSHIFT;
      *y = y1 - YSHIFT;
      return(1);
      break;
 
    case 3:
      p1 = phi, p2 = lam;

      merc_sphr_xy(p1, p2, &x1, &y1);
      *x = x1 - XSHIFT;
      *y = y1 - YSHIFT;
      return(1);
      break;

    case 4:
       p1 = phi, p2 = lam;

      miller_sphr_xy(p1, p2, &x1, &y1);
      *x = x1 - XSHIFT;
      *y = y1 - YSHIFT;
      return(1);
      break;

    case 5:
      no_proj_2lc(phi, lam, &x1, &y1);
      *x = x1, *y = y1;
      return(1);
      break;
   case 6:
      utm_sphr_xy(phi, lam, &x1, &y1);
      *x = x1, *y = y1;
      return(1);
      break;

   case 7:
      utm_ellipsoid_xy(phi, lam, &x1, &y1);
      *x = x1, *y = y1;
      return(1);
      break;

   case 8:
      utm_sphr_xy(phi, lam, &x1, &y1);
      *x = x1- XSHIFT, *y = y1- YSHIFT;
      return(1);
      break;

   case 9:
      utm_ellipsoid_xy(phi, lam, &x1, &y1);
     *x = x1- XSHIFT, *y = y1- YSHIFT;
      return(1);
      break;

   case 10:
      Lambert_Az_sphr_xy(phi, lam, &x1, &y1);
     *x = x1- XSHIFT, *y = y1- YSHIFT;
      return(1);
      break;



    default:
      jgclc(mplot->origin.phi, mplot->origin.lam, phi, lam, &y1, &x1);
      *x = x1, *y = y1;
      return(1);
      break;
    }
  return(0);
  }

/* FUNC DEF */int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y)
  {
  float x1,y1, p1, p2;

  switch(mplot->project_type)
    {
    case 0:
      x1 = x, y1 = y;
      nlcgc(&p1, &p2, y1,  x1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 1:
      x1 = x, y1 = y;
      jlcgc(mplot->origin.phi, mplot->origin.lam, &p1, &p2, y1, x1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 2:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      albers_EAsphr_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 3:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      merc_sphr_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 4:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      miller_sphr_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 5:
      x1 = x, y1 = y;
      no_proj_2gc(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;
    case 6:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      utm_sphr_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 7:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      utm_ellipsoid_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 8:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      utm_sphr_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;

    case 9:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      utm_ellipsoid_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;
      
    case 10:
      x1 = (x + XSHIFT);
      y1 = y + YSHIFT;
      Lambert_Az_sphr_ll(&p1, &p2, x1, y1);
      *phi = p1, *lam = p2;
      return(1);
      break;


    default:
      x1 = x, y1 = y;

      jlcgc(mplot->origin.phi, mplot->origin.lam, &p1, &p2, y1, x1);
      *phi = p1, *lam = p2;
      return(1);
      break;
    }
  return(0);
  }

/* FUNC DEF */int geo2xy_2(int type, float phi1, float lam1, float phi, float lam, float *x,
	     float *y)
  {
  float x1,y1, p1, p2;

  switch(type)
    {
    case 0:
      p1 = phi,	p2 = lam;
      ngclc(p1, p2, &y1, &x1);
      *x = x1, *y = y1;
      return(1);
      break;

    case 1:
      jgclc(phi1, lam1, phi, lam, &y1, &x1);
      *x = x1, *y = y1;
      return(1);
      break;

    case 2:
      p1 = phi;
      p2 = lam;
      albers_EAsphr_xy(p1, p2, &x1, &y1);
      *x = x1 - XSHIFT;
      *y = y1 - YSHIFT;
      return(1);
      break;

    case 3:
      p1 = phi, p2 = lam;
      merc_sphr_xy(p1, p2, &x1, &y1);
      *x = x1 - XSHIFT;
      *y = y1 - YSHIFT;
      return(1);
      break;

    case 4:
       p1 = phi, p2 = lam;
      miller_sphr_xy(p1, p2, &x1, &y1);
      *x = x1 - XSHIFT;
      *y =  y1 - YSHIFT;
      return(1);
      break;

    case 5:
      p1 = phi, p2 = lam;
      no_proj_2lc(p1, p2, &x1, &y1);
      *x = x1, *y = y1;
      return(1);
      break;

   case 6:
      utm_sphr_xy(phi, lam, &x1, &y1);
      *x = x1, *y = y1;
      return(1);
      break;

   case 7:
      utm_ellipsoid_xy(phi, lam, &x1, &y1);
      *x = x1, *y = y1;
      return(1);
      break;

   case 8:
      utm_sphr_xy(phi, lam, &x1, &y1);
      *x = x1 - XSHIFT;
      *y =  y1 - YSHIFT;
      return(1);
      break;

   case 9:
      utm_ellipsoid_xy(phi, lam, &x1, &y1);
      *x = x1 - XSHIFT;
      *y =  y1 - YSHIFT;
      return(1);
      break;

   case 10:
      Lambert_Az_sphr_xy(phi, lam, &x1, &y1);
      *x = x1 - XSHIFT;
      *y =  y1 - YSHIFT;
      return(1);
      break;


    default:
      jgclc(phi1, lam1, phi, lam, &y1, &x1);
      *x = x1, *y = y1;
      return(1);
      break;
    }
  return(0);
  }
