
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "xsec.h"

/* --- function prototypes --- */

/* Prototype needed for circular calls */

void make_xsec_window(Widget top, xsec *xs, Pixel *colors, Font *fonts);
static void xs_Key_q_lees(Widget w, XEvent *event, String *params,
			  Cardinal *num_params);

/* --- global variables --- */

static char defaultTranslations[] = "#augment\n<Key>q: xs_key_q_lees()\n";
static XtActionsRec actions[] =
  {
    { "xs_key_q_lees", xs_Key_q_lees }
  };

/* --- functions --- */

static char *pr_float(float f)
  {
  static char s[20];

  sprintf(s, "%2.1f", f);
  return(s);
  }

/* --------------------------------------------------------- */

static void redraw_xsec(Widget wij, void *client_data, Region exposed)
  {
  xsec *xs;		/* The data to redraw */
  Display *d;		/* The display we're using */
  Window w;		/* The window we're drawing in */
  GC ggc;		/* The gc to use */
  Pixel *colors;	/* Color map */

  /* This must be first, before redrawing */

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  printf("Sxs->GGC: %lx\n", (long)xs->ggc);
  w = XtWindow(wij);
  d = XtDisplay(wij);
  ggc = xs->ggc;
  colors = xs->colors;
  XSetRegion(d, ggc, exposed);

  /* Now get around to drawing */

  printf("Drawing cross-section\n");
  XSetForeground(d, ggc, colors[XmapAppColor(5)]);
  XDrawRectangle(d, w, ggc, 10, 10, 100, 100);
  printf("Exs->GGC: %lx\n", (long)xs->ggc);
  }

/* ----------------------------------------------------- */

/* Tells a widget to repaint one rectangle */

static void send_repaint(Widget wij, int x, int y, int w, int h)
  {
  Region exposed;
  XRectangle r = { x, y, w, h };

  exposed = XCreateRegion();
  XUnionRectWithRegion(&r, exposed, exposed);
  redraw_xsec(wij, NULL, exposed);
  XDestroyRegion(exposed);
  }

/* --------------------------------------------------------- */

static void quit()
  {

  exit(0);
  }

/* --------------------------------------------------------- */

static void xs_Key_q_lees(Widget w, XEvent *event, String *params,
			  Cardinal *num_params)
  {
  printf(" Bye! Quitting geotouch......\n");
  quit();
  }

/* --------------------------------------------------------- */

static void destroy_xsec(Widget wij, void *client_data, void *server_data)
  {
  xsec *m;

  XtVaGetValues(wij, XtNdata, &m, NULL);
  XmapFree(m);
  printf("\a\a\a\aDestroying xsec!\n");
  }

/* ---------------------------------------------------------- */

void init_xsec_class(XtAppContext apcon)
  {

  XtAppAddActions(apcon, actions, XtNumber(actions));
  }

/* ----------------------------------------------------------- */

 /* Given an already-created GenWidget, and an xsec structure with
    data in it, initializes the rest of the stuff in xsec, and attaches it
    and the widget together, also puts translations into the widget. */

void init_xsec_wij(Widget w, xsec *m, Pixel *colors, Font *fonts)
  {
  XGCValues xgc;

  xgc.function = GXnor;
  xgc.foreground = BlackPixelOfScreen(XtScreen(w));
  if(m == NULL) return;
  m->ggc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		     GCForeground, &xgc);
  printf("Initting the GC: %lx\n", (long)m->ggc);
  m->colors = colors;
  m->fonts = fonts;
  m->wij = w;
  XtVaSetValues(w, XtNdata, m, NULL);
  XtAddCallback(w, XtNredraw, (XtCallbackProc)redraw_xsec, NULL);
  XtAddCallback(w, XtNdestroy, (XtCallbackProc)destroy_xsec, NULL);
  }

/* ------------------------------------------------------------ */

static void quit_window(Widget wij, xsec *pf, char *call_data)
  {

  XtDestroyWidget(pf->shell);
  }

/* --------------------------------------------------------- */

void make_xsec_window(Widget top, xsec *xs, Pixel *colors, Font *fonts)
  {
  Widget xp, box, menu, gen, pane;

  pane = XtVaCreateManagedWidget("pane", panedWidgetClass, top, NULL);

  box = XtVaCreateManagedWidget("control", boxWidgetClass, pane, NULL);

  xp = XtVaCreateManagedWidget("viewport", viewportWidgetClass, pane,
			       XtNallowHoriz, TRUE, XtNallowVert, TRUE,
			       FALSE);

  gen = XtVaCreateManagedWidget("core", genWidgetClass, xp, XtNtranslations,
				XtParseTranslationTable(defaultTranslations),
				XtNdata, xs, NULL);

  init_xsec_wij(gen, xs, colors, fonts);
  xs->shell = top;

  /* File menu */

  xp = XtVaCreateManagedWidget("File", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp, NULL);

  xp = XtVaCreateManagedWidget("Quit Window", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)quit_window, xs);

  xp = XtVaCreateManagedWidget("Quit", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)quit, xs);

  /* Done making widgets, let's see them. */

  XtRealizeWidget(top);
  }
