/*
 * ---------------------------------------------------------------------------
 * rotwidget.h - Public definitions for RotateWidget
 *
 * Mark Lindner - 2/10/96
 * ---------------------------------------------------------------------------
 */

#ifndef _rotwidget_h
#define _rotwidget_h

#include <X11/Core.h>
#include <math.h>

#include "geotouch.h"

/* resource names */

#define XtNfontName		"fontName"
#define XtNwireframe		"wireframe"
#define XtNrotX			"rotX"
#define XtNrotY			"rotY"
#define XtNrotZ			"rotZ"
#define XtNorigX		"origX"
#define XtNorigY		"origY"
#define XtNorigZ		"origZ"
#define XtNradius		"radius"
#define XtNpointSet		"pointSet"
#define XtNlineSet		"lineSet"
#define XtNsetFlags		"setFlags"
#define XtNaxes			"axes"
#define XtNxmax			"xmax"
#define XtNxmin			"xmin"
#define XtNymax			"ymax"
#define XtNymin			"ymin"
#define XtNxAngle		"xAngle"
#define XtNyAngle		"yAngle"
#define XtNzAngle		"zAngle"
#define XtNcontainer		"container"

#define XtCFontName		"FontName"
#define XtCWireframe		"Wireframe"
#define XtCRotX			"RotX"
#define XtCRotY			"RotY"
#define XtCRotZ			"RotZ"
#define XtCOrigX		"OrigX"
#define XtCOrigY		"OrigY"
#define XtCOrigZ		"OrigZ"
#define XtCRadius		"Radius"
#define XtCPointSet		"PointSet"
#define XtCLineSet		"LineSet"
#define XtCSetFlags		"SetFlags"
#define XtCAxes			"Axes"
#define XtCXmax			"Xmax"
#define XtCXmin			"Xmin"
#define XtCYmax			"Ymax"
#define XtCYmin			"Ymin"
#define XtCXAngle		"XAngle"
#define XtCYAngle		"YAngle"
#define XtCZAngle		"ZAngle"
#define XtCContainer		"Container"

/* flags masks */

#define ROTMASK_RESET 1
#define ROTMASK_FANCY 2
#define ROTMASK_CONTAINER 4
#define ROTMASK_ANGLES 8

/* Class record constants, make public the "imaginary" class */

extern WidgetClass rotateWidgetClass;

typedef struct _RotateClassRec * RotateWidgetClass;
typedef struct _RotateRec      * RotateWidget;

typedef struct ptset_t
  {
  int n;
  float *x;
  float *y;
  float *z;
  } ptset_t;

typedef struct
  {
  float xfx, xfy, xfz;
  float yfx, yfy, yfz;
  float zfx, zfy, zfz;
  short xax, xay;
  short yax, yay;
  short zax, zay;
  short ox, oy;
  } axes_t;

#endif /* _rotwidget_h */
