
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

/* --- local headers --- */

#include "geotouch.h"
#include "contour.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jutil.h"

/* --- functions --- */

/** FUNC DEF **/  double bilin_interp(struct SURF_GRD *grd, float xkm, float ykm)
  {
  double t, u, ans, y1, y2, y3, y4;
  int i,j, k;  /* for now i = 1:nx  */
    
  i = (int)(xkm / grd->xinc);
  j = (int)((grd->ymax - ykm) / grd->yinc);

  k = (j + 1) * grd->nx + i; 
  y1 = grd->val[k];

  k = (j + 1) * grd->nx + (i + 1); 
  y2 = grd->val[k];

  k = j * grd->nx + (i + 1); 
  y3 = grd->val[k];

  k = j * grd->nx + i; 
  y4 = grd->val[k];

  t = (xkm - grd->xinc * i) / (grd->xinc);
  u = (ykm - grd->yinc * (grd->ny - (j + 2))) / (grd->yinc);

  ans = ((1 - t) * (1 - u) * y1 + t * (1 - u) * y2 + t * u * y3 + (1 - t) * u
	 * y4);

  return(ans);
  }

/** FUNC DEF **/  double bilin_interp2(float *x, float *y, float **z, int nx, int ny, float px,
		     float py)
  {
  double t, u, ans, y1, y2, y3, y4;
  int i, j; /* for now i = 1:nx  */
    
  i = (int)((px / (x[2] - x[1])) + 1);
  j = (int)((py / (y[2] - y[1])) + 1);

  t = ((px - x[i]) / (x[i + 1] - x[i]));
  u = ((py - y[j]) / (y[j + 1] - y[j]));

  y1 = z[i][j];
  y2 = z[i + 1][j];
  y3 = z[i + 1][j + 1];
  y4 = z[i][j + 1];
          
  ans = ((1 - t) * (1 - u) * y1 + t * (1 - u) * y2 + t * u * y3 + (1 - t)
	 * u * y4);

  return(ans);
  }

/** FUNC DEF **/  void slice_surf(struct SURF_GRD *grd, float x1, float y1, float x2, float y2,
		float *r, float *f, int SLICE_pts)
  {
  float x, y, hoz_dist, delta, co, si, new;
  int i;

  /* dump_a_bit_grd(grd); */

  hoz_dist = sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
  delta = hoz_dist / SLICE_pts;
  co = (x2 - x1) / hoz_dist;
  si = (y2 - y1) / hoz_dist;

  for(i = 0; i < SLICE_pts; i++)
    {
    r[i] = delta * i;
    x = x1 + r[i] * co;
    y = y1 + r[i] * si;

    /* polin2(xsurf, ysurf, val, (long)grd->nx,(long)grd->ny, x,y, &new,
       &dnew);
       fprintf(stderr,"%f %f %f %f\n",x,y, new , dnew);*/

    new = bilin_interp(grd, x,y);
    f[i] = new;
    }
  }

/** FUNC DEF **/  float  sample_surf(struct SURF_GRD *grd, float x, float y)
  {
  float new;
  /* dump_a_bit_grd(grd); */
    new = bilin_interp(grd, x,y);
    return(new);
  }


#if 0
  val = alloc_fmat((long)1, (long)grd->nx, (long)1, (long)grd->ny);
xsurf = alloc_fvec((long)1,(long)grd->nx);
     for(i=1; i<=grd->nx; i++)  { xsurf[i] = grd->xinc*(i-1);
          /*fprintf(stderr,"x %f\n", xsurf[i]) ;*/
             }
ysurf = alloc_fvec((long)1,(long)grd->ny);
     for(i=1; i<=grd->ny; i++)  { ysurf[i] = grd->yinc*(i-1);
          /*fprintf(stderr,"y %f\n", ysurf[i]) ;*/
             }


for (i = 1; i <= grd->nx; i++) {
	for (j = 1; j <= grd->ny; j++) {
          k = (j-1)*grd->nx+(i-1);
         val[i][j] = grd->val[k];
    /*fprintf(stderr,"mat[%d][%d] = %f %d %f %f\n",i,j, val[i][j], k, xsurf[i], ysurf[j]) ;*/
	}
	}

free_fvec(xsurf,(long)1,(long)grd->nx);
free_fvec(ysurf,(long)1,(long)grd->ny);
free_fmat(val,(long)1,(long)grd->nx,(long)1,(long)grd->ny);

#endif


